/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.formplugin.web.vaapply;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.web.evaluation.EvaluationServiceHelper;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeEventEnum;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.shift.RefDateType;
import kd.wtc.wtbs.common.model.wtctimerange.WtcTimeRangeArgsModel;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class VaInfoCustomEvtEdit
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(VaInfoCustomEvtEdit.class);

    public void customEvent(CustomEventArgs args) {
        String key = args.getEventName();
        String eventArgs = args.getEventArgs();
        LOG.info("rangeChange\u4e8b\u4ef6\u524d\u7aef\u81ea\u5b9a\u4e49\u63a7\u4ef6\u6570\u636e\uff1a{}", (Object)eventArgs);
        if (StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{WtcTimeRangeEventEnum.RANGE_CHANGE.value})) {
            WtcTimeRangeArgsModel timeRangeArgsModel = (WtcTimeRangeArgsModel)JSON.parseObject((String)eventArgs, WtcTimeRangeArgsModel.class);
            List dateStrs = timeRangeArgsModel.getDate();
            if (!CollectionUtils.isEmpty((Collection)dateStrs) && dateStrs.size() == 2) {
                String startDateStr = (String)dateStrs.get(0);
                String endDateStr = (String)dateStrs.get(1);
                Date startDate = this.getDate(timeRangeArgsModel.getStartMethod(), startDateStr);
                Date endDate = this.getDate(timeRangeArgsModel.getEndMethod(), endDateStr);
                this.getModel().beginInit();
                this.getModel().setValue("startmethod", (Object)timeRangeArgsModel.getStartMethod());
                this.getModel().setValue("endmethod", (Object)timeRangeArgsModel.getEndMethod());
                this.getModel().setValue("startdate", (Object)startDate);
                this.getModel().setValue("enddate", (Object)endDate);
                boolean selfAdd = startDate == null || endDate == null;
                this.getModel().setValue("selfadd", (Object)selfAdd);
                this.getModel().endInit();
                if (selfAdd) {
                    this.getModel().setValue("applytime", null);
                }
                this.getModel().setValue("datechange", (Object)System.currentTimeMillis());
            }
        } else if (StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{WtcTimeRangeEventEnum.SET_CHOOSE_TIME.value})) {
            Date startDate;
            DynamicObject dataEntity = this.getModel().getDataEntity();
            ArrayList attFileBaseBoIds = Lists.newArrayList((Object[])new Long[]{dataEntity.getLong("attfileboid")});
            JSONObject jsonObject = JSON.parseObject((String)eventArgs);
            String rosterDateStr = jsonObject.getString("date");
            if (StringUtils.isNotEmpty((CharSequence)rosterDateStr) && rosterDateStr.trim().length() >= 10) {
                rosterDateStr = rosterDateStr.trim().substring(0, 10);
                try {
                    startDate = WTCDateUtils.parseDate((String)rosterDateStr, (String)"yyyy-MM-dd");
                }
                catch (ParseException e) {
                    LOG.warn("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01{}", (Object)rosterDateStr);
                    return;
                }
            } else {
                LOG.info("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e.");
                return;
            }
            Date endDate = startDate;
            DutyShiftResponse shiftResponse = EvaluationServiceHelper.getDutyShiftsByAttFileBoId((List)attFileBaseBoIds, (Date)startDate, (Date)endDate);
            Shift shift = shiftResponse.getCurrShiftHis(Long.valueOf(dataEntity.getLong("attfileboid")), startDate).orElse(null);
            if (shift != null) {
                String endDateStr;
                String startDateStr;
                boolean offNonPlan = shift.getOffNonPlan();
                if (offNonPlan) {
                    startDateStr = WTCDateUtils.date2Str((Date)startDate, (String)"yyyy-MM-dd") + " 00:00:00";
                    endDateStr = WTCDateUtils.date2Str((Date)startDate, (String)"yyyy-MM-dd") + " 23:59:00";
                } else {
                    startDate = WTCDateUtils.getDate((Date)startDate, (Integer)shift.getLastShiftStartDate());
                    if (StringUtils.equals((CharSequence)RefDateType.NEXTDAY.code, (CharSequence)shift.getLastRefEndDay())) {
                        endDate = WTCDateUtils.addDays((Date)endDate, (int)1);
                    }
                    endDate = WTCDateUtils.getDate((Date)endDate, (Integer)shift.getLastShiftEndDate());
                    startDateStr = WTCDateUtils.date2Str((Date)startDate, (String)"yyyy-MM-dd HH:mm:ss");
                    endDateStr = WTCDateUtils.date2Str((Date)endDate, (String)"yyyy-MM-dd HH:mm:ss");
                }
                HashMap returnMap = Maps.newHashMap();
                returnMap.put("event", WtcTimeRangeEventEnum.CHOOSE_TIME_RESPONSE.value);
                returnMap.put("timestamp", System.currentTimeMillis());
                returnMap.put("type", jsonObject.getString("type"));
                returnMap.put("owndate", rosterDateStr);
                ArrayList argsList = Lists.newArrayList((Object[])new String[]{startDateStr, endDateStr});
                returnMap.put("args", argsList);
                CustomControl customControl = (CustomControl)this.getView().getControl("wtctimerange");
                customControl.setData((Object)returnMap);
            } else {
                LOG.info("\u6839\u636e\u65e5\u671f\u672a\u67e5\u8be2\u5230\u6392\u73ed\uff1astartDate\uff1a{},attFileBaseBoIds:{}", (Object)startDate, (Object)attFileBaseBoIds);
            }
        } else {
            LOG.info("\u672a\u5b9a\u4e49\u7684\u4e8b\u4ef6\u7c7b\u578b\uff1a{}", (Object)key);
        }
    }

    private Date getDate(int vamethod, String dateStr) {
        if (StringUtils.isEmpty((CharSequence)dateStr) || StringUtils.equals((CharSequence)"null", (CharSequence)dateStr)) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        try {
            if (vamethod == WtcTimeRangeBtnTypeEnum.CUSTOM.code) {
                return dateTimeFormat.parse(dateStr);
            }
            return dateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            LOG.warn("\u65e5\u671f\u683c\u5f0f\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }
}

