/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.formplugin.web.vaapply;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.AbstractFormView;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sdk.wtc.wtabm.business.quota.OnRenameVaTypeEvent;
import kd.sdk.wtc.wtabm.business.spva.SpecialVaExpService;
import kd.wtc.wtabm.business.vaapply.VaApplyExtHelper;
import kd.wtc.wtabm.business.vaapply.VaApplyService;
import kd.wtc.wtabm.business.vaapply.VaApplyServiceHelper;
import kd.wtc.wtabm.business.vaapply.VaBaseService;
import kd.wtc.wtabm.business.vaapply.VaInfoService;
import kd.wtc.wtabm.business.vaapply.VaKDStringHelper;
import kd.wtc.wtabm.business.vaapply.checker.VaBillCheckService;
import kd.wtc.wtabm.business.vaapply.checker.VaEntityCheckService;
import kd.wtc.wtabm.common.entity.vaapply.VaInfoTimeFiledVo;
import kd.wtc.wtabm.common.entity.vaapply.VaInfoVo;
import kd.wtc.wtabm.common.entity.vaapply.VaQuotaResInfo;
import kd.wtc.wtabm.common.entity.vaapply.VaTypeSelectVo;
import kd.wtc.wtbs.business.bill.AttfileLimitScopeServiceImpl;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillStyleService;
import kd.wtc.wtbs.business.bill.IAttfileLimitScopeService;
import kd.wtc.wtbs.business.bill.WtcTimeRangeControlService;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonCurrModel;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonCurrResult;
import kd.wtc.wtbs.business.web.applybill.operatecore.extend.WtcAbstractUnityBillAutoOperator;
import kd.wtc.wtbs.business.web.applybill.operatecore.va.VaAutoOperator;
import kd.wtc.wtbs.business.web.applybill.service.BillEntityCheckService;
import kd.wtc.wtbs.business.web.attendperson.AttendPersonServiceImpl;
import kd.wtc.wtbs.common.bill.ApplyTimeTypeParam;
import kd.wtc.wtbs.common.bill.AttfileLimitScope;
import kd.wtc.wtbs.common.deduction.frozen.BillApplyEntryFrozenResult;
import kd.wtc.wtbs.common.deduction.frozen.FrozenResult;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.HisDataStatus;
import kd.wtc.wtbs.common.enums.bill.BillOpenStyleEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.enums.bill.va.SpecialVaTypeEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeEventEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.bill.BillApplyTimeResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.model.wtctimerange.WtcTimeRangeArgsModel;
import kd.wtc.wtbs.common.model.wtctimerange.WtcTimeRangeModel;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtabm.common.entity.VaDetailPreviewVo;
import kd.wtc.wtbs.wtabm.common.entity.VaLactationTimeStorage;
import kd.wtc.wtbs.wtp.enums.vaplan.BaseSetTimeBreastDayTypeEnum;

public class VaInfoEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
BasedataFuzzySearchListener {
    private static final Log LOG = LogFactory.getLog(VaInfoEdit.class);
    private static final VaApplyServiceHelper VA_APPLY_SERVICE_HELPER = (VaApplyServiceHelper)WTCAppContextHelper.getBean(VaApplyServiceHelper.class);
    private final VaInfoService vaInfoService = new VaInfoService();

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("vacationtype");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        basedataEdit.addBasedataFuzzySearchListener((BasedataFuzzySearchListener)this);
        ((BasedataEdit)this.getView().getControl("valactattype")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"quotainfo"});
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeBindData(EventObject arg) {
        LOG.info("vainfoedit_beforebinddata:{}", (Object)this.getView().getFormShowParameter().getClass().getName());
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (Objects.equals(status, OperationStatus.ADDNEW)) {
            VaInfoService.initPage((IFormView)this.getView());
        } else if (Objects.equals(status, OperationStatus.EDIT) || Objects.equals(status, OperationStatus.VIEW)) {
            VaInfoService.initPageForEdit((IFormView)this.getView());
        }
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.setVaTypeDisplayValue();
        VaInfoVo vaInfoVo = VaInfoService.getVaInfoVoFromShowParam((IFormView)this.getView());
        HashMap<String, String> map = new HashMap<String, String>(4);
        if (vaInfoVo.getSpecialVaType().length() != 0) {
            map.put("IS_SPECIAL_TYPE", "true");
        } else {
            map.put("IS_SPECIAL_TYPE", "false");
        }
        if (vaInfoVo.getParentBillId() != 0L) {
            map.put("isUpdate", "true");
            this.getView().setVisible(Boolean.FALSE, new String[]{"changecheck"});
            ComboEdit keyEdit = (ComboEdit)this.getView().getControl("changecheck");
            keyEdit.setMustInput(false);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"changecheck"});
            ComboEdit keyEdit = (ComboEdit)this.getView().getControl("changecheck");
            keyEdit.setMustInput(false);
            map.put("isUpdate", "false");
        }
        this.getPageCache().put(map);
        this.getModel().setDataChanged(false);
    }

    private void setVaTypeDisplayValue() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject vaTypeDy = dataEntity.getDynamicObject("vacationtype");
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        Boolean quotaInfoBtnVisible = Boolean.FALSE;
        if (vaTypeDy != null) {
            Map<Long, VaQuotaResInfo> vaQuotasMap = this.getQuotaInfo(dataEntity, false);
            IClientViewProxy clientProxy = ((AbstractFormView)this.getView()).getClientProxy();
            long vaTypeId = vaTypeDy.getLong("id");
            VaQuotaResInfo vaQuotaResInfo = vaQuotasMap.get(vaTypeId);
            String displayName = vaTypeDy.getString("name");
            if (vaQuotaResInfo != null) {
                displayName = displayName + vaQuotaResInfo.getQuotaStr();
                OnRenameVaTypeEvent onRenameVaTypeEvent = VaApplyExtHelper.onRenameVaTypeEvent((DynamicObject)vaTypeDy, (long)vaTypeId, (String)parentView.getFormShowParameter().getFormId(), (VaQuotaResInfo)vaQuotaResInfo);
                if (onRenameVaTypeEvent != null) {
                    if (!onRenameVaTypeEvent.isCancel()) {
                        displayName = onRenameVaTypeEvent.getVaTypeName();
                        quotaInfoBtnVisible = onRenameVaTypeEvent.isShowQuotas();
                    } else {
                        displayName = vaTypeDy.getString("name");
                        quotaInfoBtnVisible = Boolean.FALSE;
                    }
                } else {
                    quotaInfoBtnVisible = Boolean.TRUE;
                }
            }
            clientProxy.setEntryProperty("vacationtype", "v", (Object)new Object[]{vaTypeDy.getString("number"), displayName, vaTypeDy.getString("number"), "", ""});
        }
        this.getView().setVisible(quotaInfoBtnVisible, new String[]{"quotainfo"});
        this.getView().setVisible(quotaInfoBtnVisible, new String[]{"singlequotaflex"});
    }

    private Map<Long, VaQuotaResInfo> getQuotaInfo(DynamicObject dataEntity, boolean isAll) {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null || !parentView.getModel().isDataLoaded()) {
            return new HashMap<Long, VaQuotaResInfo>(0);
        }
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(this.getAppId(), parentView.getEntityId());
        VaApplyService service = new VaApplyService();
        return service.getQuotaInfo(dataEntity, isAll, applyAttr, ApplyBillCheckEnum.VACATIONFORM, parentView.getModel().getDataEntity(true));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        IPageCache pageCache;
        String lactationTypeStr;
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"vacationtype")) {
            long parentBillId = this.getModel().getDataEntity().getLong("parentid");
            long entryParentId = this.getModel().getDataEntity().getLong("entryparentid");
            long attfileBoid = this.getModel().getDataEntity().getLong("attfileboid");
            DynamicObject parentBillDyn = null;
            DynamicObject billDyn = null;
            if (parentBillId != 0L) {
                parentBillDyn = VA_APPLY_SERVICE_HELPER.loadSingle((Object)parentBillId);
            }
            IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            String entityId = "wtabm_vaapply";
            if (parentView != null) {
                billDyn = parentView.getModel().getDataEntity();
                entityId = parentView.getEntityId();
            }
            List changeVaTypes = VaApplyService.getVaTypes((long)attfileBoid, (DynamicObject)parentBillDyn, (long)entryParentId, (String)entityId, (String)this.getAppId());
            Set enumTypeIdSet = changeVaTypes.stream().map(VaTypeSelectVo::getVaTypeId).collect(Collectors.toSet());
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList filters = Lists.newArrayListWithExpectedSize((int)2);
            QFilter audit = new QFilter("id", "in", enumTypeIdSet);
            audit.and(WTCHisServiceHelper.statusValidQFilter());
            if (billDyn == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u52a0\u8f7d\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"VaApplyService_09", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
            }
            DynamicObject orgDy = billDyn.getDynamicObject("org");
            if (orgDy != null) {
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"wtbd_vacationtype", (Long)orgDy.getLong("id"));
                if (baseDataFilter != null) {
                    audit.and(baseDataFilter);
                }
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8003\u52e4\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"VaApplyService_08", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
            }
            filters.add(audit);
            showParameter.getListFilterParameter().setQFilters((List)filters);
            showParameter.getListFilterParameter().setOrderBy("number");
            showParameter.setCustomParam("isShowQuota", (Object)"true");
            showParameter.setCustomParam("attFileBoId", (Object)String.valueOf(attfileBoid));
            showParameter.setCustomParam("attFileVId", (Object)String.valueOf(billDyn.getLong("attfilebasef7.id")));
            showParameter.setCustomParam("personId", (Object)String.valueOf(billDyn.getLong("personid.id")));
            showParameter.setCustomParam("billId", (Object)String.valueOf(billDyn.getLong("id")));
            showParameter.setCustomParam("parentBillId", (Object)String.valueOf(parentBillId));
            showParameter.setCustomParam("useDate", (Object)WTCDateUtils.date2Str((Date)VaBaseService.getInstance().getUseVersionDate(this.getModel().getDataEntity(), ApplyBillCheckEnum.VACATIONFORM), (String)"yyyy-MM-dd"));
            showParameter.setCustomParam("startDate", (Object)WTCDateUtils.date2Str((Date)this.getModel().getDataEntity().getDate("startdate"), (String)"yyyy-MM-dd"));
            showParameter.setCustomParam("endDate", (Object)WTCDateUtils.date2Str((Date)this.getModel().getDataEntity().getDate("enddate"), (String)"yyyy-MM-dd"));
            showParameter.setCustomParam("billFormId", (Object)parentView.getFormShowParameter().getFormId());
            showParameter.setBillFormId("wtabm_vacationtype_layout");
        }
        if ("valactattype".equals(fieldKey) && !WTCStringUtils.isEmpty((String)(lactationTypeStr = (pageCache = this.getPageCache()).get("breastdaytypedata")))) {
            Set lactationTypeSet = Arrays.stream(lactationTypeStr.split(",")).filter(WTCStringUtils::isNotEmpty).map(Long::valueOf).collect(Collectors.toSet());
            List<QFilter> filters = Collections.singletonList(new QFilter("id", "in", lactationTypeSet));
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setQFilters(filters);
        }
    }

    private void changeTypeAndCleanEvent() {
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue("startdate", null);
        model.setValue("enddate", null);
        model.setValue("startmethod", null);
        model.setValue("endmethod", null);
        model.setValue("lactatstart", null);
        model.setValue("lactatend", null);
        model.setValue("selfadd", (Object)Boolean.TRUE);
        this.getModel().setValue("applytime", (Object)"");
        model.endInit();
        this.getView().updateView("applytime");
    }

    public void propertyChanged(PropertyChangedArgs args) {
        ChangeData changeData;
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return;
        }
        if (args.getChangeSet() == null || args.getChangeSet().length <= 0) {
            return;
        }
        parentView.getPageCache().put("force_close", "0");
        String name = args.getProperty().getName();
        if (!StringUtils.equalsAny((CharSequence)name, (CharSequence[])new CharSequence[]{"vacationtype", "datechange", "changecheck", "valactattype", "spvacationtype"})) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if ("vacationtype".equals(name)) {
            this.changeVaTypeEvent(args, dataEntity);
        }
        Date startdate = dataEntity.getDate("startdate");
        Date enddate = dataEntity.getDate("enddate");
        if ("vacationtype".equals(name) || "datechange".equals(name)) {
            BillResponse billResponse;
            if ("datechange".equals(name)) {
                Tuples.Tuple2 verifyTime = WtcTimeRangeControlService.getInstance().passCheckTime(this.getModel().getDataEntity(true), ApplyBillCheckEnum.VACATIONFORM, BillTypeEnum.VACATIONBILL.getBillName());
                if (!((Boolean)verifyTime.item1).booleanValue()) {
                    this.getModel().beginInit();
                    this.getModel().setValue("applytime", (Object)"");
                    this.getModel().endInit();
                    this.getView().updateView("applytime");
                    return;
                }
            }
            long attFileBoId = dataEntity.getLong("attfileboid");
            long vacationTypeId = this.getModel().getDataEntity().getLong("vacationtype.id");
            LOG.info("propertyChanged,args: name:{}, vacationTypeId:{}, startdate:{}, enddate:{}, attFileBoId:{}", new Object[]{name, vacationTypeId, startdate, enddate, attFileBoId});
            if (vacationTypeId == 0L) {
                this.collapseAndClearPolicy(parentView);
                return;
            }
            this.setVaTypeDisplayValue();
            String startMethod = dataEntity.getString("startmethod");
            String endMethod = dataEntity.getString("endmethod");
            if (startdate == null || enddate == null) {
                Date now = WTCDateUtils.toDate((LocalDate)LocalDate.now());
                this.vaDateRangeInit(now, now, WtcTimeRangeBtnTypeEnum.DAY.value, WtcTimeRangeBtnTypeEnum.DAY.value);
            }
            boolean selfAdd = dataEntity.getBoolean("selfadd");
            boolean needCheckAttFileAuth = VaInfoService.isNeedCheckAttFileAuth((IFormView)this.getView());
            UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(this.getAppId(), parentView.getEntityId());
            VaEntityCheckService billCommonCheckHelper = VaEntityCheckService.createService((long)attFileBoId, (ApplyBillCheckEnum)ApplyBillCheckEnum.VACATIONFORM, (DynamicObject)dataEntity, (boolean)needCheckAttFileAuth, (UnifyBillApplyAttr)applyAttr);
            try {
                billResponse = billCommonCheckHelper.checkAndGetBaseSetDy();
            }
            catch (KDBizException ex) {
                LOG.warn("\u83b7\u53d6\u4f11\u5047\u57fa\u7840\u914d\u7f6e\u5f02\u5e38, \u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)ex);
                if (!selfAdd) {
                    throw ex;
                }
                this.collapseAndClearPolicy(parentView);
                return;
            }
            if (!billResponse.isSuccess()) {
                if (startdate != null && enddate != null && !selfAdd) {
                    this.getView().showTipNotification((String)billResponse.getMessage().get(0));
                }
                this.vaDateRangeInit(startdate, enddate, startMethod, endMethod);
                this.collapseAndClearPolicy(parentView);
                return;
            }
            DynamicObject matchBaseSet = (DynamicObject)billResponse.getData();
            if (Objects.isNull(matchBaseSet)) {
                if (startdate != null && enddate != null && !selfAdd) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u4f11\u5047\u65b9\u6848\uff0c\u65e0\u6cd5\u7533\u8bf7\u4f11\u5047\u3002", (String)"VaInfoEdit_10", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
                }
                this.vaDateRangeInit(startdate, enddate, startMethod, endMethod);
                this.collapseAndClearPolicy(parentView);
                return;
            }
            this.setParentAttPolicy(dataEntity, billCommonCheckHelper.getBillAutoOperator());
            boolean specialVaTypechange = this.judgeVaType(args, matchBaseSet, billCommonCheckHelper);
            if (specialVaTypechange) {
                this.dateRangeChange();
            } else {
                return;
            }
        }
        if (StringUtils.equals((CharSequence)name, (CharSequence)"changecheck")) {
            this.getModel().setValue("entryparentid", this.getModel().getValue("changecheck"));
        }
        if (StringUtils.equals((CharSequence)name, (CharSequence)"valactattype")) {
            this.calculateLactationTime(name);
        }
        if (StringUtils.equals((CharSequence)name, (CharSequence)"spvacationtype") && StringUtils.isEmpty((CharSequence)((String)(changeData = args.getChangeSet()[0]).getOldValue())) && StringUtils.isEmpty((CharSequence)((String)changeData.getNewValue()))) {
            return;
        }
    }

    private void changeVaTypeEvent(PropertyChangedArgs args, DynamicObject dataEntity) {
        this.changeTypeAndCleanEvent();
        Object newValue = args.getChangeSet()[0].getNewValue();
        Long typeId = newValue == null ? null : Long.valueOf(((DynamicObject)newValue).getLong("id"));
        VaInfoVo vaInfoVo = VaInfoService.getVaInfoVoFromShowParam((IFormView)this.getView());
        if (vaInfoVo != null) {
            WtcTimeRangeModel wtcTimeRangeModel = new WtcTimeRangeModel();
            WtcTimeRangeArgsModel argsModel = new WtcTimeRangeArgsModel();
            long attFileBoId = vaInfoVo.getAttFileBoid();
            Date startTime = dataEntity.getDate("startdate");
            Date endTime = dataEntity.getDate("enddate");
            String startMethod = dataEntity.getString("startmethod");
            String endMethod = dataEntity.getString("endmethod");
            ApplyTimeTypeParam applyTimeTypeParam = new ApplyTimeTypeParam();
            applyTimeTypeParam.setEntity("wtbd_vacationtype");
            applyTimeTypeParam.setApplyTimeTypeField("applytimetype");
            applyTimeTypeParam.setJumpStepField("jumpstep");
            applyTimeTypeParam.setTypeId(typeId);
            applyTimeTypeParam.setAttFileBoId(attFileBoId);
            applyTimeTypeParam.setOriStartTime(startTime);
            applyTimeTypeParam.setOriEndTime(endTime);
            applyTimeTypeParam.setOriStartBtnTypeEnum(WtcTimeRangeBtnTypeEnum.getEnumByValue((String)startMethod));
            applyTimeTypeParam.setOriEndBtnTypeEnum(WtcTimeRangeBtnTypeEnum.getEnumByValue((String)endMethod));
            applyTimeTypeParam.setDisableTip(WtcTimeRangeControlService.getInstance().getDisableTip(BillTypeEnum.VACATIONBILL.getBillName()));
            WtcTimeRangeControlService.getInstance().setApplyTimeTypeData(applyTimeTypeParam, argsModel);
            CustomControl customControl = (CustomControl)this.getView().getControl("wtctimerange");
            wtcTimeRangeModel.setEvent(WtcTimeRangeEventEnum.CHANGE_TYPE.value);
            wtcTimeRangeModel.setArgs(argsModel);
            wtcTimeRangeModel.setTimestamp(new Date().getTime());
            customControl.setData((Object)wtcTimeRangeModel);
        }
        this.getModel().beginInit();
        this.getView().getModel().setValue("lactatstart", null);
        this.getView().getModel().setValue("lactatend", null);
        this.getModel().endInit();
        this.getView().setEnable(Boolean.valueOf(newValue != null), new String[]{"lactatdaterange"});
        this.getView().updateView("lactatstart");
        this.getView().updateView("lactatend");
        this.getView().updateView("lactatdaterange");
    }

    private void setParentAttPolicy(DynamicObject dataEntity, WtcAbstractUnityBillAutoOperator vaAutoOperator) {
        long attFileBoId = dataEntity.getLong("attfileboid");
        long vaTypeId = dataEntity.getLong("vacationtype.id");
        VaInfoVo vaInfoVo = VaInfoService.getVaInfoVoFromShowParam((IFormView)this.getView());
        if (!WTCStringUtils.equals((String)vaInfoVo.getBillStyle(), (String)BillOpenStyleEnum.SINGLE.getCode())) {
            return;
        }
        IFormView parentView = this.getParentViewWithPlugin();
        if (parentView == null) {
            return;
        }
        List allRule = vaAutoOperator.getAllRule(attFileBoId);
        IAttfileLimitScopeService limitScopeService = (IAttfileLimitScopeService)WTCAppContextHelper.getBean(AttfileLimitScopeServiceImpl.class);
        Map attfileLimitScopeMap = limitScopeService.queryAttfileVersionInfo((Set)Sets.newHashSet((Object[])new Long[]{attFileBoId}), null);
        boolean unmatchedAttPolicy = true;
        for (DynamicObject rule : allRule) {
            String dataStatus = rule.getString("datastatus");
            if (!StringUtils.equals((CharSequence)dataStatus, (CharSequence)HisDataStatus.EFFECTIVE.code)) continue;
            Container attPolicyFlex = (Container)parentView.getControl("attpolicyflex");
            for (DynamicObject ruleEntry : rule.getDynamicObjectCollection("entryentity")) {
                AttfileLimitScope attfileLimitScope;
                boolean matchLimit;
                long vacationTypeId = ruleEntry.getLong("vatype.id");
                if (vacationTypeId != vaTypeId || !(matchLimit = limitScopeService.matchLimit(attfileLimitScope = (AttfileLimitScope)attfileLimitScopeMap.get(attFileBoId), ruleEntry.getString("limitscope")))) continue;
                DynamicObject attPolicyDyn = ruleEntry.getDynamicObject("attpolicy");
                if (attPolicyDyn != null) {
                    unmatchedAttPolicy = false;
                    attPolicyFlex.setCollapse(false);
                    parentView.setVisible(Boolean.TRUE, new String[]{"richtexteditorap"});
                    parentView.setVisible(Boolean.FALSE, new String[]{"lackpageflex"});
                    RichTextEditor richTextEditor = (RichTextEditor)parentView.getControl("richtexteditorap");
                    DynamicObject vaType = this.getModel().getDataEntity().getDynamicObject("vacationtype");
                    String vaTypeName = vaType.getLocaleString("name").getLocaleValue();
                    String content = attPolicyDyn.getString("content");
                    StringBuilder builder = new StringBuilder();
                    builder.append("<b style=\"line-height:40px;font-size:14px;color:#212121\">");
                    builder.append(vaTypeName);
                    builder.append(":</b>");
                    content = content.replace("<p>", "<p style=\"line-height:20px;font-size:12px;color:#666666\">");
                    builder.append(content);
                    richTextEditor.setText(builder.toString());
                }
                this.getView().sendFormAction(parentView);
                break;
            }
            if (!unmatchedAttPolicy) continue;
            this.collapseAndClearPolicy(parentView);
        }
    }

    private void collapseAndClearPolicy(IFormView parentView) {
        VaInfoVo vaInfoVoFromShowParam = VaInfoService.getVaInfoVoFromShowParam((IFormView)this.getView());
        String billStyle = vaInfoVoFromShowParam.getBillStyle();
        if (!WTCStringUtils.equals((String)billStyle, (String)BillOpenStyleEnum.SINGLE.getCode())) {
            return;
        }
        Container attPolicyFlex = (Container)parentView.getControl("attpolicyflex");
        attPolicyFlex.setCollapse(true);
        parentView.setVisible(Boolean.FALSE, new String[]{"richtexteditorap"});
        parentView.setVisible(Boolean.TRUE, new String[]{"lackpageflex"});
        this.getView().sendFormAction(parentView);
    }

    private void calculateLactationTime(String name) {
        DynamicObject vaLactationType = this.getModel().getDataEntity().getDynamicObject("valactattype");
        boolean selfAdd = this.getModel().getDataEntity().getBoolean("selfadd");
        if (vaLactationType == null || selfAdd) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date startdate = dataEntity.getDate("startdate");
        Date enddate = dataEntity.getDate("enddate");
        if (Objects.isNull(startdate) && Objects.isNull(enddate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u65e5\u671f\u8303\u56f4\u3002", (String)"VaInfoEdit_08", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isVaLactationTypeChanged = "valactattype".equals(name);
        BaseSetTimeBreastDayTypeEnum typeEnum = BaseSetTimeBreastDayTypeEnum.getById((long)vaLactationType.getLong("id"));
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, SpecialVaExpService.class, (String)"kd.sdk.wtc.wtabm.business.spva.SpecialVaExpService", null);
        AtomicBoolean autoCreatePreviewVo = new AtomicBoolean(false);
        hrPluginProxy.callReplace(lactationService -> lactationService.isAutoCreateSubEntry(vaLactationType)).forEach(res -> {
            if (res != null) {
                autoCreatePreviewVo.set((boolean)res);
            }
        });
        if (typeEnum != BaseSetTimeBreastDayTypeEnum.GO_EARLY && typeEnum != BaseSetTimeBreastDayTypeEnum.COME_LATE && !autoCreatePreviewVo.get()) {
            this.getPageCache().put("needCheck", "needCheck");
            if (isVaLactationTypeChanged) {
                VaInfoService.timeCustomRangeInit((IFormView)this.getView(), (VaLactationTimeStorage)new VaLactationTimeStorage());
                this.getModel().deleteEntryData("entryentity");
                this.getModel().setValue("applytime", (Object)"");
            }
            return;
        }
        this.getPageCache().remove("needCheck");
        long attfileBoid = dataEntity.getLong("attfileboid");
        boolean needCheckAttFileAuth = VaInfoService.isNeedCheckAttFileAuth((IFormView)this.getView());
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(this.getAppId(), this.getView().getEntityId());
        VaEntityCheckService vaEntityCheckService = VaEntityCheckService.createService((long)attfileBoid, (ApplyBillCheckEnum)ApplyBillCheckEnum.VACATIONFORM, (DynamicObject)dataEntity, (boolean)needCheckAttFileAuth, (UnifyBillApplyAttr)applyAttr);
        BillResponse billResponse = vaEntityCheckService.checkBaseSetBaseInfo();
        VaInfoService.lactationControlInit((IFormView)this.getView(), (BillEntityCheckService)vaEntityCheckService, (boolean)true);
        if (billResponse.isSuccess()) {
            List message = billResponse.getMessage();
            if (!CollectionUtils.isEmpty((Collection)message)) {
                this.getView().showTipNotification((String)message.get(0));
            }
            VaInfoService.calculateVaInfoDetail((IFormView)this.getView(), (Date)startdate, (Date)enddate, (VaEntityCheckService)vaEntityCheckService);
        } else {
            this.getModel().setValue("vatime", null);
            this.getModel().setValue("unit", null);
            this.getModel().setValue("applytime", null);
            List message = billResponse.getMessage();
            this.getView().showTipNotification((String)message.get(0));
        }
    }

    private void dateRangeChange() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long attFileBoId = dataEntity.getLong("attfileboid");
        Date startDate = dataEntity.getDate("startdate");
        Date endDate = dataEntity.getDate("enddate");
        DynamicObject vacationType = dataEntity.getDynamicObject("vacationtype");
        if (vacationType == null) {
            return;
        }
        if (this.isDateRangeChanged(dataEntity, startDate, endDate)) {
            SpecialVaTypeEnum vaTypeEnum = SpecialVaTypeEnum.getByType((String)dataEntity.getString("spvacationtype"));
            boolean needCheckAttFileAuth = VaInfoService.isNeedCheckAttFileAuth((IFormView)this.getView());
            if (vaTypeEnum != null) {
                this.getModel().setValue("startdate", (Object)WTCDateUtils.getDayStartTime((Date)startDate));
                this.getModel().setValue("enddate", (Object)WTCDateUtils.getDayStartTime((Date)endDate));
            }
            IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(this.getAppId(), parentView.getEntityId());
            VaEntityCheckService billCommonCheckHelper = VaEntityCheckService.createService((long)attFileBoId, (ApplyBillCheckEnum)ApplyBillCheckEnum.VACATIONFORM, (DynamicObject)dataEntity, (boolean)needCheckAttFileAuth, (UnifyBillApplyAttr)applyAttr);
            if (Objects.isNull(vaTypeEnum)) {
                long before = System.currentTimeMillis();
                LOG.info("checkStartDateAndEndDate, {}", (Object)before);
                BillResponse billResponse = billCommonCheckHelper.checkStartDateAndEndDate();
                LOG.info("checkStartDateAndEndDate, use time:{}, Response:{}", (Object)(System.currentTimeMillis() - before), (Object)SerializationUtils.toJsonString((Object)billResponse));
                if (this.billRespProcess(billResponse, true)) {
                    return;
                }
                this.ordinaryVaProcess(billCommonCheckHelper);
            } else {
                this.specialVaTypeProcess((BillEntityCheckService)billCommonCheckHelper);
            }
        }
    }

    private void specialVaTypeProcess(BillEntityCheckService billCommonCheckHelper) {
        BillResponse billResponse = billCommonCheckHelper.checkBaseSetBaseInfo();
        if (!billResponse.isSuccess()) {
            this.updateApplyInfo(null, null, null);
            List message = billResponse.getMessage();
            this.getView().showTipNotification((String)message.get(0));
        } else {
            DynamicObject baseSetDy = billCommonCheckHelper.getBaseSetDy();
            this.updateApplyInfo(null, null, null);
            FieldEdit control = (FieldEdit)this.getControl("lactatreasontext");
            List mustInput = billCommonCheckHelper.getMustInput();
            control.setMustInput(!CollectionUtils.isEmpty((Collection)mustInput));
            VaInfoService.updateLactationInfo((IFormView)this.getView(), (DynamicObject)baseSetDy);
            VaInfoService.cacheBreastDateTypes((IPageCache)this.getPageCache(), (DynamicObject)baseSetDy);
        }
    }

    private void ordinaryVaProcess(VaEntityCheckService billCommonCheckHelper) {
        long beforeCheck = System.currentTimeMillis();
        LOG.info("\u5f00\u59cb\u8ba1\u7b97\u548c\u6821\u9a8c, {}", (Object)beforeCheck);
        BillResponse billResponse = billCommonCheckHelper.checkBaseSet();
        LOG.info("\u7ed3\u675f\u8ba1\u7b97\u548c\u6821\u9a8c, \u8017\u65f6\uff1a{},billResponse:{}", (Object)(System.currentTimeMillis() - beforeCheck), (Object)billResponse);
        BillApplyTimeResult timeResult = Optional.ofNullable(billResponse.getData()).filter(data -> data instanceof BillApplyTimeResult).orElse(null);
        if (timeResult != null) {
            this.updateApplyInfo(timeResult.getTimeByUnit(), timeResult.getUnit(), timeResult.getDesc());
        }
        if (billResponse.isSuccess()) {
            List message = billResponse.getMessage();
            if (!CollectionUtils.isEmpty((Collection)message)) {
                this.getView().showTipNotification((String)message.get(0));
            }
            if (timeResult == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VaInfoEdit_15", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
            }
            VaInfoVo vaInfoVo = VaInfoService.getVaInfoVoFromModel((IFormView)this.getView(), (BillApplyTimeResult)timeResult);
            if (this.validateQuota(this.getModel().getDataEntity(), this.getView(), billCommonCheckHelper, vaInfoVo)) {
                return;
            }
            VaAutoOperator billAutoOperator = (VaAutoOperator)billCommonCheckHelper.getBillAutoOperator();
            billResponse = VaInfoService.checkBillRepeat((IFormView)this.getView(), (VaAutoOperator)billAutoOperator, (VaInfoVo)vaInfoVo);
            if (!billResponse.isSuccess()) {
                this.getView().showTipNotification((String)billResponse.getMessage().get(0));
                return;
            }
            List mustInput = billCommonCheckHelper.getMustInput();
            FieldEdit control = (FieldEdit)this.getControl("reasontext");
            control.setMustInput(!CollectionUtils.isEmpty((Collection)mustInput));
        } else {
            List message = billResponse.getMessage();
            this.getView().showTipNotification((String)message.get(0));
        }
    }

    private boolean billRespProcess(BillResponse billResponse, boolean isPropertyChanged) {
        if (billResponse.isSuccess()) {
            Date ownDate = (Date)billResponse.getData();
            if (ownDate != null) {
                this.getModel().setValue("owndate", (Object)ownDate);
            }
        } else {
            List message = billResponse.getMessage();
            if (isPropertyChanged) {
                this.getView().showTipNotification((String)message.get(0));
            } else {
                this.showTipNotification((String)message.get(0));
            }
            return true;
        }
        return false;
    }

    private void updateApplyInfo(BigDecimal timeByUnit, String unit, String desc) {
        this.getModel().setValue("vatime", (Object)timeByUnit);
        this.getModel().setValue("unit", (Object)unit);
        this.getModel().setValue("applytime", (Object)desc);
    }

    private boolean isDateRangeChanged(DynamicObject dataEntity, Date startDate, Date endDate) {
        DynamicObject vaLactationType = dataEntity.getDynamicObject("valactattype");
        boolean selfAdd = dataEntity.getBoolean("selfadd");
        boolean isNotOpt = Objects.isNull(vaLactationType) || !Objects.equals(BaseSetTimeBreastDayTypeEnum.CUSTOM.id, vaLactationType.getLong("id"));
        return !selfAdd && isNotOpt && startDate != null && endDate != null;
    }

    private boolean judgeVaType(PropertyChangedArgs args, DynamicObject matchBaseSet, VaEntityCheckService billCommonCheckHelper) {
        String name = args.getProperty().getName();
        IPageCache pageCache = this.getPageCache();
        boolean prevIsUpdate = StringUtils.equals((CharSequence)"true", (CharSequence)pageCache.get("isUpdate"));
        boolean prevIsSpecialVaType = StringUtils.equals((CharSequence)"true", (CharSequence)pageCache.get("IS_SPECIAL_TYPE"));
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date startdate = dataEntity.getDate("startdate");
        Date enddate = dataEntity.getDate("enddate");
        String startMethod = dataEntity.getString("startmethod");
        String endMethod = dataEntity.getString("endmethod");
        SpecialVaTypeEnum typeEnum = SpecialVaTypeEnum.getByType((String)matchBaseSet.getString("specialdaytype"));
        boolean isLactation = Objects.equals(typeEnum, SpecialVaTypeEnum.LACTATION_TYPE);
        if (matchBaseSet.getBoolean("isspecialholiday") && isLactation) {
            if (prevIsUpdate && !prevIsSpecialVaType) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u54fa\u4e73\u5047\u4e0d\u53ef\u53d8\u66f4\u4e3a\u54fa\u4e73\u5047\u3002", (String)"VaInfoEdit_01", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(name, args.getChangeSet()[0].getOldValue());
                this.vaDateRangeInit(startdate, enddate, startMethod, endMethod);
                return false;
            }
            this.getModel().setValue("spvacationtype", (Object)typeEnum.vaType);
            VaLactationTimeStorage timeStorage = VaInfoService.updateLactationInfo((IFormView)this.getView(), (DynamicObject)matchBaseSet);
            VaInfoService.cacheBreastDateTypes((IPageCache)this.getPageCache(), (DynamicObject)matchBaseSet);
            if (timeStorage.getFetuses() == 0 || WTCStringUtils.isEmpty((String)timeStorage.getBornDate()) || " ~ ".equals(timeStorage.getBornDate())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u751f\u80b2\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VaInfoEdit_04", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap11"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap11"});
            }
            VaInfoService.timeCustomRangeInit((IFormView)this.getView(), (VaLactationTimeStorage)timeStorage);
            this.vaDateRangeInit(startdate, enddate, WtcTimeRangeBtnTypeEnum.DAY.value, WtcTimeRangeBtnTypeEnum.DAY.value);
            this.updateApplyInfo(null, null, null);
            VaInfoService.lactationControlInit((IFormView)this.getView(), (BillEntityCheckService)billCommonCheckHelper, (boolean)isLactation, (boolean)dataEntity.getBoolean("selfadd"));
        } else {
            if (prevIsUpdate && prevIsSpecialVaType) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u54fa\u4e73\u5047\u4e0d\u53ef\u53d8\u66f4\u4e3a\u975e\u54fa\u4e73\u5047\u3002", (String)"VaInfoEdit_07", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(name, args.getChangeSet()[0].getOldValue());
                this.vaDateRangeInit(startdate, enddate, startMethod, endMethod);
                return false;
            }
            SpecialVaTypeEnum specialVaTypeEnum = SpecialVaTypeEnum.getByType((String)this.getModel().getDataEntity().getString("spvacationtype"));
            if (specialVaTypeEnum == null) {
                this.vaDateRangeInit(startdate, enddate, startMethod, endMethod);
            } else if (specialVaTypeEnum == SpecialVaTypeEnum.LACTATION_TYPE) {
                this.vaDateRangeInit(null, null, WtcTimeRangeBtnTypeEnum.DAY.value, WtcTimeRangeBtnTypeEnum.DAY.value);
                this.updateApplyInfo(null, null, null);
            }
            this.getModel().setValue("spvacationtype", null);
            this.getModel().setValue("lactationtimejson", null);
            this.getModel().deleteEntryData("entryentity");
            this.getPageCache().remove("vaLactationApplyTimes");
        }
        this.getModel().setValue("valactattype", null);
        return true;
    }

    private void vaDateRangeInit(Date startdate, Date enddate, String startMethod, String endMethod) {
        this.getModel().beginInit();
        this.getModel().setValue("startmethod", (Object)startMethod);
        this.getModel().setValue("endmethod", (Object)endMethod);
        this.getModel().setValue("startdate", (Object)startdate);
        this.getModel().setValue("enddate", (Object)enddate);
        this.getModel().endInit();
    }

    private void vaCustomCtrlInit() {
        String lactationType = (String)this.getModel().getValue("spvacationtype");
        if (StringUtils.equals((CharSequence)lactationType, (CharSequence)SpecialVaTypeEnum.LACTATION_TYPE.vaType)) {
            WtcTimeRangeModel wtcTimeRangeModel = new WtcTimeRangeModel();
            WtcTimeRangeArgsModel args = new WtcTimeRangeArgsModel();
            CustomControl customControl = (CustomControl)this.getView().getControl("wtctimerange");
            wtcTimeRangeModel.setEvent(WtcTimeRangeEventEnum.CHANGE_TYPE.value);
            wtcTimeRangeModel.setArgs(args);
            wtcTimeRangeModel.setTimestamp(new Date().getTime());
            customControl.setData((Object)wtcTimeRangeModel);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Button button = (Button)evt.getSource();
        String operationKey = button.getOperationKey();
        if ("ensure".equals(operationKey)) {
            Tuples.Tuple2 passTimeCheck = WtcTimeRangeControlService.getInstance().passCheckTime(this.getModel().getDataEntity(true), ApplyBillCheckEnum.VACATIONFORM, BillTypeEnum.VACATIONBILL.getBillName());
            if (!((Boolean)passTimeCheck.item1).booleanValue()) {
                evt.setCancel(true);
                this.getView().showTipNotification((String)passTimeCheck.item2);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "ensure": {
                this.opEnsure(args);
                break;
            }
            case "wtctimerange": {
                break;
            }
        }
    }

    private void opEnsure(BeforeDoOperationEventArgs args) {
        VaInfoVo vaInfoVoFromShowParam = VaInfoService.getVaInfoVoFromShowParam((IFormView)this.getView());
        boolean notLeave = vaInfoVoFromShowParam.getNotLeave();
        if (notLeave) {
            return;
        }
        if (!WTCStringUtils.equals((String)vaInfoVoFromShowParam.getBillStyle(), (String)BillOpenStyleEnum.SINGLE.getCode())) {
            args.setCancel(true);
        }
        if (Objects.nonNull(this.getPageCache().get("needCheck")) && StringUtils.equals((CharSequence)this.getModel().getDataEntity().getString("spvacationtype"), (CharSequence)SpecialVaTypeEnum.LACTATION_TYPE.vaType)) {
            List visibleList = JSON.parseArray((String)this.getPageCache().get("VISIBLE_LIST"), VaInfoTimeFiledVo.class);
            BillResponse response = VaInfoService.checkSpecialTimes((List)visibleList);
            args.setCancel(true);
            if (!response.isSuccess()) {
                this.showTipNotification((String)response.getMessage().get(0));
            } else {
                this.showTipNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u65e5\u671f\u8303\u56f4\u6216\u65f6\u95f4\u8303\u56f4\u53d8\u52a8\uff0c\u8bf7\u751f\u6210\u4f11\u5047\u660e\u7ec6\u3002", (String)"VaInfoEdit_09", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long attFileBoId = dataEntity.getLong("attfileboid");
        Date startDate = dataEntity.getDate("startdate");
        Date endDate = dataEntity.getDate("enddate");
        DynamicObject vacationType = dataEntity.getDynamicObject("vacationtype");
        if (vacationType != null) {
            IFormView view;
            BillApplyTimeResult timeResult;
            boolean isLactationType;
            boolean isCheckPersonInfo;
            if (VaInfoService.dateRangeCheck((Date)startDate, (Date)endDate, (IFormView)this.getView())) {
                args.setCancel(true);
                return;
            }
            boolean needCheckAttFileAuth = VaInfoService.isNeedCheckAttFileAuth((IFormView)this.getView());
            IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(this.getAppId(), parentView.getEntityId());
            VaEntityCheckService vaBillCheckHelper = VaEntityCheckService.createService((long)attFileBoId, (ApplyBillCheckEnum)ApplyBillCheckEnum.VACATIONFORM, (DynamicObject)dataEntity, (boolean)needCheckAttFileAuth, (UnifyBillApplyAttr)applyAttr);
            vaBillCheckHelper.setCheckApplySpan(true);
            BillResponse billResponse = vaBillCheckHelper.checkStartDateAndEndDate();
            if (this.billRespProcess(billResponse, false)) {
                args.setCancel(true);
                return;
            }
            DynamicObject baseSetDy = vaBillCheckHelper.getBaseSetDy();
            long attPersonId = dataEntity.getLong("attpersonid.id");
            if (baseSetDy != null && (isCheckPersonInfo = baseSetDy.getBoolean("ischeckpersoninfo"))) {
                VaApplyService vaApplyService = (VaApplyService)WTCAppContextHelper.getBean(VaApplyService.class);
                AttendPersonCurrResult currentAttPerson = AttendPersonServiceImpl.getInstance().getCurrentAttPerson((List)Lists.newArrayList((Object[])new Long[]{attPersonId}));
                AttendPersonCurrModel personModel = vaApplyService.parseAttendPersonCurrModel(attPersonId, currentAttPerson);
                DynamicObject parentDataEntity = parentView.getModel().getDataEntity(true);
                String applyTypeRadio = parentDataEntity.getString("applytyperadio");
                billResponse = vaBillCheckHelper.checkPersonInfo(baseSetDy, applyTypeRadio, personModel);
                if (!billResponse.isSuccess()) {
                    this.gotoPersonInfo(billResponse.getMessage(), vaInfoVoFromShowParam);
                    args.setCancel(true);
                    return;
                }
            }
            billResponse = vaBillCheckHelper.checkBaseSetBaseInfo();
            List message = billResponse.getMessage();
            if (!billResponse.isSuccess()) {
                args.setCancel(true);
                this.showTipNotification((String)message.get(0));
                return;
            }
            SpecialVaTypeEnum vaTypeEnum = SpecialVaTypeEnum.getByType((String)this.getModel().getDataEntity().getString("spvacationtype"));
            boolean bl = isLactationType = vaTypeEnum == SpecialVaTypeEnum.LACTATION_TYPE;
            if (!CollectionUtils.isEmpty((Collection)message) && isLactationType) {
                args.setCancel(true);
                this.showTipNotification((String)message.get(0));
            }
            DynamicObject matchBaseSet = vaBillCheckHelper.getBaseSetDy();
            BillApplyTimeResult result = new BillApplyTimeResult();
            result.setUnit(matchBaseSet.getString("unit"));
            VaInfoVo voFromModel = VaInfoService.getVaInfoVoFromModel((IFormView)this.getView(), (BillApplyTimeResult)result);
            boolean checkRes = this.checkEntryEntityVacationTypes(parentView, voFromModel);
            if (!checkRes) {
                return;
            }
            if (isLactationType) {
                vaBillCheckHelper.setCheckApplySpan(false);
                VaLactationTimeStorage timeStorage = VaInfoService.updateLactationInfo((IFormView)this.getView(), (DynamicObject)matchBaseSet);
                voFromModel.setEntryReason(this.getModel().getDataEntity().getString("lactatreasontext"));
                if (timeStorage.getFetuses() == 0 || StringUtils.isEmpty((CharSequence)timeStorage.getBornDate()) || " ~ ".equals(timeStorage.getBornDate())) {
                    args.setCancel(true);
                    this.showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u751f\u80b2\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VaInfoEdit_04", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap11"});
                    return;
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap11"});
                long vaLactatTypeId = this.getModel().getDataEntity().getLong("valactattype.id");
                if (vaLactatTypeId == 0L) {
                    args.setCancel(true);
                    this.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u54fa\u4e73\u5047\u4f11\u5047\u65b9\u5f0f\u201d\u3002", (String)"VaInfoEdit_14", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
                    return;
                }
                BaseSetTimeBreastDayTypeEnum breastDayTypeEnum = BaseSetTimeBreastDayTypeEnum.getById((long)vaLactatTypeId);
                List detailList = voFromModel.getDetailList();
                if (breastDayTypeEnum != BaseSetTimeBreastDayTypeEnum.CUSTOM) {
                    billResponse = vaBillCheckHelper.genVaSubEntity();
                    if (!billResponse.isSuccess()) {
                        args.setCancel(true);
                        this.showTipNotification((String)billResponse.getMessage().get(0));
                        return;
                    }
                    detailList = (List)billResponse.getData();
                    voFromModel.setDetailList(detailList);
                }
                timeResult = this.lactationApplyTimePackProcess(vaBillCheckHelper, result.getUnit(), timeStorage, detailList);
            } else {
                timeResult = this.commonTypeProcess(vaBillCheckHelper, voFromModel);
            }
            if (timeResult == null) {
                args.setCancel(true);
                return;
            }
            List mustInput = vaBillCheckHelper.getMustInput();
            String fieldKey = isLactationType ? "lactatreasontext" : "reasontext";
            FieldEdit control = (FieldEdit)this.getControl(fieldKey);
            control.setMustInput(!CollectionUtils.isEmpty((Collection)mustInput));
            String reasonText = (String)this.getModel().getValue(fieldKey);
            if (StringUtils.isEmpty((CharSequence)reasonText) && !CollectionUtils.isEmpty((Collection)mustInput)) {
                args.setCancel(true);
                this.showTipNotification(VaKDStringHelper.vaReasonMustInput());
                return;
            }
            this.updateApplyInfo(timeResult.getTimeByUnit(), timeResult.getUnit(), timeResult.getDesc());
            if (BigDecimal.ZERO.compareTo(timeResult.getValHour()) == 0) {
                args.setCancel(true);
                this.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u65f6\u957f\u4e3a0\uff0c\u4e0d\u5141\u8bb8\u63d0\u5355\u3002", (String)"VaInfoEdit_12", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
                return;
            }
            VaAutoOperator vaAutoOperator = (VaAutoOperator)vaBillCheckHelper.getBillAutoOperator();
            if (this.vaBillRepeatCheckProcess(args, vaAutoOperator, voFromModel)) {
                args.setCancel(true);
                return;
            }
            if (this.vaUpdateProcess(dataEntity, attFileBoId, voFromModel)) {
                args.setCancel(true);
                return;
            }
            DynamicObject matchRule = vaBillCheckHelper.getMatchRule();
            boolean isQuota = matchRule.getBoolean("isquota");
            boolean isDisposable = matchRule.getBoolean("isdisposable");
            if (isQuota && isDisposable) {
                this.getModel().setValue("isdisposable", (Object)Boolean.TRUE);
                voFromModel.setDisposable(true);
            }
            if ((view = this.getVainfoView()) == null) {
                args.setCancel(true);
                return;
            }
            if (this.validateQuota(dataEntity, view, vaBillCheckHelper, voFromModel)) {
                args.setCancel(true);
                return;
            }
            voFromModel.setApplyTime(timeResult.getTimeByUnit());
            voFromModel.setUnit(timeResult.getUnit());
            voFromModel.setEntryVaTimeDay(timeResult.getValDay());
            voFromModel.setEntryVaTimeHour(timeResult.getValHour());
            voFromModel.setEndDateText(timeResult.getUnit());
            String dataEntityBase64 = SerializationUtils.serializeToBase64((Object)dataEntity);
            voFromModel.setDynamicObjectBase64(dataEntityBase64);
            String vaInfoVoBase64 = SerializationUtils.serializeToBase64((Object)voFromModel);
            if (WTCStringUtils.equals((String)vaInfoVoFromShowParam.getBillStyle(), (String)BillOpenStyleEnum.SINGLE.getCode())) {
                this.getPageCache().put("VA_INFO_VO", vaInfoVoBase64);
            } else {
                this.getView().returnDataToParent((Object)vaInfoVoBase64);
                this.getView().close();
            }
        }
    }

    private boolean checkEntryEntityVacationTypes(IFormView parentView, VaInfoVo voFromModel) {
        String entityId = parentView.getEntityId();
        if (WTCStringUtils.equals((String)BillOpenStyleEnum.SINGLE.getCode(), (String)voFromModel.getBillStyle()) || StringUtils.equalsAny((CharSequence)entityId, (CharSequence[])new CharSequence[]{"wtabm_vaupdate", "wtabm_vaupdateself"})) {
            return true;
        }
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        DynamicObject billDataEntity = parentView.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntityDys = billDataEntity.getDynamicObjectCollection("entryentity");
        boolean containsLactation = false;
        boolean containsOther = false;
        for (int index = 0; index < entryEntityDys.size(); ++index) {
            DynamicObject entryDy = (DynamicObject)entryEntityDys.get(index);
            String specialVaType = entryDy.getString("specialvatype");
            if (status != OperationStatus.ADDNEW && index == voFromModel.getRowIndex()) continue;
            if (WTCStringUtils.equals((String)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (String)specialVaType)) {
                containsLactation = true;
                continue;
            }
            containsOther = true;
        }
        String spVacationType = (String)this.getModel().getValue("spvacationtype");
        if (WTCStringUtils.equals((String)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (String)spVacationType)) {
            containsLactation = true;
        } else {
            containsOther = true;
        }
        if (containsOther && containsLactation) {
            this.getView().showTipNotification(VaKDStringHelper.vacationTypeCheckErr());
            return false;
        }
        return true;
    }

    private IFormView getVainfoView() {
        VaInfoVo vaInfoVo = VaInfoService.getVaInfoVoFromShowParam((IFormView)this.getView());
        String billStyle = vaInfoVo.getBillStyle();
        IFormView view = this.getView();
        if (BillOpenStyleEnum.SINGLE.getCode().equals(billStyle)) {
            view = this.getParentViewWithPlugin();
        }
        return view;
    }

    private void showTipNotification(String message) {
        VaInfoVo vaInfoVo = VaInfoService.getVaInfoVoFromShowParam((IFormView)this.getView());
        String billStyle = vaInfoVo.getBillStyle();
        IFormView view = this.getView();
        if (BillOpenStyleEnum.SINGLE.getCode().equals(billStyle)) {
            view = this.getParentViewWithPlugin();
        }
        if (view != null) {
            view.showTipNotification(message);
        }
    }

    private boolean validateQuota(DynamicObject dataEntity, IFormView view, VaEntityCheckService entityCheckService, VaInfoVo vaInfoVo) {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null || !parentView.getModel().isDataLoaded()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u52a0\u8f7d\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"VaApplyService_09", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject matchRule = entityCheckService.getMatchRule();
        if (matchRule == null) {
            LOG.warn("\u672a\u67e5\u8be2\u5230\u4f11\u5047\u89c4\u5219\u3002");
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u627e\u5230\u4f11\u5047\u89c4\u5219\u3002", (String)"VaInfoService_5", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
            return true;
        }
        boolean isQuota = matchRule.getBoolean("isquota");
        long deductRuleId = matchRule.getLong("deductrule.id");
        DynamicObject billDyn = parentView.getModel().getDataEntity(true);
        if (isQuota || deductRuleId != 0L) {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            DynamicObject copiedBill = VaInfoService.generateVaApplyBill((DynamicObject)billDyn, (VaInfoVo)vaInfoVo, (OperationStatus)status, (DynamicObject)matchRule);
            FrozenResult frozenResult = this.vaInfoService.tryFrozen(entityCheckService, copiedBill);
            if (!frozenResult.isSuccess()) {
                String errMsg = VaBaseService.getInstance().getQuotaExeptionDesc(frozenResult);
                view.showTipNotification(errMsg);
                return true;
            }
            List billFrozenResultList = frozenResult.getBillFrozenResultList();
            Optional<BillApplyEntryFrozenResult> first = billFrozenResultList.stream().filter(res -> vaInfoVo.getId() == res.getEntryId()).findFirst();
            if (first.isPresent()) {
                BillApplyEntryFrozenResult entryFrozenResult = first.get();
                DynamicObject vaTypeF7Dyn = dataEntity.getDynamicObject("vacationtype");
                BillResponse popValidateQuota = VaBaseService.getInstance().parseTryFrozenRes(billDyn, entryFrozenResult, vaTypeF7Dyn, matchRule, vaInfoVo.getNonQtApplyCaches());
                if (!popValidateQuota.isSuccess()) {
                    view.showTipNotification((String)popValidateQuota.getMessage().get(0));
                    return true;
                }
                if (CollectionUtils.isNotEmpty((Collection)popValidateQuota.getMessage())) {
                    this.getPageCache().put("WTABM_CACHENONAPPLY", SerializationUtils.serializeToBase64((Object)vaInfoVo.getNonQtApplyCaches()));
                    view.showTipNotification((String)popValidateQuota.getMessage().get(0));
                }
            }
        }
        return false;
    }

    private boolean vaUpdateProcess(DynamicObject dataEntity, long attfileBoid, VaInfoVo voFromModel) {
        long parentId = voFromModel.getParentBillId();
        if (parentId != 0L) {
            String value = (String)this.getModel().getValue("changecheck");
            if (value != null) {
                this.getModel().setValue("entryparentid", (Object)value);
            }
            DynamicObject parentBillDyn = VA_APPLY_SERVICE_HELPER.loadSingle((Object)voFromModel.getParentBillId());
            DynamicObjectCollection dynamicObjectCollection = parentBillDyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject parentEntryDataEntity : dynamicObjectCollection) {
                long parentEntryId = (Long)parentEntryDataEntity.getPkValue();
                if (dataEntity.getLong("entryparentid") != parentEntryId) continue;
                boolean needCheckAttFileAuth = VaInfoService.isNeedCheckAttFileAuth((IFormView)this.getView());
                DynamicObject dynamicObject = VA_APPLY_SERVICE_HELPER.loadDynamicObject(new QFilter("entryentity.id", "=", (Object)parentEntryId));
                DynamicObject entryRow = dynamicObject.getDynamicObjectCollection("entryentity").stream().filter(et -> (Long)et.getPkValue() == parentEntryId).findFirst().get();
                IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
                UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(this.getAppId(), parentView.getEntityId());
                VaEntityCheckService changeCheckHelper = VaEntityCheckService.createService((long)attfileBoid, (ApplyBillCheckEnum)ApplyBillCheckEnum.VACATION, (DynamicObject)entryRow, (boolean)needCheckAttFileAuth, (UnifyBillApplyAttr)applyAttr);
                BillResponse billResponse = changeCheckHelper.checkChangeSet(dataEntity);
                if (billResponse.isSuccess()) continue;
                List message = billResponse.getMessage();
                this.showTipNotification((String)message.get(0));
                return true;
            }
        }
        return false;
    }

    private boolean vaBillRepeatCheckProcess(BeforeDoOperationEventArgs args, VaAutoOperator vaAutoOperator, VaInfoVo voFromModel) {
        BillResponse billResponse;
        BaseSetTimeBreastDayTypeEnum dayTypeEnum = BaseSetTimeBreastDayTypeEnum.getById((long)voFromModel.getSpecialVaMethod());
        if (BaseSetTimeBreastDayTypeEnum.CUSTOM.equals((Object)dayTypeEnum)) {
            String startStr = this.getPageCache().get("startdate");
            String endStr = this.getPageCache().get("enddate");
            Date start = WTCDateUtils.str2Date((String)startStr, (String)"yyyy-MM-dd");
            Date end = WTCDateUtils.str2Date((String)endStr, (String)"yyyy-MM-dd");
            voFromModel.setStartDate(start);
            voFromModel.setStartDateText(startStr);
            voFromModel.setEndDate(end);
            voFromModel.setEndDateText(endStr);
        }
        if (!(billResponse = VaInfoService.checkBillRepeat((IFormView)this.getView(), (VaAutoOperator)vaAutoOperator, (VaInfoVo)voFromModel)).isSuccess()) {
            String errorMsg = (String)billResponse.getMessage().get(0);
            this.showTipNotification(errorMsg);
            args.setCancel(true);
            return true;
        }
        return false;
    }

    private BillApplyTimeResult commonTypeProcess(VaEntityCheckService vaBillCheckHelper, VaInfoVo voFromModel) {
        BillApplyTimeResult timeResult = null;
        BillResponse billResponse = vaBillCheckHelper.checkBaseSet();
        List message = billResponse.getMessage();
        String billStyle = voFromModel.getBillStyle();
        if (!(CollectionUtils.isEmpty((Collection)message) || !BillOpenStyleEnum.MULTI.getCode().equals(billStyle) && billResponse.isSuccess())) {
            this.showTipNotification((String)message.get(0));
        }
        if (billResponse.isSuccess()) {
            timeResult = (BillApplyTimeResult)billResponse.getData();
            voFromModel.setEntryVaTimeHour(timeResult.getValHour());
            voFromModel.setEntryVaTimeDay(timeResult.getValDay());
            voFromModel.setUnit(timeResult.getUnit());
        }
        return timeResult;
    }

    private BillApplyTimeResult lactationApplyTimePackProcess(VaEntityCheckService vaBillCheckHelper, String unit, VaLactationTimeStorage vaLactationTimeStorage, List<VaDetailPreviewVo> detailList) {
        BillApplyTimeResult timeResult = new BillApplyTimeResult();
        timeResult.setUnit(unit);
        BillResponse billResponse = VaBillCheckService.checkSpecialTimes((BigDecimal)vaLactationTimeStorage.getOffTimePerDay(), detailList);
        if (!billResponse.isSuccess()) {
            this.showTipNotification((String)billResponse.getMessage().get(0));
            return null;
        }
        BigDecimal day = BigDecimal.ZERO;
        BigDecimal hour = BigDecimal.ZERO;
        for (VaDetailPreviewVo vaDetailPreviewVo : detailList) {
            day = day.add(vaDetailPreviewVo.getApplyTimeDay());
            hour = hour.add(vaDetailPreviewVo.getApplyTimeHour());
        }
        timeResult.setValDay(day);
        timeResult.setValHour(hour);
        billResponse = vaBillCheckHelper.checkApplyTime(timeResult);
        if (!billResponse.isSuccess()) {
            this.showTipNotification((String)billResponse.getMessage().get(0));
            return null;
        }
        return timeResult;
    }

    public void handleData(BasedataFuzzySearchEvent basedataFuzzySearchEvent) {
        Map<Long, VaQuotaResInfo> vaQuotasMap = this.getQuotaInfo(this.getModel().getDataEntity(), true);
        for (Object queryDatum : basedataFuzzySearchEvent.getQueryData()) {
            String idStr;
            long vaTypeId;
            VaQuotaResInfo vaQuotaResInfo;
            List list = (List)queryDatum;
            if (CollectionUtils.isEmpty((Collection)list) || list.size() < 3 || list.get(0) == null || list.get(2) == null || (vaQuotaResInfo = vaQuotasMap.get(vaTypeId = Long.parseLong(idStr = list.get(0).toString()))) == null) continue;
            String displayName = list.get(2) + vaQuotaResInfo.getQuotaStr();
            IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            OnRenameVaTypeEvent onRenameVaTypeEvent = VaApplyExtHelper.onRenameVaTypeEvent(null, (long)vaTypeId, (String)parentView.getFormShowParameter().getFormId(), (VaQuotaResInfo)vaQuotaResInfo);
            if (onRenameVaTypeEvent != null) {
                displayName = !onRenameVaTypeEvent.isCancel() ? onRenameVaTypeEvent.getVaTypeName() : (String)list.get(2);
            }
            if (!HRStringUtils.isNotEmpty((String)displayName)) continue;
            list.set(2, displayName);
        }
    }

    private String getAppId() {
        return BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("quotainfo".equals(key)) {
            this.showQuotaInfoPage();
        }
    }

    private void showQuotaInfoPage() {
        DynamicObject billDyn;
        DynamicObject dataEntity;
        LOG.info("\u8df3\u8f6c\u989d\u5ea6\u8be6\u60c5\u5f00\u59cb");
        DynamicObject newDataEntity = dataEntity = this.getModel().getDataEntity();
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            LOG.warn("\u83b7\u53d6parentView\u5f02\u5e38\uff0c\u4e0d\u518d\u6267\u884c");
            return;
        }
        DynamicObject newBillDy = billDyn = parentView.getModel().getDataEntity(true);
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(this.getAppId(), parentView.getEntityId());
        boolean openSingleStyle = BillStyleService.getInstance().isOpenSingleStyle(billDyn);
        VaApplyService service = new VaApplyService();
        if (openSingleStyle && billDyn != null && billDyn.getDynamicObjectCollection("entryentity").size() == 1) {
            MainEntityType dyType = EntityMetadataCache.getDataEntityType((String)dataEntity.getDataEntityType().getName());
            newDataEntity = (DynamicObject)dyType.createInstance();
            HRDynamicObjectUtils.copy((DynamicObject)dataEntity, (DynamicObject)newDataEntity);
            newBillDy = service.updateOwnDateByNewDy(billDyn, applyAttr);
            Optional newEntryDy = WTCCollectionIndexUtil.getEleFromList((List)newBillDy.getDynamicObjectCollection("entryentity"), (int)0);
            if (newEntryDy.isPresent()) {
                newDataEntity.set(ApplyBillCheckEnum.VACATIONFORM.getOwndate(), (Object)((DynamicObject)newEntryDy.get()).getDate(ApplyBillCheckEnum.VACATION.getOwndate()));
            }
        }
        service.openQuotaInfoDetail(newBillDy, newDataEntity, applyAttr, this.getVainfoView(), ApplyBillCheckEnum.VACATIONFORM);
        this.getView().sendFormAction(this.getVainfoView());
    }

    private void gotoPersonInfo(List<String> messages, VaInfoVo vaInfoVoFromShowParam) {
        IFormView parentView = this.getParentViewWithPlugin();
        if (parentView == null) {
            LOG.warn("\u83b7\u53d6parentView\u5f02\u5e38\uff0c\u4e0d\u518d\u6267\u884c\u3002");
            return;
        }
        LOG.info("\u8df3\u8f6c\u5458\u5de5\u4fe1\u606f\u63d0\u793a\u5f00\u59cb");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wtabm_personreminde");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.VIEW);
        if (CollectionUtils.isNotEmpty(messages)) {
            formShowParameter.setCustomParam("TIPS", (Object)messages.get(0));
        }
        String formId = parentView.getEntityId();
        formShowParameter.setCustomParam("ENTITYID", (Object)formId);
        if (BillOpenStyleEnum.SINGLE.getCode().equals(vaInfoVoFromShowParam.getBillStyle())) {
            parentView.showForm(formShowParameter);
        } else {
            this.getView().showForm(formShowParameter);
        }
    }

    private IFormView getParentViewWithPlugin() {
        IFormView parentView = null;
        try {
            parentView = this.getView().getParentView();
        }
        catch (Exception ex) {
            LOG.warn("\u3010\u83b7\u53d6\u7236\u9875\u9762VIEW\u3011\u5f02\u5e38\uff0cex");
        }
        return parentView;
    }
}

