/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.formplugin.web.vaapply;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtabm.business.vaapply.VaInfoService;
import kd.wtc.wtabm.business.vaapply.checker.VaEntityCheckService;
import kd.wtc.wtabm.common.entity.vaapply.VaInfoTimeFiledVo;
import kd.wtc.wtabm.common.entity.vaapply.VaInfoVo;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.web.applybill.service.BillEntityCheckService;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.bill.BillApplyTimeResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtabm.common.entity.VaDetailItemPreviewVo;
import kd.wtc.wtbs.wtabm.common.entity.VaDetailPreviewVo;
import kd.wtc.wtbs.wtabm.common.entity.VaLactationTimeStorage;

public class VaInfoTimeFieldEdit
extends HRDataBaseEdit {
    private void creatLactationTime(BeforeDoOperationEventArgs args) {
        args.setCancel(this.dateRangeCheck());
        List generateList = Collections.emptyList();
        if (!args.isCancel()) {
            List visibleList = JSON.parseArray((String)this.getPageCache().get("VISIBLE_LIST"), VaInfoTimeFiledVo.class);
            BillResponse response = VaInfoService.checkSpecialTimes((List)visibleList);
            if (response.isSuccess()) {
                generateList = (List)response.getData();
            } else {
                this.getView().showTipNotification((String)response.getMessage().get(0));
                args.setCancel(true);
            }
        }
        if (!args.isCancel() && !generateList.isEmpty()) {
            BillApplyTimeResult result = new BillApplyTimeResult();
            VaInfoVo vaInfoVoFromModel = VaInfoService.getVaInfoVoFromModel((IFormView)this.getView(), (BillApplyTimeResult)result);
            this.getModel().setValue("lactationtimejson", (Object)vaInfoVoFromModel.getVaLactationTimeStorageJson());
            DynamicObject dataEntity = this.getModel().getDataEntity();
            long attfileBoid = dataEntity.getLong("attfileboid");
            boolean needCheckAttFileAuth = VaInfoService.isNeedCheckAttFileAuth((IFormView)this.getView());
            UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView()), this.getView().getEntityId());
            VaEntityCheckService vaEntityCheckService = VaEntityCheckService.createService((long)attfileBoid, (ApplyBillCheckEnum)ApplyBillCheckEnum.VACATIONFORM, (DynamicObject)this.getModel().getDataEntity(), (boolean)needCheckAttFileAuth, (UnifyBillApplyAttr)applyAttr);
            BillResponse billResponse = vaEntityCheckService.checkBaseSetBaseInfo();
            if (billResponse.isSuccess()) {
                List message = billResponse.getMessage();
                if (!CollectionUtils.isEmpty((Collection)message)) {
                    this.getView().showTipNotification((String)message.get(0));
                }
                VaInfoService.lactationControlInit((IFormView)this.getView(), (BillEntityCheckService)vaEntityCheckService, (boolean)true);
                Date startdate = dataEntity.getDate("startdate");
                Date enddate = dataEntity.getDate("enddate");
                DynamicObject baseSetDy = vaEntityCheckService.getBaseSetDy();
                VaLactationTimeStorage timeStorage = VaInfoService.updateLactationInfo((IFormView)this.getView(), (DynamicObject)baseSetDy);
                if (timeStorage.getFetuses() == 0 || WTCStringUtils.isEmpty((String)timeStorage.getBornDate()) || " ~ ".equals(timeStorage.getBornDate())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u751f\u80b2\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VaInfoEdit_04", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap11"});
                    return;
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap11"});
                Date lactationEnd = WTCDateUtils.str2Date((String)timeStorage.getLactationEndDate(), (String)"yyyy-MM-dd");
                Date bornDate = WTCDateUtils.str2Date((String)timeStorage.getBornDate(), (String)"yyyy-MM-dd");
                BillResponse response = VaEntityCheckService.getDateRangeTips((Date)startdate, (Date)enddate, (Date)lactationEnd, (Date)bornDate);
                if (!response.isSuccess()) {
                    this.getView().showTipNotification((String)response.getMessage().get(0));
                    return;
                }
                result.setUnit(baseSetDy.getString("unit"));
                billResponse = vaEntityCheckService.genVaSubEntity();
                if (!billResponse.isSuccess()) {
                    this.getView().showTipNotification((String)billResponse.getMessage().get(0));
                    args.setCancel(true);
                    return;
                }
                List detailPreviewVos = (List)billResponse.getData();
                this.fullApplyTimeInfo(result, detailPreviewVos);
                VaInfoService.customerEntryShow((List)generateList, (IFormView)this.getView());
                VaInfoService.fullVaInfoEntry((List)detailPreviewVos, (IDataModel)this.getModel());
                Date startDate = dataEntity.getDate("startdate");
                Date endDate = dataEntity.getDate("enddate");
                this.getPageCache().put("startdate", WTCDateUtils.date2Str((Date)startDate, (String)"yyyy-MM-dd"));
                this.getPageCache().put("enddate", WTCDateUtils.date2Str((Date)endDate, (String)"yyyy-MM-dd"));
                this.getPageCache().put("vaLactationApplyTimes", JSON.toJSONString((Object)detailPreviewVos));
                this.getPageCache().remove("needCheck");
            } else {
                List message = billResponse.getMessage();
                this.getView().showTipNotification((String)message.get(0));
                args.setCancel(true);
            }
        }
    }

    private void fullApplyTimeInfo(BillApplyTimeResult result, List<VaDetailPreviewVo> detailPreviewVos) {
        BigDecimal day = BigDecimal.ZERO;
        BigDecimal hour = BigDecimal.ZERO;
        for (VaDetailPreviewVo detailPreviewVo : detailPreviewVos) {
            day = day.add(detailPreviewVo.getApplyTimeDay());
            hour = hour.add(detailPreviewVo.getApplyTimeHour());
        }
        result.setValHour(hour);
        result.setValDay(day);
        this.getModel().setValue("vatime", (Object)result.getTimeByUnit());
        this.getModel().setValue("unit", (Object)result.getUnit());
        this.getModel().setValue("applytime", (Object)result.getDesc());
    }

    private boolean dateRangeCheck() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date startDate = dataEntity.getDate("startdate");
        Date endDate = dataEntity.getDate("enddate");
        return VaInfoService.dateRangeCheck((Date)startDate, (Date)endDate, (IFormView)this.getView());
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey;
        switch (fieldKey = args.getProperty().getName()) {
            case "lactatstart": 
            case "lactatend": {
                Date endDateVal;
                Date startDateVal;
                DateRangeEdit edit = (DateRangeEdit)this.getView().getControl("lactatdaterange");
                this.getModel().beginInit();
                Object startDate = this.getModel().getValue(edit.getStartDateFieldKey());
                this.getModel().setValue("startdate", startDate);
                Object endDate = this.getModel().getValue(edit.getEndDateFieldKey());
                this.getModel().setValue("enddate", endDate);
                boolean selfAdd = edit.getStartDateFieldKey() == null || edit.getEndDateFieldKey() == null;
                this.getModel().setValue("selfadd", (Object)selfAdd);
                this.getModel().endInit();
                this.getModel().setValue("valactattype", null);
                this.getModel().setValue("applytime", (Object)"");
                if (startDate == null || endDate == null || (startDateVal = (Date)startDate).after(endDateVal = (Date)endDate)) break;
                this.getModel().setValue("datechange", (Object)System.currentTimeMillis());
                break;
            }
        }
        ChangeData changeData = args.getChangeSet()[0];
        if (fieldKey.startsWith("timerangefieldstart") || fieldKey.startsWith("timerangefieldend")) {
            this.timeRangeChanged(fieldKey, changeData);
        }
    }

    private void timeRangeChanged(String fieldKey, ChangeData changeData) {
        int index = this.getControlIndex(fieldKey);
        if (index > 0 && index < 6) {
            this.getPageCache().put("needCheck", "needCheck");
            List visibleList = JSON.parseArray((String)this.getPageCache().get("VISIBLE_LIST"), VaInfoTimeFiledVo.class);
            if (Objects.nonNull(visibleList)) {
                ((VaInfoTimeFiledVo)visibleList.get(index - 1)).setTimeStart(this.getModel().getDataEntity().getInt("timerangefieldstart" + index)).setTimeEnd(this.getModel().getDataEntity().getInt("timerangefieldend" + index));
                this.getPageCache().put("VISIBLE_LIST", JSON.toJSONString((Object)visibleList));
            }
        } else if (index >= 6 && index <= 10) {
            int rowIndex = changeData.getRowIndex();
            int colIndex = index - 5;
            List detailPreviewVos = JSON.parseArray((String)this.getPageCache().get("vaLactationApplyTimes"), VaDetailPreviewVo.class);
            if (detailPreviewVos == null) {
                return;
            }
            VaDetailPreviewVo detailPreviewVo = (VaDetailPreviewVo)detailPreviewVos.get(rowIndex);
            DynamicObject dataEntity = this.getModel().getDataEntity();
            long attfileBoid = dataEntity.getLong("attfileboid");
            boolean needCheckAttFileAuth = VaInfoService.isNeedCheckAttFileAuth((IFormView)this.getView());
            IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView()), parentView.getEntityId());
            VaEntityCheckService billCommonCheckHelper = VaEntityCheckService.createService((long)attfileBoid, (ApplyBillCheckEnum)ApplyBillCheckEnum.VACATIONFORM, (DynamicObject)this.getModel().getDataEntity(), (boolean)needCheckAttFileAuth, (UnifyBillApplyAttr)applyAttr);
            BillResponse billResponse = billCommonCheckHelper.checkBaseSetBaseInfo();
            List message = billResponse.getMessage();
            if (!CollectionUtils.isEmpty((Collection)message)) {
                this.getView().showTipNotification((String)message.get(0));
            }
            if (!billResponse.isSuccess()) {
                return;
            }
            List itemVos = detailPreviewVo.getItemVos();
            Map<Integer, VaDetailItemPreviewVo> itemVoMap = itemVos.stream().collect(Collectors.toMap(VaDetailItemPreviewVo::getRowSeq, itemVo -> itemVo, (item1, item2) -> item1));
            DynamicObject entryEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            int startInt = entryEntity.getInt("timerangefieldstart" + index);
            int endInt = entryEntity.getInt("timerangefieldend" + index);
            if (startInt != -1 && endInt != -1) {
                VaDetailItemPreviewVo detailItemPreviewVo = itemVoMap.computeIfAbsent(colIndex, key -> new VaDetailItemPreviewVo());
                Date startTime = WTCDateUtils.toDate((LocalDateTime)LocalDateTime.of(WTCDateUtils.toLocalDate((Date)detailPreviewVo.getDate()), LocalTime.ofSecondOfDay(startInt)));
                Date endTime = WTCDateUtils.toDate((LocalDateTime)LocalDateTime.of(WTCDateUtils.toLocalDate((Date)detailPreviewVo.getDate()), LocalTime.ofSecondOfDay(endInt)));
                List dutyShiftsRange = billCommonCheckHelper.getDutyShiftsRange();
                BillApplyTimeResult timeResult = VaInfoService.genVaDetail((VaEntityCheckService)billCommonCheckHelper, (Date)detailPreviewVo.getDate(), (Date)startTime, (Date)endTime, (List)dutyShiftsRange);
                detailItemPreviewVo.setDate(detailPreviewVo.getDate()).setStartTime(startTime).setEndTime(endTime).setRowSeq(colIndex).setDateTypeId(detailPreviewVo.getDateType()).setUnit(timeResult.getUnit()).setApplyTimeHour(timeResult.getValHour()).setApplyTimeDay(timeResult.getValDay());
            } else {
                itemVoMap.remove(colIndex);
            }
            detailPreviewVo.getItemVos().clear();
            detailPreviewVo.getItemVos().addAll(itemVoMap.values());
            detailPreviewVo.adjustApplyTime();
            this.updateApplyTime(changeData.getRowIndex(), detailPreviewVos, detailPreviewVo);
        }
    }

    private void updateApplyTime(int colIndex, List<VaDetailPreviewVo> detailPreviewVos, VaDetailPreviewVo detailPreviewVo) {
        this.getModel().setValue("perapplytime", (Object)detailPreviewVo.getApplyTimeHour(), colIndex);
        BillApplyTimeResult timeResult = new BillApplyTimeResult();
        this.fullApplyTimeInfo(timeResult, detailPreviewVos);
        this.getPageCache().put("vaLactationApplyTimes", JSON.toJSONString(detailPreviewVos));
    }

    private int getControlIndex(String fieldKey) {
        int index;
        char[] arr = fieldKey.toCharArray();
        int res = 0;
        for (int curIndex = fieldKey.contains("timerangefieldend") ? "timerangefieldend".length() : "timerangefieldstart".length(); curIndex < arr.length && (index = arr[curIndex] - 48) > 0 && index < 10; ++curIndex) {
            res = res * 10 + index;
        }
        return res;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((FormOperate)args.getSource()).getOperateKey();
        IPageCache pageCache = this.getPageCache();
        LinkedList<VaInfoTimeFiledVo> unVisibleList = new LinkedList<VaInfoTimeFiledVo>();
        LinkedList<Object> visibleList = new LinkedList<Object>();
        List unVisible = JSON.parseArray((String)pageCache.get("UNVISIBLE_LIST"), VaInfoTimeFiledVo.class);
        List visible = JSON.parseArray((String)pageCache.get("VISIBLE_LIST"), VaInfoTimeFiledVo.class);
        if (unVisible != null) {
            unVisibleList.addAll(unVisible);
        }
        if (visible != null) {
            visibleList.addAll(visible);
        }
        if (StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{"newtimefield", "deltimefield"})) {
            switch (key) {
                case "newtimefield": {
                    if (unVisibleList.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u589e\u52a05\u4e2a\u65f6\u95f4\u8303\u56f4\u8bbe\u7f6e\u3002", (String)"VaInfoTimeFieldEdit_03", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    VaInfoTimeFiledVo needShow = (VaInfoTimeFiledVo)unVisibleList.removeFirst();
                    needShow.setVisible(true);
                    VaInfoService.initTimeRangeControl((VaInfoTimeFiledVo)needShow, (IFormView)this.getView());
                    visibleList.addLast(needShow);
                    VaInfoService.updateVisibleCache((IFormView)this.getView(), visibleList, unVisibleList);
                    break;
                }
                case "deltimefield": {
                    if (visibleList.size() == 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u4fdd\u75591\u4e2a\u65f6\u95f4\u8303\u56f4\u914d\u7f6e\u3002", (String)"VaInfoTimeFieldEdit_04", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    VaInfoTimeFiledVo vaInfoTimeFiledVo = (VaInfoTimeFiledVo)visibleList.removeLast();
                    vaInfoTimeFiledVo.setVisible(false);
                    vaInfoTimeFiledVo.setTimeStart(-1);
                    vaInfoTimeFiledVo.setTimeEnd(-1);
                    VaInfoService.initTimeRangeControl((VaInfoTimeFiledVo)vaInfoTimeFiledVo, (IFormView)this.getView());
                    unVisibleList.addFirst(vaInfoTimeFiledVo);
                    VaInfoService.updateVisibleCache((IFormView)this.getView(), visibleList, unVisibleList);
                    break;
                }
            }
        }
        if ("lactatcreate".equals(key)) {
            if (!visibleList.isEmpty()) {
                int needHide = 0;
                ArrayList<Tuple> tuples = new ArrayList<Tuple>(visibleList.size());
                for (VaInfoTimeFiledVo vaInfoTimeFiledVo : visibleList) {
                    if (vaInfoTimeFiledVo.getTimeStart() != -1 && vaInfoTimeFiledVo.getTimeEnd() != -1) {
                        tuples.add(new Tuple((Object)vaInfoTimeFiledVo.getTimeStart(), (Object)vaInfoTimeFiledVo.getTimeEnd()));
                        continue;
                    }
                    ++needHide;
                }
                for (int i = 0; i < tuples.size(); ++i) {
                    Tuple tuple = (Tuple)tuples.get(i);
                    VaInfoTimeFiledVo filedVo = (VaInfoTimeFiledVo)visibleList.get(i);
                    filedVo.setTimeStart(((Integer)tuple.item1).intValue()).setTimeEnd(((Integer)tuple.item2).intValue());
                    VaInfoService.initTimeRangeControl((VaInfoTimeFiledVo)filedVo, (IFormView)this.getView());
                }
                while (needHide != 0 && visibleList.size() != 1) {
                    VaInfoTimeFiledVo needHideField = (VaInfoTimeFiledVo)visibleList.removeLast();
                    needHideField.setVisible(false);
                    needHideField.setTimeStart(-1);
                    needHideField.setTimeEnd(-1);
                    VaInfoService.initTimeRangeControl((VaInfoTimeFiledVo)needHideField, (IFormView)this.getView());
                    unVisibleList.addFirst(needHideField);
                    --needHide;
                }
                VaInfoService.updateVisibleCache((IFormView)this.getView(), visibleList, unVisibleList);
            }
            this.creatLactationTime(args);
        }
    }
}

