/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.formplugin.web.vaapply.batch;

import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.wtc.wtabm.business.vaapply.VaKDStringHelper;
import kd.wtc.wtabm.business.vaapply.batch.BatchVaApplyService;
import kd.wtc.wtabm.business.vaapply.batch.BatchVaPropertyHelper;
import kd.wtc.wtabm.common.constants.batch.BatchVaApplyConstants;
import kd.wtc.wtbs.business.bill.batchbill.BillPropertyHelper;
import kd.wtc.wtbs.common.bill.batchbill.BatchBillCheckResult;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class BatchVaApplyBillEdit
extends HRCoreBaseBillEdit
implements BatchVaApplyConstants {
    private BatchVaApplyService batchVaApplyService = (BatchVaApplyService)WTCAppContextHelper.getBean(BatchVaApplyService.class);

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.batchVaApplyService.fillVaEntryDateInfo(this.getView(), -1);
        this.getView().updateView("entryentity");
        this.batchVaApplyService.refreshVaInfoSummary(this.getView());
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (WTCStringUtils.equals((String)operateKey, (String)"addentry")) {
            long adminOrgId = dataEntity.getLong("adminorg.id");
            if (adminOrgId == 0L) {
                this.getView().showTipNotification(VaKDStringHelper.chooseAdminOrg());
                args.setCancel(true);
                return;
            }
            this.showAddNewPage();
        }
    }

    private void showAddNewPage() {
        FormShowParameter batchVaInfoForm = this.batchVaApplyService.getBatchVaInfoForm(false);
        batchVaInfoForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addentry"));
        this.getView().showForm(batchVaInfoForm);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        BatchBillCheckResult batchBillCheckResult;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (WTCStringUtils.equals((String)actionId, (String)"addentry")) {
            BatchBillCheckResult batchBillCheckResult2 = this.getVaInfoReturnData();
            if (batchBillCheckResult2 != null && batchBillCheckResult2.isAllSuccess()) {
                this.addEntryRows((DynamicObject)batchBillCheckResult2.getData());
                this.clearVaInfoReturnDataCache();
            }
        } else if (!WTCStringUtils.equals((String)actionId, (String)"modifyentry") && "ensure".equals(actionId) && (batchBillCheckResult = this.getVaInfoReturnData()) != null) {
            this.addEntryRows((DynamicObject)batchBillCheckResult.getData());
            this.clearVaInfoReturnDataCache();
        }
    }

    private void addEntryRows(DynamicObject batchVaInfoDyn) {
        if (batchVaInfoDyn != null) {
            DynamicObjectCollection entryColl = batchVaInfoDyn.getDynamicObjectCollection("entryentity");
            if (WTCCollections.isEmpty((Collection)entryColl)) {
                return;
            }
            IDataModel model = this.getModel();
            model.beginInit();
            Map billModelPropertyMap = BatchVaPropertyHelper.getBillModelPropertyMap();
            BillPropertyHelper billPropertyHelper = new BillPropertyHelper(model, batchVaInfoDyn);
            billPropertyHelper.setPropertyMap(billModelPropertyMap);
            billPropertyHelper.setModelDataValue();
            model.updateCache();
            this.batchVaApplyService.fillVaEntryInfo(this.getView(), -1);
            this.batchVaApplyService.fillVaEntryDateInfo(this.getView(), -1);
            this.getView().updateView("subentryentity");
            this.getView().updateView("entryentity");
            model.endInit();
            this.batchVaApplyService.refreshVaInfoSummary(this.getView());
        }
    }

    private BatchBillCheckResult getVaInfoReturnData() {
        IPageCache pageCache = this.getView().getPageCache();
        String dataStr = pageCache.get("vaReturnToParentData");
        if (HRStringUtils.isNotEmpty((String)dataStr)) {
            return (BatchBillCheckResult)SerializationUtils.deSerializeFromBase64((String)dataStr);
        }
        return null;
    }

    private void clearVaInfoReturnDataCache() {
        this.getPageCache().remove("vaReturnToParentData");
    }
}

