/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.formplugin.web.vaapply.batch;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.wtc.wtabm.business.vaapply.batch.BatchVaApplyService;
import kd.wtc.wtabm.business.vaapply.batch.BatchVaPropertyHelper;
import kd.wtc.wtbs.business.bill.batchbill.BatchBillUnifyService;
import kd.wtc.wtbs.business.bill.batchbill.BillPropertyHelper;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class BatchVaApplyBillTplEdit
extends HRCoreBaseBillEdit {
    private BatchVaApplyService batchVaApplyService = (BatchVaApplyService)WTCAppContextHelper.getBean(BatchVaApplyService.class);

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        FormShowParameter formShowParameter = args.getFormShowParameter();
        formShowParameter.setCustomParam("customHREntityNumber", (Object)"wtabm_batchvaapply");
        formShowParameter.setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
        String propKey = "attfilebasef7.adminorg";
        formShowParameter.setCustomParam("custom_parent_f7_prop", (Object)propKey);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (WTCStringUtils.equals((String)operateKey, (String)"modifyentry")) {
            this.showEditPage();
        } else if (WTCStringUtils.equals((String)operateKey, (String)"modifyentrychange")) {
            this.showEditPage();
        } else if (Lists.newArrayList((Object[])new String[]{"save", "submit", "submiteffect"}).contains(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            BillResponse billResponse = BatchVaApplyService.INSTANCE.checkDataRule(dataEntity);
            if (!billResponse.isSuccess()) {
                this.getView().showTipNotification(billResponse.topErrMsg());
                args.setCancel(true);
            }
            this.batchVaApplyService.fillEntryId(this.getModel().getDataEntity(true));
        } else if ("discard".equals(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            BillResponse billResponse = BatchVaApplyService.INSTANCE.checkDataRule(dataEntity);
            if (!billResponse.isSuccess()) {
                this.getView().showTipNotification(billResponse.topErrMsg());
                args.setCancel(true);
            }
            this.fillEntryId();
        }
    }

    private void fillEntryId() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection vaInfoEntryColl = dataEntity.getDynamicObjectCollection("entryentity");
        List enptyEntryIds = vaInfoEntryColl.stream().filter(item -> item.getLong("id") == 0L).collect(Collectors.toList());
        if (WTCCollections.isNotEmpty(enptyEntryIds)) {
            long[] ids = ID.genLongIds((int)enptyEntryIds.size());
            for (int index = 0; index < enptyEntryIds.size(); ++index) {
                DynamicObject vaInfoEntryDy = (DynamicObject)enptyEntryIds.get(index);
                vaInfoEntryDy.set("id", (Object)ids[index]);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (Lists.newArrayList((Object[])new String[]{"save", "submit", "submiteffect"}).contains(operateKey)) {
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            if (!operationResult.isSuccess()) {
                operationResult.setShowMessage(false);
                IDataModel model = this.getModel();
                int entryRowCount = model.getEntryRowCount("entryentity");
                Object source = afterDoOperationEventArgs.getSource();
                FormShowParameter showParameter = BatchBillUnifyService.getInstance().getBatchBillCheckResultForm(source, operationResult, this.getPageCache(), entryRowCount);
                if (showParameter == null) {
                    this.getView().showOperationResult(operationResult);
                } else {
                    this.getView().showForm(showParameter);
                }
                this.batchVaApplyService.refreshVaInfoSummary(this.getView());
            } else {
                this.batchVaApplyService.refreshVaInfoSummary(this.getView());
                this.getModel().setDataChanged(false);
            }
        }
    }

    private void showEditPage() {
        FormShowParameter batchVaInfoForm = this.batchVaApplyService.getBatchVaInfoForm(true);
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        batchVaInfoForm.setCustomParam("entryCurrentRowIndex", (Object)entryCurrentRowIndex);
        batchVaInfoForm.setCustomParam("sourcedataentity", (Object)SerializationUtils.serializeToBase64((Object)this.getModel().getDataEntity(true)));
        batchVaInfoForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "modifyentry"));
        this.getView().showForm(batchVaInfoForm);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (WTCStringUtils.equals((String)actionId, (String)"modifyentry") && (returnData = evt.getReturnData()) != null) {
            DynamicObject batchVaInfoDyn = (DynamicObject)returnData;
            IDataModel model = this.getModel();
            model.beginInit();
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            Map billModelPropertyMap = BatchVaPropertyHelper.getBillModelPropertyMap();
            BillPropertyHelper billPropertyHelper = new BillPropertyHelper(model, batchVaInfoDyn);
            billPropertyHelper.setPropertyMap(billModelPropertyMap);
            billPropertyHelper.setWriteToIndex(entryCurrentRowIndex);
            billPropertyHelper.setModelDataValue();
            model.updateCache();
            this.batchVaApplyService.fillVaEntryInfo(this.getView(), entryCurrentRowIndex);
            this.batchVaApplyService.fillVaEntryDateInfo(this.getView(), entryCurrentRowIndex);
            this.getView().updateView("subentryentity");
            this.getView().updateView("entryentity");
            model.endInit();
            this.batchVaApplyService.refreshVaInfoSummary(this.getView());
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        DynamicObject dy = this.getModel().getDataEntity(true);
        HashSet checkChangeProps = Sets.newHashSet((Object[])new String[]{"attfilebasef7", "attfilebasef7_id", "vacationtypelist", "startdate", "enddate", "unit", "applytime", "adminorg", "adminorg_id", "org", "org_id", "desc", "changetype", "entryentity"});
        this.checkChange(dy, checkChangeProps);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs args) {
        super.afterDeleteRow(args);
        this.batchVaApplyService.refreshVaInfoSummary(this.getView());
    }

    private void checkChange(DynamicObject dy, Set<String> checkChangeProps) {
        DataEntityPropertyCollection properties = dy.getDynamicObjectType().getProperties();
        DataEntityState dataEntityState = dy.getDataEntityState();
        for (IDataEntityProperty property : properties) {
            String name;
            if (property instanceof DynamicCollectionProperty) {
                if (!checkChangeProps.contains(property.getName())) {
                    dataEntityState.setBizChanged(property.getOrdinal(), false);
                }
                DynamicObjectCollection entryColl = dy.getDynamicObjectCollection(property.getName());
                for (DynamicObject entryDy : entryColl) {
                    this.checkChange(entryDy, checkChangeProps);
                }
            }
            if (checkChangeProps.contains(name = property.getName())) continue;
            dataEntityState.setBizChanged(property.getOrdinal(), false);
        }
    }
}

