/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.formplugin.web.vaapply.batch;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.wtc.wtabm.business.vaapply.batch.BatchVaApplyService;
import kd.wtc.wtabm.common.constants.batch.BatchVaApplyConstants;
import kd.wtc.wtbs.business.bill.batchbill.BatchBillUnifyService;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.formplugin.web.batchbill.BatchBillTplChangeEdit;

public class BatchVaApplyBillUpdateEdit
extends BatchBillTplChangeEdit
implements BatchVaApplyConstants {
    private final BatchVaApplyService batchVaApplyService = (BatchVaApplyService)WTCAppContextHelper.getBean(BatchVaApplyService.class);

    public void initialize() {
        this.initEntryOpColumn();
        super.initialize();
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.loadHisBill();
        this.updateEntryDateInfo();
        this.getModel().setDataChanged(false);
    }

    protected void setChangeBillOtherData() {
        this.updateEntryDateInfo();
    }

    private void updateEntryDateInfo() {
        this.batchVaApplyService.fillVaEntryDateInfo(this.getView(), -1);
        this.batchVaApplyService.refreshVaInfoSummary(this.getView());
        this.getView().updateView("entryentity");
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String changeName;
        super.propertyChanged(evt);
        switch (changeName = evt.getProperty().getName()) {
            case "changetype": {
                this.allEntryLoseEfficacy(evt);
                this.updateEntryDateInfo();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String opKey = source.getOperateKey();
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        OperateOption option = source.getOption();
        if ("cancelentry".equals(opKey)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            List leaveEntries = entryEntity.stream().filter(entry -> !entry.getBoolean("isnotleave")).collect(Collectors.toList());
            if (leaveEntries.size() < 2) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5047\u5355\u8c03\u6574\u9700\u81f3\u5c11\u4fdd\u7559\u4e00\u6761\u6570\u636e\uff0c\u82e5\u60f3\u5168\u90e8\u53d6\u6d88\u4f11\u5047\u53ef\u9009\u62e9\u5047\u5355\u5931\u6548\u3002", (String)"VaUpdateBillEdit_02", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            option.setVariableValue("entryCurrentRowIndex", String.valueOf(entryCurrentRowIndex));
        } else if ("uncancelentry".equals(opKey)) {
            this.cancelLoseEfficacy(entryCurrentRowIndex);
            DynamicObject focusEntry = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
            if (focusEntry.getBoolean("isnotleave")) {
                focusEntry.set("isnotleave", (Object)false);
                option.setVariableValue("entryCurrentRowIndex", String.valueOf(entryCurrentRowIndex));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String opKey = evt.getOperateKey();
        if (evt.getOperationResult() == null || !evt.getOperationResult().isSuccess()) {
            int entryCurrentRowIndex;
            if ("uncancelentry".equals(opKey) && (entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity")) >= 0 && WTCCollections.isNotEmpty((Collection)this.getModel().getEntryEntity("entryentity")) && this.getModel().getEntryEntity("entryentity").size() > entryCurrentRowIndex) {
                DynamicObject focusEntry = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
                focusEntry.set("isnotleave", (Object)true);
            }
            return;
        }
        this.updateEntryOpColum(opKey);
        if (StringUtils.equalsAny((CharSequence)opKey, (CharSequence[])new CharSequence[]{"submit", "submiteffect", "unsubmit", "discard", "delete"})) {
            this.loadHisBill();
        }
    }

    private void initEntryOpColumn() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addPackageDataListener(pkEvent -> {
            boolean status = pkEvent.getRowData().getBoolean("isnotleave");
            if (pkEvent.getSource() instanceof OperationColumn && "operationcolumnap".equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey())) {
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    switch (operationColItem.getOperationKey()) {
                        case "modifyentrychange": 
                        case "cancelentry": {
                            operationColItem.setVisible(!status);
                            operationColItem.setLocked(status);
                            break;
                        }
                        case "uncancelentry": {
                            operationColItem.setVisible(status);
                            operationColItem.setLocked(!status);
                            break;
                        }
                    }
                }
            }
        });
    }

    private void updateEntryOpColum(String opKey) {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject focusEntry = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
        if ("cancelentry".equals(opKey)) {
            this.cancelLoseEfficacy(entryCurrentRowIndex);
            this.loseEfficacy(focusEntry, entryCurrentRowIndex);
        }
        if ("cancelentry".equals(opKey) || "uncancelentry".equals(opKey)) {
            this.updateEntryDateInfo();
        }
    }

    private void allEntryLoseEfficacy(PropertyChangedArgs evt) {
        boolean changeValue;
        boolean bl = changeValue = evt.getChangeSet() != null && evt.getChangeSet().length > 0 && evt.getChangeSet()[0] != null && evt.getChangeSet()[0].getNewValue() instanceof String;
        if (changeValue && "2".equals(evt.getChangeSet()[0].getNewValue())) {
            for (int i = 0; i < this.getModel().getEntryEntity("entryentity").size(); ++i) {
                this.loseEfficacy((DynamicObject)this.getModel().getEntryEntity("entryentity").get(i), i);
            }
        }
    }

    private void loadHisBill() {
        BatchBillUnifyService.getInstance().loadHisBill(this.getView(), this.getModel().getDataEntity(true), "wtabm_batchvaupdate", false);
    }

    private void loseEfficacy(DynamicObject entry, Integer focusRowIndex) {
        BatchVaApplyService.INSTANCE.loseEfficacyEntry(this.getModel(), entry, focusRowIndex);
    }

    private void cancelLoseEfficacy(int focusRowIndex) {
        long parentId = this.getModel().getDataEntity(true).getLong("parent");
        DynamicObject parentDy = BatchVaApplyService.INSTANCE.loadSingle((Object)parentId);
        if (parentDy == null) {
            return;
        }
        Optional<DynamicObject> optional = parentDy.getDynamicObjectCollection("entryentity").stream().filter(e -> e.getInt("seq") == focusRowIndex + 1).findFirst();
        if (optional.isPresent()) {
            this.getModel().beginInit();
            this.resetFieldValue(optional.get(), NOTSETVALUEKEYS, true, true, false, true, focusRowIndex, -1);
            this.getModel().endInit();
        }
    }
}

