/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.formplugin.web.vaapply.batch;

import com.alibaba.fastjson.JSON;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.wtc.wtabm.business.vaapply.batch.BatchVaApplyService;
import kd.wtc.wtabm.business.vaapply.batch.BatchVaInfoService;
import kd.wtc.wtabm.common.constants.batch.BatchVaInfoConstants;
import kd.wtc.wtbs.business.bill.WtcTimeRangeControlService;
import kd.wtc.wtbs.common.bill.ApplyTimeTypeParam;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeEventEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.wtctimerange.WtcTimeRangeArgsModel;
import kd.wtc.wtbs.common.model.wtctimerange.WtcTimeRangeModel;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class BatchVaInfoCustomEvtEdit
extends HRCoreBaseBillEdit
implements BatchVaInfoConstants {
    private BatchVaInfoService batchVaInfoService = (BatchVaInfoService)WTCAppContextHelper.getBean(BatchVaInfoService.class);
    private static final Log LOG = LogFactory.getLog(BatchVaInfoCustomEvtEdit.class);

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
    }

    public void customEvent(CustomEventArgs args) {
        WtcTimeRangeArgsModel timeRangeArgsModel;
        List dateStrs;
        super.customEvent(args);
        String key = args.getEventName();
        String eventArgs = args.getEventArgs();
        if (WTCStringUtils.equals((String)key, (String)WtcTimeRangeEventEnum.RANGE_CHANGE.value) && !CollectionUtils.isEmpty((Collection)(dateStrs = (timeRangeArgsModel = (WtcTimeRangeArgsModel)JSON.parseObject((String)eventArgs, WtcTimeRangeArgsModel.class)).getDate())) && dateStrs.size() == 2) {
            String startDateStr = (String)dateStrs.get(0);
            String endDateStr = (String)dateStrs.get(1);
            IDataModel model = this.getModel();
            DynamicObject dataEntity = model.getDataEntity(true);
            int startMethod = timeRangeArgsModel.getStartMethod();
            int endMethod = timeRangeArgsModel.getEndMethod();
            Date startDate = this.getDate(timeRangeArgsModel.getStartMethod(), startDateStr);
            Date endDate = this.getDate(timeRangeArgsModel.getEndMethod(), endDateStr);
            String oldStartMethod = dataEntity.getString("startmethod");
            String oldEndMethod = dataEntity.getString("endmethod");
            Date oldStartDate = dataEntity.getDate("startdate");
            Date oldEndDate = dataEntity.getDate("enddate");
            boolean needRefreshVaTime = !Objects.equals(oldStartMethod, String.valueOf(startMethod)) || !Objects.equals(oldEndMethod, String.valueOf(endMethod)) || !Objects.equals(oldStartDate, startDate) || !Objects.equals(oldEndDate, endDate);
            model.beginInit();
            model.setValue("startmethod", (Object)timeRangeArgsModel.getStartMethod());
            model.setValue("endmethod", (Object)timeRangeArgsModel.getEndMethod());
            model.setValue("startdate", (Object)startDate);
            model.setValue("enddate", (Object)endDate);
            model.endInit();
            model.setValue("datechange", (Object)System.currentTimeMillis());
            BillResponse billResponse = this.batchVaInfoService.checkBatchVaDateRange(model);
            if (!billResponse.isSuccess()) {
                this.getView().showTipNotification(billResponse.topErrMsg());
                model.setValue("applytimetxt", (Object)"-");
                return;
            }
            BillResponse response = this.batchVaInfoService.checkDateRule(model);
            if (!response.isSuccess()) {
                model.setValue("applytimetxt", (Object)"-");
                return;
            }
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (OperationStatus.ADDNEW != status && needRefreshVaTime) {
                BatchVaApplyService.INSTANCE.refreshVaTime(this.getView());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        IDataEntityProperty property = args.getProperty();
        String name = property.getName();
        if ("vacationtype".equals(name)) {
            this.changeTypeAndCleanEvent();
            this.changeVaTypeEvent(args);
        }
    }

    private void changeVaTypeEvent(PropertyChangedArgs args) {
        DynamicObjectCollection entryEntityColl;
        Object newValue;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Long typeId = args != null ? ((newValue = args.getChangeSet()[0].getNewValue()) == null ? null : Long.valueOf(((DynamicObject)newValue).getLong("id"))) : Long.valueOf(dataEntity.getLong("vacationtype.id"));
        long attFileBoId = 0L;
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW != status && WTCCollections.isNotEmpty((Collection)(entryEntityColl = dataEntity.getDynamicObjectCollection("entryentity")))) {
            DynamicObject dynamicObject = (DynamicObject)entryEntityColl.get(0);
            attFileBoId = dynamicObject.getLong("attfile.id");
        }
        WtcTimeRangeModel wtcTimeRangeModel = new WtcTimeRangeModel();
        WtcTimeRangeArgsModel argsModel = new WtcTimeRangeArgsModel();
        Date startTime = dataEntity.getDate("startdate");
        Date endTime = dataEntity.getDate("enddate");
        String startMethod = dataEntity.getString("startmethod");
        String endMethod = dataEntity.getString("endmethod");
        ApplyTimeTypeParam applyTimeTypeParam = new ApplyTimeTypeParam();
        applyTimeTypeParam.setEntity("wtbd_vacationtype");
        applyTimeTypeParam.setApplyTimeTypeField("applytimetype");
        applyTimeTypeParam.setJumpStepField("jumpstep");
        applyTimeTypeParam.setTypeId(typeId);
        applyTimeTypeParam.setAttFileBoId(attFileBoId);
        applyTimeTypeParam.setOriStartTime(startTime);
        applyTimeTypeParam.setOriEndTime(endTime);
        applyTimeTypeParam.setOriStartBtnTypeEnum(WtcTimeRangeBtnTypeEnum.getEnumByValue((String)startMethod));
        applyTimeTypeParam.setOriEndBtnTypeEnum(WtcTimeRangeBtnTypeEnum.getEnumByValue((String)endMethod));
        applyTimeTypeParam.setDisableTip(WtcTimeRangeControlService.getInstance().getDisableTip(BillTypeEnum.VACATIONBILL.getBillName()));
        WtcTimeRangeControlService.getInstance().setApplyTimeTypeData(applyTimeTypeParam, argsModel);
        CustomControl customControl = (CustomControl)this.getView().getControl("wtctimerange");
        wtcTimeRangeModel.setEvent(WtcTimeRangeEventEnum.CHANGE_TYPE.value);
        wtcTimeRangeModel.setArgs(argsModel);
        wtcTimeRangeModel.setTimestamp(new Date().getTime());
        customControl.setData((Object)wtcTimeRangeModel);
    }

    private void changeTypeAndCleanEvent() {
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue("startdate", null);
        model.setValue("enddate", null);
        model.setValue("startmethod", null);
        model.setValue("endmethod", null);
        model.setValue("selfadd", (Object)Boolean.TRUE);
        model.endInit();
    }

    private Date getDate(int vamethod, String dateStr) {
        if (WTCStringUtils.isEmpty((String)dateStr) || WTCStringUtils.equals((String)"null", (String)dateStr)) {
            LOG.warn("\u3010\u6279\u91cf\u4f11\u5047\u81ea\u5b9a\u4e49\u4e8b\u4ef6\u3011\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0cdateStr\uff1a{}", (Object)dateStr);
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        try {
            if (vamethod == WtcTimeRangeBtnTypeEnum.CUSTOM.code) {
                return dateTimeFormat.parse(dateStr);
            }
            return dateFormat.parse(dateStr);
        }
        catch (ParseException ex) {
            LOG.warn("\u3010\u6279\u91cf\u4f11\u5047\u81ea\u5b9a\u4e49\u4e8b\u4ef6\u3011\u65e5\u671f\u683c\u5f0f\u5f02\u5e38\u3002dateStr\uff1a{}", (Object)dateStr, (Object)ex);
            return null;
        }
    }
}

