/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.formplugin.web.vaapply.batch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.wtc.wtabm.business.vaapply.VaApplyService;
import kd.wtc.wtabm.business.vaapply.VaInfoService;
import kd.wtc.wtabm.business.vaapply.VaKDStringHelper;
import kd.wtc.wtabm.business.vaapply.batch.BatchVaApplyService;
import kd.wtc.wtabm.business.vaapply.batch.BatchVaInfoService;
import kd.wtc.wtabm.common.constants.batch.BatchVaInfoConstants;
import kd.wtc.wtabm.common.entity.vaapply.VaInfoVo;
import kd.wtc.wtabm.common.entity.vaapply.VaTypeSelectVo;
import kd.wtc.wtabm.formplugin.web.vaapply.batch.BatchVaApplyBillEdit;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.batchbill.BatchBillUnifyService;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRCSMServiceImpl;
import kd.wtc.wtbs.common.bill.batchbill.BatchBillCheckResult;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeTypeEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.wtctimerange.WtcTimeRangeModel;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class BatchVaInfoEdit
extends HRCoreBaseBillEdit
implements BeforeF7SelectListener,
BatchVaInfoConstants {
    private static final Log LOG = LogFactory.getLog(BatchVaInfoEdit.class);
    private BatchVaInfoService batchVaInfoService = (BatchVaInfoService)WTCAppContextHelper.getBean(BatchVaInfoService.class);
    private IFormView parentPageView = null;

    private IFormView getParentPageView() {
        if (this.parentPageView == null) {
            this.parentPageView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        }
        if (this.parentPageView == null) {
            throw new KDBizException(VaKDStringHelper.parentPageViewErr());
        }
        return this.parentPageView;
    }

    public void registerListener(EventObject event) {
        BasedataEdit vaTypeEdit;
        BasedataEdit attFileEdit = (BasedataEdit)this.getControl("attfilef7");
        if (attFileEdit != null) {
            attFileEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((vaTypeEdit = (BasedataEdit)this.getView().getControl("vacationtype")) != null) {
            vaTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject evt) {
        boolean addNew;
        LOG.info("\u3010\u6279\u91cf\u5047\u5355\u4fe1\u606f\u3011afterBindData");
        super.afterBindData(evt);
        boolean bl = addNew = OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus();
        if (addNew) {
            CustomControl customControl = (CustomControl)this.getView().getControl("wtctimerange");
            WtcTimeRangeModel wtcTimeRangeModel = VaInfoService.initWtcTimeRangeModel((VaInfoVo)new VaInfoVo(), (WtcTimeRangeTypeEnum)WtcTimeRangeTypeEnum.EDIT);
            customControl.setData((Object)wtcTimeRangeModel);
            this.getView().setVisible(Boolean.FALSE, new String[]{"applytimetxt"});
            this.syncMainToInfo();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"applytimetxt"});
            this.batchVaInfoService.initEditVaInfoForm(this.getView());
            this.syncMainToInfo();
            BatchVaApplyService.INSTANCE.setVaTimeText(this.getModel());
            this.getView().updateView("flexpanelap3");
        }
    }

    private void syncMainToInfo() {
        IFormView parentView = this.getParentPageView();
        if (parentView != null) {
            IDataModel parentModel = parentView.getModel();
            DynamicObject parentDataEntity = parentModel.getDataEntity(true);
            IDataModel model = this.getModel();
            model.beginInit();
            model.setValue("adminorg", parentDataEntity.get("adminorg"));
            model.setValue("org", parentDataEntity.get("org"));
            model.setValue("isfromdb", (Object)parentDataEntity.getDataEntityState().getFromDatabase());
            model.setValue("ischangebill", parentModel.getValue("ischangebill"));
            DynamicObjectCollection vaInfoEntryColl = parentDataEntity.getDynamicObjectCollection("entryentity");
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object editIndexObj = formShowParameter.getCustomParam("entryCurrentRowIndex");
            int editIndex = -1;
            if (editIndexObj != null) {
                editIndex = Integer.parseInt(String.valueOf(editIndexObj));
                DynamicObject vaInfoEntryDy = (DynamicObject)vaInfoEntryColl.get(editIndex);
                model.setValue("parentid", vaInfoEntryDy.get("entryparent"));
                DynamicObjectCollection subEntryEntityColl = vaInfoEntryDy.getDynamicObjectCollection("subentryentity");
                if (WTCCollections.isNotEmpty((Collection)subEntryEntityColl)) {
                    model.setValue("entryparentid", ((DynamicObject)subEntryEntityColl.get(0)).get("entryparentid"));
                }
            }
            Date maxVaDate = null;
            Date minVaDate = null;
            if (WTCCollections.isNotEmpty((Collection)vaInfoEntryColl)) {
                for (int index = 0; index < vaInfoEntryColl.size(); ++index) {
                    if (index == editIndex) continue;
                    DynamicObject vaInfoEntryDy = (DynamicObject)vaInfoEntryColl.get(index);
                    Date startDate = vaInfoEntryDy.getDate("startdate");
                    Date endDate = vaInfoEntryDy.getDate("enddate");
                    if (startDate != null) {
                        startDate = WTCDateUtils.getZeroDate((Date)startDate);
                        if (minVaDate == null) {
                            minVaDate = startDate;
                        } else if (startDate.compareTo(minVaDate) < 0) {
                            minVaDate = startDate;
                        }
                    }
                    if (endDate == null) continue;
                    endDate = WTCDateUtils.getZeroDate((Date)endDate);
                    if (maxVaDate == null) {
                        maxVaDate = endDate;
                        continue;
                    }
                    if (endDate.compareTo(maxVaDate) <= 0) continue;
                    maxVaDate = endDate;
                }
                model.setValue("maxvadate", maxVaDate);
                model.setValue("minvadate", minVaDate);
                int totalEntrySize = vaInfoEntryColl.size();
                if (editIndex > -1) {
                    --totalEntrySize;
                }
                model.setValue("countvaentry", (Object)totalEntrySize);
            }
            model.endInit();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        ChangeData[] changeSet;
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if ("vacationtype".equals(name) && (changeSet = args.getChangeSet()) != null && changeSet.length > 0) {
            Object newValue = changeSet[0].getNewValue();
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (newValue == null) {
                this.getModel().setValue("applytimetxt", (Object)"-");
            } else if (OperationStatus.ADDNEW != status) {
                BatchVaApplyService.INSTANCE.refreshVaTime(this.getView());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (WTCStringUtils.equals((String)operateKey, (String)"addentry")) {
            BasedataEdit control = (BasedataEdit)this.getControl("attfilef7");
            control.click();
        } else if (WTCStringUtils.equals((String)operateKey, (String)"ensure")) {
            BillResponse billResponse = this.batchVaInfoService.checkDateRule(this.getModel());
            if (!billResponse.isSuccess()) {
                boolean showMsg = true;
                OperateOption option = source.getOption();
                if (option.containsVariable("triggerFrom")) {
                    boolean bl = showMsg = !"dateChange".equals(option.getVariableValue("triggerFrom"));
                }
                if (showMsg) {
                    this.getView().showTipNotification(billResponse.topErrMsg());
                }
                args.setCancel(true);
                return;
            }
            OperateOption option = source.getOption();
            this.setEnsureOperation(option);
            LOG.info("BatchVaInfoEdit.syncMainToInfo,adminorg:{}", this.getModel().getDataEntity().get("adminorg.id"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (WTCStringUtils.equals((String)operateKey, (String)"ensure")) {
            int editRowIndex = this.getEditRowIndex();
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            if (editRowIndex >= 0) {
                Object source = afterDoOperationEventArgs.getSource();
                FormOperate formOperate = (FormOperate)source;
                OperateOption option = formOperate.getOption();
                this.handleEditVaInfoCheckResult(operationResult, option);
            } else {
                this.handleAddVaInfoCheckResult(operationResult);
            }
        }
    }

    private void handleEditVaInfoCheckResult(OperationResult operationResult, OperateOption option) {
        if (operationResult.isSuccess()) {
            String triggerFrom = "";
            if (option.containsVariable("triggerFrom")) {
                triggerFrom = option.getVariableValue("triggerFrom");
            }
            if (!"dateChange".equals(triggerFrom)) {
                this.getView().returnDataToParent((Object)this.getModel().getDataEntity());
                this.getView().close();
            }
            return;
        }
        operationResult.setShowMessage(false);
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        if (WTCCollections.isNotEmpty((Collection)allErrorOrValidateInfo)) {
            String message = ((IOperateInfo)allErrorOrValidateInfo.get(0)).getMessage();
            this.getView().showTipNotification(message);
        }
        BatchVaApplyService.INSTANCE.setVaTimeText(this.getModel());
    }

    private void handleAddVaInfoCheckResult(OperationResult operationResult) {
        operationResult.setShowMessage(false);
        if (!operationResult.isSuccess()) {
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            FormShowParameter showParameter = BatchBillUnifyService.getInstance().getBatchBillCheckResultForm(null, operationResult, this.getParentPageView().getPageCache(), entryRowCount);
            if (showParameter == null) {
                this.getView().showOperationResult(operationResult);
            } else {
                showParameter.setCloseCallBack(new CloseCallBack(BatchVaApplyBillEdit.class.getName(), "ensure"));
                this.getParentPageView().showForm(showParameter);
                showParameter.setShowTitle(false);
                this.getView().sendFormAction(this.getParentPageView());
                this.returnDataToParent(false);
                this.getView().close();
            }
        } else {
            this.returnDataToParent(true);
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        IDataModel model = this.getModel();
        if (WTCStringUtils.equals((String)actionId, (String)"attfilef7") && WTCCollections.isNotEmpty((Collection)(returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()))) {
            int[] rowIndexes = model.batchCreateNewEntryRow("entryentity", returnData.size());
            long[] ids = ID.genLongIds((int)returnData.size());
            for (int index = 0; index < returnData.size(); ++index) {
                ListSelectedRow listSelectedRow = returnData.get(index);
                long primaryKeyValue = (Long)listSelectedRow.getPrimaryKeyValue();
                int rowIndex = rowIndexes[index];
                model.setValue("attfilebasef7", (Object)primaryKeyValue, rowIndex);
                model.setValue("entryid", (Object)ids[index], rowIndex);
            }
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            for (int index = 0; index < entryEntity.size(); ++index) {
                DynamicObject entryDy = (DynamicObject)entryEntity.get(index);
                model.setValue("personid", entryDy.get("attfilebasef7.attperson"), index);
                model.setValue("attfile", entryDy.get("attfilebasef7.boid"), index);
                model.setValue("attfilename", entryDy.get("attfilebasef7.textname"), index);
            }
            model.updateCache();
            EntryGrid control = (EntryGrid)this.getControl("entryentity");
            control.setPageIndex(1);
        }
    }

    private void returnDataToParent(boolean allSuccess) {
        IDataModel model = this.getModel();
        if (!allSuccess) {
            DynamicObject dataEntity = model.getDataEntity(true);
            DynamicObjectCollection attFileEntryColl = dataEntity.getDynamicObjectCollection("entryentity");
            attFileEntryColl.removeIf(item -> !item.getBoolean("checksuccess"));
        }
        BatchBillCheckResult billCheckResult = new BatchBillCheckResult();
        billCheckResult.setAllSuccess(allSuccess);
        billCheckResult.setData((Object)model.getDataEntity(true));
        IFormView parentPageView = this.getParentPageView();
        parentPageView.getPageCache().put("vaReturnToParentData", SerializationUtils.serializeToBase64((Object)billCheckResult));
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (WTCStringUtils.equals((String)key, (String)"attfilef7")) {
            DynamicObject billDyn = this.getModel().getDataEntity();
            long adminOrgId = billDyn.getLong("adminorg.id");
            if (adminOrgId == 0L) {
                IFormView parentPageView = this.getParentPageView();
                IDataModel parentModel = parentPageView.getModel();
                adminOrgId = parentModel.getDataEntity().getLong("adminorg.id");
            }
            if (adminOrgId != 0L) {
                QFilter qFilter = new QFilter("adminorg.id", "=", (Object)adminOrgId);
                evt.addCustomQFilter(qFilter);
            }
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            String authAppId = BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView());
            formShowParameter.setCustomParam("orgAppId", (Object)authAppId);
            formShowParameter.setCustomParam("orgEntityId", (Object)"wtabm_batchvaapply");
            formShowParameter.setCustomParam("orgField", (Object)"attfilebasef7.affiliateadminorg");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "attfilef7"));
            AttFileQueryServiceImpl.getInstance().setFileF7OrgPerm((FormShowParameter)formShowParameter, "wtabm_batchvaapply", authAppId);
            HRCSMServiceImpl ihrcsmService = HRCSMServiceImpl.getInstance();
            QFilter dataRuleForBdProp = ihrcsmService.getDataRuleForBdProp(Long.valueOf(RequestContext.get().getCurrUserId()), authAppId, "wtabm_batchvaapply", "attfilebasef7", "47150e89000000ac", (Map)Maps.newHashMap());
            evt.addCustomQFilter(dataRuleForBdProp);
            formShowParameter.setMultiSelect(true);
            List selectedAttFileBaseIds = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").stream().map(dyn -> dyn.getLong("attfilebasef7.id")).collect(Collectors.toList());
            if (WTCCollections.isNotEmpty(selectedAttFileBaseIds)) {
                QFilter qFilter = new QFilter("id", "not in", selectedAttFileBaseIds);
                evt.addCustomQFilter(qFilter);
            }
        } else if (WTCStringUtils.equals((String)key, (String)"vacationtype")) {
            this.handleVaTypeF7(evt);
        }
    }

    private void handleVaTypeF7(BeforeF7SelectEvent evt) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        QFilter filter = WTCHisServiceHelper.statusValidQFilter();
        DynamicObject orgDy = dataEntity.getDynamicObject("org");
        if (orgDy != null) {
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"wtbd_vacationtype", (Long)orgDy.getLong("id"));
            if (baseDataFilter != null) {
                filter.and(baseDataFilter);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8003\u52e4\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"VaApplyService_08", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
        }
        ArrayList filters = Lists.newArrayListWithExpectedSize((int)2);
        filters.add(filter);
        DynamicObjectCollection vaInfoColl = dataEntity.getDynamicObjectCollection("entryentity");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (WTCCollections.isNotEmpty((Collection)vaInfoColl) && OperationStatus.EDIT == formShowParameter.getStatus()) {
            IFormView parentView;
            long parentBillId = dataEntity.getLong("parentid");
            long entryParentId = dataEntity.getLong("entryparentid");
            DynamicObject vaInfoDy = (DynamicObject)vaInfoColl.get(0);
            long attfileBoid = vaInfoDy.getLong("attfilebasef7.boid");
            DynamicObject parentBillDyn = null;
            String entityId = "wtabm_vaapply";
            if (parentBillId != 0L) {
                parentBillDyn = HRBaseServiceHelper.create((String)entityId).loadSingle((Object)parentBillId);
            }
            if ((parentView = this.getParentPageView()) != null) {
                entityId = parentView.getEntityId();
            }
            String appId = BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView());
            List changeVaTypes = VaApplyService.getVaTypes((long)attfileBoid, (DynamicObject)parentBillDyn, (long)entryParentId, (String)entityId, (String)appId);
            Set enumTypeIdSet = changeVaTypes.stream().map(VaTypeSelectVo::getVaTypeId).collect(Collectors.toSet());
            QFilter audit = new QFilter("id", "in", enumTypeIdSet);
            filters.add(audit);
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().addAll(filters);
        showParameter.getListFilterParameter().setOrderBy("number");
    }

    private void setEnsureOperation(OperateOption option) {
        DynamicObject dataEntity = this.getParentPageView().getModel().getDataEntity(true);
        option.setVariableValue("parentbillmodel", SerializationUtils.serializeToBase64((Object)dataEntity));
        option.setVariableValue("entryCurrentRowIndex", String.valueOf(this.getEditRowIndex()));
    }

    private int getEditRowIndex() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object editRowIndexObj = formShowParameter.getCustomParam("entryCurrentRowIndex");
        return editRowIndexObj == null ? -1 : Integer.parseInt(String.valueOf(editRowIndexObj));
    }
}

