/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.formplugin.web.vaapply.mob.datesel;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtabm.business.vaapply.checker.VaEntityCheckService;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.common.components.DateSelCustomConstants;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.enums.bill.va.SpecialVaTypeEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.formplugin.web.mobile.DateSelCustomUtil;

public class VaDateSelCustomPlugin
extends AbstractMobFormPlugin
implements DateSelCustomConstants {
    private static final Log LOG = LogFactory.getLog(VaDateSelCustomPlugin.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btndetermine"});
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btndetermine": {
                HashMap<String, String> returnData = new HashMap<String, String>(16);
                LOG.info("VaDateSelCustomPlugin.click.DATERMINE.starttime:{}", (Object)System.currentTimeMillis());
                if (this.submitCheck(returnData)) {
                    return;
                }
                LOG.info("VaDateSelCustomPlugin.click.DATERMINE.endtime:{}", (Object)System.currentTimeMillis());
                LOG.info("VaDateSelCustomPlugin.click.DATERMINE.returndata:{}", returnData);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                break;
            }
        }
    }

    private boolean submitCheck(Map<String, String> returnData) {
        Long attFileBo = (Long)this.getView().getFormShowParameter().getCustomParam("attFileBo");
        String entryEntityStr = (String)this.getView().getFormShowParameter().getCustomParam("entryentity");
        DynamicObject entryEntity = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)entryEntityStr);
        ApplyBillCheckEnum checkEnum = ApplyBillCheckEnum.VACATION;
        boolean entryReturnDataSuccess = DateSelCustomUtil.setEntityReturnData((IDataModel)this.getModel(), (IFormView)this.getView(), returnData, (DynamicObject)entryEntity, (String)"entrystartdate", (String)"entryenddate", (String)"entrystarttimetext", (String)"entryendtimetext", (String)"entrystartmethod", (String)"entryendmethod");
        if (!entryReturnDataSuccess) {
            return true;
        }
        LOG.info("DateSelCustomPlugin.submitCheck.VAAPPLY.attFileBo:{}", (Object)attFileBo);
        LOG.info("DateSelCustomPlugin.submitCheck.VAAPPLY.entryEntity:{}", (Object)entryEntity);
        if (DateSelCustomUtil.showTipCheck((IFormView)this.getView(), returnData, (DynamicObject)entryEntity, (String)"entrystartdate", (String)"entryenddate")) {
            return true;
        }
        VaEntityCheckService billCommonCheckHelper = (VaEntityCheckService)WTCAppContextHelper.getBean(VaEntityCheckService.class);
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView viewNoPlugin = this.getView().getViewNoPlugin(parentPageId);
        if (viewNoPlugin == null) {
            LOG.info("\u83b7\u53d6\u7236\u9875\u9762ID\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u9875\u9762\u5df2\u5931\u6548\u3002");
            return true;
        }
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView()), viewNoPlugin.getEntityId());
        billCommonCheckHelper.initBean(attFileBo, UnifyBillEnum.VA, checkEnum, entryEntity, applyAttr);
        if (entryEntity.get("entryvacationtype") != null) {
            DynamicObject baseSetDy = null;
            BillResponse response = billCommonCheckHelper.checkAndGetBaseSetDy();
            if (response.isSuccess()) {
                baseSetDy = (DynamicObject)response.getData();
            }
            if (baseSetDy != null && StringUtils.equals((CharSequence)baseSetDy.getString("specialdaytype"), (CharSequence)SpecialVaTypeEnum.LACTATION_TYPE.vaType)) {
                return false;
            }
            LOG.info("VaDateSelCustomPlugin.submitCheck.entryvacationtype.starttime:{}", (Object)System.currentTimeMillis());
            BillResponse billResponse = billCommonCheckHelper.checkBaseSet();
            LOG.info("VaDateSelCustomPlugin.submitCheck.entryvacationtype.endtime:{}", (Object)System.currentTimeMillis());
            if (!billResponse.isSuccess()) {
                this.getView().showTipNotification((String)billResponse.getMessage().get(0));
                return true;
            }
        } else {
            BillResponse billResponse = billCommonCheckHelper.checkStartDateAndEndDate();
            if (!billResponse.isSuccess()) {
                this.getView().showTipNotification((String)billResponse.getMessage().get(0));
                return true;
            }
        }
        return false;
    }
}

