/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.formplugin.web.vaimport;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtabm.business.vaapply.VaCommonService;
import kd.wtc.wtabm.business.vaapply.VaKDStringHelper;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class VaApplyImportEdit
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(VaApplyImportEdit.class);
    private Map<String, DynamicObject> numberAndTop1 = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> numberAndPersonDy = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> numberAndAttFileBoDy = new HashMap<String, DynamicObject>(16);
    private Long personId = null;

    private Long getPersonId() {
        if (this.personId == null) {
            this.personId = BillUnifyService.getUserId();
        }
        return this.personId;
    }

    private boolean checkMustInput(DynamicObject billDyn, ImportDataEventArgs e) {
        boolean fail = false;
        if (billDyn.get("org") == null) {
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u8003\u52e4\u7ba1\u7406\u7ec4\u7ec7\u4e3a\u5fc5\u586b\u9879\u3002", (String)"VaApplyImportEdit_13", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
            fail = true;
        }
        if (billDyn.get("attfilebasef7") == null) {
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u4f11\u5047\u5458\u5de5\u4e3a\u5fc5\u586b\u9879\u3002", (String)"VaApplyImportEdit_14", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
            fail = true;
        }
        DynamicObjectCollection entries = billDyn.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject row = (DynamicObject)entries.get(i);
            if (row.get("entryvacationtype") == null) {
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), ResManager.loadKDString((String)"\u4f11\u5047\u7c7b\u578b\u4e3a\u5fc5\u586b\u9879\u3002", (String)"VaApplyImportEdit_15", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
                fail = true;
            }
            if (row.get("entrystartmethod") == null) {
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), ResManager.loadKDString((String)"\u4f11\u5047\u65b9\u5f0f\uff08\u5f00\u59cb\uff09\u4e3a\u5fc5\u586b\u9879\u3002", (String)"VaApplyImportEdit_16", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
                fail = true;
            }
            if (row.get("entrystartdate") == null) {
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), ResManager.loadKDString((String)"\u4f11\u5047\u5f00\u59cb\u65e5\u671f\u4e3a\u5fc5\u586b\u9879\u3002", (String)"VaApplyImportEdit_17", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
                fail = true;
            }
            if (row.get("entrystartmethod") == null) {
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), ResManager.loadKDString((String)"\u4f11\u5047\u65b9\u5f0f\uff08\u7ed3\u675f\uff09\u4e3a\u5fc5\u586b\u9879\u3002", (String)"VaApplyImportEdit_18", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
                fail = true;
            }
            if (row.get("entrystartdate") != null) continue;
            e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), ResManager.loadKDString((String)"\u4f11\u5047\u7ed3\u675f\u65e5\u671f\u4e3a\u5fc5\u586b\u9879\u3002", (String)"VaApplyImportEdit_19", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
            fail = true;
        }
        return fail;
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        List sourceDataList = e.getSourceDataList();
        if (CollectionUtils.isEmpty((Collection)sourceDataList)) {
            return;
        }
        BillCommonService commonService = new BillCommonService();
        commonService.initBillImportData(this.getView(), sourceDataList, this.numberAndTop1, this.numberAndPersonDy, this.numberAndAttFileBoDy);
    }

    public void afterImportData(ImportDataEventArgs eventArgs) {
        super.afterImportData(eventArgs);
        BillModel billModel = (BillModel)eventArgs.getSource();
        DynamicObject dataEntity = billModel.getDataEntity(true);
        if (!dataEntity.getBoolean("isneedhand")) {
            dataEntity.set("handperson", null);
            dataEntity.set("handreason", null);
        }
        VaCommonService vaCommonService = new VaCommonService();
        Date now = new Date();
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity");
        int entryCount = dynamicObjectCollection.size();
        for (int idx = 0; idx < entryCount; ++idx) {
            DynamicObject entry = (DynamicObject)dynamicObjectCollection.get(idx);
            entry.set("entrystartdate", entry.get("vaentrystartdate"));
            entry.set("entryenddate", entry.get("vaentryenddate"));
            if (this.isIllegalStart(entryCount, idx + 1, entry, eventArgs, vaCommonService) || this.isIllegalEnd(entryCount, idx + 1, entry, eventArgs, vaCommonService) || this.isIllegalDateRange(entryCount, idx + 1, entry, eventArgs, vaCommonService) || this.isIllegalMethod(entryCount, idx + 1, entry, eventArgs, vaCommonService)) {
                eventArgs.setCancel(true);
                return;
            }
            entry.set("owndate", (Object)now);
        }
        if (this.checkMustInput(dataEntity, eventArgs)) {
            eventArgs.setCancel(true);
            return;
        }
        DynamicObject attFileF7Dy = dataEntity.getDynamicObject("attfilebasef7");
        if (attFileF7Dy != null) {
            String number = attFileF7Dy.getString("number");
            if (HRStringUtils.isEmpty((String)number)) {
                return;
            }
            DynamicObject attFileDy = this.numberAndAttFileBoDy.get(number);
            String attFileError = BillCommonService.getInstance().judgeAttFile(attFileDy, BillTypeEnum.VACATIONBILL.getBillName());
            if (HRStringUtils.isNotEmpty((String)attFileError)) {
                eventArgs.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), attFileError);
                eventArgs.setCancel(true);
                return;
            }
            dataEntity.set("attfile", (Object)attFileDy);
            dataEntity.set("personid", (Object)this.numberAndPersonDy.get(number));
            DynamicObject top1Dy = this.numberAndTop1.get(number);
            if (top1Dy == null) {
                eventArgs.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u60a8\u672a\u6709\u201d\u6863\u6848\u7f16\u53f7\u201c\u4e3a%s\u7684\u6570\u636e\u6743\u9650\uff0c\u65b0\u589e\u6570\u636e\u5931\u8d25\u3002", (String)"VaApplyImportEdit_1", (String)"wtc-wtabm-formplugin", (Object[])new Object[]{number}));
                eventArgs.setCancel(true);
                return;
            }
            dataEntity.set("attfilebasef7", (Object)top1Dy);
            Long attPerson = this.getPersonId();
            if (attPerson != null && dataEntity.getLong("personid.id") == attPerson.longValue()) {
                eventArgs.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u4e0d\u53ef\u4ee3\u81ea\u5df1\u53d1\u8d77\u7533\u8bf7\u64cd\u4f5c\u3002", (String)"VaApplyImportEdit_12", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
                eventArgs.setCancel(true);
                return;
            }
        }
    }

    private boolean isIllegalDateRange(int entryCount, int idx, DynamicObject entry, ImportDataEventArgs e, VaCommonService vaCommonService) {
        try {
            Date start = entry.getDate("entrystartdate");
            Date end = entry.getDate("entryenddate");
            if (start.getTime() > end.getTime()) {
                this.dealImport(e, vaCommonService.getMsg(entryCount, idx, VaKDStringHelper.startTimeAfterEndTime()));
                return true;
            }
            return false;
        }
        catch (Exception exp) {
            LOG.warn((Throwable)exp);
            this.dealImport(e, this.getDefaultMsg());
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), this.getDefaultMsg());
            e.setCancel(true);
            return true;
        }
    }

    private boolean isIllegalStart(int entryCount, int idx, DynamicObject entry, ImportDataEventArgs e, VaCommonService validateService) {
        try {
            Date startZero;
            String startMethod = entry.getString("entrystartmethod");
            Date start = entry.getDate("entrystartdate");
            if (StringUtils.equalsAny((CharSequence)startMethod, (CharSequence[])new CharSequence[]{WtcTimeRangeBtnTypeEnum.HALF_UP.value, WtcTimeRangeBtnTypeEnum.HALF_DOWN.value, WtcTimeRangeBtnTypeEnum.DAY.value}) && (startZero = WTCDateUtils.getZeroDate((Date)start)).getTime() != start.getTime()) {
                this.dealImport(e, validateService.getMsg(entryCount, idx, ResManager.loadKDString((String)"\u201c\u4f11\u5047\u65b9\u5f0f\uff08\u5f00\u59cb\uff09\u201d\u7b49\u4e8e\u5168\u5929/\u4e0a\u534a\u5929/\u4e0b\u534a\u5929\u65f6\uff0c\u201c\u4f11\u5047\u5f00\u59cb\u65f6\u95f4\u201d\u683c\u5f0f\u53ea\u80fd\u586b\u5199\u5e74\u6708\u65e5\u90e8\u5206\uff08\u5982\uff1a2023-03-01 00:00:00\uff09\u3002", (String)"VaApplyImportEdit_5", (String)"wtc-wtabm-formplugin", (Object[])new Object[0])));
                return true;
            }
            return false;
        }
        catch (Exception exp) {
            LOG.warn((Throwable)exp);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), validateService.getMsg(entryCount, idx, this.getDefaultMsg()));
            e.setCancel(true);
            return true;
        }
    }

    private boolean isIllegalEnd(int entryCount, int idx, DynamicObject entry, ImportDataEventArgs e, VaCommonService validateService) {
        try {
            Date endZero;
            String endMethod = entry.getString("entryendmethod");
            Date end = entry.getDate("entryenddate");
            if (StringUtils.equalsAny((CharSequence)endMethod, (CharSequence[])new CharSequence[]{WtcTimeRangeBtnTypeEnum.HALF_UP.value, WtcTimeRangeBtnTypeEnum.HALF_DOWN.value, WtcTimeRangeBtnTypeEnum.DAY.value}) && (endZero = WTCDateUtils.getZeroDate((Date)end)).getTime() != end.getTime()) {
                this.dealImport(e, validateService.getMsg(entryCount, idx, ResManager.loadKDString((String)"\u201c\u4f11\u5047\u65b9\u5f0f\uff08\u7ed3\u675f\uff09\u201d\u7b49\u4e8e\u5168\u5929/\u4e0a\u534a\u5929/\u4e0b\u534a\u5929\u65f6\uff0c\u201c\u4f11\u5047\u7ed3\u675f\u65f6\u95f4\u201d\u683c\u5f0f\u53ea\u80fd\u586b\u5199\u5e74\u6708\u65e5\u90e8\u5206\uff08\u5982\uff1a2023-03-01 00:00:00\uff09\u3002", (String)"VaApplyImportEdit_6", (String)"wtc-wtabm-formplugin", (Object[])new Object[0])));
                e.setCancel(true);
                return true;
            }
            return false;
        }
        catch (Exception exp) {
            LOG.warn((Throwable)exp);
            this.dealImport(e, validateService.getMsg(entryCount, idx, this.getDefaultMsg()));
            return true;
        }
    }

    private boolean isIllegalMethod(int entryCount, int idx, DynamicObject entry, ImportDataEventArgs e, VaCommonService validateService) {
        try {
            String startMethod = entry.getString("entrystartmethod");
            String endMethod = entry.getString("entryendmethod");
            if (WtcTimeRangeBtnTypeEnum.DAY.value.equals(startMethod)) {
                if (!WtcTimeRangeBtnTypeEnum.DAY.value.equals(endMethod)) {
                    this.dealImport(e, validateService.getMsg(entryCount, idx, VaKDStringHelper.startMethodDayCheck()));
                    return true;
                }
            } else {
                boolean endMethodIsNotHalf;
                boolean bl = endMethodIsNotHalf = !WtcTimeRangeBtnTypeEnum.HALF_UP.value.equals(endMethod) && !WtcTimeRangeBtnTypeEnum.HALF_DOWN.value.equals(endMethod);
                if (WtcTimeRangeBtnTypeEnum.HALF_UP.value.equals(startMethod)) {
                    if (endMethodIsNotHalf) {
                        this.dealImport(e, validateService.getMsg(entryCount, idx, VaKDStringHelper.startMethodHalfUpCheck()));
                        return true;
                    }
                } else if (WtcTimeRangeBtnTypeEnum.HALF_DOWN.value.equals(startMethod)) {
                    if (WtcTimeRangeBtnTypeEnum.HALF_UP.value.equals(endMethod)) {
                        Date start = entry.getDate("entrystartdate");
                        Date end = entry.getDate("entryenddate");
                        Date startZero = WTCDateUtils.getZeroDate((Date)start);
                        Date endZero = WTCDateUtils.getZeroDate((Date)end);
                        if (startZero.getTime() >= endZero.getTime()) {
                            this.dealImport(e, validateService.getMsg(entryCount, idx, VaKDStringHelper.startMethodHalfDownNoCrossDayCheck()));
                            return true;
                        }
                    } else if (endMethodIsNotHalf) {
                        this.dealImport(e, validateService.getMsg(entryCount, idx, VaKDStringHelper.startMethodHalfDownCheck()));
                        return true;
                    }
                } else if (WtcTimeRangeBtnTypeEnum.CUSTOM.value.equals(startMethod) && !WtcTimeRangeBtnTypeEnum.CUSTOM.value.equals(endMethod)) {
                    this.dealImport(e, validateService.getMsg(entryCount, idx, VaKDStringHelper.startMethodCustomCheck()));
                    return true;
                }
            }
            return false;
        }
        catch (Exception exp) {
            LOG.warn((Throwable)exp);
            this.dealImport(e, validateService.getMsg(entryCount, idx, this.getDefaultMsg()));
            return true;
        }
    }

    private String getDefaultMsg() {
        return ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002 \u8bf7\u68c0\u67e5\u6570\u636e\u6a21\u677f\uff1a1\u3001\u6570\u636e\u6a21\u677f\u4e0e\u5355\u636e\u5b9e\u4f53\u662f\u5426\u5339\u914d\uff1b2\u3001\u6570\u636e\u6a21\u677f\u662f\u5426\u5728\u7b2c\u4e00\u4e2a\u5de5\u4f5c\u8868\u3002", (String)"VaApplyImportEdit_20", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]);
    }

    private void dealImport(ImportDataEventArgs eventArgs, String errorMsg) {
        if (eventArgs != null) {
            eventArgs.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), errorMsg);
            eventArgs.setCancel(true);
        }
    }
}

