/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.formplugin.web.vaimport;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.ReflectionUtils;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class VaImportPlugin
extends BatchImportPlugin {
    private static final Log LOG = LogFactory.getLog(VaImportPlugin.class);

    public List<String> getDefaultLockUIs() {
        List lockUis = super.getDefaultLockUIs();
        lockUis.add("radiofield1");
        lockUis.add("radiofield2");
        return lockUis;
    }

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        try {
            Field view = ctx.getClass().getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            IFormView formView = (IFormView)view.get(ctx);
            ctx.addOption("appid", (Object)BillCommonService.getInstance().getAuthAppIdForFormPlugin(formView));
            ctx.addOption("appnumber", (Object)BillCommonService.getInstance().getAuthAppIdForFormPlugin(formView));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOG.warn("OtImportPlugin setContext warn", (Throwable)e);
        }
        return super.setContext(rc, ctx, startArgs);
    }

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return 1000;
    }

    protected void beforeSave(List<ImportBillData> billDatas, ImportLogger logger) {
        super.beforeSave(billDatas, logger);
        Iterator<ImportBillData> iterator = billDatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData bill = iterator.next();
            JSONObject data = bill.getData();
            JSONArray entryEntity = data.getJSONArray("entryentity");
            boolean fail = false;
            for (int i = 0; i < entryEntity.size(); ++i) {
                JSONObject entry = entryEntity.getJSONObject(i);
                Integer rowNum = entry.getInteger("rowNum");
                if (!this.resetDateStr("vaentrystartdate", entry)) {
                    this.log(rowNum, ResManager.loadKDString((String)"\u4f11\u5047\u5f00\u59cb\u65f6\u95f4\uff1a%s \u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"VaImportPlugin_1", (String)"wtc-wtabm-formplugin", (Object[])new Object[]{entry.getString("vaentrystartdate")}), logger);
                    fail = true;
                }
                if (this.resetDateStr("vaentryenddate", entry)) continue;
                this.log(rowNum, ResManager.loadKDString((String)"\u4f11\u5047\u7ed3\u675f\u65f6\u95f4\uff1a%s \u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"VaImportPlugin_2", (String)"wtc-wtabm-formplugin", (Object[])new Object[]{entry.getString("vaentryenddate")}), logger);
                fail = true;
            }
            if (!fail) continue;
            iterator.remove();
            logger.fail();
            logger.signTotalRow(bill.getEndIndex() - bill.getStartIndex() + 1);
        }
    }

    private void log(int rowIndex, String errorMsg, ImportLogger logger) {
        Map logCache = logger.getLogCache();
        if (logCache.get(rowIndex) != null) {
            ((List)logCache.get(rowIndex)).add(new ImportLogger.ImportLog(errorMsg));
            logger.setLogCache(logCache);
        } else {
            logger.log(Integer.valueOf(rowIndex), errorMsg);
        }
    }

    private boolean resetDateStr(String key, JSONObject entry) {
        try {
            Date date = this.str2Date(entry.getString(key));
            if (date == null) {
                return false;
            }
            entry.getInnerMap().put(key, WTCDateUtils.date2Str((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
            return true;
        }
        catch (Exception exp) {
            return false;
        }
    }

    private Date str2Date(String dateStr) {
        if (dateStr == null) {
            return null;
        }
        Date date = WTCDateUtils.str2Date((String)dateStr, (String)"yyyy-MM-dd HH:mm:ss");
        if (date != null) {
            return date;
        }
        return WTCDateUtils.str2Date((String)dateStr, (String)"yyyy-MM-dd HH:mm");
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        return super.save(rowdatas, logger);
    }
}

