/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.formplugin.web.vaupdate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.wtc.wtabm.business.vaapply.VaApplyService;
import kd.wtc.wtabm.business.vaapply.VaApplyServiceHelper;
import kd.wtc.wtabm.business.vaapply.VaKDStringHelper;
import kd.wtc.wtabm.business.vaapply.checker.VaBillCheckService;
import kd.wtc.wtabm.business.vaapply.checker.VaEntityCheckService;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.bill.BillOpenStyleEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.formplugin.util.WTCBillViewUtils;

public class VaUpdateBillEdit
extends HRCoreBaseBillEdit {
    private static final Log LOG = LogFactory.getLog(VaUpdateBillEdit.class);
    private final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtabm_vaupdate");
    private static final VaApplyServiceHelper VA_APPLY_SERVICE_HELPER = (VaApplyServiceHelper)WTCAppContextHelper.getBean(VaApplyServiceHelper.class);
    VaApplyService vaApplyService = (VaApplyService)WTCAppContextHelper.getBean(VaApplyService.class);

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        BillShowParameter billShowParameter = (BillShowParameter)evt.getFormShowParameter();
        Long parentId = (Long)billShowParameter.getCustomParam("parentid");
        if (parentId != null) {
            StringBuilder errMsg = new StringBuilder();
            boolean require = WTCBillViewUtils.requireMutex((String)String.valueOf(parentId), (String)"wtabm_vaapply", (String)"update", (StringBuilder)errMsg);
            if (!require) {
                evt.setCancel(true);
                evt.setCancelMessage(errMsg.toString());
            }
        }
    }

    public void beforeBindData(EventObject object) {
        super.beforeBindData(object);
    }

    public void afterBindData(EventObject object) {
        super.afterBindData(object);
        this.getModel().beginInit();
        BillShowParameter formShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        BillOperationStatus status = formShowParameter.getBillStatus();
        if (status.equals((Object)BillOperationStatus.ADDNEW)) {
            Long parentId = (Long)formShowParameter.getCustomParam("parentid");
            this.copyModel(parentId);
            BillUnifyService.setPersonInfo((IFormView)this.getView());
            this.copyAttachment(parentId);
        }
        this.getModel().updateEntryCache(this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity"));
        this.getModel().endInit();
        this.getView().updateView("attachflex");
        this.loadHisInfo();
        this.loadBillState();
        this.getModel().setDataChanged(false);
        this.getView().setVisible(Boolean.FALSE, new String[]{"lab_changeperson"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"attfilebasef7", "org"});
        Long id = (Long)this.getModel().getValue("id");
        if (status.equals((Object)BillOperationStatus.ADDNEW) || id == null || id == 0L) {
            BillCommonService billCommonService = new BillCommonService();
            UnifyBillApplyAttr unifyBillApplyAttr = new UnifyBillApplyAttr(billCommonService.getAuthAppIdForFormPlugin(this.getView()), this.getView().getEntityId(), "attfilebasef7");
            billCommonService.showAttFileChangeInfoAndUpdate(this.getView(), this.getView().getModel(), unifyBillApplyAttr);
        }
        boolean isNotLeave = (Boolean)this.getModel().getValue("isnotleave");
        this.dealIsNeedHand(isNotLeave);
    }

    private void loadBillState() {
        boolean isNotLeave = (Boolean)this.getModel().getValue("isnotleave");
        this.getModel().setValue("billstate", (Object)(isNotLeave ? "2" : "1"));
    }

    private void cancelStateChanged(List<String> propNames) {
        DataEntityState dataEntityState = this.getModel().getDataEntity().getDataEntityState();
        DataEntityPropertyCollection properties = this.getModel().getDataEntity().getDataEntityType().getProperties();
        for (int i = 0; i < properties.size(); ++i) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get(i);
            String name = iDataEntityProperty.getName();
            if (!HRStringUtils.isNotEmpty((String)name) || !propNames.contains(name)) continue;
            dataEntityState.setBizChanged(i, false);
        }
    }

    private void copyAttachment(Long parentId) {
        Long pkValue = DB.genGlobalLongId();
        this.getModel().getDataEntity().set("id", (Object)pkValue);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_attachment");
        QFilter filter = new QFilter("finterid", "=", (Object)parentId.toString());
        DynamicObject[] originalAttachments = helper.loadDynamicObjectArray(new QFilter[]{filter});
        if (originalAttachments == null || originalAttachments.length == 0) {
            return;
        }
        DynamicObject[] attachments = new DynamicObject[originalAttachments.length];
        for (int i = 0; i < originalAttachments.length; ++i) {
            DynamicObject attachment = originalAttachments[i];
            DynamicObject newAttachment = helper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)attachment, (DynamicObject)newAttachment);
            newAttachment.set("fbilltype", (Object)this.getView().getFormShowParameter().getFormId());
            newAttachment.set("finterid", (Object)pkValue);
            attachments[i] = newAttachment;
        }
        helper.save(attachments);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String billState;
        boolean changeNotLeave;
        boolean isNotLeave;
        String name = args.getProperty().getName();
        if (args.getChangeSet() == null || args.getChangeSet().length <= 0) {
            return;
        }
        if (StringUtils.equals((CharSequence)"billstate", (CharSequence)name) && (isNotLeave = ((Boolean)this.getModel().getValue("isnotleave")).booleanValue()) != (changeNotLeave = StringUtils.equals((CharSequence)(billState = (String)args.getChangeSet()[0].getNewValue()), (CharSequence)"2"))) {
            this.getModel().setValue("isnotleave", (Object)changeNotLeave);
        }
        if (StringUtils.equals((CharSequence)"isnotleave", (CharSequence)name)) {
            long parentId = (Long)this.getModel().getValue("parentid");
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtabm_vaapply");
            DynamicObject parentDynObj = serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)parentId));
            DynamicObjectCollection parentEntry = parentDynObj.getDynamicObjectCollection("entryentity");
            this.getModel().deleteEntryData("entryentity");
            this.getModel().batchCreateNewEntryRow("entryentity", parentEntry.size());
            this.copyEntry(parentEntry);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            boolean isNotLeave2 = (Boolean)this.getModel().getValue("isnotleave");
            this.dealIsNeedHand(isNotLeave2);
            if (isNotLeave2) {
                for (int index = 0; index < entryEntity.size(); ++index) {
                    this.getModel().setValue("entryapplytime", (Object)0, index);
                    this.getModel().setValue("entryvatimeday", (Object)0, index);
                    this.getModel().setValue("entryvatimehour", (Object)0, index);
                }
                this.getModel().setValue("applytime", (Object)0);
            } else {
                this.refreshApplyTimes();
            }
            this.dealSingle(entryEntity);
            this.vaApplyService.dealBreastfeedingLeave(this.getView());
            VaApplyService.summaryVaTypeTime((IFormView)this.getView());
            this.vaApplyService.handleVisForQuota(this.getView());
        }
    }

    private void dealSingle(DynamicObjectCollection entryEntity) {
        String billStyle = this.getModel().getDataEntity().getString("billstyle");
        if (StringUtils.equals((CharSequence)billStyle, (CharSequence)BillOpenStyleEnum.SINGLE.getCode()) && WTCCollections.isNotEmpty((Collection)entryEntity)) {
            VaApplyService.showSinglePageInContainer((IFormView)this.getView());
        }
    }

    private void dealIsNeedHand(boolean isNotLeave) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        IPageCache pageCache = this.getView().getPageCache();
        if (isNotLeave) {
            Map handInfoMap = WTCCollections.modifiableMap((Object)"isneedhand", (Object)String.valueOf(dataEntity.getBoolean("isneedhand")));
            handInfoMap.put("handperson", dataEntity.getString("handperson"));
            handInfoMap.put("handreason", dataEntity.getString("handreason"));
            pageCache.put(handInfoMap);
            this.getModel().setValue("isneedhand", (Object)false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isneedhand"});
            this.getModel().setValue("applytime", (Object)0);
        } else {
            String isNeedHandStr = pageCache.get("isneedhand");
            if (WTCStringUtils.isNotEmpty((String)isNeedHandStr) && Boolean.parseBoolean(isNeedHandStr)) {
                this.getModel().setValue("isneedhand", (Object)true);
                this.getModel().setValue("handperson", (Object)pageCache.get("handperson"));
                this.getModel().setValue("handreason", (Object)pageCache.get("handreason"));
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"isneedhand"});
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        this.cancelStateChanged(Collections.singletonList("isnotleave"));
    }

    private void loadHisInfo() {
        long parentId = this.getModel().getDataEntity().getLong("parentid");
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        boolean isHaveChange = this.getModel().getDataEntity().getBoolean("ishavechange");
        if (parentId == 0L) {
            return;
        }
        ArrayList<Long> list = new ArrayList<Long>();
        this.getParentIdList(list, parentId);
        list.add(pkValue);
        if (isHaveChange) {
            this.getChildIdList(list, pkValue);
        }
        ListShowParameter lsp = new ListShowParameter();
        ListFilterParameter fParameter = new ListFilterParameter();
        QFilter filter = new QFilter("id", "in", list);
        fParameter.setFilter(filter);
        lsp.setListFilterParameter(fParameter);
        lsp.getOpenStyle().setShowType(ShowType.InContainer);
        lsp.setBillFormId(this.getView().getFormShowParameter().getFormId());
        lsp.setFormId("wtbs_rimlesslist");
        lsp.getOpenStyle().setTargetKey("flexformhis");
        lsp.setHasRight(true);
        lsp.setCustomParam("billno", (Object)this.getModel().getDataEntity().getString("billno"));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        lsp.setCustomParam("wtcbill_hasright", formShowParameter.getCustomParam("wtcbill_hasright"));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void getParentIdList(List<Long> list, Long parentId) {
        DynamicObject parentDynObj = this.serviceHelper.queryOne(String.join((CharSequence)",", "ischange", "parentid"), new QFilter("id", "=", (Object)parentId));
        if (parentDynObj != null) {
            boolean isChange = parentDynObj.getBoolean("ischange");
            list.add(parentId);
            if (isChange) {
                Long id = parentDynObj.getLong("parentid");
                this.getParentIdList(list, id);
            }
        }
    }

    private void getChildIdList(List<Long> list, Long id) {
        DynamicObject childDyn = this.serviceHelper.queryOne(String.join((CharSequence)",", "id", "ishavechange"), new QFilter("parentid", "=", (Object)id));
        if (childDyn != null) {
            boolean isHaveChange = childDyn.getBoolean("ishavechange");
            long childId = (Long)childDyn.getPkValue();
            list.add(childId);
            if (isHaveChange) {
                this.getChildIdList(list, childId);
            }
        }
    }

    private void copyModel(Long parentId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtabm_vaapply");
        DynamicObject parentDynObj = serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)parentId));
        this.getModel().setValue("parentid", (Object)parentId);
        this.getModel().setValue("originalid", (Object)parentDynObj.getLong("originalid"));
        this.getModel().setValue("attfile", parentDynObj.get("attfile"));
        this.getModel().setValue("personid", parentDynObj.get("personid"));
        this.getModel().setValue("attfilebasef7", parentDynObj.get("attfilebasef7"));
        this.getModel().setValue("org", parentDynObj.get("org"));
        this.getView().updateView("attfilebasef7");
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        boolean isNeedHand = parentDynObj.getBoolean("isneedhand");
        this.getModel().setValue("isneedhand", (Object)isNeedHand);
        this.getModel().setValue("handperson", (Object)parentDynObj.getString("handperson"));
        this.getModel().setValue("handreason", (Object)parentDynObj.getString("handreason"));
        String applyTypeRadio = this.getApplyTypeRadio();
        this.getModel().setValue("applytyperadio", (Object)applyTypeRadio);
        this.getModel().setValue("attfilebasef7", (Object)parentDynObj.getLong("attfilebasef7.id"));
        FieldEdit handPerson = (FieldEdit)this.getView().getControl("handperson");
        FieldEdit handReason = (FieldEdit)this.getView().getControl("handreason");
        this.getView().setVisible(Boolean.valueOf(isNeedHand), new String[]{"handperson", "handreason"});
        handPerson.setMustInput(isNeedHand);
        handReason.setMustInput(isNeedHand);
        this.getView().updateView("fieldsetpanelap21");
        this.getModel().setValue("isnotleave", (Object)parentDynObj.getBoolean("isnotleave"));
        this.getModel().setValue("startdatestr", (Object)parentDynObj.getString("startdatestr"));
        this.getModel().setValue("enddatestr", (Object)parentDynObj.getString("enddatestr"));
        this.getModel().setValue("billstyle", (Object)parentDynObj.getString("billstyle"));
        DynamicObjectCollection parentEntry = parentDynObj.getDynamicObjectCollection("entryentity");
        for (int index = 0; index < parentEntry.size(); ++index) {
            dynamicObjectCollection.addNew();
        }
        this.copyEntry(parentEntry);
    }

    private String getApplyTypeRadio() {
        String entityId = this.getView().getFormShowParameter().getFormId();
        if (StringUtils.equals((CharSequence)entityId, (CharSequence)"wtabm_vaupdateself")) {
            return "0";
        }
        return "1";
    }

    private void copyEntry(DynamicObjectCollection parentEntry) {
        for (int index = 0; index < parentEntry.size(); ++index) {
            DynamicObject entry = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(index);
            DynamicObject row = (DynamicObject)parentEntry.get(index);
            this.copyEntryProp(row, index, true);
            this.copySubEntry(entry, row.getDynamicObjectCollection("vadetailentry"));
        }
        this.getModel().updateCache();
    }

    private void copyEntryProp(DynamicObject row, int index, boolean isParent) {
        boolean entryNotNull;
        String entryUnit = row.getString("entryunit");
        this.getModel().setValue("entryvacationtype", (Object)row.getLong("entryvacationtype.id"), index);
        this.getModel().setValue("entryapplytime", (Object)(StringUtils.equals((CharSequence)"A", (CharSequence)entryUnit) ? row.getBigDecimal("entryvatimeday") : row.getBigDecimal("entryvatimehour")), index);
        this.getModel().setValue("entryvatime", (Object)row.getBigDecimal("entryvatime"), index);
        this.getModel().setValue("entryreason", (Object)row.getString("entryreason"), index);
        this.getModel().setValue("entrystartdate", (Object)row.getDate("entrystartdate"), index);
        this.getModel().setValue("entryenddate", (Object)row.getDate("entryenddate"), index);
        this.getModel().setValue("owndate", (Object)row.getDate("owndate"), index);
        this.getModel().setValue("entryunit", (Object)entryUnit, index);
        this.getModel().setValue("entrystartmethod", (Object)row.getString("entrystartmethod"), index);
        this.getModel().setValue("entryendmethod", (Object)row.getString("entryendmethod"), index);
        this.getModel().setValue("entryvatimeday", (Object)row.getBigDecimal("entryvatimeday"), index);
        this.getModel().setValue("entryvatimehour", (Object)row.getBigDecimal("entryvatimehour"), index);
        this.getModel().setValue("entryvalidtimehour", (Object)row.getBigDecimal("entryvalidtimehour"), index);
        this.getModel().setValue("entryvalidtimeday", (Object)row.getBigDecimal("entryvalidtimeday"), index);
        this.getModel().setValue("entrystarttimetext", (Object)VaApplyService.getDateStr((DynamicObject)row, (boolean)true), index);
        this.getModel().setValue("entryendtimetext", (Object)VaApplyService.getDateStr((DynamicObject)row, (boolean)false), index);
        if (isParent) {
            this.getModel().setValue("entryparentid", (Object)row.getLong("id"), index);
        } else {
            this.getModel().setValue("entryparentid", (Object)row.getLong("entryparentid"), index);
        }
        this.getModel().setValue("specialvatype", row.get("specialvatype"), index);
        this.getModel().setValue("specialvamethod", row.get("specialvamethod"), index);
        this.getModel().setValue("specialextjson", row.get("specialextjson"), index);
        this.getModel().setValue("isdisposable", row.get("isdisposable"), index);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        boolean bl = entryNotNull = WTCCollections.isNotEmpty((Collection)entryEntity) && entryEntity.size() > index && entryEntity.get(index) != null;
        if (entryNotNull) {
            DynamicObject targetEntry = (DynamicObject)entryEntity.get(index);
            BillCommonService.writeInfo2Model((DynamicObject)row, (DynamicObject)targetEntry, (IDataModel)this.getModel(), (Integer)index);
        }
    }

    private void copySubEntry(DynamicObject row, DynamicObjectCollection subEntries) {
        if (CollectionUtils.isEmpty((Collection)subEntries)) {
            return;
        }
        DynamicObjectCollection subEntriesDyn = row.getDynamicObjectCollection("vadetailentry");
        for (DynamicObject subEntry : subEntries) {
            DynamicObject subEntryDyn = subEntriesDyn.addNew();
            this.doSetSubEntry(subEntryDyn, subEntry);
        }
    }

    private void doSetSubEntry(DynamicObject subEntryDyn, DynamicObject subEntry) {
        subEntryDyn.set("vaentrydate", subEntry.get("vaentrydate"));
        subEntryDyn.set("vaentrystarttime", subEntry.get("vaentrystarttime"));
        subEntryDyn.set("vaentryendtime", subEntry.get("vaentryendtime"));
        subEntryDyn.set("vaentrydatetype", subEntry.get("vaentrydatetype"));
        subEntryDyn.set("vaentryapplytimeday", subEntry.get("vaentryapplytimeday"));
        subEntryDyn.set("vaentryapplytimehour", subEntry.get("vaentryapplytimehour"));
        subEntryDyn.set("vaentryseq", subEntry.get("vaentryseq"));
        subEntryDyn.set("vaentryunit", subEntry.get("vaentryunit"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        BillShowParameter formShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        BillOperationStatus pageStatus = formShowParameter.getBillStatus();
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (BillOperationStatus.ADDNEW.equals((Object)pageStatus)) {
            if (HRStringUtils.equals((String)"unsubmit", (String)operateKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"VaUpdateBillEdit_01", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (HRStringUtils.equals((String)"save", (String)operateKey) || HRStringUtils.equals((String)"submit", (String)operateKey) || HRStringUtils.equals((String)"submit-audit", (String)operateKey) || HRStringUtils.equals((String)"submiteffect", (String)operateKey)) {
                this.getModel().updateEntryCache(this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity"));
                this.copyEntryEntity(this.getModel().getDataEntity().getDynamicObjectCollection("entryentity"));
            }
        }
        if (StringUtils.equals((CharSequence)"deleterow", (CharSequence)operateKey)) {
            long parentId = dataEntity.getLong("parentid");
            DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection("entryentity");
            if (entries.size() < 2) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5047\u5355\u8c03\u6574\u9700\u81f3\u5c11\u4fdd\u7559\u4e00\u6761\u6570\u636e\uff0c\u82e5\u60f3\u5168\u90e8\u53d6\u6d88\u4f11\u5047\u53ef\u9009\u62e9\u5047\u5355\u5931\u6548\u3002", (String)"VaUpdateBillEdit_02", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
                return;
            }
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject changeEntry = (DynamicObject)entries.get(rowIndex);
            long parentEntryId = changeEntry.getLong("entryparentid");
            DynamicObject parentBillDyn = VA_APPLY_SERVICE_HELPER.loadSingle((Object)parentId);
            Optional<DynamicObject> first = parentBillDyn.getDynamicObjectCollection("entryentity").stream().filter(et -> (Long)et.getPkValue() == parentEntryId).findFirst();
            if (first.isPresent()) {
                DynamicObject entryRow = first.get();
                String authAppIdForFormPlugin = BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView());
                UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(authAppIdForFormPlugin, this.getView().getEntityId());
                long attFileBoId = dataEntity.getLong("attfile.id");
                boolean needCheckAttFileAuth = "1".equals(dataEntity.getString("applytyperadio"));
                VaEntityCheckService changeCheckHelper = VaEntityCheckService.createService((long)attFileBoId, (ApplyBillCheckEnum)ApplyBillCheckEnum.VACATION, (DynamicObject)entryRow, (boolean)needCheckAttFileAuth, (UnifyBillApplyAttr)applyAttr);
                Map changeSetDyMap = changeCheckHelper.getBillAutoOperator().getChangeSetDy(attFileBoId, entryRow.getDate("entrystartdate"), entryRow.getDate("entryenddate"), entryRow.getLong("entryvacationtype.id"));
                boolean useStartOrEnd = changeCheckHelper.getUseStartOrEnd();
                DynamicObject changeSetDy = null;
                if (MapUtils.isNotEmpty((Map)changeSetDyMap)) {
                    List sortedKeys = changeSetDyMap.keySet().stream().sorted().collect(Collectors.toList());
                    DynamicObject dynamicObject = changeSetDy = useStartOrEnd ? (DynamicObject)changeSetDyMap.get(sortedKeys.get(0)) : (DynamicObject)changeSetDyMap.get(sortedKeys.get(sortedKeys.size() - 1));
                }
                if (MapUtils.isEmpty((Map)changeSetDyMap) || changeSetDy == null) {
                    String failMsg = VaKDStringHelper.canNotChange((String)UnifyBillEnum.VA.getDescriptionStr());
                    this.getView().showTipNotification(failMsg);
                    return;
                }
            }
            this.getModel().deleteEntryRow("entryentity", rowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        AbstractOperate operate = (AbstractOperate)afterDoOperationEventArgs.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equalsAny((CharSequence)operateKey, (CharSequence[])new CharSequence[]{"submit", "submiteffect", "unsubmit", "discard", "delete"})) {
            this.loadHisInfo();
        }
        if (StringUtils.equalsAny((CharSequence)operateKey, (CharSequence[])new CharSequence[]{"deleterow"})) {
            this.getView().updateView("entryentity");
            this.vaApplyService.handleVisForQuota(this.getView());
        }
    }

    public void pageRelease(EventObject evt) {
        super.pageRelease(evt);
        Long parentId = (Long)this.getView().getFormShowParameter().getCustomParam("parentid");
        if (parentId != null) {
            DataMutex dataMutex = DataMutex.create();
            dataMutex.release(parentId.toString(), "wtabm_vaapply", "update");
        }
    }

    private void copyEntryEntity(DynamicObjectCollection entryEntity) {
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        for (int index = 0; index < entryEntity.size(); ++index) {
            DynamicObject row = (DynamicObject)entryEntity.get(index);
            this.copyEntryProp(row, index, false);
            for (DynamicObject subEntry : row.getDynamicObjectCollection("vadetailentry")) {
                this.doSetSubEntry(subEntry, subEntry);
            }
        }
    }

    private void refreshApplyTimes() {
        DynamicObject billDyn = this.getModel().getDataEntity();
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView()), this.getView().getEntityId());
        VaBillCheckService vaBillCheckService = new VaBillCheckService(ApplyBillCheckEnum.VACATION, UnifyBillEnum.VA, Collections.singletonList(billDyn), applyAttr);
        BillResponse billResponse = vaBillCheckService.refresh();
        DynamicObjectCollection entryEntity = billDyn.getDynamicObjectCollection("entryentity");
        for (int index = 0; index < entryEntity.size(); ++index) {
            DynamicObject row = (DynamicObject)entryEntity.get(index);
            String entryUnit = row.getString("entryunit");
            BigDecimal entryApplyTimeShow = StringUtils.equals((CharSequence)"A", (CharSequence)entryUnit) ? row.getBigDecimal("entryvatimeday") : row.getBigDecimal("entryvatimehour");
            this.getModel().setValue("entryapplytime", (Object)entryApplyTimeShow, index);
        }
        LOG.info("\u91cd\u65b0\u6821\u9a8c\u6240\u6709\u6821\u9a8c\u9879\u5e76\u751f\u6210\u4f11\u5047\u4fe1\u606f\u7ed3\u679c\uff1a{}\uff0c\u63d0\u793a\u4fe1\u606f\uff1a{}", (Object)billResponse.isSuccess(), (Object)billResponse.getMessage());
    }
}

