/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.formplugin.web.vaupdate;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtabm.business.vaapply.VaApplyMobBusiness;
import kd.wtc.wtabm.common.vaapply.VaApplyMobConstants;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.wtabm.common.constants.VaApplyConstants;

public class VaUpdateHisPlugin
extends AbstractMobFormPlugin
implements VaApplyMobConstants,
VaApplyConstants {
    private VaApplyMobBusiness vaApplyMobBusiness = VaApplyMobBusiness.getInstance();

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Long pkId = (Long)this.getView().getFormShowParameter().getCustomParam("pkId");
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        DynamicObject busiTripBill = new HRBaseServiceHelper("wtabm_vaupdate").loadSingle((Object)pkId);
        if (type != null && HRStringUtils.equals((String)type, (String)"updateself")) {
            busiTripBill = new HRBaseServiceHelper("wtabm_vaupdateself").loadSingle((Object)pkId);
        }
        List<DynamicObject> billHistoryList = this.getBillHistory(busiTripBill);
        this.setCardEntry(billHistoryList);
    }

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        MobileFormShowParameter formShowParameter = (MobileFormShowParameter)evt.getFormShowParameter();
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u53d8\u66f4\u5386\u53f2", (String)"VaUpdateHisPlugin_4", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
    }

    private void setCardEntry(List<DynamicObject> billHistoryList) {
        IDataModel model = this.getModel();
        for (int index = 0; index < billHistoryList.size(); ++index) {
            String vaTotalTimeStr;
            String changeTitle;
            String applyTypeOther;
            DynamicObject billDy = billHistoryList.get(index);
            int changeCount = billHistoryList.size() - index - 1;
            int rowIndex = model.createNewEntryRow("entryentity");
            String name = billDy.getString("personid.name");
            String applyType = billDy.getString("applytyperadio");
            String string = applyTypeOther = BillApplyTypeEnum.OTHER.getCode().equals(applyType) ? ResManager.loadKDString((String)"\u4e3a\u4ed6\u4eba\u7533\u8bf7", (String)"VaUpdateHisPlugin_5", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]) : "";
            if (changeCount == 0) {
                model.setValue("changenum", (Object)ResManager.loadKDString((String)"\u3010\u539f\u5355\u3011", (String)"VaUpdateHisPlugin_0", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]), rowIndex);
                changeTitle = ResManager.loadKDString((String)"{0}\u7684{1}\u4f11\u5047\u5355", (String)"VaUpdateHisPlugin_2", (String)"wtc-wtabm-formplugin", (Object[])new Object[]{name, applyTypeOther});
                CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
                cardEntry.setChildVisible(false, rowIndex, new String[]{"trestmethodflex"});
            } else {
                model.setValue("changenum", (Object)ResManager.loadKDString((String)"\u201c\u7b2c%s\u6b21\u53d8\u66f4\u201d", (String)"VaUpdateHisPlugin_1", (String)"wtc-wtabm-formplugin", (Object[])new Object[]{changeCount}), rowIndex);
                changeTitle = ResManager.loadKDString((String)"{0}\u7684{1}\u4f11\u5047\u53d8\u66f4\u5355", (String)"VaUpdateHisPlugin_3", (String)"wtc-wtabm-formplugin", (Object[])new Object[]{name, applyTypeOther});
            }
            model.setValue("changetitle", (Object)changeTitle, rowIndex);
            SimpleDateFormat simpleDateFormat = WTCInteDateUtil.getUserSimpleDateFormat();
            if (billDy.getDate("startdate") != null) {
                String sdate = simpleDateFormat.format(billDy.getDate("startdate"));
                model.setValue("entrystarttimetext", (Object)sdate, rowIndex);
            }
            if (billDy.getDate("enddate") != null) {
                String edate = simpleDateFormat.format(billDy.getDate("enddate"));
                model.setValue("entryendtimetext", (Object)edate, rowIndex);
            }
            String vaTotalTime = vaTotalTimeStr = this.vaApplyMobBusiness.getVaTotalTimeStr(billDy);
            if (vaTotalTimeStr.indexOf(44) != -1) {
                vaTotalTime = vaTotalTimeStr.replace(',', '\n');
            }
            model.setValue("vasumflex", (Object)vaTotalTime, rowIndex);
            if (billDy.get("submitdate") == null) continue;
            String applydate = WTCInteDateUtil.formatBySysTzAndUserFmt((Date)billDy.getDate("submitdate"));
            model.setValue("submitdate", (Object)applydate, rowIndex);
        }
    }

    private List<DynamicObject> getBillHistory(DynamicObject busiTripBill) {
        long creator = busiTripBill.getLong("creator.id");
        long personid = busiTripBill.getLong("personid.id");
        QFilter filter = new QFilter("creator", "=", (Object)creator);
        filter.and(new QFilter("personid", "=", (Object)personid));
        DynamicObject[] busiTripBills = new HRBaseServiceHelper("wtabm_vaupdate").loadDynamicObjectArray(filter.toArray());
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        if (type != null && HRStringUtils.equals((String)type, (String)"updateself")) {
            busiTripBills = new HRBaseServiceHelper("wtabm_vaupdateself").loadDynamicObjectArray(filter.toArray());
        }
        ArrayList<DynamicObject> busiTripBillAllHistoryList = new ArrayList<DynamicObject>(10);
        busiTripBillAllHistoryList.add(busiTripBill);
        long parent = busiTripBill.getLong("parentid");
        while (parent != 0L) {
            boolean breakLoop = true;
            for (DynamicObject tripBill : busiTripBills) {
                if (parent != tripBill.getLong("id")) continue;
                busiTripBillAllHistoryList.add(tripBill);
                parent = tripBill.getLong("parentid");
                breakLoop = false;
            }
            if (!breakLoop) continue;
            break;
        }
        boolean isnewbill = busiTripBill.getBoolean("ishavechange");
        while (!isnewbill) {
            boolean breakLoop = true;
            for (DynamicObject tripBill : busiTripBills) {
                parent = tripBill.getLong("parentid");
                if (parent != busiTripBill.getLong("id")) continue;
                busiTripBillAllHistoryList.add(0, tripBill);
                isnewbill = tripBill.getBoolean("ishavechange");
                busiTripBill = tripBill;
                breakLoop = false;
            }
            if (!breakLoop) continue;
            break;
        }
        return busiTripBillAllHistoryList;
    }
}

