/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtabm.formplugin.web.vaupdate;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtabm.business.vaapply.VaApplyMobBusiness;
import kd.wtc.wtabm.business.vaapply.VaKDStringHelper;
import kd.wtc.wtabm.business.vaapply.checker.VaEntityCheckService;
import kd.wtc.wtabm.common.vaapply.VaApplyMobConstants;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.mobile.ComComponentsHelper;
import kd.wtc.wtbs.common.components.TypeSelCusStyleEnum;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.enums.bill.BillOpenStyleEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.enums.bill.va.SpecialVaTypeEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtbs.wtabm.common.constants.VaApplyConstants;

public class VaUpdateMobChangePlugin
extends AbstractMobFormPlugin
implements VaApplyMobConstants,
VaApplyConstants {
    public static final String NEWATTACHMENT = "newattachment";
    public static final String OLDATTACHMENT = "oldattachment";
    public static final String DEL_PAGE = "WTC_DEL_PAGE";
    private final VaApplyMobBusiness vaApplyMobBusiness = VaApplyMobBusiness.getInstance();
    private static final Log logger = LogFactory.getLog(VaUpdateMobChangePlugin.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"panelup", "paneldown", "lbl_up", "lbl_down", "historyflex", "historyap", "flexchangever"});
    }

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        MobileBillShowParameter formShowParameter = (MobileBillShowParameter)evt.getFormShowParameter();
        Object customParam = formShowParameter.getCustomParam("businessKey");
        logger.info("VaUpdateMobChangePlugin.preOpenForm.customParam:{}", customParam);
        if (customParam != null) {
            long pkId = Long.parseLong(formShowParameter.getCustomParam("businessKey").toString());
            formShowParameter.setPkId((Object)pkId);
        }
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u53d8\u66f4\u7533\u8bf7", (String)"VaUpdateMobChangePlugin_0", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
    }

    public void afterBindData(EventObject evt) {
        IFormView view;
        DynamicObject vaApplyChangeBill;
        super.afterBindData(evt);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtabm_vaapply");
        Long pkId = (Long)this.getView().getFormShowParameter().getCustomParam("changeId");
        String entityType = this.getView().getEntityId();
        if (status.equals((Object)OperationStatus.ADDNEW)) {
            DynamicObject parentDynObj = serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)pkId));
            if (pkId != null) {
                this.getModel().setValue("parentid", (Object)pkId);
                this.copyModel(parentDynObj);
                this.copyAttachment(pkId);
            }
            entityType = this.getEntityIdByDyn(parentDynObj);
        }
        String billState = (vaApplyChangeBill = (view = this.getView()).getModel().getDataEntity(true)).getBoolean("isnotleave") ? "2" : "1";
        DynamicObjectCollection vaApplyChangeBillEntry = vaApplyChangeBill.getDynamicObjectCollection("entryentity");
        if (pkId == null || Long.parseLong(pkId.toString()) == 0L) {
            pkId = this.getModel().getDataEntity().getLong("id");
        }
        List oldAttachment = AttachmentServiceHelper.getAttachments((String)entityType, (Object)pkId, (String)"attachmentpanel");
        String oldAttachCache = SerializationUtils.serializeToBase64((Object)oldAttachment);
        this.getView().getPageCache().put(OLDATTACHMENT, oldAttachCache);
        this.getView().getPageCache().put(NEWATTACHMENT, oldAttachCache);
        this.getView().setVisible(Boolean.FALSE, new String[]{"paneldown"});
        if (vaApplyChangeBillEntry.size() <= 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"panelup"});
        }
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentitychange");
        for (int i = 0; i < vaApplyChangeBillEntry.size(); ++i) {
            cardEntry.setChildVisible(false, i, new String[]{"flexchangever"});
        }
        this.vaApplyMobBusiness.setVaApproInfo(vaApplyChangeBill, this.getView(), 0);
        this.getModel().beginInit();
        this.getModel().setValue("billstate", (Object)billState);
        this.getModel().endInit();
        this.getView().updateView("billstate");
        this.judgeTreatMethod(billState);
        DynamicObject entry = this.getModel().getDataEntity(true);
        String handPerson = entry.getString("handperson");
        Label handPersonLabel = (Label)this.getView().getControl("labelapperson");
        handPersonLabel.setText(handPerson);
        Label handReasonLabel = (Label)this.getView().getControl("labelapreason");
        String labelReason = entry.getString("handreason");
        handReasonLabel.setText(labelReason);
        this.getView().getPageCache().put("labelapperson", handPerson);
        this.getView().getPageCache().put("labelreason", labelReason);
        this.getView().getPageCache().put("isneedhand", entry.getString("isneedhand"));
        this.showPageStyle();
    }

    private void showPageStyle() {
        boolean isSingle = WTCStringUtils.equals((String)this.getModel().getDataEntity().getString("billstyle"), (String)BillOpenStyleEnum.SINGLE.getCode());
        this.getView().setVisible(Boolean.valueOf(!isSingle), new String[]{"flexpanelap71", "flexpanelap20"});
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        String name = evt.getProperty().getName();
        if ("billstate".equals(name)) {
            String billStatus = (String)this.getModel().getValue("billstate");
            this.treatMethodChanged(billStatus);
        }
    }

    private void treatMethodChanged(String billState) {
        Label treatMethodTipsLabel = (Label)this.getView().getControl("treatmethodtips");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtabm_vaapply");
        long parentId = (Long)this.getModel().getValue("parentid");
        DynamicObject parentDynObj = serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)parentId));
        if ("1".equals(billState) || "".equals(billState) || billState == null) {
            this.dealTreatmentChangeBaseInfo(false);
            this.getView().getPageCache().put("TREATMENT_METHOD", "TREATMENT_METHOD");
            this.copyModel(parentDynObj);
            this.vaApplyMobBusiness.showEntryCardHeader(this.getView());
            this.vaApplyMobBusiness.refreshApplyTimes(this.getView());
            DynamicObject mainEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection busChangeBillEntry = mainEntity.getDynamicObjectCollection("entryentity");
            this.vaApplyMobBusiness.setShowDate(busChangeBillEntry, this.getModel());
            this.vaApplyMobBusiness.setBreLeaveInfo(mainEntity, this.getView());
            this.vaApplyMobBusiness.setVaTime(busChangeBillEntry, this.getModel());
            this.getView().updateView("entryentity");
            this.dealAttachAndTotalTimeWhenAdjust();
        } else if ("2".equals(billState)) {
            this.dealTreatmentChangeBaseInfo(true);
            this.getModel().beginInit();
            this.copyModel(parentDynObj);
            this.getModel().endInit();
            this.dealAttachAndTimeWhenNotLeave();
        }
        VaApplyMobBusiness.getInstance().setHandPanelVisible(this.getView(), billState);
        this.getView().getPageCache().put("TREATMENT_METHOD", "");
    }

    private void dealTreatmentChangeBaseInfo(boolean isNotLeave) {
        this.getModel().setValue("isnotleave", (Object)isNotLeave);
        Label treatMethodTipsLabel = (Label)this.getView().getControl("treatmethodtips");
        if (!isNotLeave) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexdownup"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"attachmentpanel"});
            treatMethodTipsLabel.setText(ResManager.loadKDString((String)"\u5b9e\u9645\u4f11\u5047\u65f6\u95f4\u4e0e\u539f\u4f11\u5047\u5355\u7533\u8bf7\u7684\u65f6\u95f4\u4e0d\u4e00\u81f4\uff0c\u8bf7\u586b\u5199\u5b9e\u9645\u4f11\u5047\u65f6\u95f4\u3002", (String)"VaUpdateMobChangePlugin_1", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
        } else {
            if ("up".equals(this.getView().getPageCache().get("updown"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexdownup"});
            }
            treatMethodTipsLabel.setText(ResManager.loadKDString((String)"\u5b9e\u9645\u6ca1\u6709\u4f11\u5047\uff0c\u65e0\u9700\u7ef4\u62a4\u4f11\u5047\u4fe1\u606f\uff0c\u539f\u4f11\u5047\u5355\u505a\u5931\u6548\u5904\u7406\u3002", (String)"VaUpdateMobChangePlugin_2", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
        }
        this.flexVisible(!isNotLeave);
    }

    private void dealAttachAndTotalTimeWhenAdjust() {
        String newAttachCache = this.getView().getPageCache().get(NEWATTACHMENT);
        List newAttachment = (List)SerializationUtils.deSerializeFromBase64((String)newAttachCache);
        AttachmentPanel panel = (AttachmentPanel)this.getControl("attachmentpanel");
        panel.bindData(newAttachment);
        DynamicObject vaApplyChangeBill = this.getView().getModel().getDataEntity(true);
        this.vaApplyMobBusiness.vaTotalTimeLineFeed(vaApplyChangeBill, this.getView(), "vasumtimeflex", "vaapply");
    }

    private void dealAttachAndTimeWhenNotLeave() {
        DynamicObject vaApplyChangeBill = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection vaApplyChangeBillEntry = vaApplyChangeBill.getDynamicObjectCollection("entryentity");
        for (int index = 0; index < vaApplyChangeBillEntry.size(); ++index) {
            this.getModel().setValue("entryvatimeday", (Object)0.0, index);
            this.getModel().setValue("entryvatimehour", (Object)0.0, index);
        }
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        for (int index = 0; index < vaApplyChangeBillEntry.size(); ++index) {
            if (HRStringUtils.equals((String)((DynamicObject)vaApplyChangeBillEntry.get(index)).getString("specialvatype"), (String)SpecialVaTypeEnum.LACTATION_TYPE.vaType)) {
                cardEntry.setChildVisible(false, index, new String[]{"entrystarttimetext1"});
                cardEntry.setChildVisible(false, index, new String[]{"entryendtimetext1"});
                continue;
            }
            cardEntry.setChildVisible(true, index, new String[]{"entrystarttimetext1"});
            cardEntry.setChildVisible(true, index, new String[]{"entryendtimetext1"});
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        this.vaApplyMobBusiness.setApproEntity(dataEntity, this.getModel());
        this.getView().updateView("entryentity");
        this.vaApplyMobBusiness.vaTotalTimeLineFeed(dataEntity, this.getView(), "vasumflex", "det");
    }

    private void judgeTreatMethod(String billState) {
        this.getModel().getDataEntity(true);
        if ("1".equals(billState) || "".equals(billState) || billState == null) {
            this.dealTreatmentChangeBaseInfo(false);
            this.vaApplyMobBusiness.refreshApplyTimes(this.getView());
            this.vaApplyMobBusiness.setVaTime(this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity"), this.getModel());
            this.dealAttachAndTotalTimeWhenAdjust();
        } else if ("2".equals(billState)) {
            this.dealTreatmentChangeBaseInfo(true);
            this.dealAttachAndTimeWhenNotLeave();
        }
        this.getView().updateView("entryentity");
        VaApplyMobBusiness.getInstance().setHandPanelVisible(this.getView(), billState);
    }

    private void flexVisible(Boolean isVisible) {
        this.getView().setVisible(Boolean.valueOf(isVisible == false), new String[]{"updownflex"});
        this.getView().setVisible(Boolean.valueOf(isVisible == false), new String[]{"invalidflex"});
        this.getView().setVisible(isVisible, new String[]{"adjustflex"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.isCancel()) {
            return;
        }
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        this.vaApplyMobBusiness.billStatusCheckForDetail(operateKey, dataEntity, args, this.getView());
        if (args.isCancel()) {
            return;
        }
        switch (operateKey) {
            case "save": 
            case "submit": {
                Object treatMethodGroup;
                OperationStatus status = this.getView().getFormShowParameter().getStatus();
                String billStatus = (String)this.getModel().getValue("billstate");
                if (HRStringUtils.equals((String)billStatus, (String)"1")) {
                    if (!VaApplyMobBusiness.getInstance().valiteHandMust(args, this.getView())) {
                        return;
                    }
                } else {
                    this.getModel().setValue("isneedhand", (Object)false);
                    this.getModel().setValue("handperson", null);
                    this.getModel().setValue("handreason", null);
                }
                if (!"2".equals(treatMethodGroup = this.getModel().getValue("billstate"))) break;
                Long pkId = (Long)this.getView().getFormShowParameter().getCustomParam("changeId");
                if (pkId == null || Long.parseLong(pkId.toString()) == 0L) {
                    pkId = dataEntity.getLong("id");
                }
                this.copyAttachment(pkId);
                break;
            }
            case "mob_deleteentry": {
                long parentId = dataEntity.getLong("parentid");
                DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection("entryentity");
                int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                DynamicObject changeEntry = (DynamicObject)entries.get(rowIndex);
                long parentEntryId = changeEntry.getLong("entryparentid");
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtabm_vaapply");
                DynamicObject parentBillDyn = serviceHelper.loadSingle((Object)parentId);
                Optional<DynamicObject> first = parentBillDyn.getDynamicObjectCollection("entryentity").stream().filter(et -> (Long)et.getPkValue() == parentEntryId).findFirst();
                if (!first.isPresent()) break;
                DynamicObject entryRow = first.get();
                String authAppIdForFormPlugin = BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView());
                UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(authAppIdForFormPlugin, this.getView().getEntityId());
                long attFileBoId = dataEntity.getLong("attfile.id");
                boolean needCheckAttFileAuth = "1".equals(dataEntity.getString("applytyperadio"));
                VaEntityCheckService changeCheckHelper = VaEntityCheckService.createService((long)attFileBoId, (ApplyBillCheckEnum)ApplyBillCheckEnum.VACATION, (DynamicObject)entryRow, (boolean)needCheckAttFileAuth, (UnifyBillApplyAttr)applyAttr);
                Map changeSetDyMap = changeCheckHelper.getBillAutoOperator().getChangeSetDy(attFileBoId, entryRow.getDate("entrystartdate"), entryRow.getDate("entryenddate"), entryRow.getLong("entryvacationtype.id"));
                boolean useStartOrEnd = changeCheckHelper.getUseStartOrEnd();
                DynamicObject changeSetDy = null;
                if (MapUtils.isNotEmpty((Map)changeSetDyMap)) {
                    List sortedKeys = changeSetDyMap.keySet().stream().sorted().collect(Collectors.toList());
                    DynamicObject dynamicObject = changeSetDy = useStartOrEnd ? (DynamicObject)changeSetDyMap.get(sortedKeys.get(0)) : (DynamicObject)changeSetDyMap.get(sortedKeys.get(sortedKeys.size() - 1));
                }
                if (!MapUtils.isEmpty((Map)changeSetDyMap) && changeSetDy != null) break;
                String failMsg = VaKDStringHelper.canNotChange((String)UnifyBillEnum.VA.getDescriptionStr());
                this.getView().showTipNotification(failMsg);
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "save": {
                boolean isSuccess = args.getOperationResult().isSuccess();
                if (!isSuccess) break;
                this.vaApplyMobBusiness.showVaUpdateAppro(this.getView());
                break;
            }
            case "submit": {
                boolean isSuccessSub = args.getOperationResult().isSuccess();
                DynamicObjectCollection busChangeBillEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                this.vaApplyMobBusiness.setShowDate(busChangeBillEntry, this.getModel());
                if (!isSuccessSub) break;
                this.vaApplyMobBusiness.showFeedBackPage(this.getView());
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        this.vaApplyMobBusiness.setUpAndDown(key, this.getView(), this.getModel());
        if ("historyflex".equals(key)) {
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setFormId("wtabm_vaupdate_his");
            String entityId = this.getView().getEntityId();
            String type = "update";
            if ("wtabm_vaupdateself".equals(entityId)) {
                type = "updateself";
            }
            showParameter.setCustomParam("type", (Object)type);
            Object pkId = this.getView().getFormShowParameter().getCustomParam("changeId");
            logger.info("VaUpdateMobChangePlugin.click.pkId1:{}", pkId);
            if (pkId != null && Long.parseLong(pkId.toString()) != 0L) {
                showParameter.setCustomParam("pkId", pkId);
                logger.info("VaUpdateMobChangePlugin.click.pkId2:{}", pkId);
            } else {
                showParameter.setCustomParam("pkId", (Object)this.getModel().getDataEntity().getLong("id"));
                logger.info("VaUpdateMobChangePlugin.click.pkId3:{}", (Object)this.getModel().getDataEntity().getLong("id"));
            }
            this.getView().showForm((FormShowParameter)showParameter);
        } else if ("flexchangever".equals(key)) {
            List traverParams = this.vaApplyMobBusiness.queryChangEver(this.getView());
            if (traverParams.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53d8\u66f4\u6821\u9a8c\u6570\u636e\u3002", (String)"VaUpdateMobChangePlugin_4", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
            } else {
                CloseCallBack typeCallBack = new CloseCallBack((IFormPlugin)this, "back_changever");
                ComComponentsHelper.getInstance().openNoHelpTypePage(this.getView(), ResManager.loadKDString((String)"\u8bf7\u9009\u62e9", (String)"VaUpdateMobChangePlugin_5", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]), TypeSelCusStyleEnum.VAAPPLY.getEvent(), traverParams, typeCallBack);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "back_changever": {
                Map returnData = (Map)event.getReturnData();
                this.vaApplyMobBusiness.setChangEver(this.getView(), returnData);
                break;
            }
            case "back_callback": {
                logger.info("vaupdate callback return");
                Object returnedData = event.getReturnData();
                if (StringUtils.equals((CharSequence)DEL_PAGE, (CharSequence)String.valueOf(returnedData))) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void copyAttachment(Long parentId) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.ADDNEW)) {
            Long pkValue = DB.genGlobalLongId();
            this.getModel().getDataEntity().set("id", (Object)pkValue);
            HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_attachment");
            QFilter filter = new QFilter("finterid", "=", (Object)parentId.toString());
            logger.info("VaUpdateMobChangePlugin.copyAttachment.parentId:{}", (Object)parentId);
            logger.info("VaUpdateMobChangePlugin.copyAttachment.pkValue:{}", (Object)pkValue);
            Object[] originalAttachments = helper.loadDynamicObjectArray(new QFilter[]{filter});
            logger.info("VaUpdateMobChangePlugin.copyAttachment.originalAttachments:{}", originalAttachments);
            if (originalAttachments == null || originalAttachments.length == 0) {
                return;
            }
            String entityId = this.getView().getEntityId();
            String type = "wtabm_vaupdate";
            if ("wtabm_vaupdateself".equals(entityId)) {
                type = "wtabm_vaupdateself";
            }
            DynamicObject[] attachments = new DynamicObject[originalAttachments.length];
            for (int i = 0; i < originalAttachments.length; ++i) {
                Object attachment = originalAttachments[i];
                DynamicObject newAttachment = helper.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)attachment, (DynamicObject)newAttachment);
                newAttachment.set("fbilltype", (Object)type);
                newAttachment.set("finterid", (Object)pkValue);
                attachments[i] = newAttachment;
            }
            helper.save(attachments);
        }
    }

    private void copyModel(DynamicObject parentDynObj) {
        this.getView().getPageCache().put("CACHE_KEY_SET_VAL_BY_PARENT", "CACHE_KEY_SET_VAL_BY_PARENT");
        this.getModel().setValue("originalid", (Object)parentDynObj.getLong("originalid"));
        this.getView().getModel().setValue("personid", parentDynObj.get("personid"));
        this.getView().getModel().setValue("attfilebasef7", parentDynObj.get("attfilebasef7"));
        this.getView().getModel().setValue("attfile", parentDynObj.get("attfile"));
        String entityId = this.getView().getEntityId();
        BillApplyTypeEnum billApplyTypeEnum = null;
        if ("wtabm_vaupdate".equals(entityId)) {
            billApplyTypeEnum = BillApplyTypeEnum.OTHER;
        } else if ("wtabm_vaupdateself".equals(entityId)) {
            billApplyTypeEnum = BillApplyTypeEnum.SELF;
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7533\u8bf7\u7c7b\u578b\u3002", (String)"VaUpdateMobChangePlugin_6", (String)"wtc-wtabm-formplugin", (Object[])new Object[0]));
        }
        this.getView().getModel().setValue("applytyperadio", (Object)billApplyTypeEnum.getCode());
        this.getView().getModel().setValue("handperson", (Object)parentDynObj.getString("handperson"));
        this.getView().getModel().setValue("handreason", (Object)parentDynObj.getString("handreason"));
        this.getView().getModel().deleteEntryData("entryentity");
        this.getModel().setValue("org", (Object)parentDynObj.getLong("org.id"));
        this.getModel().setValue("billstyle", (Object)parentDynObj.getString("billstyle"));
        DynamicObjectCollection parentEntry = parentDynObj.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection dynamicObjectCollection = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        this.getView().getPageCache().put("specialvamethod", "1");
        for (int index = 0; index < parentEntry.size(); ++index) {
            boolean entryNotNull;
            this.getView().getModel().createNewEntryRow("entryentity");
            DynamicObject row = (DynamicObject)parentEntry.get(index);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            SimpleDateFormat userDateTimeFormat = WTCInteDateUtil.getUserDateTimeFormat();
            userDateTimeFormat.setTimeZone(WTCInteDateUtil.getSysTimeZone().getTimeZone());
            this.getView().getModel().setValue("entrystartmethod", row.get("entrystartmethod"), index);
            this.getView().getModel().setValue("entryendmethod", row.get("entryendmethod"), index);
            this.getView().getModel().setValue("entryreason", row.get("entryreason"), index);
            this.getView().getModel().setValue("specialvamethod", row.get("specialvamethod"), index);
            this.getView().getModel().setValue("specialvatype", row.get("specialvatype"), index);
            this.getView().getModel().setValue("specialextjson", row.get("specialextjson"), index);
            long ownTime = row.get("owndate") != null ? ((Timestamp)row.get("owndate")).getTime() : System.currentTimeMillis();
            String ownDate = dateFormat.format(Long.parseLong(String.valueOf(ownTime)));
            this.getView().getModel().setValue("owndate", (Object)this.vaApplyMobBusiness.transferString2Date(ownDate, 1), index);
            this.getView().getModel().setValue("entryunit", row.get("entryunit"), index);
            this.getView().getModel().setValue("entryvatimeday", row.get("entryvatimeday"), index);
            this.getView().getModel().setValue("entryvatimehour", row.get("entryvatimehour"), index);
            this.getView().getModel().setValue("entryparentid", row.getPkValue(), index);
            long startTime = ((Timestamp)row.get("entrystartdate")).getTime();
            long endTime = ((Timestamp)row.get("entryenddate")).getTime();
            String startDate = userDateTimeFormat.format(Long.parseLong(String.valueOf(startTime)));
            String endDate = userDateTimeFormat.format(Long.parseLong(String.valueOf(endTime)));
            this.getView().getModel().setValue("entrystartdate", (Object)this.vaApplyMobBusiness.transferString2Date(startDate, 1), index);
            this.getView().getModel().setValue("entryenddate", (Object)this.vaApplyMobBusiness.transferString2Date(endDate, 1), index);
            this.getView().getModel().setValue("entryvacationtype", row.get("entryvacationtype"), index);
            this.copySubEntry((DynamicObject)dynamicObjectCollection.get(index), row.getDynamicObjectCollection("vadetailentry"));
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            boolean bl = entryNotNull = WTCCollections.isNotEmpty((Collection)entryEntity) && entryEntity.size() > index && entryEntity.get(index) != null;
            if (!entryNotNull) continue;
            DynamicObject targetEntry = (DynamicObject)entryEntity.get(index);
            BillCommonService.writeInfo2Model((DynamicObject)row, (DynamicObject)targetEntry, (IDataModel)this.getModel(), (Integer)index);
        }
        this.getView().getPageCache().remove("CACHE_KEY_SET_VAL_BY_PARENT");
    }

    private void copySubEntry(DynamicObject row, DynamicObjectCollection subEntries) {
        logger.info("VaUpdateMobChangePlugin.copySubEntry.subEntries:{}", (Object)SerializationUtils.toJsonString((Object)subEntries));
        if (CollectionUtils.isEmpty((Collection)subEntries)) {
            return;
        }
        DynamicObjectCollection subEntriesDyn = row.getDynamicObjectCollection("vadetailentry");
        for (DynamicObject subEntry : subEntries) {
            DynamicObject subEntryDyn = subEntriesDyn.addNew();
            this.doSetSubEntry(subEntryDyn, subEntry);
        }
    }

    private void doSetSubEntry(DynamicObject subEntryDyn, DynamicObject subEntry) {
        subEntryDyn.set("vaentrydate", subEntry.get("vaentrydate"));
        subEntryDyn.set("vaentrystarttime", subEntry.get("vaentrystarttime"));
        subEntryDyn.set("vaentryendtime", subEntry.get("vaentryendtime"));
        subEntryDyn.set("vaentrydatetype", subEntry.get("vaentrydatetype"));
        subEntryDyn.set("vaentryapplytimeday", subEntry.get("vaentryapplytimeday"));
        subEntryDyn.set("vaentryapplytimehour", subEntry.get("vaentryapplytimehour"));
        subEntryDyn.set("vaentryseq", subEntry.get("vaentryseq"));
        subEntryDyn.set("vaentryunit", subEntry.get("vaentryunit"));
    }

    private String getEntityIdByDyn(DynamicObject parentDyn) {
        boolean parentIsChange = parentDyn.getBoolean("ischange");
        String parentApplyType = parentDyn.getString("applytyperadio");
        String entityType = null;
        entityType = parentIsChange ? (StringUtils.equals((CharSequence)parentApplyType, (CharSequence)"0") ? "wtabm_vaupdateself" : "wtabm_vaupdate") : (StringUtils.equals((CharSequence)parentApplyType, (CharSequence)"0") ? "wtabm_vaapplyself" : "wtabm_vaapply");
        return entityType;
    }
}

