/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.servicehelper;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;

public class ServiceFactory {
    private static final Map<String, String> SERVICE_MAP = new HashMap<String, String>();

    public static <T> T getService(Class<T> clazz) {
        return (T)ServiceFactory.getService(clazz.getSimpleName());
    }

    public static Object getService(String serviceName) {
        String className = SERVICE_MAP.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230\u3002", (String)"ServiceFactory_0", (String)"wtc-wtam-servicehelper", (Object[])new Object[0]), serviceName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    private ServiceFactory() {
    }

    static {
        SERVICE_MAP.put("IBusitripBillService", "kd.wtc.wtam.mservice.BusitripBillServiceImpl");
        SERVICE_MAP.put("WFProcCoteUpgrade", "kd.wtc.wtam.mservice.WFProcCoteUpgrade");
        SERVICE_MAP.put("WFProcCoteOTChangeUpgrade", "kd.wtc.wtam.mservice.WFProcCoteOTChangeUpgrade");
        SERVICE_MAP.put("IActivateTripBillOriginalIdUpgrade", "kd.wtc.wtam.business.upgarde.ActivateTripBillOriginalIdUpgrade");
        SERVICE_MAP.put("WFProcCoteUpgradeV2", "kd.wtc.wtam.mservice.WFProcCoteUpgradeV2");
        SERVICE_MAP.put("WFProcCoteUpgradeAdBatchV2", "kd.wtc.wtam.mservice.WFProcCoteUpgradeAdBatchV2");
        SERVICE_MAP.put("ITpBillService", "kd.wtc.wtam.mservice.TpBillService");
        SERVICE_MAP.put("ITripSdkService", "kd.wtc.wtam.mservice.TripSdkServiceImpl");
        SERVICE_MAP.put("IActivateSupSignChangeCategoryUpgrade", "kd.wtc.wtam.business.upgarde.ActivateSupSignChangeCategoryUpgrade");
    }
}

