/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.opplugin.web.busitripbill;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.wtc.wtam.common.model.TripDateModel;
import kd.wtc.wtam.opplugin.web.busitripbill.validator.BusTripBillSingleStyleValidator;
import kd.wtc.wtam.opplugin.web.busitripbill.validator.BusiTripBillValidator;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;

public class BusiTripBillOp
extends HRCoreBaseBillOp {
    private static final Log LOG = LogFactory.getLog(BusiTripBillOp.class);

    public void onAddValidators(AddValidatorsEventArgs args) {
        if (BillCommonService.billCheckIsStrict()) {
            args.addValidator((AbstractValidator)new BusiTripBillValidator());
            args.addValidator((AbstractValidator)new BusTripBillSingleStyleValidator());
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().add("entryentity.startdate");
        args.getFieldKeys().add("entryentity.startmethod");
        args.getFieldKeys().add("entryentity.enddate");
        args.getFieldKeys().add("entryentity.endmethod");
        args.getFieldKeys().add("entryentity.unit");
        args.getFieldKeys().add("entryentity.owndate");
        args.getFieldKeys().add("entryentity.triptime");
        args.getFieldKeys().add("entryentity.efftctime");
        args.getFieldKeys().add("entryentity.entryparentid");
        args.getFieldKeys().add("entryentity.strapplytime");
        args.getFieldKeys().add("entryentity.tripresontex");
        args.getFieldKeys().add("entryentity.traveltool");
        args.getFieldKeys().add("entryentity.from");
        args.getFieldKeys().add("entryentity.to");
        args.getFieldKeys().add("parent");
        args.getFieldKeys().add("applyperson");
        args.getFieldKeys().add("applydate");
        args.getFieldKeys().add("attfile");
        args.getFieldKeys().add("sdate");
        args.getFieldKeys().add("edate");
        args.getFieldKeys().add("sumunit");
        args.getFieldKeys().add("sumtriptime");
        args.getFieldKeys().add("busitriptypes");
        args.getFieldKeys().add("ischange");
        args.getFieldKeys().add("applydate");
        args.getFieldKeys().add("isnottrip");
        args.getFieldKeys().add("billstyle");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs evt) {
        super.beginOperationTransaction(evt);
        DynamicObject[] dys = evt.getDataEntities();
        if (dys != null && dys.length > 0) {
            ArrayList<Long> idDys = new ArrayList<Long>(dys.length);
            for (DynamicObject dy : dys) {
                idDys.add(dy.getLong("id"));
            }
            HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)"wtam_busitripselfbill");
            DynamicObject[] dbDys = serviceHelper.loadDynamicObjectArray(new QFilter("id", "in", idDys).toArray());
            if (dbDys == null || dbDys.length < 1) {
                return;
            }
            ArrayList<DynamicObject> cleanDys = new ArrayList<DynamicObject>();
            for (DynamicObject oldDy : dbDys) {
                if (oldDy == null || !oldDy.containsProperty("busitriptypes")) continue;
                oldDy.getDynamicObjectCollection("busitriptypes").clear();
                cleanDys.add(oldDy);
            }
            if (!cleanDys.isEmpty()) {
                serviceHelper.update(cleanDys.toArray(new DynamicObject[cleanDys.size()]));
            }
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        String operationKey = args.getOperationKey();
        long userId = RequestContext.get().getCurrUserId();
        for (DynamicObject dataEntity : dataEntities) {
            if (HRStringUtils.equals((String)"submiteffect", (String)operationKey) || HRStringUtils.equals((String)"submit", (String)operationKey)) {
                dataEntity.set("applydate", (Object)new Date());
                dataEntity.set("applyperson", (Object)userId);
            }
            this.setMinStartAndMaxEnd(dataEntity);
            this.setSumTripTimes(dataEntity);
            this.setMultipleData(dataEntity);
            this.setStartAndEndToFormat(dataEntity);
        }
    }

    private void setStartAndEndToFormat(DynamicObject dataEntity) {
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity");
        if (null == dynamicObjectCollection) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String startMethod = dynamicObject.getString("startmethod");
            String endMethod = dynamicObject.getString("endmethod");
            if (!"3".equals(startMethod) || !"3".equals(endMethod)) continue;
            String startDateStr = dynamicObject.getString("startdatestr");
            String endDateStr = dynamicObject.getString("enddatestr");
            SimpleDateFormat userDateTimeFormat = WTCInteDateUtil.getUserDateTimeFormat();
            userDateTimeFormat.setTimeZone(WTCInteDateUtil.getSysTimeZone().getTimeZone());
            try {
                Date startDate = userDateTimeFormat.parse(startDateStr);
                startDateStr = WTCDateUtils.date2Str((Date)startDate, (String)"yyyy-MM-dd HH:mm");
                Date endDate = userDateTimeFormat.parse(endDateStr);
                endDateStr = WTCDateUtils.date2Str((Date)endDate, (String)"yyyy-MM-dd HH:mm");
            }
            catch (ParseException e) {
                LOG.warn("BusiTripBillOp.setStartAndEndToFormat.startDate:{}", (Object)startDateStr);
            }
            dynamicObject.set("startdatestr", (Object)startDateStr);
            dynamicObject.set("enddatestr", (Object)endDateStr);
        }
    }

    private void setMultipleData(DynamicObject dataEntity) {
        DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entryentity");
        DataEntityPropertyCollection propertyCollection = dataEntity.getDataEntityType().getProperties();
        MulBasedataProp mulBasedataProp = (MulBasedataProp)propertyCollection.get((Object)"busitriptypes");
        DynamicObjectType mulType = mulBasedataProp.getDynamicCollectionItemPropertyType();
        DynamicObjectCollection types = dataEntity.getDynamicObjectCollection("busitriptypes");
        types.clear();
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject dynamicObject = new DynamicObject(mulType);
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObject type = entry.getDynamicObject("busitriptype");
            dynamicObject.set("fbasedataid_id", type.getPkValue());
            types.add((Object)dynamicObject);
        }
        dataEntity.set("busitriptypes", (Object)types);
    }

    private void setSumTripTimes(DynamicObject dataEntity) {
        DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entryentity");
        String sumUnit = "B";
        BigDecimal sumValHour = BigDecimal.ZERO;
        BigDecimal sumValDay = BigDecimal.ZERO;
        for (DynamicObject dy : entrys) {
            if (HRStringUtils.equals((String)dy.getString("unit"), (String)"A")) {
                sumUnit = "A";
                sumValHour = sumValHour.add(dy.getBigDecimal("efftctime"));
                sumValDay = sumValDay.add(dy.getBigDecimal("triptime"));
                continue;
            }
            sumValHour = sumValHour.add(dy.getBigDecimal("triptime"));
            sumValDay = sumValDay.add(dy.getBigDecimal("efftctime"));
        }
        dataEntity.set("sumunit", (Object)sumUnit);
        if (HRStringUtils.equals((String)sumUnit, (String)"A")) {
            dataEntity.set("sumtriptime", (Object)sumValDay);
        } else {
            dataEntity.set("sumtriptime", (Object)sumValHour);
        }
    }

    private void setMinStartAndMaxEnd(DynamicObject dataEntity) {
        TripDateModel tripDateModel = new TripDateModel();
        this.setEntrys(dataEntity, tripDateModel);
        dataEntity.set("sdate", (Object)tripDateModel.getStartDate());
        dataEntity.set("edate", (Object)tripDateModel.getEndDate());
    }

    private void setEntrys(DynamicObject dataEntity, TripDateModel tripDateModel) {
        DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entryentity");
        entrys.forEach(entry -> {
            Date startDate = entry.getDate("startdate");
            Date endDate = entry.getDate("enddate");
            this.setTripDateModel(tripDateModel, startDate, endDate);
        });
    }

    private void setTripDateModel(TripDateModel tripDateModel, Date startDate, Date endDate) {
        Date startDate1 = tripDateModel.getStartDate();
        Date endDate1 = tripDateModel.getEndDate();
        if (startDate1 != null && endDate1 != null) {
            if (startDate.before(startDate1)) {
                tripDateModel.setStartDate(startDate);
                tripDateModel.setStartTime(this.getTimeToInt(startDate));
            }
            if (endDate.after(endDate1)) {
                tripDateModel.setEndDate(endDate);
                tripDateModel.setEndTime(this.getTimeToInt(endDate));
            }
        } else {
            tripDateModel.setStartDate(startDate);
            tripDateModel.setStartTime(this.getTimeToInt(startDate));
            tripDateModel.setEndDate(endDate);
            tripDateModel.setEndTime(this.getTimeToInt(endDate));
        }
    }

    private int getTimeToInt(Date startDate) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(startDate);
        int hour = instance.get(11);
        int minute = instance.get(12);
        int hours = hour * 60 * 60;
        int minutes = minute * 60;
        return hours + minutes;
    }

    private boolean checkIsSummitDirectly() {
        return this.getOption().containsVariable("param_is_submit_directly");
    }
}

