/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.opplugin.web.busitripbill.validator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRCoreBaseBillValidator;
import kd.wtc.wtam.business.busitrip.BusiTripBillKDStringHelper;
import kd.wtc.wtam.business.busitrip.BusiTripBillService;
import kd.wtc.wtam.business.busitripmobile.BusiTripBillUtil;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyKDStringHelper;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.business.web.applybill.service.BustripBillCheckService;
import kd.wtc.wtbs.business.web.applybill.service.BustripBillPeriodService;
import kd.wtc.wtbs.business.web.applybill.service.BustripEntityCheckService;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.BillSourceTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.bill.BillSystemParam;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class BusiTripBillValidator
extends HRCoreBaseBillValidator {
    private static final Log logger = LogFactory.getLog(BusiTripBillValidator.class);
    public static final HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)"wtam_busitripbill");

    public void validate() {
        logger.info("BusiTripBillValidator.validate.a1=:{}", (Object)System.currentTimeMillis());
        if (this.getDataEntities() == null || this.getDataEntities().length < 1) {
            return;
        }
        if (this.getDataEntities() == null || this.getDataEntities().length < 1) {
            return;
        }
        HashSet idSet = Sets.newHashSetWithExpectedSize((int)this.getDataEntities().length);
        HashSet changeIdSet = Sets.newHashSetWithExpectedSize((int)this.getDataEntities().length);
        String formId = "";
        String changeFormId = "";
        String attFileF7AuthEntity = "";
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject formEntity = dataEntity.getDataEntity();
            boolean isChange = formEntity.getBoolean("ischange");
            String applyTypeRadio = formEntity.getString("applytyperadio");
            if (BillApplyTypeEnum.SELF.getCode().equals(applyTypeRadio)) {
                attFileF7AuthEntity = "wtam_busitripselfbill";
                if (isChange) {
                    changeFormId = "wtam_busiselfbillchange";
                    changeIdSet.add(formEntity.getLong("id"));
                    continue;
                }
                formId = "wtam_busitripselfbill";
                idSet.add(formEntity.getLong("id"));
                continue;
            }
            if (!BillApplyTypeEnum.OTHER.getCode().equals(applyTypeRadio)) continue;
            attFileF7AuthEntity = "wtam_busitripbill";
            if (isChange) {
                changeFormId = "wtam_busibillchange";
                changeIdSet.add(formEntity.getLong("id"));
                continue;
            }
            formId = "wtam_busitripbill";
            idSet.add(formEntity.getLong("id"));
        }
        OperateOption option = this.getOption();
        boolean isImport = false;
        if (option.containsVariable("importtag_of_datasource")) {
            isImport = HRStringUtils.equals((String)Boolean.TRUE.toString(), (String)option.getVariableValue("importtag_of_datasource"));
        }
        String appId = BillCommonService.getInstance().getAppIdFromOp(option);
        String listOp = option.getVariableValue("list_op", "0");
        boolean isFromList = "1".equals(listOp);
        BillSystemParam billSystemParam = SystemParamQueryUtil.getBillSystemParam();
        Map<String, List<Map<String, Object>>> attachments = this.getAttachments(isFromList, formId, changeFormId, idSet, changeIdSet);
        HashMap attFileToBustripMap = Maps.newHashMapWithExpectedSize((int)this.getDataEntities().length);
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(appId, attFileF7AuthEntity);
        if (isImport) {
            applyAttr.setSourceType(BillSourceTypeEnum.IMPORT);
        }
        logger.info("BusiTripBillValidator.validate.a2=:{}", (Object)System.currentTimeMillis());
        List tpBillList = Arrays.stream(this.getDataEntities()).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        BustripBillCheckService tpBillCheckService = new BustripBillCheckService(ApplyBillCheckEnum.BUSTRIP, UnifyBillEnum.TP, tpBillList, applyAttr);
        WtcAbstractUnityBillOperator tpOperator = tpBillCheckService.getTpOperator();
        logger.info("BusiTripBillValidator.validate.a3=:{}", (Object)System.currentTimeMillis());
        HashSet errorBillNoSet = Sets.newHashSetWithExpectedSize((int)tpBillList.size());
        Map discardAttFileBoIdMap = BillCommonService.getInstance().getDiscardAttFileBoId(this.getDataEntities());
        boolean billCheckForOp = BillCommonService.billCheckForOp();
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject formEntity = dataEntity.getDataEntity();
            logger.debug("BusiTripBillValidator.validate.formEntity:{}", (Object)formEntity);
            DynamicObjectCollection entryEntitys = formEntity.getDynamicObjectCollection("entryentity");
            boolean flag = true;
            long id = formEntity.getLong("id");
            boolean attAchmeMust = false;
            DynamicObject attFile = formEntity.getDynamicObject("attfile");
            String attFileNumber = (String)discardAttFileBoIdMap.get(attFile.getLong("id"));
            if (HRStringUtils.isNotEmpty((String)attFileNumber)) {
                this.addErrorMessage(dataEntity, BillUnifyKDStringHelper.notEffAttFile((String)BillTypeEnum.EVECTIONBILL.getBillName(), (String)attFileNumber));
                errorBillNoSet.add(formEntity.getString("billno"));
                continue;
            }
            List list = (List)attFileToBustripMap.get(attFile.getLong("id"));
            if (list == null) {
                list = Lists.newArrayListWithExpectedSize((int)4);
            }
            list.add(formEntity);
            attFileToBustripMap.put(attFile.getLong("id"), list);
            for (DynamicObject entryEntity : entryEntitys) {
                BustripEntityCheckService billCommonCheckHelper;
                BillResponse billResponse;
                if (entryEntity.get("busitriptype") == null || entryEntity.get("startdate") == null) {
                    flag = false;
                }
                if (!isFromList && !billCheckForOp || id == 0L || BusiTripBillUtil.checkBillAllDisuse((DynamicObject)formEntity) || !(billResponse = (billCommonCheckHelper = new BustripEntityCheckService((Long)attFile.getPkValue(), UnifyBillEnum.TP, ApplyBillCheckEnum.BUSTRIPFORM, entryEntity, attFileF7AuthEntity, appId)).checkBaseSet()).isSuccess()) continue;
                List mustInput = billCommonCheckHelper.getMustInput();
                this.checkMustInput(dataEntity, mustInput, entryEntity);
                if (mustInput == null || !mustInput.contains("isneedenclosure") || attAchmeMust) continue;
                attAchmeMust = true;
            }
            if (BillCommonService.billAttFileCheckStrict()) {
                this.checkAttAchment(isFromList, id, attachments, attAchmeMust, dataEntity, billSystemParam);
            }
            if (!flag) continue;
            logger.info("BusiTripBillValidator.validate.starttime:{}", (Object)System.currentTimeMillis());
            BustripBillCheckService billCommonCheckerService = new BustripBillCheckService(ApplyBillCheckEnum.BUSTRIP, UnifyBillEnum.TP, formEntity, tpOperator, applyAttr);
            BillResponse billResponse = billCommonCheckerService.checkAll();
            logger.info("BusiTripBillValidator.validate.endtime:{}", (Object)System.currentTimeMillis());
            if (billResponse.isSuccess()) continue;
            this.addErrorMessage(dataEntity, (String)billResponse.getMessage().get(0));
            errorBillNoSet.add(formEntity.getString("billno"));
        }
        logger.info("BusiTripBillValidator.validate.a4=:{}", (Object)System.currentTimeMillis());
        BustripBillPeriodService bustripBillPeriodService = new BustripBillPeriodService(isImport);
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap vaMap = Maps.newHashMapWithExpectedSize((int)this.getDataEntities().length);
        HashMap tpMap = Maps.newHashMapWithExpectedSize((int)this.getDataEntities().length);
        Map shiftInfo = bustripBillPeriodService.checkTpBillRepeat(dataEntities, (Map)vaMap, (Map)tpMap);
        logger.info("BusiTripBillValidator.validate.a5=:{}", (Object)System.currentTimeMillis());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            List errorList;
            long attFileBoId;
            List tuples;
            DynamicObject billDy = dataEntity.getDataEntity();
            if (billDy.getBoolean("isnottrip") || errorBillNoSet.contains(billDy.getString("billno")) || (tuples = (List)shiftInfo.get(attFileBoId = billDy.getLong("attfile.id"))) == null || tuples.isEmpty() || (errorList = bustripBillPeriodService.checkAllOfRepeat(billDy, tuples, attFileBoId, (Map)vaMap, (Map)tpMap, (Map)attFileToBustripMap)) == null || errorList.isEmpty()) continue;
            for (String errorMsg : errorList) {
                this.addErrorMessage(dataEntity, errorMsg);
            }
        }
        logger.info("BusiTripBillValidator.validate.a6=:{}", (Object)System.currentTimeMillis());
    }

    private void checkAttAchment(boolean isFromList, long id, Map<String, List<Map<String, Object>>> attachments, boolean attAchmeMust, ExtendedDataEntity dataEntity, BillSystemParam billSystemParam) {
        if (isFromList && id != 0L) {
            List<Map<String, Object>> list = attachments.get(String.valueOf(id));
            List errorList = BusiTripBillService.getInstance().attachmeCheck(attAchmeMust, list, billSystemParam);
            if (!errorList.isEmpty()) {
                for (String error : errorList) {
                    this.addErrorMessage(dataEntity, error);
                }
            }
        }
    }

    private Map<String, List<Map<String, Object>>> getAttachments(boolean isFromList, String formId, String changeFormId, Set<Long> idSet, Set<Long> changeIdSet) {
        Map attachments = new HashMap(16);
        if (isFromList) {
            Map attachments2;
            if (HRStringUtils.isNotEmpty((String)formId)) {
                attachments = AttachmentServiceHelper.getAttachments((String)formId, (Object[])idSet.toArray(), (String)"attachmentpanel", (boolean)false);
            }
            Map map = attachments = attachments == null ? new HashMap(0) : attachments;
            if (HRStringUtils.isNotEmpty((String)changeFormId) && (attachments2 = AttachmentServiceHelper.getAttachments((String)changeFormId, (Object[])changeIdSet.toArray(), (String)"attachmentpanel", (boolean)false)) != null) {
                attachments.putAll(attachments2);
            }
        }
        return attachments;
    }

    private void checkMustInput(ExtendedDataEntity dataEntity, List<String> mustInput, DynamicObject entryEntity) {
        String typeName;
        DynamicObject typeDy = entryEntity.getDynamicObject("busitriptype");
        String string = typeName = HRObjectUtils.isEmpty((Object)typeDy) ? "" : typeDy.getString("name");
        if (mustInput != null && mustInput.contains("isreasonrequired") && HRStringUtils.isEmpty((String)entryEntity.getString("tripresontex"))) {
            this.addErrorMessage(dataEntity, BusiTripBillKDStringHelper.reason((String)typeName));
        }
        if (mustInput != null && mustInput.contains("isvehicle") && entryEntity.get("traveltool") == null) {
            this.addErrorMessage(dataEntity, BusiTripBillKDStringHelper.tool((String)typeName));
        }
        if (mustInput != null && mustInput.contains("isplace")) {
            DynamicObject from = entryEntity.getDynamicObject("from");
            DynamicObject to = entryEntity.getDynamicObject("to");
            if (HRObjectUtils.isEmpty((Object)from)) {
                this.addErrorMessage(dataEntity, BusiTripBillKDStringHelper.from((String)typeName));
            }
            if (HRObjectUtils.isEmpty((Object)to)) {
                this.addErrorMessage(dataEntity, BusiTripBillKDStringHelper.to((String)typeName));
            }
        }
    }
}

