/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.mservice;

import java.util.List;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.wtc.wtam.business.upgarde.UpgradeCommonService;
import kd.wtc.wtam.mservice.WFProcCoteUpgradeV2;
import kd.wtc.wtbs.business.upgrade.WTCUpgradeService;

public abstract class AbstractWFProcCoteUpgrade
extends WTCUpgradeService {
    protected static final Log LOG = LogFactory.getLog(WFProcCoteUpgradeV2.class);
    private static final String UPDATE_PROC_COTE = "update t_wf_model set fcategory = ? where fid=?;";

    public void upgradeAction(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                DBRoute dbRoute = new DBRoute(dbKey);
                long wtamId = UpgradeCommonService.getInstance().cateGoryId(dbRoute);
                HRDBUtil.executeBatch((DBRoute)dbRoute, (String)UPDATE_PROC_COTE, this.getPresetProcParams(wtamId));
                this.upgradeActionNext(ver, iteration, dbKey, sqlFileName);
            }
            catch (Exception ex) {
                tx.markRollback();
                LOG.warn("AbstractWFProcCoteUpgrade.upgradeAction.Exception:{}", (Object)ex.getMessage());
            }
        }
    }

    protected void upgradeActionNext(String ver, String iteration, String dbKey, String sqlFileName) {
    }

    protected abstract List<Object[]> getPresetProcParams(Long var1);
}

