/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.mservice;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtam.mservice.api.IBusitripBillService;
import kd.wtc.wtbs.business.model.EffectiveEntityVo;
import kd.wtc.wtbs.business.model.PersonHasBillVo;
import kd.wtc.wtbs.business.util.WTCPermUtils;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class BusitripBillServiceImpl
implements IBusitripBillService {
    private static final Log LOG = LogFactory.getLog(BusitripBillServiceImpl.class);
    private final List<String> auditStatusList = Collections.unmodifiableList(Arrays.asList("D", "B", "C"));

    public List<EffectiveEntityVo> getBusitripbill(Long attfileId, Date startDate, Date endDate) {
        endDate = WTCDateUtils.getDayEndTime((Date)endDate);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtam_busitripbill");
        QFilter filter = new QFilter("attfile.id", "=", (Object)attfileId).and("billstatus", "=", (Object)"C").and("isnottrip", "=", (Object)Boolean.FALSE);
        HasPermOrgResult allPermOrgs = WTCPermUtils.getAllPermOrgs((String)"wtam", (String)"wtam_busitripbill");
        if (!allPermOrgs.hasAllOrgPerm() && allPermOrgs.getHasPermOrgs() != null) {
            filter.and("org", "in", (Object)allPermOrgs.getHasPermOrgs());
        }
        QFilter dateFilter = new QFilter("entryentity.startdate", "<=", (Object)endDate).and("entryentity.enddate", ">=", (Object)startDate);
        QFilter ownDateFilter = new QFilter("entryentity.owndate", ">=", (Object)startDate).and("entryentity.owndate", "<=", (Object)endDate);
        QFilter dateTimeFilter = dateFilter.or(ownDateFilter);
        filter.and(dateTimeFilter);
        DynamicObject[] supsignDys = helper.query("id,billno,ischange,applytyperadio,entryentity.startdate,entryentity.enddate,busitriptype.name,entryentity.triptime,entryentity.unit", new QFilter[]{filter}, "entryentity.startdate");
        ArrayList<EffectiveEntityVo> effectiveEntityVoList = new ArrayList<EffectiveEntityVo>();
        for (DynamicObject supsignDy : supsignDys) {
            DynamicObjectCollection entryentity = supsignDy.getDynamicObjectCollection("entryentity");
            String formId = BusitripBillServiceImpl.getFormId(supsignDy);
            for (DynamicObject dynamicObject : entryentity) {
                Date entryEndDate;
                Date entryStartDate = dynamicObject.getDate("startdate");
                if (!this.check(entryStartDate, entryEndDate = dynamicObject.getDate("enddate"), startDate, endDate)) continue;
                EffectiveEntityVo effectiveEntityVo = new EffectiveEntityVo();
                effectiveEntityVo.setId(Long.valueOf(supsignDy.getLong("id")));
                effectiveEntityVo.setStartDate(dynamicObject.getDate("startdate"));
                effectiveEntityVo.setEndDate(dynamicObject.getDate("enddate"));
                effectiveEntityVo.setBillno(supsignDy.getString("billno"));
                effectiveEntityVo.setChildType(dynamicObject.getString("busitriptype.name"));
                effectiveEntityVo.setFormId(formId);
                effectiveEntityVo.setApplyTime(dynamicObject.getBigDecimal("triptime"));
                effectiveEntityVo.setUnit(dynamicObject.getString("unit"));
                effectiveEntityVoList.add(effectiveEntityVo);
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("BusitripBillServiceImpl.getBusitripbill fileId = {} startDate = {} endDate = {} effectiveEntityVoList={}", new Object[]{attfileId, startDate, endDate, JSON.toJSONString(effectiveEntityVoList)});
        }
        return effectiveEntityVoList;
    }

    private boolean check(Date entryStartDate, Date entryEndDate, Date startDate, Date endDate) {
        return entryStartDate != null && entryEndDate != null && startDate != null && endDate != null && startDate.compareTo(entryEndDate) <= 0 && entryStartDate.compareTo(endDate) <= 0;
    }

    public Map<Long, Boolean> hasBtBill(List<Long> attfileboIds, Date effectdate) {
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(4);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtam_busitripbill");
        QFilter filter = this.getBillStatusFilter(attfileboIds);
        QFilter startFilter = new QFilter("entryentity.startdate", ">=", (Object)effectdate);
        QFilter endFilter = new QFilter("entryentity.enddate", ">=", (Object)effectdate);
        QFilter dateFilter = startFilter.or(endFilter);
        ArrayList startMethodList = Lists.newArrayListWithCapacity((int)16);
        startMethodList.add("1");
        startMethodList.add("2");
        QFilter noCustomFilter = new QFilter("entryentity.startmethod", "in", (Object)startMethodList);
        filter.and(noCustomFilter);
        DynamicObject[] query = helper.query("attfile.id", new QFilter[]{filter.and(dateFilter)});
        List<Long> hasbill = this.getHasBill(attfileboIds, query, effectdate, helper);
        if (!WTCCollections.isEmpty(hasbill)) {
            for (Long attfilebo : attfileboIds) {
                result.put(attfilebo, hasbill.contains(attfilebo));
            }
        }
        return result;
    }

    private List<Long> getHasBill(List<Long> attfileboIds, DynamicObject[] query, Date effectdate, HRBaseServiceHelper helper) {
        ArrayList hasBillList = Lists.newArrayListWithCapacity((int)16);
        QFilter qFilter = this.getBillStatusFilter(attfileboIds);
        DynamicObject[] dynamicObjects = this.getCustomData(qFilter, effectdate, helper);
        if (dynamicObjects != null && dynamicObjects.length != 0) {
            hasBillList.addAll(Arrays.stream(dynamicObjects).map(e -> e.getLong("attfile.id")).collect(Collectors.toList()));
        }
        if (query != null && query.length != 0) {
            hasBillList.addAll(Arrays.stream(query).map(e -> e.getLong("attfile.id")).collect(Collectors.toList()));
        }
        return hasBillList;
    }

    private QFilter getBillStatusFilter(List<Long> attfileboIds) {
        return new QFilter("attfile.id", "in", attfileboIds).and("billstatus", "in", this.auditStatusList).and("isnottrip", "=", (Object)Boolean.FALSE);
    }

    private DynamicObject[] getCustomData(QFilter qFilter, Date effectdate, HRBaseServiceHelper helper) {
        QFilter ownDateFilter = new QFilter("entryentity.owndate", ">=", (Object)effectdate);
        QFilter customFilter = new QFilter("entryentity.startmethod", "=", (Object)"3");
        qFilter.and(customFilter).and(ownDateFilter);
        return helper.query("attfile.id", new QFilter[]{qFilter});
    }

    private static String getFormId(DynamicObject supsignDy) {
        String formId = "wtam_busitripbill";
        boolean ischange = supsignDy.getBoolean("ischange");
        String applytyperadio = supsignDy.getString("applytyperadio");
        if (HRStringUtils.equals((String)applytyperadio, (String)"0") && ischange) {
            formId = "wtam_busiselfbillchange";
        } else if (HRStringUtils.equals((String)applytyperadio, (String)"1") && ischange) {
            formId = "wtam_busibillchange";
        } else if (HRStringUtils.equals((String)applytyperadio, (String)"0") && !ischange) {
            formId = "wtam_busitripselfbill";
        } else if (HRStringUtils.equals((String)applytyperadio, (String)"1") && !ischange) {
            formId = "wtam_busitripbill";
        }
        return formId;
    }

    public Map<Long, Boolean> personHasBtBill(List<PersonHasBillVo> personHasBillVoList) {
        Date minDate = null;
        Date maxDate = null;
        for (PersonHasBillVo personHasBillVo : personHasBillVoList) {
            Date startDate = personHasBillVo.getStartDate();
            if (minDate == null || minDate.compareTo(startDate) > 0) {
                minDate = startDate;
            }
            Date endDate = personHasBillVo.getEndDate();
            if (maxDate != null && maxDate.compareTo(endDate) >= 0) continue;
            maxDate = endDate;
        }
        List personIdList = personHasBillVoList.stream().map(PersonHasBillVo::getAttPersonId).collect(Collectors.toList());
        List<String> auditStatusList = Arrays.asList("D", "B", "C");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtam_busitripbill");
        QFilter filter = new QFilter("personid.id", "in", personIdList).and("billstatus", "in", auditStatusList).and("isnottrip", "=", (Object)Boolean.FALSE);
        QFilter startFilter = new QFilter("entryentity.startdate", "<=", (Object)maxDate);
        QFilter endFilter = new QFilter("entryentity.enddate", ">=", (Object)minDate);
        QFilter dateFilter = startFilter.and(endFilter);
        DynamicObject[] dys = helper.queryOriginalArray("entryentity.startdate, entryentity.enddate, personid.id", new QFilter[]{filter.and(dateFilter)});
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)dys.length);
        for (DynamicObject dy : dys) {
            Date billStartDate = dy.getDate("entryentity.startdate");
            Date billEndDate = dy.getDate("entryentity.enddate");
            long billPersonId = dy.getLong("personid.id");
            for (PersonHasBillVo personHasBillVo : personHasBillVoList) {
                if (personHasBillVo.getAttPersonId() != billPersonId || personHasBillVo.getStartDate() == null || personHasBillVo.getEndDate() == null || personHasBillVo.getEndDate().compareTo(billStartDate) < 0 || personHasBillVo.getStartDate().compareTo(billEndDate) > 0) continue;
                resultMap.put(personHasBillVo.getId(), Boolean.TRUE);
            }
        }
        return resultMap;
    }
}

