/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.wtc.wtam.business.upgarde.UpgradeCommonService;
import kd.wtc.wtbs.common.predata.wtam.PreDataWFProcCote;

public class WFProcCoteOTChangeUpgrade
implements IUpgradeService {
    private static final String UPDATE_PROC_COTE = "update t_wf_model set fcategory = ? where fid=?;";

    public UpgradeResult afterExecuteSqlWithResult(String ver1, String iteration1, String dbKey, String sqlFileName1) {
        UpgradeResult result = new UpgradeResult();
        boolean flag = true;
        try (TXHandle tx = TX.requiresNew();){
            try {
                DBRoute dbRoute = new DBRoute(dbKey);
                long wtamId = UpgradeCommonService.getInstance().cateGoryId(dbRoute);
                List<Object[]> presetProcParams = this.getPresetProcParams(wtamId);
                HRDBUtil.executeBatch((DBRoute)dbRoute, (String)UPDATE_PROC_COTE, presetProcParams);
            }
            catch (Exception ex) {
                result.setErrorInfo(ex.getMessage());
                tx.markRollback();
                flag = false;
            }
        }
        result.setEl("warning");
        if (flag) {
            result.setLog("WFProcCoteOTChangeUpgrade Success");
        } else {
            result.setLog("WFProcCoteOTChangeUpgrade Fail");
        }
        result.setSuccess(flag);
        return result;
    }

    private List<Object[]> getPresetProcParams(Long groupId) {
        List<Long> idList = Arrays.asList(PreDataWFProcCote.PD_PROCCATE_WTOM_OTBILLCHANGE, PreDataWFProcCote.PD_PROCCATE_WTOM_OTSELFBILLCHANGE);
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        for (Long id : idList) {
            Object[] org = new Object[]{groupId, id};
            params.add(org);
        }
        return params;
    }
}

