/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.wtc.wtam.business.upgarde.UpgradeCommonService;
import kd.wtc.wtbs.common.predata.wtam.PreDataWFProcCote;

public class WFProcCoteUpgrade
implements IUpgradeService {
    private static final String UPDATE_PROC_COTE = "update t_wf_model set fcategory = ? where fid=?;";

    public UpgradeResult afterExecuteSqlWithResult(String ver1, String iteration1, String dbKey, String sqlFileName1) {
        UpgradeResult result = new UpgradeResult();
        boolean flag = true;
        try (TXHandle tx = TX.requiresNew();){
            try {
                DBRoute dbRoute = new DBRoute(dbKey);
                long wtamId = UpgradeCommonService.getInstance().cateGoryId(dbRoute);
                HRDBUtil.executeBatch((DBRoute)dbRoute, (String)UPDATE_PROC_COTE, this.getPresetProcParams(wtamId));
            }
            catch (Exception ex) {
                result.setErrorInfo(ex.getMessage());
                tx.markRollback();
                flag = false;
            }
        }
        result.setEl("warning");
        if (flag) {
            result.setLog("WFProcCoteUpgrade Success");
        } else {
            result.setLog("WFProcCoteUpgrade Fail");
        }
        result.setSuccess(flag);
        return result;
    }

    private List<Object[]> getPresetProcParams(Long groupId) {
        List<Long> idList = Arrays.asList(PreDataWFProcCote.PD_WTABM_VAAPPLY, PreDataWFProcCote.PD_WTABM_VAAPPLYSELF, PreDataWFProcCote.PD_WTABM_VAUPDATE, PreDataWFProcCote.PD_WTABM_VAUPDATESELF, PreDataWFProcCote.PD_WTAM_BUSIBILLCHANGE, PreDataWFProcCote.PD_WTAM_BUSISELFBILLCHANGE, PreDataWFProcCote.PD_WTAM_BUSITRIPBILL, PreDataWFProcCote.PD_WTAM_BUSITRIPSELFBILL, PreDataWFProcCote.PD_WTOM_OTBILLSELF, PreDataWFProcCote.PD_WTOM_OVERTIMEAPPLYBILL, PreDataWFProcCote.PD_WTPM_SUPSIGNBATCH, PreDataWFProcCote.PD_WTPM_SUPSIGNPC, PreDataWFProcCote.PD_WTPM_SUPSIGNSELF);
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        for (Long id : idList) {
            params.add(new Object[]{groupId, id});
        }
        return params;
    }
}

