/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.mservice;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtam.mservice.AbstractWFProcCoteUpgrade;
import kd.wtc.wtbs.common.predata.wtam.PreDataWFProcCote;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.proxy.Joiner;

public class WFProcCoteUpgradeV2
extends AbstractWFProcCoteUpgrade {
    private static final List<String> BSM_ENTITYNUMBER_LIST = Lists.newArrayList((Object[])new String[]{"wtam_busibillchange", "wtam_busitripbill", "wtpm_supsignpc", "wtabm_vaapply", "wtabm_vaupdate", "wtom_otbillchange", "wtom_overtimeapplybill"});

    @Override
    public void upgradeActionNext(String ver, String iteration, String dbKey, String sqlFileName) {
        DBRoute dbRoute = DBRoute.of((String)dbKey);
        Map<String, List<String>> sqlMap = this.initUpdateSqlMap();
        this.deleteBillSubject(sqlMap, dbRoute);
        ArrayList<String> allSqls = new ArrayList<String>(16);
        if (sqlMap.size() > 0) {
            List<String> queryEntityNumberResult = this.queryBillSubjectModel(dbRoute);
            for (Map.Entry<String, List<String>> sqlEntry : sqlMap.entrySet()) {
                List<String> sqls;
                String entityNumber = sqlEntry.getKey();
                if (queryEntityNumberResult.contains(entityNumber) || !WTCCollections.isNotEmpty(sqls = sqlEntry.getValue())) continue;
                allSqls.addAll(sqls);
            }
        }
        if (WTCCollections.isNotEmpty(allSqls)) {
            String join = Joiner.on((String)"").join(allSqls);
            DB.execute((DBRoute)dbRoute, (String)join);
        }
    }

    private void deleteBillSubject(Map<String, List<String>> sqlMap, DBRoute dbRoute) {
        ArrayList<String> allDeleteSqls = new ArrayList<String>(sqlMap.size());
        for (Map.Entry<String, List<String>> entry : sqlMap.entrySet()) {
            List<String> sqls = entry.getValue();
            for (String sql : sqls) {
                if (!sql.startsWith("DELETE") && !sql.startsWith("delete")) continue;
                allDeleteSqls.add(sql);
            }
        }
        if (WTCCollections.isNotEmpty(allDeleteSqls)) {
            String join = Joiner.on((String)"").join(allDeleteSqls);
            DB.execute((DBRoute)dbRoute, (String)join);
        }
    }

    @Override
    protected List<Object[]> getPresetProcParams(Long groupId) {
        List<Long> idList = Arrays.asList(PreDataWFProcCote.PD_WTABM_VAAPPLY_V2, PreDataWFProcCote.PD_WTABM_VAAPPLYSELF_V2, PreDataWFProcCote.PD_WTABM_VAUPDATE_V2, PreDataWFProcCote.PD_WTABM_VAUPDATESELF_V2, PreDataWFProcCote.PD_WTAM_BUSIBILLCHANGE_V2, PreDataWFProcCote.PD_WTAM_BUSISELFBILLCHANGE_V2, PreDataWFProcCote.PD_WTAM_BUSITRIPBILL_V2, PreDataWFProcCote.PD_WTOM_OTBILLSELF_V2, PreDataWFProcCote.PD_WTOM_OVERTIMEAPPLYBILL_V2, PreDataWFProcCote.PD_WTPM_SUPSIGNPC_V2, PreDataWFProcCote.PD_WTPM_SUPSIGNSELF_V2, PreDataWFProcCote.PD_WTAM_BUSITRIPSELFBILL_V2, PreDataWFProcCote.PD_PROCCATE_WTOM_OTBILLCHANGE_V2, PreDataWFProcCote.PD_PROCCATE_WTOM_OTSELFBILLCHANGE_V2);
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        for (Long id : idList) {
            params.add(new Object[]{groupId, id});
        }
        return params;
    }

    private List<String> queryBillSubjectModel(DBRoute dbRoute) {
        String querySql = "select fentitynumber from T_WF_BILLSUBJECTMODEL where ";
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(querySql, new Object[0]);
        sqlBuilder.appendIn("fentitynumber", BSM_ENTITYNUMBER_LIST.toArray());
        return (List)DB.query((DBRoute)dbRoute, (SqlBuilder)sqlBuilder, resultSet -> {
            ArrayList<String> queryEntityNumberResult = new ArrayList<String>(BSM_ENTITYNUMBER_LIST.size());
            while (resultSet.next()) {
                queryEntityNumberResult.add(resultSet.getString("fentitynumber"));
            }
            return queryEntityNumberResult;
        });
    }

    private Map<String, List<String>> initUpdateSqlMap() {
        HashMap sqlMap = Maps.newHashMapWithExpectedSize((int)8);
        try (BufferedReader bd = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/upgrade/kd_1.5.226_wtam_wfbillsubjectmodel_update.sql")));){
            String line;
            String entityNumber = "";
            while ((line = bd.readLine()) != null) {
                if (HRStringUtils.isEmpty((String)line)) continue;
                if (BSM_ENTITYNUMBER_LIST.contains(line)) {
                    entityNumber = line;
                    continue;
                }
                List sqls = sqlMap.computeIfAbsent(entityNumber, key -> Lists.newArrayList());
                sqls.add(line);
            }
        }
        catch (IOException io) {
            String msg = "WFProcCoteUpgradeV2 exception";
            LOG.warn(msg, (Throwable)io);
            throw new KDBizException((Throwable)io, new ErrorCode("WFProcCoteUpgradeV2", msg), new Object[0]);
        }
        return sqlMap;
    }
}

