/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.mservice.openapi.busitripbill;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiErrorCode;
import kd.bos.openapi.common.custom.annotation.ApiErrorCodes;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtam.business.busitrip.BusiTripBillImportService;
import kd.wtc.wtam.business.busitrip.BusiTripBillKDStringHelper;
import kd.wtc.wtam.business.busitripmobile.BusiTripBillUtil;
import kd.wtc.wtam.mservice.openapi.busitripbill.BusitripBillEntryModel;
import kd.wtc.wtam.mservice.openapi.busitripbill.BusitripBillReqModel;
import kd.wtc.wtam.mservice.openapi.busitripbill.BusitripBillRespModel;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

@ApiController(desc="Busitrip OpenApi", value="Busitrip OpenApi")
@ApiMapping(value="/busitrip")
@ApiErrorCodes(value={@ApiErrorCode(code="0-999", desc="api system error"), @ApiErrorCode(code="10000-99999", desc="BOS\u5e73\u53f0\u5f02\u5e38"), @ApiErrorCode(code="wtam.100001", desc="\u5165\u53c2\u4e0d\u5408\u6cd5\u3002"), @ApiErrorCode(code="wtam.100002", desc="\u7cfb\u7edf\u5185\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\u3002"), @ApiErrorCode(code="wtam.100003", desc="\u4e1a\u52a1\u6570\u636e\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002")})
public class BusitripOtherBillOpenApi
implements Serializable {
    private static final long serialVersionUID = -6297133741985055063L;
    private static final Log LOGGER = LogFactory.getLog(BusitripOtherBillOpenApi.class);
    private static final int maxBillSize = 50;
    private static final int oneBillMaxEntrySize = 10;

    /*
     * WARNING - void declaration
     */
    @ApiPostMapping(desc="busitripOtherBill", value="/busitripOtherBill")
    public CustomApiResult<List<BusitripBillRespModel>> busitripOtherBill(@ApiParam(value="\u8bf7\u6c42\u53c2\u6570") @Valid @ApiParam(value="\u8bf7\u6c42\u53c2\u6570") @Valid ArrayList<BusitripBillReqModel> request) {
        void var8_16;
        BusitripBillRespModel billRes;
        ArrayList<BusitripBillRespModel> res;
        if (request.isEmpty()) {
            return CustomApiResult.success(new LinkedList());
        }
        if (request.size() > 50) {
            String errorMsg = ResManager.loadKDString((String)"1\u6b21\u63a5\u53e3\u8c03\u7528\u4e0d\u80fd\u4f20\u5165\u8d85\u8fc7{0}\u4e2a{1}\u5355\u3002", (String)"BusitripOtherBillOpenApi_4", (String)"wtc-wtam-mservice", (Object[])new Object[]{50, BillTypeEnum.EVECTIONBILL.getBillName()});
            return CustomApiResult.fail((String)"wtam.100001", (String)errorMsg);
        }
        HashMap<Integer, String> errorMap = new HashMap<Integer, String>(16);
        Map<Integer, DynamicObject> legalBillMap = this.checkParamAndGetSuccessInfo(request, errorMap);
        DynamicObject[] billArr = new DynamicObject[legalBillMap.size()];
        HashMap<Object, Integer> pk2ReqIndexMap = new HashMap<Object, Integer>(legalBillMap.size());
        int arrIdx = 0;
        for (Map.Entry<Integer, DynamicObject> entry : legalBillMap.entrySet()) {
            pk2ReqIndexMap.put(entry.getValue().get("id"), entry.getKey());
            billArr[arrIdx++] = entry.getValue();
        }
        if (billArr.length > 0) {
            Throwable throwable = null;
            try (TXHandle handle = TX.requiresNew();){
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("currbizappid", "wtam");
                operateOption.setVariableValue("importtag_of_datasource", Boolean.TRUE.toString());
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"submiteffect", (String)"wtam_busitripbill", (DynamicObject[])billArr, (OperateOption)operateOption);
                if (!operationResult.isSuccess()) {
                    LOGGER.warn("busitripOtherBill executeOperate fail. operationResult:{}", (Object)operationResult);
                    ValidateResultCollection validateResColl = operationResult.getValidateResult();
                    for (ValidateResult validateResult : validateResColl.getValidateErrors()) {
                        if (validateResult.isSuccess()) continue;
                        for (OperateErrorInfo operateErrorInfo : validateResult.getAllErrorInfo()) {
                            Object billPK = operateErrorInfo.getPkValue();
                            Integer reqIndex = (Integer)pk2ReqIndexMap.get(billPK);
                            String errMsg = (String)errorMap.get(reqIndex);
                            if (!WTCStringUtils.isEmpty((String)errMsg) && !errMsg.equals(operationResult.getMessage())) continue;
                            errorMap.put(reqIndex, operateErrorInfo.getMessage());
                        }
                    }
                    List successPkIds = operationResult.getSuccessPkIds();
                    for (DynamicObject bill : billArr) {
                        Integer reqIndex;
                        Object billPK = bill.get("id");
                        if (successPkIds.contains(billPK) || errorMap.containsKey(reqIndex = (Integer)pk2ReqIndexMap.get(billPK))) continue;
                        errorMap.put(reqIndex, operationResult.getMessage());
                    }
                }
                if (!errorMap.isEmpty()) {
                    handle.markRollback();
                }
            }
            catch (Throwable operateOption) {
                Throwable throwable2 = operateOption;
                throw operateOption;
            }
        }
        if (errorMap.isEmpty()) {
            void var8_14;
            res = new ArrayList<BusitripBillRespModel>(request.size());
            boolean bl = false;
            while (var8_14 < request.size()) {
                billRes = new BusitripBillRespModel();
                billRes.setIndex((int)var8_14);
                billRes.setBillNo(legalBillMap.get((int)var8_14).getString("billno"));
                res.add(billRes);
                ++var8_14;
            }
            return CustomApiResult.success(res);
        }
        res = new ArrayList(request.size());
        boolean bl = false;
        while (var8_16 < request.size()) {
            billRes = new BusitripBillRespModel();
            billRes.setIndex((int)var8_16);
            String errMsg = (String)errorMap.get((int)var8_16);
            if (errMsg != null) {
                billRes.setErrMsg(errMsg);
            }
            res.add(billRes);
            ++var8_16;
        }
        CustomApiResult customApiResult = new CustomApiResult();
        customApiResult.setStatus(false);
        customApiResult.setErrorCode("wtam.100003");
        customApiResult.setData(res);
        return customApiResult;
    }

    private boolean notEqualsAny(String str, String ... tar) {
        if (str != null && tar != null) {
            for (String s : tar) {
                if (!str.equals(s)) continue;
                return false;
            }
        }
        return true;
    }

    private Map<Integer, DynamicObject> checkParamAndGetSuccessInfo(ArrayList<BusitripBillReqModel> billList, Map<Integer, String> errorMap) {
        DynamicObject[] arr;
        HashSet occurBillNoSet = Sets.newHashSetWithExpectedSize((int)billList.size());
        HashMap billNo2ReqIdxMap = Maps.newHashMapWithExpectedSize((int)billList.size());
        HashSet attFileNumberSet = Sets.newHashSetWithExpectedSize((int)billList.size());
        HashSet orgNumberSet = Sets.newHashSetWithExpectedSize((int)billList.size());
        HashSet busTypeNumberSet = Sets.newHashSetWithExpectedSize((int)billList.size());
        HashSet travelToolNumberSet = Sets.newHashSetWithExpectedSize((int)billList.size());
        HashSet cityNumberSet = Sets.newHashSetWithExpectedSize((int)billList.size());
        for (int reqIndex = 0; reqIndex < billList.size(); ++reqIndex) {
            BusitripBillReqModel bill = billList.get(reqIndex);
            if (errorMap.containsKey(reqIndex)) continue;
            if (WTCStringUtils.isNotEmpty((String)bill.getBillNo()) && !occurBillNoSet.add(bill.getBillNo())) {
                errorMap.put(reqIndex, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u201c%s\u201d\u91cd\u590d\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"BusitripOtherBillOpenApi_1", (String)"wtc-wtam-mservice", (Object[])new Object[]{bill.getBillNo()}));
                continue;
            }
            if (WTCCollections.isEmpty(bill.getEntryEntity())) {
                errorMap.put(reqIndex, ResManager.loadKDString((String)"\u201c{0}\u4fe1\u606f\u201d\u4e3a\u5fc5\u586b\u9879\u3002", (String)"BusitripOtherBillOpenApi_12", (String)"wtc-wtam-mservice", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName()}));
                continue;
            }
            if (bill.getEntryEntity().size() > 10) {
                errorMap.put(reqIndex, ResManager.loadKDString((String)"1\u4e2a{0}\u5355\u6700\u591a\u5141\u8bb8\u4e0a\u4f20{1}\u6761\u5206\u5f55\u3002", (String)"BusitripOtherBillOpenApi_5", (String)"wtc-wtam-mservice", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName(), 10}));
                continue;
            }
            boolean billEntryCheckFail = false;
            for (BusitripBillEntryModel billEntry : bill.getEntryEntity()) {
                if (HRStringUtils.isEmpty((String)billEntry.getBusitripType())) {
                    billEntryCheckFail = true;
                    errorMap.put(reqIndex, ResManager.loadKDString((String)"\u53c2\u6570\u201cbusitripType\u201d\u5fc5\u586b\uff0c\u8bf7\u586b\u5199\u3002", (String)"BusitripOtherBillOpenApi_15", (String)"wtc-wtam-mservice", (Object[])new Object[0]));
                    break;
                }
                if (this.notEqualsAny(billEntry.getStartMethod(), "0", "1", "2", "3")) {
                    billEntryCheckFail = true;
                    errorMap.put(reqIndex, ResManager.loadKDString((String)"\u8bf7\u6309\u89c4\u8303\u586b\u5199\u201d{0}\u65b9\u5f0f(\u5f00\u59cb)\u201c 0:\u4e0a\u534a\u5929, 1:\u4e0b\u534a\u5929, 2:\u5168\u5929, 3:\u81ea\u9009\u65f6\u6bb5\u3002", (String)"BusitripOtherBillOpenApi_10", (String)"wtc-wtam-mservice", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName()}));
                    break;
                }
                if (HRStringUtils.isEmpty((String)billEntry.getStartDateStr())) {
                    billEntryCheckFail = true;
                    errorMap.put(reqIndex, ResManager.loadKDString((String)"\u53c2\u6570\u201cstartDateStr\u201d\u5fc5\u586b\uff0c\u8bf7\u586b\u5199\u3002", (String)"BusitripOtherBillOpenApi_16", (String)"wtc-wtam-mservice", (Object[])new Object[0]));
                    break;
                }
                if (this.notEqualsAny(billEntry.getEndMethod(), "0", "1", "2", "3")) {
                    billEntryCheckFail = true;
                    errorMap.put(reqIndex, ResManager.loadKDString((String)"\u8bf7\u6309\u89c4\u8303\u586b\u5199\u201d{0}\u65b9\u5f0f(\u7ed3\u675f)\u201c 0:\u4e0a\u534a\u5929, 1:\u4e0b\u534a\u5929, 2:\u5168\u5929, 3:\u81ea\u9009\u65f6\u6bb5\u3002", (String)"BusitripOtherBillOpenApi_11", (String)"wtc-wtam-mservice", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName()}));
                    break;
                }
                if (!HRStringUtils.isEmpty((String)billEntry.getEndDateStr())) continue;
                billEntryCheckFail = true;
                errorMap.put(reqIndex, ResManager.loadKDString((String)"\u53c2\u6570\u201cendDateStr\u201d\u5fc5\u586b\uff0c\u8bf7\u586b\u5199\u3002", (String)"BusitripOtherBillOpenApi_17", (String)"wtc-wtam-mservice", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName()}));
                break;
            }
            if (billEntryCheckFail) continue;
            if (WTCStringUtils.isNotEmpty((String)bill.getBillNo())) {
                billNo2ReqIdxMap.put(bill.getBillNo(), reqIndex);
            }
            attFileNumberSet.add(bill.getAttFileNumber());
            orgNumberSet.add(bill.getOrg());
            for (BusitripBillEntryModel billEntry : bill.getEntryEntity()) {
                if (HRStringUtils.isNotEmpty((String)billEntry.getBusitripType())) {
                    busTypeNumberSet.add(billEntry.getBusitripType());
                }
                if (WTCStringUtils.isNotEmpty((String)billEntry.getTravelTool())) {
                    travelToolNumberSet.add(billEntry.getTravelTool());
                }
                if (WTCStringUtils.isNotEmpty((String)billEntry.getFrom())) {
                    cityNumberSet.add(billEntry.getFrom());
                }
                if (!WTCStringUtils.isNotEmpty((String)billEntry.getTo())) continue;
                cityNumberSet.add(billEntry.getTo());
            }
        }
        HRBaseServiceHelper billDao = new HRBaseServiceHelper("wtam_busitripbill");
        for (DynamicObject existBillNo : arr = billDao.query("billno", new QFilter("billno", "in", billNo2ReqIdxMap.keySet()).toArray())) {
            String billNo = existBillNo.getString("billno");
            Integer integer = (Integer)billNo2ReqIdxMap.get(billNo);
            if (integer == null || errorMap.containsKey(integer)) continue;
            errorMap.put(integer, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u201c%s\u201d\u91cd\u590d\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"BusitripOtherBillOpenApi_1", (String)"wtc-wtam-mservice", (Object[])new Object[]{billNo}));
        }
        HashMap fileNumber2Top1Map = new HashMap(16);
        HashMap fileNumber2PersonMap = new HashMap(16);
        HashMap fileNumber2AttFileBoMap = new HashMap(16);
        new BillCommonService().initBillImportData("wtam", "wtam_busitripbill", (Set)attFileNumberSet, fileNumber2Top1Map, fileNumber2PersonMap, fileNumber2AttFileBoMap);
        Map<String, DynamicObject> orgNumberMap = this.queryOrgByNumber(orgNumberSet);
        Map<String, DynamicObject> travelTypeNumberMap = this.queryTravelTypeByNumber(busTypeNumberSet);
        Map<String, DynamicObject> travelToolNumberMap = this.queryTravelToolByNumber(travelToolNumberSet);
        Map<String, DynamicObject> cityNumberMap = this.queryCityByNumber(cityNumberSet);
        block4: for (int reqIndex = 0; reqIndex < billList.size(); ++reqIndex) {
            BusitripBillReqModel bill = billList.get(reqIndex);
            if (errorMap.containsKey(reqIndex)) continue;
            if (!fileNumber2AttFileBoMap.containsKey(bill.getAttFileNumber())) {
                errorMap.put(reqIndex, ResManager.loadKDString((String)"{0}\u5458\u5de5.\u6863\u6848\u7f16\u53f7\u201c{1}\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"BusitripOtherBillOpenApi_2", (String)"wtc-wtam-mservice", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName(), bill.getAttFileNumber()}));
                continue;
            }
            if (!fileNumber2PersonMap.containsKey(bill.getAttFileNumber())) {
                errorMap.put(reqIndex, ResManager.loadKDString((String)"{0}\u5458\u5de5.\u6863\u6848\u7f16\u53f7\u201c{1}\u201d\u5bf9\u5e94\u7684\u8003\u52e4\u4eba\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"BusitripOtherBillOpenApi_13", (String)"wtc-wtam-mservice", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName(), bill.getAttFileNumber()}));
                continue;
            }
            if (!orgNumberMap.containsKey(bill.getOrg())) {
                errorMap.put(reqIndex, ResManager.loadKDString((String)"\u8003\u52e4\u7ba1\u7406\u7ec4\u7ec7.\u7f16\u7801\u201c{0}\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"BusitripOtherBillOpenApi_3", (String)"wtc-wtam-mservice", (Object[])new Object[]{bill.getOrg()}));
                continue;
            }
            for (BusitripBillEntryModel billEntry : bill.getEntryEntity()) {
                String travelType = billEntry.getBusitripType();
                if (!travelTypeNumberMap.containsKey(travelType)) {
                    errorMap.put(reqIndex, ResManager.loadKDString((String)"{0}\u7c7b\u578b.\u7f16\u7801\u201c{1}\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"BusitripOtherBillOpenApi_6", (String)"wtc-wtam-mservice", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName(), travelType}));
                    continue block4;
                }
                String typeTool = billEntry.getTravelTool();
                if (WTCStringUtils.isNotEmpty((String)typeTool) && !travelToolNumberMap.containsKey(typeTool)) {
                    errorMap.put(reqIndex, ResManager.loadKDString((String)"\u4ea4\u901a\u5de5\u5177.\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"BusitripOtherBillOpenApi_7", (String)"wtc-wtam-mservice", (Object[])new Object[]{typeTool}));
                    continue block4;
                }
                String from = billEntry.getFrom();
                if (WTCStringUtils.isNotEmpty((String)from) && !cityNumberMap.containsKey(from)) {
                    errorMap.put(reqIndex, ResManager.loadKDString((String)"\u51fa\u53d1\u5730.\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"BusitripOtherBillOpenApi_8", (String)"wtc-wtam-mservice", (Object[])new Object[]{from}));
                    continue block4;
                }
                String to = billEntry.getTo();
                if (!WTCStringUtils.isNotEmpty((String)to) || cityNumberMap.containsKey(to)) continue;
                errorMap.put(reqIndex, ResManager.loadKDString((String)"\u76ee\u7684\u5730.\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"BusitripOtherBillOpenApi_9", (String)"wtc-wtam-mservice", (Object[])new Object[]{to}));
                continue block4;
            }
        }
        IDGenerator idGenerator = new IDGenerator();
        HashMap<Integer, DynamicObject> reqIdx2BillDynMap = new HashMap<Integer, DynamicObject>(billList.size());
        MainEntityType userMET = MetadataServiceHelper.getDataEntityType((String)"bos_user");
        MainEntityType billMET = MetadataServiceHelper.getDataEntityType((String)"wtam_busitripbill");
        for (int index = 0; index < billList.size(); ++index) {
            if (errorMap.containsKey(index)) continue;
            BusitripBillReqModel bill = billList.get(index);
            DynamicObject billDyn = new DynamicObject((DynamicObjectType)billMET);
            billDyn.set("id", (Object)idGenerator.getId());
            if (WTCStringUtils.isNotEmpty((String)bill.getBillNo())) {
                billDyn.set("billno", (Object)bill.getBillNo());
            }
            billDyn.set("org", (Object)orgNumberMap.get(bill.getOrg()));
            billDyn.set("attfilebasef7", fileNumber2Top1Map.get(bill.getAttFileNumber()));
            billDyn.set("attfile", fileNumber2AttFileBoMap.get(bill.getAttFileNumber()));
            billDyn.set("personid", fileNumber2PersonMap.get(bill.getAttFileNumber()));
            billDyn.set("applytyperadio", (Object)"1");
            DynamicObject user = new DynamicObject((DynamicObjectType)userMET);
            user.set("id", (Object)RequestContext.get().getCurrUserId());
            billDyn.set("creator", (Object)user);
            billDyn.set("auditstatus", (Object)"A");
            billDyn.set("billstatus", (Object)"A");
            EntryProp entryProp = (EntryProp)billDyn.getDataEntityType().getProperties().get((Object)"entryentity");
            EntryType entryType = (EntryType)entryProp.getItemType();
            DynamicObjectCollection entries = billDyn.getDynamicObjectCollection("entryentity");
            int entrySeq = 1;
            for (BusitripBillEntryModel billEntry : bill.getEntryEntity()) {
                DynamicObject newRow = new DynamicObject((DynamicObjectType)entryType);
                newRow.set("seq", (Object)entrySeq++);
                newRow.set("busitriptype", (Object)travelTypeNumberMap.get(billEntry.getBusitripType()));
                newRow.set("startmethod", (Object)billEntry.getStartMethod());
                newRow.set("startdatestr", (Object)billEntry.getStartDateStr());
                newRow.set("endmethod", (Object)billEntry.getEndMethod());
                newRow.set("enddatestr", (Object)billEntry.getEndDateStr());
                if (WTCStringUtils.isNotEmpty((String)billEntry.getTravelTool())) {
                    newRow.set("traveltool", (Object)travelToolNumberMap.get(billEntry.getTravelTool()));
                }
                if (WTCStringUtils.isNotEmpty((String)billEntry.getFrom())) {
                    newRow.set("from", (Object)cityNumberMap.get(billEntry.getFrom()));
                }
                if (WTCStringUtils.isNotEmpty((String)billEntry.getTo())) {
                    newRow.set("to", (Object)cityNumberMap.get(billEntry.getTo()));
                }
                if (WTCStringUtils.isNotEmpty((String)billEntry.getTripReason())) {
                    newRow.set("tripresontex", (Object)billEntry.getTripReason());
                }
                entries.add((Object)newRow);
            }
            reqIdx2BillDynMap.put(index, billDyn);
        }
        String upStr = BusiTripBillKDStringHelper.dayUp();
        String downStr = BusiTripBillKDStringHelper.dayDown();
        BusiTripBillImportService busiTripBillImportService = new BusiTripBillImportService();
        block8: for (Map.Entry reqIdx2BillTuple : reqIdx2BillDynMap.entrySet()) {
            Integer index = (Integer)reqIdx2BillTuple.getKey();
            DynamicObject billDyn = (DynamicObject)reqIdx2BillTuple.getValue();
            DynamicObject attFileDy = billDyn.getDynamicObject("attfile");
            String attFileError = BillCommonService.getInstance().judgeAttFile(attFileDy, BillTypeEnum.EVECTIONBILL.getBillName());
            if (HRStringUtils.isNotEmpty((String)attFileError)) {
                errorMap.put(index, attFileError);
                continue;
            }
            DynamicObjectCollection billEntries = billDyn.getDynamicObjectCollection("entryentity");
            int seq = 0;
            for (DynamicObject billEntry : billEntries) {
                ++seq;
                String errMsg = busiTripBillImportService.checkEntry(billEntry);
                if (errMsg != null) {
                    errorMap.put(index, this.getMsg(billEntries.size(), seq, errMsg));
                    continue block8;
                }
                billEntry.set("startdatestr", (Object)BusiTripBillUtil.getDateMethodStr((DynamicObject)billEntry, (String)"startmethod", (String)"startdate", (String)upStr, (String)downStr));
                billEntry.set("enddatestr", (Object)BusiTripBillUtil.getDateMethodStr((DynamicObject)billEntry, (String)"endmethod", (String)"enddate", (String)upStr, (String)downStr));
                billEntry.set("enclosuremode", (Object)0);
            }
        }
        errorMap.keySet().forEach(reqIdx2BillDynMap::remove);
        return reqIdx2BillDynMap;
    }

    private Map<String, DynamicObject> queryCityByNumber(Set<String> citySet) {
        HRBaseServiceHelper cityDao = new HRBaseServiceHelper("bd_admindivision");
        DynamicObject[] cityArr = cityDao.loadDynamicObjectArray(new QFilter("number", "in", citySet).toArray());
        HashMap<String, DynamicObject> cityNumberMap = new HashMap<String, DynamicObject>(cityArr.length);
        for (DynamicObject city : cityArr) {
            cityNumberMap.put(city.getString("number"), city);
        }
        return cityNumberMap;
    }

    private Map<String, DynamicObject> queryTravelToolByNumber(Set<String> travelToolSet) {
        HRBaseServiceHelper travelToolDao = new HRBaseServiceHelper("wtbd_traveltool");
        DynamicObject[] travelToolArr = travelToolDao.loadDynamicObjectArray(new QFilter("number", "in", travelToolSet).toArray());
        HashMap<String, DynamicObject> travelToolNumberMap = new HashMap<String, DynamicObject>(travelToolArr.length);
        for (DynamicObject travelTool : travelToolArr) {
            travelToolNumberMap.put(travelTool.getString("number"), travelTool);
        }
        return travelToolNumberMap;
    }

    private Map<String, DynamicObject> queryTravelTypeByNumber(Set<String> busTypeSet) {
        HRBaseServiceHelper travelToolDao = new HRBaseServiceHelper("wtbd_traveltype");
        DynamicObject[] travelTypeArr = travelToolDao.loadDynamicObjectArray(new QFilter("number", "in", busTypeSet).toArray());
        HashMap<String, DynamicObject> travelTypeNumberMap = new HashMap<String, DynamicObject>(travelTypeArr.length);
        for (DynamicObject travelType : travelTypeArr) {
            travelTypeNumberMap.put(travelType.getString("number"), travelType);
        }
        return travelTypeNumberMap;
    }

    private Map<String, DynamicObject> queryOrgByNumber(Set<String> orgNumberSet) {
        HRBaseServiceHelper orgDao = new HRBaseServiceHelper("bos_org");
        DynamicObject[] orgArr = orgDao.loadDynamicObjectArray(new QFilter("number", "in", orgNumberSet).toArray());
        HashMap<String, DynamicObject> orgNumberMap = new HashMap<String, DynamicObject>(orgArr.length);
        for (DynamicObject org : orgArr) {
            orgNumberMap.put(org.getString("number"), org);
        }
        return orgNumberMap;
    }

    private String getMsg(int count, int curSeq, String curMsg) {
        if (count <= 1) {
            return curMsg;
        }
        StringBuilder sb = new StringBuilder();
        for (int seq = 1; seq <= count; ++seq) {
            sb.append(BusiTripBillKDStringHelper.entity((int)seq));
            if (seq == curSeq) {
                sb.append(curMsg);
                continue;
            }
            sb.append(BusiTripBillKDStringHelper.entity());
        }
        return sb.toString();
    }

    private static class IDGenerator {
        private long[] idArr = null;
        private int idx = 0;

        private IDGenerator() {
        }

        public long getId() {
            if (this.idArr == null || this.idx >= this.idArr.length) {
                this.idArr = DB.genGlobalLongIds((int)50);
                this.idx = 0;
            }
            return this.idArr[this.idx++];
        }
    }
}

