/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.formplugin.mob.busitripbill;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.wtc.wtam.business.busitripmobile.BusiTripBillUtil;
import kd.wtc.wtam.business.busitripmobile.MobBusiChangeHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class BusiTripHistoryPlugin
extends AbstractMobFormPlugin {
    private static final Log logger = LogFactory.getLog(BusiTripHistoryPlugin.class);

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Object pkIdObj = this.getView().getFormShowParameter().getCustomParam("pkId");
        Long pkId = pkIdObj instanceof String ? Long.valueOf(String.valueOf(pkIdObj)) : (Long)pkIdObj;
        logger.info("BusiTripHistoryPlugin.beforeBindData.pkId:{}", (Object)pkId);
        DynamicObject busiTripBill = MobBusiChangeHelper.getInstance().loadSingle((Object)pkId);
        List<DynamicObject> billHistoryList = this.getBillHistory(busiTripBill);
        logger.info("BusiTripHistoryPlugin.beforeBindData.billHistoryList:{}", billHistoryList);
        this.setCardEntry(billHistoryList);
    }

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        MobileFormShowParameter formShowParameter = (MobileFormShowParameter)evt.getFormShowParameter();
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u53d8\u66f4\u5386\u53f2", (String)"BusiTripHistoryPlugin_4", (String)"wtc-wtam-formplugin", (Object[])new Object[0]));
    }

    private void setCardEntry(List<DynamicObject> billHistoryList) {
        for (int index = 0; index < billHistoryList.size(); ++index) {
            int changeCount = billHistoryList.size() - index - 1;
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            if (changeCount == 0) {
                this.getModel().setValue("changenum", (Object)ResManager.loadKDString((String)"\u3010\u539f\u5355\u3011", (String)"BusiTripHistoryPlugin_0", (String)"wtc-wtam-formplugin", (Object[])new Object[0]), rowIndex);
                CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
                cardEntry.setChildVisible(false, rowIndex, new String[]{"trestmethodflex"});
            } else {
                this.getModel().setValue("changenum", (Object)ResManager.loadKDString((String)"\u201c\u7b2c%s\u6b21\u53d8\u66f4\u201d", (String)"BusiTripHistoryPlugin_1", (String)"wtc-wtam-formplugin", (Object[])new Object[]{changeCount}), rowIndex);
                boolean treatMethod = billHistoryList.get(index).getBoolean("isnottrip");
                if (!treatMethod) {
                    this.getModel().setValue("trestmethod", (Object)ResManager.loadKDString((String)"\u5355\u636e\u8c03\u6574", (String)"BusiTripHistoryPlugin_2", (String)"wtc-wtam-formplugin", (Object[])new Object[0]), rowIndex);
                } else {
                    this.getModel().setValue("trestmethod", (Object)ResManager.loadKDString((String)"\u5355\u636e\u4f5c\u5e9f", (String)"BusiTripHistoryPlugin_3", (String)"wtc-wtam-formplugin", (Object[])new Object[0]), rowIndex);
                }
            }
            String applyType = billHistoryList.get(index).getString("applytyperadio");
            String applyTypeOther = BillApplyTypeEnum.OTHER.getCode().equals(applyType) ? ResManager.loadKDString((String)"\u4e3a\u4ed6\u4eba\u7533\u8bf7", (String)"BusiTripHistoryPlugin_8", (String)"wtc-wtam-formplugin", (Object[])new Object[0]) : "";
            String titleStr = ResManager.loadKDString((String)"{0}\u7684{1}{2}{3}\u5355", (String)"BusiTripHistoryPlugin_5", (String)"wtc-wtam-formplugin", (Object[])new Object[0]);
            boolean isChange = billHistoryList.get(index).getBoolean("ischange");
            String oriOrChangeStr = isChange ? ResManager.loadKDString((String)"\u53d8\u66f4", (String)"BusiTripHistoryPlugin_6", (String)"wtc-wtam-formplugin", (Object[])new Object[0]) : "";
            titleStr = MessageFormat.format(titleStr, billHistoryList.get(index).getString("personid.name"), applyTypeOther, BillTypeEnum.EVECTIONBILL.getBillName(), oriOrChangeStr);
            this.getModel().setValue("changetitle", (Object)titleStr, rowIndex);
            String sdate = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)billHistoryList.get(index).getDate("sdate"));
            this.getModel().setValue("starttime", (Object)sdate, rowIndex);
            String edate = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)billHistoryList.get(index).getDate("edate"));
            this.getModel().setValue("endtime", (Object)edate, rowIndex);
            List tripTotalTimeList = BusiTripBillUtil.getTripTotalTime((DynamicObject)billHistoryList.get(index));
            String tripTotalTime = "";
            if (WTCCollections.isNotEmpty((Collection)tripTotalTimeList)) {
                tripTotalTime = tripTotalTimeList.stream().collect(Collectors.joining("\n"));
            }
            this.getModel().setValue("busitriptime", (Object)tripTotalTime, rowIndex);
            String applydate = WTCInteDateUtil.formatBySysTzAndUserFmt((Date)billHistoryList.get(index).getDate("applydate"));
            this.getModel().setValue("submitdate", (Object)applydate, rowIndex);
        }
    }

    private List<DynamicObject> getBillHistory(DynamicObject busiTripBill) {
        QFilter filter = new QFilter("originalid", "=", (Object)busiTripBill.getLong("originalid"));
        Object[] busiTripBills = MobBusiChangeHelper.getInstance().loadDynamicObjectArray(filter.toArray());
        ArrayList busiTripBillAllHistoryList = Lists.newArrayList((Object[])busiTripBills);
        ArrayList<DynamicObject> afterFilter = new ArrayList<DynamicObject>(10);
        afterFilter.add(busiTripBill);
        this.getLinkDy(busiTripBill, busiTripBillAllHistoryList, afterFilter);
        afterFilter.sort(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Date date1 = o1.getDate("createtime");
                Date date2 = o2.getDate("createtime");
                date1 = date1 == null ? WTCDateUtils.getMinEndDate() : date1;
                date2 = date2 == null ? WTCDateUtils.getMinEndDate() : date2;
                return date2.compareTo(date1);
            }
        });
        return afterFilter;
    }

    private void getLinkDy(DynamicObject rootDy, List<DynamicObject> allDy, List<DynamicObject> matchDy) {
        if (matchDy.size() > 50) {
            return;
        }
        long parentId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)rootDy, (String)"parent");
        for (DynamicObject dynamicObject : allDy) {
            long id = dynamicObject.getLong("id");
            if (id != parentId) continue;
            matchDy.add(dynamicObject);
            boolean isChange = dynamicObject.getBoolean("ischange");
            if (!isChange) continue;
            this.getLinkDy(dynamicObject, allDy, matchDy);
        }
    }
}

