/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.formplugin.mob.busitripbill.change.common;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.web.applybill.service.BustripEntityCheckService;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;

public class MobBusiChangeEnableEditPlugin
extends AbstractMobFormPlugin {
    private Map<String, List<String>> map = new HashMap<String, List<String>>(4);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"startdateflex", "enddateflex", "flexbusitriptype", "flextraveltool"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEntryEnable();
    }

    private void setEntryEnable() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        Long attFileBo = this.getModel().getDataEntity().getLong("attfile.id");
        int i = 0;
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity1");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtam_busitripbill");
        Set parentEntryIds = entryEntity.stream().map(e -> e.getLong("entryparentid")).collect(Collectors.toSet());
        DynamicObject dynamicObject = helper.loadDynamicObject(new QFilter("entryentity.id", "in", parentEntryIds));
        if (Objects.nonNull(dynamicObject)) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
            Map<Long, DynamicObject> collect = dynamicObjectCollection.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
            String appId = BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView());
            for (DynamicObject entryRow : entryEntity) {
                long entryParentId = entryRow.getLong("entryparentid");
                BustripEntityCheckService billCommonCheckHelper = new BustripEntityCheckService(attFileBo, UnifyBillEnum.TP, ApplyBillCheckEnum.BUSTRIP, collect.get(entryParentId), this.getView().getEntityId(), appId);
                DynamicObject matchChangeSet = billCommonCheckHelper.getMatchChangeSet();
                boolean isMatch = Objects.nonNull(matchChangeSet);
                if (isMatch) {
                    this.lockEntryByChangeSet(cardEntry, i, matchChangeSet);
                } else {
                    this.lockEntryRow(cardEntry, i);
                }
                ++i;
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String customMap = this.getPageCache().get("customMap");
        if (HRStringUtils.isNotEmpty((String)customMap)) {
            this.map = (Map)SerializationUtils.fromJsonString((String)customMap, Map.class);
        }
        Container source = (Container)evt.getSource();
        String key = source.getKey();
        CardEntry entryGrid = (CardEntry)this.getControl("entryentity1");
        int focusRow = entryGrid.getEntryState().getFocusRow();
        List<String> list = this.map.get(String.valueOf(focusRow));
        if (!CollectionUtils.isEmpty(list)) {
            evt.setCancel(list.contains(key));
        } else {
            evt.setCancel(true);
        }
    }

    private void lockEntryByChangeSet(CardEntry cardEntry, int i, DynamicObject matchChangeSet) {
        boolean istypechange = matchChangeSet.getBoolean("istypechange");
        boolean isvehicle = matchChangeSet.getBoolean("isvehicle");
        boolean isdestination = matchChangeSet.getBoolean("isdestination");
        ArrayList<String> cannotEditItem = new ArrayList<String>(4);
        cannotEditItem.add("non");
        if (!isvehicle) {
            cardEntry.setChildEnable(false, i, new String[]{"traveltool"});
            cannotEditItem.add("flextraveltool");
        }
        if (!isdestination) {
            cardEntry.setChildEnable(false, i, new String[]{"from", "to"});
        }
        this.map.put(String.valueOf(i), cannotEditItem);
        this.getPageCache().put("customMap", SerializationUtils.toJsonString(this.map));
    }

    private void lockEntryRow(CardEntry cardEntry, int i) {
        cardEntry.setChildEnable(false, i, new String[]{"busitriptype", "flexbusitriptype", "startdate", "startdatestr", "startdateflex", "enddate", "enddatestr", "enddateflex", "from", "to", "traveltool", "flextraveltool", "tripresontex"});
    }
}

