/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.formplugin.mob.busitripbill.common;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.CityEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtam.business.busitrip.BusiTripBillKDStringHelper;
import kd.wtc.wtam.business.busitripmobile.BusiTripBillUtil;
import kd.wtc.wtam.business.busitripmobile.MobBusiTripBusiness;
import kd.wtc.wtam.business.busitripmobile.MobBusiTripHelper;
import kd.wtc.wtam.common.constants.busitripbill.BusiTripConstants;
import kd.wtc.wtam.common.constants.busitripbill.BusiTripMConstants;
import kd.wtc.wtam.formplugin.mob.busitripbill.original.common.BusiTripMobEditCommon;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.WtcTimeRangeControlService;
import kd.wtc.wtbs.business.mobile.ComComponentsHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.applybill.service.BustripBillPeriodService;
import kd.wtc.wtbs.business.web.applybill.service.BustripEntityCheckService;
import kd.wtc.wtbs.common.bill.ApplyTimeTypeParam;
import kd.wtc.wtbs.common.components.TypeSelCusStyleEnum;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.bill.BillApplyTimeResult;
import kd.wtc.wtbs.common.model.bill.BillEntryEntityVo;
import kd.wtc.wtbs.common.model.wtctimerange.WtcTimeRangeArgsModel;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class BusiTripMobEntryInfoPlugin
extends AbstractMobBillPlugIn
implements BeforeF7SelectListener,
BusiTripMConstants,
BusiTripConstants {
    private static final Log LOG = LogFactory.getLog(BusiTripMobEntryInfoPlugin.class);
    private MobBusiTripBusiness mobBusiTripBusiness = MobBusiTripBusiness.getInstance();

    public void registerListener(EventObject eventObject) {
        BasedataEdit busiTripType;
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"startdateflex", "enddateflex", "flexbusitriptype", "flextraveltool"});
        BasedataEdit from = (BasedataEdit)this.getControl("from");
        from.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit to = (BasedataEdit)this.getControl("to");
        to.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit travelTool = (BasedataEdit)this.getView().getControl("traveltool");
        if (travelTool != null) {
            travelTool.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((busiTripType = (BasedataEdit)this.getControl("busitriptype")) != null) {
            busiTripType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        Object attFile = this.getModel().getDataEntity(true).get("attfile");
        if (attFile == null) {
            return;
        }
        DynamicObjectCollection busChangeBillEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        CardEntry entryGrid = this.getCardEntry();
        for (int index = 0; index < busChangeBillEntry.size(); ++index) {
            DynamicObject dy = (DynamicObject)busChangeBillEntry.get(index);
            if (dy.get("busitriptype") != null) {
                if (!BillCommonService.billCheckIsStrict()) continue;
                this.setMust(index, entryGrid);
                continue;
            }
            entryGrid.setChildVisible(false, 0, new String[]{"istravelrequire", "isreasonrequire"});
        }
    }

    private void setMust(int focusRow, CardEntry entryGrid) {
        BustripEntityCheckService checkTypeHelper;
        BillResponse typeResponse;
        DynamicObject mainEntity = this.getView().getModel().getDataEntity(true);
        DynamicObject dataEntity = (DynamicObject)mainEntity.getDynamicObjectCollection("entryentity").get(focusRow);
        if (dataEntity.get("startdate") != null && dataEntity.get("enddate") != null && dataEntity.get("busitriptype") != null && (typeResponse = (checkTypeHelper = this.getCheckHelper(dataEntity)).checkBaseSet()).isSuccess() && checkTypeHelper.getMustInput() != null) {
            List mustInput = checkTypeHelper.getMustInput();
            List mustInpConvert = BusiTripBillUtil.setMustInpConvert((List)mustInput);
            if (mustInpConvert.contains("tripresontex")) {
                entryGrid.setChildVisible(true, focusRow, new String[]{"isreasonrequire"});
            } else {
                entryGrid.setChildVisible(false, focusRow, new String[]{"isreasonrequire"});
            }
            BusiTripBillUtil.setFieldMustInput((List)mustInpConvert, (IFormView)this.getView());
            if (mustInpConvert.contains("traveltool")) {
                entryGrid.setChildVisible(true, focusRow, new String[]{"istravelrequire"});
            } else {
                entryGrid.setChildVisible(false, focusRow, new String[]{"istravelrequire"});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        CardEntry entryGrid = this.getCardEntry();
        int focusRow = entryGrid.getEntryState().getFocusRow();
        switch (name) {
            case "startmethod": 
            case "endmethod": 
            case "startdate": 
            case "enddate": {
                if (this.timeChange(focusRow)) break;
                this.checkTimeAndType(focusRow, entryGrid);
                break;
            }
            case "busitriptype": {
                this.changeTypeEvent(focusRow);
                break;
            }
        }
    }

    private void changeTypeEvent(int index) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue("startmethod", null, index);
        model.setValue("endmethod", null, index);
        model.setValue("triptime", null, index);
        model.setValue("efftctime", null, index);
        model.setValue("unit", null, index);
        model.setValue("strapplytime", null, index);
        model.setValue("startdate", null, index);
        model.setValue("enddate", null, index);
        model.setValue("owndate", null, index);
        model.endInit();
        model.setValue("startdatestr", (Object)"", index);
        model.setValue("enddatestr", (Object)"", index);
        this.getView().updateView("entryentity");
        Control entryentitychange = this.getView().getControl("entryentity1");
        if (entryentitychange != null) {
            this.getView().updateView("entryentity1");
        }
        BusiTripMobEditCommon.setTripTotal(model.getDataEntity(true), this.getView());
        CardEntry entryGrid = this.getCardEntry();
        int focusRow = entryGrid.getEntryState().getFocusRow();
        entryGrid.setChildVisible(false, focusRow, new String[]{"istravelrequire"});
        entryGrid.setChildVisible(false, focusRow, new String[]{"isreasonrequire"});
        this.getView().updateView("istravelrequire");
        this.getView().updateView("isreasonrequire");
    }

    private void checkTimeAndType(int focusRow, CardEntry entryGrid) {
        DynamicObject mainEntity = this.getView().getModel().getDataEntity(true);
        DynamicObject dataEntity = (DynamicObject)mainEntity.getDynamicObjectCollection("entryentity").get(focusRow);
        if (dataEntity.get("startdate") != null && dataEntity.get("enddate") != null && dataEntity.get("busitriptype") != null) {
            BustripEntityCheckService checkTypeHelper = this.getCheckHelper(dataEntity);
            long startCost = System.currentTimeMillis();
            BillResponse typeResponse = checkTypeHelper.checkBaseSet();
            LOG.info("BusiTripMobCommonPlugin.propertyChanged.BUSITRIPTYPE. startTime={},endtime={}", (Object)startCost, (Object)System.currentTimeMillis());
            if (typeResponse.isSuccess()) {
                BillApplyTimeResult timeResult = (BillApplyTimeResult)typeResponse.getData();
                LOG.info("BusiTripMobCommonPlugin.propertyChanged.timeResult:{}", (Object)timeResult);
                this.getView().getModel().setValue("strapplytime", (Object)timeResult.getDesc(), focusRow);
                this.getView().getModel().setValue("triptime", (Object)timeResult.getTimeByUnit(), focusRow);
                this.getView().getModel().setValue("efftctime", (Object)timeResult.getOtherTime(), focusRow);
                this.getView().getModel().setValue("unit", (Object)timeResult.getUnit(), focusRow);
                if (checkTypeHelper.getMustInput() != null) {
                    List mustInput = checkTypeHelper.getMustInput();
                    LOG.info("BusiTripMobCommonPlugin.propertyChanged.mustInput:{}", (Object)mustInput);
                    List mustInpConvert = BusiTripBillUtil.setMustInpConvert((List)mustInput);
                    LOG.info("BusiTripMobCommonPlugin.propertyChanged.mustInpConvert:{}", (Object)mustInpConvert);
                    BusiTripBillUtil.setFieldMustInput((List)mustInpConvert, (IFormView)this.getView());
                    if (mustInpConvert.contains("traveltool")) {
                        entryGrid.setChildVisible(true, focusRow, new String[]{"istravelrequire"});
                    } else {
                        entryGrid.setChildVisible(false, focusRow, new String[]{"istravelrequire"});
                    }
                    if (mustInpConvert.contains("tripresontex")) {
                        entryGrid.setChildVisible(true, focusRow, new String[]{"isreasonrequire"});
                    } else {
                        entryGrid.setChildVisible(false, focusRow, new String[]{"isreasonrequire"});
                    }
                }
                LOG.info("BusiTripMobCommonPlugin.propertyChanged.setTripTotal:{}", (Object)mainEntity);
                BusiTripMobEditCommon.setTripTotal(mainEntity, this.getView());
            } else {
                LOG.info("BusiTripMobCommonPlugin.propertyChanged.BUSITRIPTYPE.Message:{}", typeResponse.getMessage().get(0));
                this.getView().showTipNotification((String)typeResponse.getMessage().get(0));
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "startdateflex": 
            case "enddateflex": {
                if (this.getView().getModel().getDataEntity().get("personid") == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9{0}\u4eba\u5458\u3002", (String)"BusiTripMobEntryInfoPlugin_0", (String)"wtc-wtam-formplugin", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName()}));
                    break;
                }
                if (this.getView().getModel().getValue("busitriptype") == null) {
                    String tip = WtcTimeRangeControlService.getInstance().getDisableTip(BillTypeEnum.EVECTIONBILL.getBillName());
                    this.getView().showTipNotification(tip);
                    return;
                }
                Map<String, Object> dateParams = this.setSelectDateParams();
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "back_selectdate");
                ComComponentsHelper.getInstance().openMultiSelectDate(this.getView(), TypeSelCusStyleEnum.BUSITRIP.getEvent(), dateParams, closeCallBack);
                break;
            }
            case "flexbusitriptype": {
                if (this.getView().getModel().getDataEntity().get("personid") == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9{0}\u4eba\u5458\u3002", (String)"BusiTripMobEntryInfoPlugin_1", (String)"wtc-wtam-formplugin", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName()}));
                    break;
                }
                String entityId = this.getView().getEntityId();
                List params = this.mobBusiTripBusiness.queryBusTripType(this.getView(), entityId);
                if (params.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0{0}\u7c7b\u578b\u6570\u636e\u3002", (String)"BusiTripMobEntryInfoPlugin_2", (String)"wtc-wtam-formplugin", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName()}));
                    break;
                }
                CloseCallBack typeCallBack = new CloseCallBack((IFormPlugin)this, "back_type");
                ComComponentsHelper.getInstance().openTypePage(this.getView(), ResManager.loadKDString((String)"\u8bf7\u9009\u62e9", (String)"BusiTripMobEntryInfoPlugin_3", (String)"wtc-wtam-formplugin", (Object[])new Object[0]), TypeSelCusStyleEnum.BUSITRIP.getEvent(), params, typeCallBack);
                break;
            }
            case "flextraveltool": {
                this.clickTravelTool();
                break;
            }
        }
    }

    private void clickTravelTool() {
        List traverParams = this.mobBusiTripBusiness.queryTravelTool(this.getView());
        if (traverParams.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u4ea4\u901a\u5de5\u5177\u6570\u636e\u3002", (String)"BusiTripMobEntryInfoPlugin_4", (String)"wtc-wtam-formplugin", (Object[])new Object[0]));
        } else {
            CloseCallBack typeCallBack = new CloseCallBack((IFormPlugin)this, "back_traveltool");
            ComComponentsHelper.getInstance().openNoHelpTypePage(this.getView(), ResManager.loadKDString((String)"\u8bf7\u9009\u62e9", (String)"BusiTripMobEntryInfoPlugin_5", (String)"wtc-wtam-formplugin", (Object[])new Object[0]), TypeSelCusStyleEnum.BUSITRAVEL.getEvent(), traverParams, typeCallBack);
        }
    }

    private Map<String, Object> setSelectDateParams() {
        Date defaultEndTime;
        DynamicObject mainDataEntity = this.getView().getModel().getDataEntity();
        Long attFileBo = null;
        if (mainDataEntity != null && mainDataEntity.getDynamicObject("attfile") != null) {
            attFileBo = mainDataEntity.getDynamicObject("attfile").getLong("id");
        }
        DynamicObject dynamicObject = this.mobBusiTripBusiness.getEntryClickRowData(this.getView());
        String entryEntityStr = SerializationUtils.serializeToBase64((Object)dynamicObject);
        ApplyTimeTypeParam applyTimeTypeParam = new ApplyTimeTypeParam();
        applyTimeTypeParam.setOriStartTime(dynamicObject.getDate("startdate"));
        applyTimeTypeParam.setOriEndTime(dynamicObject.getDate("enddate"));
        applyTimeTypeParam.setOriStartBtnTypeEnum(WtcTimeRangeBtnTypeEnum.getEnumByValue((String)dynamicObject.getString("startmethod")));
        applyTimeTypeParam.setOriEndBtnTypeEnum(WtcTimeRangeBtnTypeEnum.getEnumByValue((String)dynamicObject.getString("endmethod")));
        applyTimeTypeParam.setEntity("wtbd_traveltype");
        applyTimeTypeParam.setApplyTimeTypeField("applytimetype");
        applyTimeTypeParam.setJumpStepField("jumpstep");
        applyTimeTypeParam.setTypeId(Long.valueOf(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dynamicObject, (String)"busitriptype")));
        applyTimeTypeParam.setDisableTip(WtcTimeRangeControlService.getInstance().getDisableTip(BillTypeEnum.EVECTIONBILL.getBillName()));
        attFileBo = attFileBo == null ? Long.valueOf(0L) : attFileBo;
        applyTimeTypeParam.setAttFileBoId(attFileBo.longValue());
        WtcTimeRangeArgsModel argsModel = new WtcTimeRangeArgsModel();
        WtcTimeRangeControlService.getInstance().setApplyTimeTypeData(applyTimeTypeParam, argsModel);
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put("startmethod", WtcTimeRangeBtnTypeEnum.getValueByCode((int)argsModel.getStartMethod()));
        customParams.put("endmethod", WtcTimeRangeBtnTypeEnum.getValueByCode((int)argsModel.getEndMethod()));
        customParams.put("APPLY_TIME_TYPE", argsModel.getApplyTimeType());
        customParams.put("APPLY_TIME_STEP", argsModel.getMinuteStep());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat simpleDateFormatHHmm = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Date defaultStartTime = argsModel.getDefaultStartTime();
        if (defaultStartTime != null) {
            customParams.put("startdate", simpleDateFormat.format(defaultStartTime));
            customParams.put("startdatestr", MobBusiTripHelper.dateTransformation((String)simpleDateFormatHHmm.format(defaultStartTime), (String)((String)customParams.get("startmethod"))));
        }
        if ((defaultEndTime = argsModel.getDefaultEndTime()) != null) {
            customParams.put("enddate", simpleDateFormat.format(defaultEndTime));
            customParams.put("enddatestr", MobBusiTripHelper.dateTransformation((String)simpleDateFormatHHmm.format(defaultEndTime), (String)((String)customParams.get("endmethod"))));
        }
        customParams.put("attFileBo", attFileBo);
        customParams.put("entryentity", entryEntityStr);
        return customParams;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String entityId = beforeF7SelectEvent.getProperty().getName();
        if ("from".equals(entityId) || "to".equals(entityId)) {
            CityEdit cityEdit = (CityEdit)beforeF7SelectEvent.getSource();
            cityEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u57ce\u5e02", (String)"BusiTripMobEntryInfoPlugin_6", (String)"wtc-wtam-formplugin", (Object[])new Object[0])));
        } else if (HRStringUtils.equals((String)"traveltool", (String)entityId)) {
            this.clickTravelTool();
            beforeF7SelectEvent.setCancel(true);
        } else if ("busitriptype".equals(entityId)) {
            Container control = (Container)this.getControl("flexbusitriptype");
            control.click();
            beforeF7SelectEvent.setCancel(true);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "back_type": {
                Map returnData = (Map)event.getReturnData();
                this.mobBusiTripBusiness.setType(this.getView(), returnData);
                break;
            }
            case "back_selectdate": {
                Map returnData = (Map)event.getReturnData();
                this.mobBusiTripBusiness.setSelectDates(this.getView(), returnData);
                break;
            }
            case "back_traveltool": {
                Map returnData = (Map)event.getReturnData();
                this.mobBusiTripBusiness.setTravelTool(this.getView(), returnData);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "mob_deleteentry": {
                this.mobBusiTripBusiness.deleteEntry(this.getView());
                break;
            }
            case "save": {
                MobBusiTripBusiness.getInstance().setSubmit(this.getView());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "newentry": {
                this.mobBusiTripBusiness.showEntryCardHeader(this.getView());
                CardEntry cardEntry = this.getCardEntry();
                int length = cardEntry.getEntryData().getDataEntitys().length - 1;
                cardEntry.setChildVisible(false, length, new String[]{"istravelrequire", "isreasonrequire"});
                break;
            }
            case "deleteentry": {
                this.mobBusiTripBusiness.showEntryCardHeader(this.getView());
                DynamicObject mainEntity = this.getView().getModel().getDataEntity(true);
                this.setTripTotal(mainEntity);
            }
            case "mob_deleteentry": {
                break;
            }
        }
    }

    private CardEntry getCardEntry() {
        String entityId = this.getView().getEntityId();
        CardEntry cardEntry = "wtam_busitripbill".equals(entityId) || "wtam_busitripselfbill".equals(entityId) ? (CardEntry)this.getView().getControl("entryentity") : (CardEntry)this.getView().getControl("entryentity1");
        return cardEntry;
    }

    private void setTripTotal(DynamicObject mainEntity) {
        BusiTripBillUtil.tripTotalTimeLineFeed((DynamicObject)mainEntity, (IFormView)this.getView(), (String)"triptotaltimeflex", (String)"apply");
    }

    private boolean timeChange(int focusRow) {
        DynamicObject strDataEntity = (DynamicObject)this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(focusRow);
        if (strDataEntity.get("startdate") != null && strDataEntity.get("enddate") != null) {
            String startMethod = this.getView().getPageCache().get("startmethod");
            String endMethod = this.getView().getPageCache().get("endmethod");
            String startStr = this.getView().getPageCache().get("startdate");
            String endStr = this.getView().getPageCache().get("enddate");
            if (startMethod == null || !startMethod.equals(strDataEntity.get("startmethod"))) {
                return true;
            }
            if (endMethod == null || !endMethod.equals(strDataEntity.get("endmethod"))) {
                return true;
            }
            if (startStr == null || strDataEntity.getDate("startdate").getTime() != Long.parseLong(startStr)) {
                return true;
            }
            if (endStr == null || strDataEntity.getDate("enddate").getTime() != Long.parseLong(endStr)) {
                return true;
            }
            BustripEntityCheckService checkDateHelper = this.getCheckHelper(strDataEntity);
            LOG.info("BusiTripMobCommonPlugin.propertyChanged.DATE.starttime:{}", (Object)System.currentTimeMillis());
            BillResponse dateResponse = checkDateHelper.checkStartDateAndEndDate();
            LOG.info("BusiTripMobCommonPlugin.propertyChanged.DATE.endtime:{}", (Object)System.currentTimeMillis());
            if (dateResponse.isSuccess()) {
                Date ownData = (Date)dateResponse.getData();
                LOG.info("BusiTripMobCommonPlugin.propertyChanged.ownData:{}", (Object)ownData);
                this.getView().getModel().setValue("owndate", (Object)ownData, focusRow);
                BillResponse billResponse = this.checkStagingBillRepeat(focusRow);
                if (!billResponse.isSuccess()) {
                    this.getView().showTipNotification(BusiTripBillKDStringHelper.checkTime());
                    return false;
                }
            } else {
                LOG.info("BusiTripMobCommonPlugin.propertyChanged.Message:{}", dateResponse.getMessage().get(0));
                this.getView().showTipNotification((String)dateResponse.getMessage().get(0));
                return true;
            }
        }
        return false;
    }

    private BillResponse checkStagingBillRepeat(int focusRow) {
        DynamicObjectCollection coll = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        long attFileId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dataEntity, (String)"attfile");
        ArrayList list = Lists.newArrayListWithExpectedSize((int)coll.size());
        BillEntryEntityVo curVo = new BillEntryEntityVo();
        for (int index = 0; index < coll.size(); ++index) {
            DynamicObject entry = (DynamicObject)coll.get(index);
            BillEntryEntityVo billEntryEntityVo = new BillEntryEntityVo();
            billEntryEntityVo.setRowIndex(index + 1);
            billEntryEntityVo.setStartDate(entry.getDate("startdate"));
            billEntryEntityVo.setAttFileBoid(attFileId);
            billEntryEntityVo.setStartMethod(entry.getString("startmethod"));
            billEntryEntityVo.setEndDate(entry.getDate("enddate"));
            billEntryEntityVo.setEndMethod(entry.getString("endmethod"));
            billEntryEntityVo.setOwnDate(entry.getDate("owndate"));
            if (index == focusRow) {
                curVo = billEntryEntityVo;
                continue;
            }
            list.add(billEntryEntityVo);
        }
        if (list.isEmpty()) {
            return BillResponse.success();
        }
        return new BustripBillPeriodService().checkStagingBillRepeat((List)list, curVo);
    }

    private BustripEntityCheckService getCheckHelper(DynamicObject dataEntity) {
        DynamicObject mainDataEntity = this.getView().getModel().getDataEntity(true);
        Long attFileBo = null;
        Boolean applyType = Boolean.FALSE;
        if (mainDataEntity != null) {
            if (mainDataEntity.getDynamicObject("attfile") != null) {
                attFileBo = mainDataEntity.getDynamicObject("attfile").getLong("id");
            }
            applyType = mainDataEntity.getBoolean("applytyperadio");
        }
        UnifyBillEnum infoEnum = UnifyBillEnum.TP;
        ApplyBillCheckEnum checkEnum = ApplyBillCheckEnum.BUSTRIP;
        LOG.info("BusiTripMobCommonPlugin.getCheckHelper.attFileBo:{}", attFileBo);
        LOG.info("BusiTripMobCommonPlugin.getCheckHelper.dataEntity:{}", (Object)dataEntity);
        LOG.info("BusiTripMobCommonPlugin.getCheckHelper.busitriptype:{}", dataEntity.get("busitriptype"));
        String appId = BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView());
        BustripEntityCheckService bustripEntityCheckService = new BustripEntityCheckService(attFileBo, infoEnum, checkEnum, dataEntity, this.getView().getEntityId(), appId);
        bustripEntityCheckService.setNeedCheckAttFileAuth(applyType);
        return bustripEntityCheckService;
    }
}

