/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.formplugin.mob.busitripbill.original.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtam.business.busitrip.BusiTripBillService;
import kd.wtc.wtam.business.busitripmobile.MobBusiEntityRelationHelper;
import kd.wtc.wtam.business.busitripmobile.MobBusiTripBusiness;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyKDStringHelper;
import kd.wtc.wtbs.business.mobile.BillContainerService;
import kd.wtc.wtbs.business.mobile.MobileCommonServiceHelper;
import kd.wtc.wtbs.business.web.applybill.service.BustripEntityCheckService;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class BusiTripMobDetailCommon {
    private static final Log LOG = LogFactory.getLog(BusiTripMobDetailCommon.class);

    public void handleDetailButton(IDataModel model, IFormView formView) {
        DynamicObject busiTripBill = model.getDataEntity(true);
        String billStatus = busiTripBill.getString("billstatus");
        formView.setVisible(Boolean.FALSE, new String[]{"headerflex", "approvalflex", "buttonflex", "changebuttonflex", "leftflex", "rightflex", "unsubmitbuttonflex"});
        Object flagWorkFlow = formView.getFormShowParameter().getCustomParam("flagWorkFlow");
        if (flagWorkFlow != null) {
            formView.setVisible(Boolean.TRUE, new String[]{"leftflex"});
            formView.setVisible(Boolean.TRUE, new String[]{"rightflex"});
            boolean editable = MobileCommonServiceHelper.getInstance().isEditable(model);
            if (editable) {
                formView.setVisible(Boolean.TRUE, new String[]{"approvalflex", "headerflex", "buttonflex"});
            } else {
                formView.setVisible(Boolean.TRUE, new String[]{"approvalflex", "headerflex"});
                if ("C".equals(billStatus)) {
                    formView.setVisible(Boolean.TRUE, new String[]{"changebuttonflex"});
                } else if ("D".equals(billStatus) || "B".equals(billStatus)) {
                    formView.setVisible(Boolean.TRUE, new String[]{"unsubmitbuttonflex"});
                }
            }
        }
        if (StringUtils.equalsAny((CharSequence)billStatus, (CharSequence[])new CharSequence[]{"A", "G"})) {
            formView.setVisible(Boolean.TRUE, new String[]{"headerflex", "buttonflex"});
        }
        if (StringUtils.equalsAny((CharSequence)billStatus, (CharSequence[])new CharSequence[]{"A"})) {
            formView.setVisible(Boolean.FALSE, new String[]{"approvalflex"});
        }
    }

    public void clickChange(IDataModel model, IFormView formView) {
        DynamicObject dataEntity = model.getDataEntity(true);
        if (!dataEntity.getBoolean("isnewbill")) {
            formView.showTipNotification(BillUnifyKDStringHelper.changeRepeat((String)BillTypeEnum.EVECTIONBILL.getBillName()));
            return;
        }
        if (!this.couldChange(formView, model.getDataEntity(true))) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8be5{0}\u5355\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"BusiTripMobDetailCommon_0", (String)"wtc-wtam-formplugin", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName()}));
            return;
        }
        Map<String, Object> returnMap = this.getReturnMap(model.getDataEntity());
        HashMap<String, Object> customParams = new HashMap<String, Object>(2);
        customParams.put("wtam_busitripbill", returnMap);
        customParams.put("pkId", model.getDataEntity().getLong("id"));
        BillCommonService billCommonService = new BillCommonService();
        BillApplyTypeEnum billApplyTypeEnum = billCommonService.billChangeOpenType(model.getDataEntity(true));
        String targetFormId = billApplyTypeEnum == BillApplyTypeEnum.SELF ? "wtam_buchangeselfmob" : "wtam_busichangedetail";
        BillContainerService.getInstance().openChangePage(formView, targetFormId, customParams);
    }

    private boolean couldChange(IFormView view, DynamicObject dynamicObject) {
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        Long attFileBo = dynamicObject.getLong("attfile.id");
        String appId = BillCommonService.getInstance().getAuthAppIdForFormPlugin(view);
        for (DynamicObject entryRow : entryEntity) {
            BustripEntityCheckService billCommonCheckHelper = new BustripEntityCheckService(attFileBo, UnifyBillEnum.TP, ApplyBillCheckEnum.BUSTRIP, entryRow, view.getEntityId(), appId);
            DynamicObject matchChangeSet = billCommonCheckHelper.getMatchChangeSet();
            boolean isMatch = Objects.nonNull(matchChangeSet);
            if (!isMatch) continue;
            return true;
        }
        return false;
    }

    private Map<String, Object> getReturnMap(DynamicObject dynamicObject) {
        BusiTripBillService billService = new BusiTripBillService();
        return billService.genOriginDataMap(dynamicObject);
    }

    public static void jumpToEdit(boolean needCleanAttFile, IFormView formView, IDataModel dataModel) {
        MobileBillShowParameter formShowParameter = (MobileBillShowParameter)formView.getFormShowParameter();
        MobBusiTripBusiness.getInstance().releaseMutexIfIsCurrentUser((Long)formShowParameter.getPkId(), formView.getEntityId());
        String targetFormId = MobBusiEntityRelationHelper.getOriginalEntityEdit((String)formView.getEntityId());
        HashMap<String, Boolean> customParams = new HashMap<String, Boolean>(2);
        customParams.put("isAbnormal", Boolean.FALSE);
        if (needCleanAttFile) {
            customParams.put("needCleanAttFile", Boolean.TRUE);
        }
        BillContainerService.getInstance().openEditPage(formView, targetFormId, dataModel.getDataEntity().getLong("id"), customParams);
    }
}

