/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.formplugin.web.attconfirm;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.util.WTCPermUtils;
import kd.wtc.wtbs.common.enums.HisDataStatus;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.attconfirm.AttConfirmHelper;
import kd.wtc.wtp.business.attconfirm.AttConfirmServiceFactory;
import kd.wtc.wtp.business.attconfirm.IAttConfirmOpService;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmCheckServiceImpl;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmQueryServiceImpl;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordStatusEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordTypeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmDataStatusEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmRecordOpEnum;
import kd.wtc.wtp.common.kdstring.AttConfirmKDString;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordModel;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordOpParam;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordOpResult;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordQueryParam;

public class AttConfirmBillEdit
extends HRDataBaseEdit {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().getEntryEntity("entryentity").clear();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"latestvalue", "lastvalue", "isshowdiff", "diffentryentity"});
        boolean isPass = this.preValidator();
        if (isPass) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"defaultflex"});
            this.interactiveProcessing();
            this.dataProcessing();
            this.comparedToLastConfirmResult();
            AttConfirmRecordModel recordModel = this.queryCurrentAttConfirmRecord();
            if (recordModel != null) {
                boolean isByDate = AttConRecordTypeEnum.BY_DATE == recordModel.getType();
                this.getView().setVisible(Boolean.valueOf(isByDate), new String[]{"attitem", "unit", "diff_attitem", "diff_unit"});
                this.getView().setVisible(Boolean.valueOf(!isByDate), new String[]{"sumattitem", "sumunit", "diff_sumattitem", "diff_sumunit"});
            }
            this.getModel().setDataChanged(false);
        } else if (this.getView().getParentView() != null && "wtss_attconfirmlistpc".equals(this.getView().getParentView().getFormShowParameter().getFormId())) {
            String tabPageName = "";
            AttConfirmRecordModel recordModel = this.queryCurrentAttConfirmRecord();
            if (recordModel == null) {
                tabPageName = HisDataStatus.DELETE.getName();
            } else {
                tabPageName = WTCDateUtils.date2Str((Date)recordModel.getStartDate(), (String)"yyyy-MM-dd");
                if (recordModel.getType() == AttConRecordTypeEnum.BY_PERIOD) {
                    tabPageName = tabPageName + "~" + WTCDateUtils.date2Str((Date)recordModel.getEndDate(), (String)"yyyy-MM-dd");
                }
            }
            HashMap<String, LocaleString> map = new HashMap<String, LocaleString>();
            map.put("text", new LocaleString(tabPageName));
            this.getView().getParentView().updateControlMetadata(String.valueOf(this.getAttConfirmRecordId()), map);
            this.getView().getParentView().setVisible(Boolean.FALSE, new String[]{"bar_ok"});
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        Object source = this.getView().getFormShowParameter().getCustomParams().get("source");
        if (source != null && Objects.equals(source, "waitconfirmlist")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"perbuttonflex"});
        }
    }

    private void comparedToLastConfirmResult() {
        long attConfirmRecordId = this.getAttConfirmRecordId();
        AttConfirmRecordQueryParam queryParam = new AttConfirmRecordQueryParam();
        queryParam.setIds((Set)Sets.newHashSet((Object[])new Long[]{attConfirmRecordId}));
        DynamicObject[] latestConfirmRecordDys = AttConfirmQueryServiceImpl.getInstance().queryAttConfirmRecordDyList(queryParam);
        if (latestConfirmRecordDys == null || latestConfirmRecordDys.length == 0) {
            return;
        }
        DynamicObject latestDy = latestConfirmRecordDys[0];
        if (!latestDy.getBoolean("showlast")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"changedescription"});
            return;
        }
        String type = latestDy.getString("type");
        queryParam = new AttConfirmRecordQueryParam();
        queryParam.setAttFileBoIdSet((Set)Sets.newHashSet((Object[])new Long[]{WTCDynamicObjectUtils.getBaseDataId((DynamicObject)latestDy, (String)"attfile")}));
        QFilter qFilter = new QFilter("createtime", "<=", (Object)latestDy.getDate("createtime")).and(new QFilter("id", "!=", (Object)attConfirmRecordId));
        queryParam.setCustomQFilter(qFilter);
        if (AttConRecordTypeEnum.BY_DATE.getCode().equals(type)) {
            queryParam.setStartDate(latestDy.getDate("startdate"));
            queryParam.setEndDate(latestDy.getDate("enddate"));
        } else if (AttConRecordTypeEnum.BY_PERIOD.getCode().equals(type)) {
            queryParam.setPerAttPeriodIdSet((Set)Sets.newHashSet((Object[])new Long[]{latestDy.getLong("perattperiod")}));
        }
        DynamicObject[] existsConfirmRecordDys = AttConfirmQueryServiceImpl.getInstance().queryAttConfirmRecordDyList(queryParam);
        if (existsConfirmRecordDys == null || existsConfirmRecordDys.length == 0) {
            return;
        }
        DynamicObject lastConfirmRecordDy = Arrays.stream(existsConfirmRecordDys).filter(existsDy -> attConfirmRecordId != existsDy.getLong("id")).max(Comparator.comparing(existsDy -> existsDy.getDate("createtime"))).orElse(null);
        if (lastConfirmRecordDy == null || !AttConRecordStatusEnum.REVOKE.getCode().equals(lastConfirmRecordDy.getString("status")) || lastConfirmRecordDy.getDate("confirmtime") == null) {
            return;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtam_attconfirmbill");
        DynamicObject lastDy = helper.loadDynamicObject(new QFilter("attconrecord", "=", (Object)lastConfirmRecordDy.getLong("id")));
        if (lastDy == null) {
            return;
        }
        DynamicObjectCollection lastEntryDys = lastDy.getDynamicObjectCollection("entryentity");
        DynamicObject currentDy = this.getModel().getDataEntity();
        DynamicObjectCollection currentEntryDys = this.getModel().getEntryEntity("entryentity");
        List<Long> attItemIds = lastEntryDys.stream().map(dy -> dy.getLong("attitem_id")).collect(Collectors.toList());
        attItemIds.addAll(currentEntryDys.stream().map(dy -> dy.getLong("attitem_id")).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(attItemIds)) {
            return;
        }
        if (AttConRecordTypeEnum.BY_PERIOD.getCode().equals(type)) {
            Map<Long, DynamicObject> finalAttItemMap = this.queryPerSumSourceDy(attItemIds, "wtp_persumsource");
            if (finalAttItemMap.size() == 0) {
                return;
            }
            lastEntryDys.stream().filter(dy -> finalAttItemMap.get(dy.getLong("attitem_id")) != null).forEach(dy -> dy.set("attitem", finalAttItemMap.get(dy.getLong("attitem_id"))));
            currentEntryDys.stream().filter(dy -> finalAttItemMap.get(dy.getLong("attitem_id")) != null).forEach(dy -> dy.set("attitem", finalAttItemMap.get(dy.getLong("attitem_id"))));
        }
        Map<Long, DynamicObject> lastEntryDyMap = lastEntryDys.stream().collect(Collectors.toMap(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attitem"), Function.identity(), (a, b) -> a));
        Map<Long, DynamicObject> currentEntryDyMap = currentEntryDys.stream().collect(Collectors.toMap(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attitem"), Function.identity(), (a, b) -> a));
        List currentAttItemIds = currentEntryDys.stream().map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attitem")).collect(Collectors.toList());
        List lastAttItemIds = lastEntryDys.stream().map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attitem")).collect(Collectors.toList());
        Set<Long> addItemIds = currentAttItemIds.stream().filter(currentId -> !lastAttItemIds.contains(currentId)).collect(Collectors.toSet());
        Set<Long> removeItemIds = lastAttItemIds.stream().filter(lastId -> !currentAttItemIds.contains(lastId)).collect(Collectors.toSet());
        DynamicObjectCollection changeItemEntry = currentDy.getDynamicObjectCollection("diffentryentity");
        block0: for (DynamicObject currentEntryDy : currentEntryDys) {
            long attItemId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)currentEntryDy, (String)"attitem");
            String currentValue = currentEntryDy.getString("value");
            currentEntryDy.set("latestvalue", (Object)currentValue);
            for (DynamicObject lastEntryDy : lastEntryDys) {
                String lastValue = lastEntryDy.getString("value");
                if (attItemId != WTCDynamicObjectUtils.getBaseDataId((DynamicObject)lastEntryDy, (String)"attitem") || (!HRStringUtils.isEmpty((String)currentValue) || !HRStringUtils.isNotEmpty((String)lastValue)) && (!HRStringUtils.isNotEmpty((String)currentValue) || HRStringUtils.equals((String)currentValue, (String)lastEntryDy.getString("value")))) continue;
                DynamicObject changeItemDy = changeItemEntry.addNew();
                changeItemDy.set("diff_attitem", currentEntryDyMap.get(attItemId).get("attitem"));
                changeItemDy.set("diff_latestvalue", (Object)currentValue);
                changeItemDy.set("diff_lastvalue", (Object)lastValue);
                changeItemDy.set("changedescription", (Object)"B");
                continue block0;
            }
        }
        this.fillAnotherItemEntry(currentEntryDyMap, currentDy, addItemIds, "diff_latestvalue", "A");
        this.fillAnotherItemEntry(lastEntryDyMap, currentDy, removeItemIds, "diff_lastvalue", "C");
        this.getView().setVisible(Boolean.TRUE, new String[]{"latestvalue", "isshowdiff"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"value", "resultvalue", "diffentryentity"});
    }

    private Map<Long, DynamicObject> queryPerSumSourceDy(List<Long> attItemIds, String pageId) {
        HRBaseServiceHelper dailyStaSourceHelper = new HRBaseServiceHelper(pageId);
        DynamicObject[] dys = dailyStaSourceHelper.loadDynamicObjectArray(attItemIds.toArray());
        return Arrays.stream(dys).collect(Collectors.toMap(dy1 -> dy1.getLong("id"), Function.identity(), (a, b) -> a));
    }

    private boolean fillAnotherItemEntry(Map<Long, DynamicObject> entryDyMap, DynamicObject currentDy, Set<Long> itemIds, String valueKey, String changeDescription) {
        boolean isAddEntryRow = false;
        DynamicObjectCollection currentRemoveItemEntry = currentDy.getDynamicObjectCollection("diffentryentity");
        for (Long itemId : itemIds) {
            DynamicObject tempDy = entryDyMap.get(itemId);
            if (tempDy == null) continue;
            DynamicObject itemEntryDy = currentRemoveItemEntry.addNew();
            itemEntryDy.set("diff_attitem", tempDy.get("attitem"));
            itemEntryDy.set("diff_sumattitem", tempDy.get("attitem"));
            itemEntryDy.set(valueKey, (Object)tempDy.getString("value"));
            itemEntryDy.set("changedescription", (Object)changeDescription);
            isAddEntryRow = true;
        }
        return isAddEntryRow;
    }

    private boolean preValidator() {
        AttConfirmRecordModel recordModel;
        String billSource = String.valueOf(this.getView().getFormShowParameter().getCustomParams().get("source"));
        AttConfirmRecordModel queryRecordModel = this.queryCurrentAttConfirmRecord();
        if (queryRecordModel == null) {
            this.genShowDefaultPage("");
            return false;
        }
        queryRecordModel.setOpStatus(Boolean.TRUE);
        List<AttConfirmRecordModel> recordModels = Collections.singletonList(queryRecordModel);
        if (!"detail".equals(billSource)) {
            AttConfirmCheckServiceImpl.getInstance().checkReceiverIsEqualToCurrentUser(recordModels);
            recordModel = recordModels.get(0);
            if (!Boolean.TRUE.equals(recordModel.getOpStatus())) {
                this.genShowDefaultPage(recordModel.getMsg());
                return false;
            }
            AttConfirmCheckServiceImpl.getInstance().checkStatusIsRevoked(recordModels, false);
            recordModel = recordModels.get(0);
            if (!Boolean.TRUE.equals(recordModel.getOpStatus())) {
                this.genShowDefaultPage(recordModel.getMsg());
                return false;
            }
        }
        AttConfirmCheckServiceImpl.getInstance().checkAttFileIsDiscard(recordModels);
        recordModel = recordModels.get(0);
        if (!Boolean.TRUE.equals(recordModel.getOpStatus())) {
            if (AttConRecordStatusEnum.CONFIRM == recordModel.getStatus()) {
                this.getView().showTipNotification(recordModel.getMsg());
            } else {
                this.genShowDefaultPage(recordModel.getMsg());
                return false;
            }
        }
        AttConfirmCheckServiceImpl.getInstance().checkPerAttPeriodIsValidByPeriod(recordModels, false);
        recordModel = recordModels.get(0);
        if (!Boolean.TRUE.equals(recordModel.getOpStatus())) {
            if (AttConRecordStatusEnum.CONFIRM == recordModel.getStatus()) {
                this.getView().showTipNotification(recordModel.getMsg());
            } else {
                this.genShowDefaultPage(recordModel.getMsg());
                return false;
            }
        }
        AttConfirmCheckServiceImpl.getInstance().checkAccountToAfterEndDate(recordModels, false);
        recordModel = recordModels.get(0);
        if (!Boolean.TRUE.equals(recordModel.getOpStatus()) && AttConRecordStatusEnum.CONFIRM != recordModel.getStatus()) {
            this.genShowDefaultPage(recordModel.getMsg());
            return false;
        }
        return true;
    }

    private void genShowDefaultPage(String msg) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"contentflex"});
        Label label = (Label)this.getControl("defaulttips");
        label.setText(msg);
    }

    private void dataProcessing() {
        AttConRecordStatusEnum status;
        AttConfirmRecordModel recordModel = this.queryCurrentAttConfirmRecord();
        if (recordModel == null) {
            return;
        }
        String billSource = String.valueOf(this.getView().getFormShowParameter().getCustomParams().get("source"));
        if ("detail".equals(billSource)) {
            status = recordModel.getStatus();
            if (AttConRecordStatusEnum.SEND == status || AttConRecordStatusEnum.GEN == status || AttConRecordStatusEnum.NOT_CONFIRM == status) {
                this.queryLastestData();
            } else {
                this.queryExistsData();
            }
        } else {
            status = recordModel.getStatus();
            if (AttConRecordStatusEnum.CONFIRM == status) {
                this.queryExistsData();
            } else {
                this.queryLastestData();
            }
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        List<Long> attItemIds = entryEntity.stream().map(entryDy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entryDy, (String)"attitem_id")).collect(Collectors.toList());
        boolean allMatch = attItemIds.stream().allMatch(id -> id == 0L);
        if (allMatch) {
            attItemIds = entryEntity.stream().map(entryDy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entryDy, (String)"attitem")).collect(Collectors.toList());
        }
        Map<Long, DynamicObject> attItemMap = AttConRecordTypeEnum.BY_DATE == recordModel.getType() ? this.queryPerSumSourceDy(attItemIds, "wtp_dailydetsource") : this.queryPerSumSourceDy(attItemIds, "wtp_persumsource");
        for (DynamicObject entryDy2 : entryEntity) {
            DynamicObject attItemDy;
            entryDy2.set("resultvalue", entryDy2.get("value"));
            if (!WTCCollections.isNotEmpty(attItemMap)) continue;
            long attItemId = entryDy2.getLong("attitem_id");
            if (attItemId == 0L) {
                attItemId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entryDy2, (String)"attitem");
            }
            if ((attItemDy = attItemMap.get(attItemId)) != null) {
                entryDy2.set("attitem", (Object)attItemDy);
                entryDy2.set("sumattitem", (Object)attItemDy);
                continue;
            }
            entryDy2.set("attitem", null);
            entryDy2.set("sumattitem", null);
        }
    }

    private void queryExistsData() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtam_attconfirmbill");
        DynamicObject dy = helper.loadDynamicObject(new QFilter("attconrecord", "=", (Object)this.getAttConfirmRecordId()));
        if (dy != null) {
            this.getModel().setValue("attconrecord", dy.get("attconrecord"));
            this.getModel().getEntryEntity("entryentity").addAll((Collection)dy.getDynamicObjectCollection("entryentity"));
        } else {
            this.queryLastestData();
        }
    }

    private void queryLastestData() {
        List currentDy;
        AttConfirmRecordModel recordModel = this.queryCurrentAttConfirmRecord();
        if (recordModel != null && CollectionUtils.isNotEmpty((Collection)(currentDy = AttConfirmHelper.getInstance().genAttConfirmBillHisData(Collections.singletonList(recordModel), false)))) {
            this.getModel().setValue("attconrecord", ((DynamicObject)currentDy.get(0)).get("attconrecord"));
            this.getModel().getEntryEntity("entryentity").addAll((Collection)((DynamicObject)currentDy.get(0)).getDynamicObjectCollection("entryentity"));
        }
    }

    private void interactiveProcessing() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        AttConfirmRecordModel currentModel = this.queryCurrentAttConfirmRecord();
        if (currentModel == null) {
            return;
        }
        if (AttConRecordTypeEnum.BY_DATE == currentModel.getType()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap"});
        } else if (AttConRecordTypeEnum.BY_PERIOD == currentModel.getType()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"startdate"});
        }
        AttConRecordStatusEnum status = currentModel.getStatus();
        String billSource = String.valueOf(customParams.get("source"));
        if (AttConfirmDataStatusEnum.EFFECT == currentModel.getDataStatus()) {
            this.setEffectButtonAndLabel(currentModel, status, billSource);
        } else {
            Label label = (Label)this.getControl("status");
            label.setText(currentModel.getDataStatus().getName().loadKDString());
            if ("detail".equals(billSource)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"perbuttonflex", "resultvalue"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"push", "proxy", "rollback"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"detailbuttonflex", "value"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"confirm"});
                if (this.getView().getParentView() != null && "wtss_attconfirmlistpc".equals(this.getView().getParentView().getFormShowParameter().getFormId())) {
                    this.getView().getParentView().setVisible(Boolean.FALSE, new String[]{"bar_ok"});
                    this.getView().sendFormAction(this.getView().getParentView());
                }
            }
        }
        this.setTipsFlexAndStatusLabelStyle(currentModel, status);
    }

    private void setTipsFlexAndStatusLabelStyle(AttConfirmRecordModel currentModel, AttConRecordStatusEnum status) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"pernotconfirmtipflex", "peroverduetipflex", "perrevokertipflex", "perconfirmtipflex", "perinvalidtipflex", "perdiscardtipflex"});
        if (AttConfirmDataStatusEnum.DISCARD == currentModel.getDataStatus()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"perdiscardtipflex"});
            this.setStatusLabelStyle(map, "#B2B2B2", "#FAFAFA");
        } else if (AttConfirmDataStatusEnum.INVALID == currentModel.getDataStatus()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"perinvalidtipflex"});
            this.setStatusLabelStyle(map, "#B2B2B2", "#FAFAFA");
        } else if (AttConRecordStatusEnum.CONFIRM == status) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"perconfirmtipflex"});
            this.setStatusLabelStyle(map, "#1DB363", "#EDFFF3");
        } else if (AttConRecordStatusEnum.SEND == status || AttConRecordStatusEnum.GEN == status) {
            if (AttConfirmHelper.getInstance().checkLastRecordInvalidAndReconfirmed(currentModel)) {
                Label labelap3 = (Label)this.getControl("labelap3");
                labelap3.setText(AttConfirmKDString.getLastRecordInvalidAndConfirmFrontTips());
                Label labelap21 = (Label)this.getControl("labelap21");
                labelap21.setText(AttConfirmKDString.getLastRecordInvalidAndConfirmBackTips());
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"pernotconfirmtipflex"});
            this.setStatusLabelStyle(map, "#2068ED", "#EDF6FF");
        } else if (AttConRecordStatusEnum.NOT_CONFIRM == status) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"peroverduetipflex"});
            this.setStatusLabelStyle(map, "#F0262D", "#FFF0ED");
        } else if (AttConRecordStatusEnum.REVOKE == status) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"perrevokertipflex"});
            this.setStatusLabelStyle(map, "#B2B2B2", "#FAFAFA");
        }
        this.getView().updateControlMetadata("status", (Map)map);
    }

    private void setEffectButtonAndLabel(AttConfirmRecordModel currentModel, AttConRecordStatusEnum status, String billSource) {
        if ("detail".equals(billSource)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"perbuttonflex", "resultvalue"});
            Label label = (Label)this.getControl("status");
            label.setText(status.getName().loadKDString());
            if (AttConRecordStatusEnum.CONFIRM == status) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"push", "proxy"});
            } else if (AttConRecordStatusEnum.NOT_CONFIRM == status) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"push"});
            } else if (AttConRecordStatusEnum.REVOKE == currentModel.getStatus()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"push", "proxy", "rollback"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"detailbuttonflex", "value"});
            Label label = (Label)this.getControl("status");
            if (AttConRecordStatusEnum.SEND != status) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"confirm"});
                label.setText(status.getName().loadKDString());
            } else {
                label.setText(AttConfirmKDString.toBeConfirmed());
            }
            if (AttConRecordStatusEnum.NOT_CONFIRM == status) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"status"});
            }
        }
    }

    private void setStatusLabelStyle(Map<String, Object> map, String foreColorStr, String backColorStr) {
        map.put("fc", foreColorStr);
        map.put("bc", backColorStr);
        HashMap anotherBorderMap = Maps.newHashMapWithExpectedSize((int)4);
        String borderStyleStr = "1px_solid_" + foreColorStr;
        anotherBorderMap.put("r", borderStyleStr);
        anotherBorderMap.put("b", borderStyleStr);
        anotherBorderMap.put("t", borderStyleStr);
        anotherBorderMap.put("l", borderStyleStr);
        HashMap styleMap = Maps.newHashMapWithExpectedSize((int)1);
        styleMap.put("b", anotherBorderMap);
        map.put("s", styleMap);
    }

    private AttConfirmRecordModel queryCurrentAttConfirmRecord() {
        long attConfirmId = this.getAttConfirmRecordId();
        IPageCache pageCache = this.getPageCache();
        String recordModelCache = pageCache.get(String.valueOf(attConfirmId));
        if (HRStringUtils.isNotEmpty((String)recordModelCache)) {
            return (AttConfirmRecordModel)JSONObject.parseObject((String)recordModelCache, AttConfirmRecordModel.class);
        }
        AttConfirmRecordQueryParam queryParam = new AttConfirmRecordQueryParam();
        queryParam.setIds(new HashSet<Long>(Collections.singleton(attConfirmId)));
        queryParam.setQueryNotEffect(true);
        List recordModels = AttConfirmQueryServiceImpl.getInstance().queryAttConfirmRecordModelList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)recordModels)) {
            AttConfirmRecordModel recordModel = (AttConfirmRecordModel)recordModels.get(0);
            this.getPageCache().put(String.valueOf(attConfirmId), JSONObject.toJSONString((Object)recordModel));
            return recordModel;
        }
        return null;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "push": 
            case "rollback": 
            case "proxy": 
            case "confirm": 
            case "viewdetail": {
                IFormView tabView;
                boolean isAuthChanged;
                String parentPageId = this.getConfirmListPageId();
                if (!WTCStringUtils.isNotEmpty((String)parentPageId) || !(isAuthChanged = WTCPermUtils.isViewAuthChanged((IFormView)(tabView = this.getView().getView(parentPageId)), (IFormView)this.getView()))) break;
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            String operateKey;
            switch (operateKey = args.getOperateKey()) {
                case "push": {
                    FormShowParameter formShowParameter = this.getFormShowParameter("wtam_attconpushrecordgen");
                    String parentPageId = this.getConfirmListPageId();
                    formShowParameter.setCustomParam("confirmListPageId", (Object)parentPageId);
                    this.getView().showForm(formShowParameter);
                    break;
                }
                case "rollback": {
                    this.getView().showConfirm(AttConfirmKDString.getRollBackConfirmTips(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("rollback", (IFormPlugin)this));
                    break;
                }
                case "proxy": {
                    this.getView().showConfirm(AttConfirmKDString.getProxyConfirmTips(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("proxy", (IFormPlugin)this));
                    break;
                }
                case "confirm": {
                    AttConfirmRecordOpParam recordOpParam = new AttConfirmRecordOpParam();
                    recordOpParam.setOp(AttConfirmRecordOpEnum.COMFIRM);
                    recordOpParam.setAttConfirmRecordIds((Set)Sets.newHashSet((Object[])new Long[]{this.getAttConfirmRecordId()}));
                    IAttConfirmOpService attConfirmService = AttConfirmServiceFactory.getInstance().getAttConfirmService(AttConfirmRecordOpEnum.PROXY);
                    attConfirmService.opAttConfirmRecord(recordOpParam);
                    List modelList = recordOpParam.getAttConfirmRecordModelList();
                    if (!CollectionUtils.isNotEmpty((Collection)modelList)) break;
                    AttConfirmRecordModel recordModel = (AttConfirmRecordModel)modelList.get(0);
                    Boolean opStatus = recordModel.getOpStatus();
                    if (Boolean.TRUE.equals(opStatus)) {
                        IFormView parentView = this.getView().getParentView();
                        if (parentView == null) break;
                        parentView.showSuccessNotification(AttConfirmKDString.getSuccessTips());
                        this.getView().sendFormAction(parentView);
                        break;
                    }
                    String msg = recordModel.getMsg();
                    this.getView().showTipNotification(msg);
                    break;
                }
            }
        }
    }

    private FormShowParameter getFormShowParameter(String formId) {
        long confirmRecordId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)this.getModel().getDataEntity(), (String)"attconrecord");
        String confirmRecordIdStr = JSONObject.toJSONString(new HashSet<Long>(Collections.singletonList(confirmRecordId)));
        FormShowParameter gen = new FormShowParameter();
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        gen.setOpenStyle(openStyle);
        gen.setParentPageId(this.getView().getPageId());
        gen.setCustomParam("selectedRowIds", (Object)confirmRecordIdStr);
        gen.setFormId(formId);
        gen.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        return gen;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if ("rollback".equals(callBackId) && MessageBoxResult.Yes == event.getResult()) {
            if (this.checkViewAuthChanged()) {
                return;
            }
            this.rollBackAndProxyOp(AttConfirmRecordOpEnum.ROLLBACK);
        } else if ("proxy".equals(callBackId) && MessageBoxResult.Yes == event.getResult()) {
            if (this.checkViewAuthChanged()) {
                return;
            }
            this.rollBackAndProxyOp(AttConfirmRecordOpEnum.PROXY);
        }
    }

    private boolean checkViewAuthChanged() {
        String parentPageId = this.getConfirmListPageId();
        return WTCStringUtils.isNotEmpty((String)parentPageId) && WTCPermUtils.isViewAuthChanged((IFormView)this.getView().getView(parentPageId), (IFormView)this.getView());
    }

    private void rollBackAndProxyOp(AttConfirmRecordOpEnum proxy) {
        long confirmRecordId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)this.getModel().getDataEntity(), (String)"attconrecord");
        AttConfirmRecordOpParam opParam = new AttConfirmRecordOpParam();
        opParam.setAttConfirmRecordIds((Set)Sets.newHashSet((Object[])new Long[]{confirmRecordId}));
        opParam.setOp(proxy);
        AttConfirmRecordOpResult result = AttConfirmServiceFactory.getInstance().getAttConfirmService(proxy).opAttConfirmRecord(opParam);
        this.getView().returnDataToParent((Object)JSONObject.toJSONString((Object)result));
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        if ("wtam_attconpushrecordgen".equals(actionId)) {
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.showSuccessNotification(AttConfirmKDString.getSuccessTips());
                this.getView().sendFormAction(parentView);
            }
            this.getView().close();
        }
    }

    private long getAttConfirmRecordId() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long attConfirmBillId = (Long)customParams.get("attConfirmBillId");
        if (attConfirmBillId == null || attConfirmBillId == 0L) {
            attConfirmBillId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)this.getModel().getDataEntity(), (String)"attconrecord");
        }
        return attConfirmBillId;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if ("isshowdiff".equals(name)) {
            ChangeData[] changeSet = args.getChangeSet();
            if (changeSet != null && changeSet.length > 0) {
                Object newValue = changeSet[0].getNewValue();
                boolean isShowDiff = newValue instanceof Boolean && (Boolean)newValue != false;
                this.getView().setVisible(Boolean.valueOf(isShowDiff), new String[]{"diffentryentity"});
                this.getView().setVisible(Boolean.valueOf(!isShowDiff), new String[]{"entryentity"});
            }
            this.getModel().setDataChanged(false);
        }
    }

    private String getConfirmListPageId() {
        Object o;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (WTCCollections.isNotEmpty((Map)customParams) && null != (o = customParams.get("confirmListPageId"))) {
            return (String)o;
        }
        return "";
    }
}

