/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.formplugin.web.attconfirm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRCSMServiceImpl;
import kd.wtc.wtbs.common.enums.file.FileTypeEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtp.business.attconfirm.AttConfirmServiceFactory;
import kd.wtc.wtp.business.attconfirm.IAttConfirmOpService;
import kd.wtc.wtp.common.enums.attconfirm.AttConDayTypeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordDataSourceEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordOverHandleTypeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordTypeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmRecordOpEnum;
import kd.wtc.wtp.common.kdstring.AttConfirmKDString;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordGenModel;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordOpParam;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordOpResult;

public class AttConfirmRecordGenPlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(AttConfirmRecordGenPlugin.class);
    private static final String ATT_CONFIRM_RECORD_GEN_DATE_LIMIT = "kd.wtc.wtp.formplugin.web.attconfirm.dateLimit";
    private static final String ATT_CONFIRM_RECORD_GEN_FILE_LIMIT = "kd.wtc.wtp.formplugin.web.attconfirm.fileLimit";
    private static final String ATT_CONFIRM_RECORD_GEN_PERIOD_LIMIT = "kd.wtc.wtp.formplugin.web.attconfirm.periodLimit";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperationResult().isSuccess() && "confirmgen".equals(afterDoOperationEventArgs.getOperateKey())) {
            AttConfirmRecordGenModel attConfirmRecordGenModel = new AttConfirmRecordGenModel();
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObjectCollection fileDyColl = dataEntity.getDynamicObjectCollection("attfile");
            if (fileDyColl == null) {
                return;
            }
            int intValue = WTCAppContextHelper.getProjectParams().getIntValue(ATT_CONFIRM_RECORD_GEN_FILE_LIMIT, 50);
            if (fileDyColl.size() > intValue) {
                this.getView().showErrorNotification(AttConfirmKDString.attConfirmFileSelectLimit((int)intValue));
                return;
            }
            List fileIdList = fileDyColl.stream().map(d -> d.getDynamicObject("fbasedataid").get("id")).collect(Collectors.toList());
            Set<Long> filePersonIdSet = AttFileQueryServiceImpl.getInstance().queryAttFileByIds("person.id", fileIdList).stream().map(d -> d.getLong("person.id")).collect(Collectors.toSet());
            attConfirmRecordGenModel.setGenSource(AttConRecordDataSourceEnum.MANUAL_ADD);
            String type = dataEntity.getString("type");
            AttConRecordTypeEnum attConRecordTypeEnum = AttConRecordTypeEnum.getEnumByCode((String)type);
            attConfirmRecordGenModel.setType(attConRecordTypeEnum);
            if (AttConRecordTypeEnum.BY_DATE == attConRecordTypeEnum) {
                Date startDate = WTCDateUtils.getZeroDate((Date)dataEntity.getDate("startdate"));
                Date endDate = WTCDateUtils.getZeroDate((Date)dataEntity.getDate("enddate"));
                int dateLimit = WTCAppContextHelper.getProjectParams().getIntValue(ATT_CONFIRM_RECORD_GEN_DATE_LIMIT, 31);
                if (WTCDateUtils.daysBetween((Date)startDate, (Date)endDate) + 1 > dateLimit) {
                    this.getView().showErrorNotification(AttConfirmKDString.attConfirmDateSelectLimit((int)dateLimit));
                    return;
                }
                ArrayList dataScope = Lists.newArrayListWithExpectedSize((int)10);
                Date i = startDate;
                while (!i.after(endDate)) {
                    dataScope.add(i);
                    i = WTCDateUtils.addDays((Date)i, (int)1);
                }
                attConfirmRecordGenModel.setDataScope((List)dataScope);
            } else {
                DynamicObjectCollection attPeriodEntry = dataEntity.getDynamicObjectCollection("attperiodentry");
                if (attPeriodEntry != null && !attPeriodEntry.isEmpty()) {
                    int periodLimit = WTCAppContextHelper.getProjectParams().getIntValue(ATT_CONFIRM_RECORD_GEN_PERIOD_LIMIT, 10);
                    if (attPeriodEntry.size() > periodLimit) {
                        this.getView().showErrorNotification(AttConfirmKDString.attConfirmPeriodSelectLimit((int)periodLimit));
                        return;
                    }
                    Set<Long> attPeriodEntryIdSet = attPeriodEntry.stream().map(d -> d.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                    this.setPerAttPeriodData(attConfirmRecordGenModel, filePersonIdSet, attPeriodEntryIdSet);
                }
            }
            attConfirmRecordGenModel.setPersonIdSet(filePersonIdSet);
            attConfirmRecordGenModel.setZeroItemNoGen(this.getModel().getDataEntity().getBoolean("noculresult"));
            int anInt = this.getModel().getDataEntity().getInt("confirmendtime");
            attConfirmRecordGenModel.setConfirmScope(Tuple.of((Object)anInt, (Object)AttConDayTypeEnum.NORMAL));
            AttConfirmRecordOpParam attConfirmRecordOpParam = this.getAttConfirmRecordOpParam(attConfirmRecordGenModel, dataEntity, attConRecordTypeEnum);
            IAttConfirmOpService attConfirmService = AttConfirmServiceFactory.getInstance().getAttConfirmService(AttConfirmRecordOpEnum.ADD);
            AttConfirmRecordOpResult attConfirmRecordOpResult = attConfirmService.opAttConfirmRecord(attConfirmRecordOpParam);
            if (logger.isInfoEnabled()) {
                logger.info("AttConfirmRecordGen attConfirmRecordOpResult{}", (Object)JSON.toJSONString((Object)attConfirmRecordOpResult));
            }
            this.getView().returnDataToParent((Object)JSONObject.toJSONString((Object)attConfirmRecordOpResult));
            this.getView().close();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("attfile");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        if ("attfile".equals(name)) {
            this.setFileTypeFilter(event);
        }
    }

    private void setFileTypeFilter(BeforeF7SelectEvent event) {
        QFilter dataRule;
        event.getFormShowParameter().setCustomParam("orgAppId", (Object)"wtam");
        event.getFormShowParameter().setCustomParam("orgEntityId", (Object)"wtam_attconrecord");
        event.getFormShowParameter().setCustomParam("orgField", (Object)"attfileversion.affiliateadminorg");
        QFilter qFilter = new QFilter("type", "=", (Object)FileTypeEnum.ALLFILE.getFileType());
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"26", (String)"wtam", (String)"wtam_attconrecord", (String)"47150e89000000ac");
        if (hasPermOrgResult != null && !hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().isEmpty()) {
            QFilter orgQFilter = new QFilter("org", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            qFilter.and(orgQFilter);
        }
        if ((dataRule = HRCSMServiceImpl.getInstance().getDataRuleForBdProp(Long.valueOf(RequestContext.get().getCurrUserId()), "wtam", "wtam_attconrecord", "attfileversion", "47150e89000000ac", new HashMap())) != null) {
            qFilter.and(dataRule);
        }
        event.addCustomQFilter(qFilter);
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        DynamicObjectCollection attPeriodEntry;
        String name = propertyChangedArgs.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if ("attfile".equals(name)) {
            DynamicObjectCollection fileDyColl = dataEntity.getDynamicObjectCollection("attfile");
            if (fileDyColl == null) {
                return;
            }
            int intValue = WTCAppContextHelper.getProjectParams().getIntValue(ATT_CONFIRM_RECORD_GEN_FILE_LIMIT, 50);
            if (fileDyColl.size() > intValue) {
                this.getView().showErrorNotification(AttConfirmKDString.attConfirmFileSelectLimit((int)intValue));
            }
        } else if ("startdate".equals(name) || "enddate".equals(name)) {
            Date entityStartDate = dataEntity.getDate("startdate");
            Date entityEndDate = dataEntity.getDate("enddate");
            if (entityStartDate == null || entityEndDate == null) {
                return;
            }
            Date startDate = WTCDateUtils.getZeroDate((Date)entityStartDate);
            Date endDate = WTCDateUtils.getZeroDate((Date)entityEndDate);
            int dateLimit = WTCAppContextHelper.getProjectParams().getIntValue(ATT_CONFIRM_RECORD_GEN_DATE_LIMIT, 31);
            if (WTCDateUtils.daysBetween((Date)startDate, (Date)endDate) + 1 > dateLimit) {
                this.getView().showErrorNotification(AttConfirmKDString.attConfirmDateSelectLimit((int)dateLimit));
            }
        } else if ("attperiodentry".equals(name) && (attPeriodEntry = dataEntity.getDynamicObjectCollection("attperiodentry")) != null && !attPeriodEntry.isEmpty()) {
            int periodLimit = WTCAppContextHelper.getProjectParams().getIntValue(ATT_CONFIRM_RECORD_GEN_PERIOD_LIMIT, 10);
            if (attPeriodEntry.size() > periodLimit) {
                this.getView().showErrorNotification(AttConfirmKDString.attConfirmPeriodSelectLimit((int)periodLimit));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("wtam_attconopresult".equals(actionId)) {
            this.getView().close();
        }
    }

    private AttConfirmRecordOpParam getAttConfirmRecordOpParam(AttConfirmRecordGenModel attConfirmRecordGenModel, DynamicObject dataEntity, AttConRecordTypeEnum attConRecordTypeEnum) {
        String overHandleType = dataEntity.getString("overhandletype");
        attConfirmRecordGenModel.setType(attConRecordTypeEnum);
        attConfirmRecordGenModel.setOverHandleType(AttConRecordOverHandleTypeEnum.getEnumByCode((String)overHandleType));
        attConfirmRecordGenModel.setConfirmLock(dataEntity.getBoolean("confirmlock"));
        attConfirmRecordGenModel.setShowLast(dataEntity.getBoolean("showlast"));
        AttConfirmRecordOpParam attConfirmRecordOpParam = new AttConfirmRecordOpParam();
        attConfirmRecordOpParam.setAttConfirmRecordGenModel(attConfirmRecordGenModel);
        return attConfirmRecordOpParam;
    }

    private void setPerAttPeriodData(AttConfirmRecordGenModel attConfirmRecordGenModel, Set<Long> filePersonIdSet, Set<Long> attPeriodEntryIdSet) {
        PerAttPeriodQueryParam perAttPeriodQueryParam = new PerAttPeriodQueryParam();
        perAttPeriodQueryParam.setAttPersonIdSet(filePersonIdSet);
        perAttPeriodQueryParam.setPeriodIdSet(attPeriodEntryIdSet);
        perAttPeriodQueryParam.setProperties("id, attfileid, attfilevid, startdate, enddate,attperson,periodentry.begindate,periodentry.enddate");
        Set perAttPeriodSet = PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodDy(perAttPeriodQueryParam).stream().map(dy -> {
            PerAttPeriod perAttPeriod = new PerAttPeriod();
            perAttPeriod.setPrimaryId(Long.valueOf(dy.getLong("id")));
            perAttPeriod.setFileId(Long.valueOf(dy.getLong("attfilevid")));
            perAttPeriod.setFileBoId(Long.valueOf(dy.getLong("attfileid")));
            perAttPeriod.setPerAttBeginDate(dy.getDate("startdate"));
            perAttPeriod.setPerAttEndDate(dy.getDate("enddate"));
            perAttPeriod.setPersonId(Long.valueOf(dy.getLong("attperson")));
            perAttPeriod.setAttPeriodStartDate(dy.getDate("periodentry.begindate"));
            perAttPeriod.setAttPeriodEndDate(dy.getDate("periodentry.enddate"));
            return perAttPeriod;
        }).collect(Collectors.toSet());
        attConfirmRecordGenModel.setPerAttPeriodSet(perAttPeriodSet);
    }
}

