/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.formplugin.web.attconfirm;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.business.auth.WTCBizDataPermissionServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileBusiness;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.attconfirm.AttConfirmHelper;
import kd.wtc.wtp.business.attconfirm.AttConfirmServiceFactory;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmQueryServiceImpl;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmRecordOpEnum;
import kd.wtc.wtp.common.kdstring.AttConfirmKDString;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordModel;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordOpParam;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordOpResult;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordQueryParam;

public class AttConfirmRecordList
extends HRDataBaseList {
    public void setFilter(SetFilterEvent filterEvent) {
        Map customParams;
        List qFilters = filterEvent.getQFilters();
        HasPermOrgResult allPermOrgs = WTCBizDataPermissionServiceImpl.getInstance().getAllPermOrgs("wtam", "wtam_attconrecord");
        if (allPermOrgs != null && !allPermOrgs.hasAllOrgPerm() && CollectionUtils.isNotEmpty((Collection)allPermOrgs.getHasPermOrgs())) {
            QFilter selfApplyOrgQFilter = new QFilter("attfileversion.org", "in", (Object)allPermOrgs.getHasPermOrgs());
            qFilters.add(selfApplyOrgQFilter);
        }
        if ((customParams = this.getView().getFormShowParameter().getCustomParams()).containsKey("centerIds")) {
            List centerIds = JSONObject.parseArray((String)String.valueOf(customParams.get("centerIds")), Long.class);
            filterEvent.getQFilters().add(new QFilter("id", "in", (Object)centerIds));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("centerIds")) {
            args.getCommonFilterColumns().forEach(column -> column.setDefaultValue(null));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (((ListShowParameter)this.getView().getFormShowParameter()).isLookUp()) {
            return;
        }
        if (HRStringUtils.equals((String)"attfileversion_textname", (String)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            IListView listView = (IListView)this.getView();
            AttConfirmRecordQueryParam attConfirmRecordQueryParam = new AttConfirmRecordQueryParam();
            if (listView.getFocusRowPkId() != null && !listView.getFocusRowPkId().equals(0L)) {
                attConfirmRecordQueryParam.setIds((Set)Sets.newHashSet((Object[])new Long[]{(Long)listView.getFocusRowPkId()}));
                List attConfirmRecordModelList = AttConfirmQueryServiceImpl.getInstance().queryAttConfirmRecordModelList(attConfirmRecordQueryParam);
                Optional<Long> any = attConfirmRecordModelList.stream().map(AttConfirmRecordModel::getAttFileVersion).findAny();
                if (any.isPresent()) {
                    Long fileId = any.get();
                    AttFileBusiness.showAttFileDetailForm((IFormView)this.getView(), (IFormPlugin)this, (String)"attfileversion_textname", (Object)fileId);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            String operateKey;
            switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
                case "gen": {
                    this.getView().showForm(this.getFormShowParameter("wtam_attconfirmrecordgen"));
                    break;
                }
                case "push": {
                    FormShowParameter pushGenParameter = this.getFormShowParameter("wtam_attconpushrecordgen");
                    ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
                    Set ids = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toSet());
                    String idsJson = JSONObject.toJSONString(ids);
                    pushGenParameter.setCustomParam("selectedRowIds", (Object)idsJson);
                    pushGenParameter.setCustomParam("confirmListPageId", (Object)this.getView().getPageId());
                    pushGenParameter.setCustomParam("isHiddenSuccessTips", (Object)Boolean.TRUE);
                    this.getView().showForm(pushGenParameter);
                    break;
                }
                case "rollback": {
                    this.getView().showConfirm(AttConfirmKDString.getRollBackConfirmTips(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("rollback", (IFormPlugin)this));
                    break;
                }
                case "proxy": {
                    this.getView().showConfirm(AttConfirmKDString.getProxyConfirmTips(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("proxy", (IFormPlugin)this));
                    break;
                }
                case "viewdetail": {
                    FormShowParameter detailParameter = this.getFormShowParameter("wtam_attconfirmbill");
                    detailParameter.setCustomParam("source", (Object)"detail");
                    detailParameter.setCustomParam("attConfirmBillId", this.getFocusRowPkId());
                    detailParameter.setParentPageId(this.getView().getPageId());
                    detailParameter.setCustomParam("confirmListPageId", (Object)this.getView().getPageId());
                    this.getView().showForm(detailParameter);
                    break;
                }
            }
        }
    }

    private FormShowParameter getFormShowParameter(String formId) {
        FormShowParameter gen = new FormShowParameter();
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        gen.setOpenStyle(openStyle);
        gen.setParentPageId(this.getView().getPageId());
        gen.setFormId(formId);
        gen.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        return gen;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if ("rollback".equals(callBackId) && MessageBoxResult.Yes == event.getResult()) {
            this.rollBackAndProxyOp(AttConfirmRecordOpEnum.ROLLBACK);
        } else if ("proxy".equals(callBackId) && MessageBoxResult.Yes == event.getResult()) {
            this.rollBackAndProxyOp(AttConfirmRecordOpEnum.PROXY);
        }
    }

    private void rollBackAndProxyOp(AttConfirmRecordOpEnum proxy) {
        ListSelectedRowCollection rollBackSelectedRows = ((IListView)this.getView()).getSelectedRows();
        Set ids = rollBackSelectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toSet());
        AttConfirmRecordOpParam opParam = new AttConfirmRecordOpParam();
        opParam.setAttConfirmRecordIds(ids);
        opParam.setOp(proxy);
        AttConfirmRecordOpResult result = AttConfirmServiceFactory.getInstance().getAttConfirmService(proxy).opAttConfirmRecord(opParam);
        this.getView().invokeOperation("refresh");
        AttConfirmHelper.getInstance().genShowAttConfirmOpResult(result, (IFormPlugin)this, this.getView(), "wtam_attconopresult");
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        this.getView().invokeOperation("refresh");
        Object returnData = event.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = event.getActionId();
        if ("wtam_attconfirmrecordgen".equals(actionId) || "wtam_attconfirmbill".equals(actionId) || "wtam_attconpushrecordgen".equals(actionId)) {
            AttConfirmRecordOpResult result = (AttConfirmRecordOpResult)JSONObject.parseObject((String)String.valueOf(returnData), AttConfirmRecordOpResult.class);
            AttConfirmHelper.getInstance().genShowAttConfirmOpResult(result, (IFormPlugin)this, this.getView(), "wtam_attconopresult");
        }
    }
}

