/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.formplugin.web.busitripbill;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.AttachmentMarkListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtam.business.busitrip.AttachmentLimit;
import kd.wtc.wtam.business.busitrip.BillSystemParamService;

public class AttachmentLimitPlugin
extends AbstractFormPlugin
implements UploadListener,
AttachmentMarkListener {
    private static final String ATTACHMENT_PANEL = "attachmentpanel";
    private static final String SIZE = "size";

    public void registerListener(EventObject eventObject) {
        AttachmentPanel panel = (AttachmentPanel)this.getView().getControl(ATTACHMENT_PANEL);
        panel.addMarkListener((AttachmentMarkListener)this);
        panel.addUploadListener((UploadListener)this);
    }

    public void afterUpload(UploadEvent evt) {
        AttachmentPanel panel = (AttachmentPanel)evt.getSource();
        List list = panel.getAttachmentData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        AttachmentLimit attachmentLimit = BillSystemParamService.attachmentLimit();
        Integer maxCapacity = attachmentLimit.getMaxCapacity();
        int maxUploadNums = attachmentLimit.getMaxUploadNums();
        int num = list.size();
        Map map = (Map)list.get(list.size() - 1);
        Integer size = (Integer)map.get(SIZE);
        BigDecimal fileSize = BigDecimal.valueOf(size.intValue()).divide(BigDecimal.valueOf(0x100000L), 2, 4);
        if (num > maxUploadNums) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d85\u51fa\u6700\u5927\u53ef\u4e0a\u4f20\u6570\u91cf\u3002", (String)"AttachmentLimitPlugin_01", (String)"wtc-wtam-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            panel.remove(map);
            return;
        }
        if (fileSize.compareTo(BigDecimal.valueOf(maxCapacity.intValue())) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d85\u51fa\u5355\u4e2a\u9644\u4ef6\u5927\u5c0f\u9650\u5236\u3002", (String)"AttachmentLimitPlugin_02", (String)"wtc-wtam-formplugin", (Object[])new Object[0]));
            panel.remove(map);
            evt.setCancel(true);
        }
    }
}

