/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.formplugin.web.busitripbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sdk.wtc.wtam.business.tp.TpInfoExpService;
import kd.sdk.wtc.wtam.business.tp.TpInfoParameterParam;
import kd.wtc.wtam.business.busitrip.BusiTripBillKDStringHelper;
import kd.wtc.wtam.business.busitrip.BusiTripBillService;
import kd.wtc.wtam.business.busitrip.TripBillStyleService;
import kd.wtc.wtam.business.busitripmobile.BusiTripBillUtil;
import kd.wtc.wtam.common.model.BusiTypeModel;
import kd.wtc.wtam.formplugin.web.busitripbill.BusiTripCommonService;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.web.applybill.service.BustripEntityCheckService;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.bill.BillSystemParam;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.formplugin.web.WTCBaseBillCommon;

public class BusiTripBillEdit
extends HRDataBaseEdit {
    protected static final Log LOG = LogFactory.getLog(BusiTripBillEdit.class);
    protected static final String KEY_ISHAND = "ishand";

    public void preOpenForm(PreOpenFormEventArgs ee) {
        Object pkId;
        super.preOpenForm(ee);
        FormShowParameter formShowParameter = ee.getFormShowParameter();
        if (formShowParameter instanceof BillShowParameter && (pkId = ((BillShowParameter)formShowParameter).getPkId()) != null) {
            String caption;
            String formId = formShowParameter.getFormId();
            if (HRStringUtils.equals((String)"wtam_busitripbill", (String)formId)) {
                caption = BusiTripBillKDStringHelper.forOther();
            } else if (HRStringUtils.equals((String)"wtam_busibillchange", (String)formId)) {
                caption = BusiTripBillKDStringHelper.forOtherChange();
            } else if (HRStringUtils.equals((String)"wtam_busitripselfbill", (String)formId)) {
                caption = BusiTripBillKDStringHelper.self();
            } else if (HRStringUtils.equals((String)"wtam_busiselfbillchange", (String)formId)) {
                caption = BusiTripBillKDStringHelper.selfChange();
            } else {
                return;
            }
            HRBaseServiceHelper helper = new HRBaseServiceHelper("wtam_busitripbill");
            DynamicObject dy = helper.queryOne(pkId);
            DynamicObject attFile = dy.getDynamicObject("attfile");
            if (attFile != null) {
                caption = caption + "-" + attFile.getLocaleString("name");
            }
            formShowParameter.setCaption(caption);
        }
    }

    private void loadFlexDefault() {
        Label labSumstr = (Label)this.getView().getControl("sumstr");
        labSumstr.setText("");
        this.getView().setVisible(Boolean.FALSE, new String[]{"sumflex"});
        this.setVisibleRich();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW != status) {
            Container flexBPanel = (Container)this.getView().getControl("busitripsysflex");
            flexBPanel.setCollapse(true);
            AttachmentPanel attachmentpanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
            List attachmentData = attachmentpanel.getAttachmentData();
            Container flexPanel = (Container)this.getView().getControl("attflex");
            if (CollectionUtils.isEmpty((Collection)attachmentData)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"attlackflex"});
                flexPanel.setCollapse(true);
            } else {
                flexPanel.setCollapse(false);
                this.getView().setVisible(Boolean.TRUE, new String[]{"attachmentpanel"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"attlackflex"});
            }
        } else {
            Container flexPanel = (Container)this.getView().getControl("attflex");
            flexPanel.setCollapse(true);
            Container flexBPanel = (Container)this.getView().getControl("busitripsysflex");
            flexBPanel.setCollapse(true);
            this.getView().setVisible(Boolean.FALSE, new String[]{"sumflex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"attlackflex"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"pagepanel"});
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.loadFlexDefault();
        this.setBusiTripSys();
        this.setEntryStartEndDate();
        this.setSumStr();
        this.setAttachMustInput();
        BillShowParameter formShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        BillOperationStatus billStatus = formShowParameter.getBillStatus();
        if (BillOperationStatus.ADDNEW.equals((Object)billStatus)) {
            this.checkAttfile();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String ishand = this.getView().getPageCache().get(KEY_ISHAND);
        if (HRStringUtils.equals((String)"1", (String)ishand)) {
            ArrayList propEntry = Lists.newArrayList((Object[])new String[]{"startdatestr", "enddatestr"});
            DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            for (DynamicObject dy : entrys) {
                IDataEntityType eachDataEntityType = dy.getDataEntityType();
                DataEntityState dataEntityState1 = dy.getDataEntityState();
                DataEntityPropertyCollection properties = eachDataEntityType.getProperties();
                for (String prop : propEntry) {
                    IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)prop);
                    if (iDataEntityProperty == null) continue;
                    dataEntityState1.setBizChanged(iDataEntityProperty.getOrdinal(), false);
                }
            }
        }
    }

    private void setEntryStartEndDate() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entrys = model.getDataEntity(true).getDynamicObjectCollection("entryentity");
        model.beginInit();
        int index = 0;
        for (DynamicObject entry : entrys) {
            String endMethod = entry.getString("endmethod");
            String startMethod = entry.getString("startmethod");
            if (entry.get("startdate") != null && entry.get("enddate") != null) {
                String startDataStr = " ";
                String endDataStr = " ";
                if ((HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) || HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value)) && (HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) || HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value))) {
                    String endMethodStr = HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) ? BusiTripBillKDStringHelper.dayUp() : BusiTripBillKDStringHelper.dayDown();
                    String startMethodStr = HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) ? BusiTripBillKDStringHelper.dayUp() : BusiTripBillKDStringHelper.dayDown();
                    startDataStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)entry.getDate("startdate")) + startMethodStr;
                    endDataStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)entry.getDate("enddate")) + endMethodStr;
                } else if (HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.DAY.value) && HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.DAY.value)) {
                    startDataStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)entry.getDate("startdate"));
                    endDataStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)entry.getDate("enddate"));
                } else if (HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.CUSTOM.value) && HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.CUSTOM.value)) {
                    startDataStr = WTCInteDateUtil.formatBySysTzAndUserFmt((Date)entry.getDate("startdate"));
                    endDataStr = WTCInteDateUtil.formatBySysTzAndUserFmt((Date)entry.getDate("enddate"));
                } else {
                    startDataStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)entry.getDate("startdate"));
                    endDataStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)entry.getDate("enddate"));
                }
                model.setValue("startdatestr", (Object)startDataStr, index);
                model.setValue("enddatestr", (Object)endDataStr, index);
            }
            ++index;
        }
        model.endInit();
        this.getView().updateView("entryentity");
        if (index > 0) {
            this.getView().getPageCache().put(KEY_ISHAND, "1");
        }
    }

    private String getAuthAppIdForFormPlugin() {
        return BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView());
    }

    private void checkAttfile() {
        BillResponse billResponse;
        long attFileBoId = this.getModel().getDataEntity().getLong("attfile.id");
        if (attFileBoId != 0L && !(billResponse = this.checkAttFile(attFileBoId, this.getAuthAppIdForFormPlugin())).isSuccess()) {
            this.getView().showTipNotification((String)billResponse.getMessage().get(0));
            Image imahead = (Image)this.getControl("imahead");
            imahead.setUrl("/images/pc/emotion/default_person_82_82.png");
        }
    }

    private BillResponse checkAttFile(Long attFileBoId, String appId) {
        String page = "wtam_busitripbill";
        if (this.getView() != null) {
            page = this.getView().getEntityId();
        }
        BustripEntityCheckService billCommonCheckHelper = new BustripEntityCheckService(attFileBoId, UnifyBillEnum.TP, ApplyBillCheckEnum.BUSTRIP, null, page, appId);
        return billCommonCheckHelper.checkAttfile();
    }

    private void setVisibleRich() {
        for (int i = 0; i < 10; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{i == 0 ? "richtexteditorap" : "richtexteditorap" + i});
        }
    }

    private boolean isCancel(PropertyChangedArgs args) {
        ChangeData[] changeSet = args.getChangeSet();
        if (changeSet != null && changeSet.length > 0) {
            Object oldValue = changeSet[0].getOldValue();
            Object newValue = changeSet[0].getNewValue();
            if (oldValue != null && newValue != null) {
                long oldBoId = ((DynamicObject)oldValue).getLong("boid");
                long newBoId = ((DynamicObject)newValue).getLong("boid");
                if (oldBoId != 0L && oldBoId == newBoId) {
                    return true;
                }
            }
        }
        return false;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        switch (name = args.getProperty().getName()) {
            case "attfilebasef7": {
                if (this.isCancel(args)) {
                    return;
                }
            }
            case "personid": {
                this.getModel().deleteEntryData("entryentity");
                this.setBusiTripSys();
                Label labSumstr = (Label)this.getView().getControl("sumstr");
                labSumstr.setText("");
                this.getView().setVisible(Boolean.FALSE, new String[]{"sumflex"});
                break;
            }
            case "busitriptype": {
                this.setBusiTripSys();
                break;
            }
            case "attfile": {
                this.checkAttfile();
                break;
            }
            case "treatmethodgroup": {
                if (TripBillStyleService.singleStyle((DynamicObject)this.getModel().getDataEntity())) break;
                this.setSumStr();
                break;
            }
        }
    }

    protected void setBusiTripSys() {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        DynamicObject attfile = this.getView().getModel().getDataEntity().getDynamicObject("attfile");
        Container flexPanel = (Container)this.getView().getControl("busitripsysflex");
        if (CollectionUtils.isEmpty((Collection)entrys) || Objects.isNull(attfile)) {
            this.setVisibleRich();
            this.getView().setVisible(Boolean.TRUE, new String[]{"lackpageflex"});
            flexPanel.setCollapse(true);
            return;
        }
        HashSet<DynamicObject> tpTypeList = new HashSet<DynamicObject>(16);
        if (BusiTripBillEdit.systemDesc()) {
            tpTypeList.addAll(entrys.stream().map(et -> et.getDynamicObject("busitriptype")).collect(Collectors.toList()));
        } else {
            tpTypeList.add(((DynamicObject)entrys.get(entrys.size() - 1)).getDynamicObject("busitriptype"));
        }
        int index = 1;
        BustripEntityCheckService service = new BustripEntityCheckService(this.getView().getEntityId());
        Map typeRegulation = service.getTypeRegulation((Long)attfile.getPkValue(), this.getAuthAppIdForFormPlugin());
        Map<Long, String> regulationInfo = this.getRegulationInfo(typeRegulation);
        if (!CollectionUtils.isEmpty((Map)typeRegulation)) {
            StringBuilder builder = new StringBuilder();
            this.getView().setVisible(Boolean.TRUE, new String[]{"lackpageflex"});
            this.setVisibleRich();
            for (DynamicObject tpType : tpTypeList) {
                String content;
                Long regulationId;
                if (tpType == null || (regulationId = (Long)typeRegulation.get(tpType.getLong("id"))) == null || regulationId == 0L || !HRStringUtils.isNotEmpty((String)(content = regulationInfo.get(regulationId)))) continue;
                flexPanel.setCollapse(false);
                this.getView().setVisible(Boolean.FALSE, new String[]{"lackpageflex"});
                if (index != 1) {
                    builder.append("<hr style=\"border-style: dashed;\">");
                }
                builder.append("<b style=\"line-height:40px;font-size:14px;color:#212121\">");
                builder.append(tpType.getLocaleString("name").getLocaleValue());
                builder.append(":</b>");
                content = content.replace("<p>", "<p style=\"line-height:20px;font-size:12px;color:#666666\">");
                builder.append(content);
                ++index;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"richtexteditorap"});
            RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl("richtexteditorap");
            richTextEditor.setText(builder.toString());
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"lackpageflex"});
            this.setVisibleRich();
        }
    }

    private Map<Long, String> getRegulationInfo(Map<Long, Long> typeRegulation) {
        ArrayList idList = Lists.newArrayListWithExpectedSize((int)typeRegulation.size());
        Set<Map.Entry<Long, Long>> entries = typeRegulation.entrySet();
        for (Map.Entry<Long, Long> next : entries) {
            Long value = next.getValue();
            idList.add(value);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_attpolicy");
        DynamicObject[] query = serviceHelper.query("id,content", new QFilter[]{new QFilter("id", "in", (Object)idList)});
        return Arrays.stream(query).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("content")));
    }

    public static boolean systemDesc() {
        return HRStringUtils.equalsIgnoreCase((String)SystemParamQueryUtil.getBillSystemParam().getSystemdes(), (String)"1");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (!WTCBaseBillCommon.verifyAttFileExist((BeforeDoOperationEventArgs)args, (IFormView)this.getView())) {
            return;
        }
        switch (operateKey) {
            case "save": 
            case "submit": 
            case "submiteffect": {
                this.beforeDoSave(args, operateKey);
                break;
            }
            case "editentry": {
                this.getView().setReturnData((Object)"editentry");
                break;
            }
        }
    }

    public void beforeDoSave(BeforeDoOperationEventArgs args, String operateKey) {
        DynamicObjectCollection entrys = this.getView().getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entrys)) {
            this.getView().showTipNotification(BusiTripBillKDStringHelper.minEntry());
            args.setCancel(true);
            return;
        }
        DynamicObject attfile = this.getView().getModel().getDataEntity().getDynamicObject("attfile");
        if (attfile == null) {
            return;
        }
        int index = 0;
        boolean attachmeMust = false;
        boolean billCheckForOp = BillCommonService.billCheckForOp();
        for (DynamicObject dy : entrys) {
            String checkPram = BusiTripBillService.getInstance().checkParamStr(new String[]{dy.getString("startmethod"), dy.getString("endmethod"), dy.getString("startdate"), dy.getString("enddate")});
            if (!StringUtils.isEmpty((CharSequence)checkPram)) {
                this.getView().showTipNotification(checkPram);
                args.setCancel(true);
                return;
            }
            if (billCheckForOp || BusiTripBillUtil.checkBillAllDisuse((DynamicObject)this.getView().getModel().getDataEntity())) continue;
            BustripEntityCheckService billCommonCheckHelper = new BustripEntityCheckService((Long)attfile.getPkValue(), UnifyBillEnum.TP, ApplyBillCheckEnum.BUSTRIPFORM, dy, this.getView().getEntityId(), this.getAuthAppIdForFormPlugin());
            BillResponse billResponse = billCommonCheckHelper.checkBaseSet();
            if (billResponse.isSuccess()) {
                List mustInput = billCommonCheckHelper.getMustInput();
                DynamicObject typeDy = dy.getDynamicObject("busitriptype");
                if (mustInput != null && mustInput.contains("isreasonrequired") && HRStringUtils.isEmpty((String)dy.getString("tripresontex"))) {
                    this.getView().showTipNotification(BusiTripBillKDStringHelper.reason((String)typeDy.getString("name")));
                    args.setCancel(true);
                    break;
                }
                if (mustInput != null && mustInput.contains("isvehicle") && dy.get("traveltool") == null) {
                    this.getView().showTipNotification(BusiTripBillKDStringHelper.tool((String)typeDy.getString("name")));
                    args.setCancel(true);
                    break;
                }
                if (mustInput != null && mustInput.contains("isplace")) {
                    DynamicObject from = dy.getDynamicObject("from");
                    DynamicObject to = dy.getDynamicObject("to");
                    if (HRObjectUtils.isEmpty((Object)from)) {
                        this.getView().showTipNotification(BusiTripBillKDStringHelper.from((String)typeDy.getString("name")));
                        args.setCancel(true);
                        break;
                    }
                    if (HRObjectUtils.isEmpty((Object)to)) {
                        this.getView().showTipNotification(BusiTripBillKDStringHelper.to((String)typeDy.getString("name")));
                        args.setCancel(true);
                        break;
                    }
                }
                if (mustInput != null && mustInput.contains("isneedenclosure")) {
                    if (!attachmeMust) {
                        attachmeMust = true;
                    }
                } else {
                    this.getModel().setValue("enclosuremode", (Object)"0", index);
                }
            }
            ++index;
        }
        if (!billCheckForOp && BillCommonService.billAttFileCheckStrict() && !this.attachmeCheck(args, attachmeMust)) {
            return;
        }
        this.setSubmit(operateKey);
    }

    private void setSubmit(String operateKey) {
        if (HRStringUtils.equals((String)"submit", (String)operateKey) || HRStringUtils.equals((String)"submiteffect", (String)operateKey)) {
            DynamicObject mainDataEntity = this.getModel().getDataEntity();
            mainDataEntity.set("applyperson", (Object)RequestContext.get().getCurrUserId());
            mainDataEntity.set("applydate", (Object)new Date());
        }
    }

    private boolean attachmeCheck(BeforeDoOperationEventArgs args, boolean attachmeMust) {
        AttachmentPanel attachmentpanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        List attachmentData = attachmentpanel.getAttachmentData();
        BillSystemParam billSystemParam = SystemParamQueryUtil.getBillSystemParam();
        List errorList = BusiTripBillService.getInstance().attachmeCheck(attachmeMust, attachmentData, billSystemParam);
        if (errorList.isEmpty()) {
            return true;
        }
        this.getView().showTipNotification((String)errorList.get(0));
        args.setCancel(true);
        return false;
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs eventArgs) {
        String name = eventArgs.getEntryProp().getName();
        String returnData = (String)this.getView().getReturnData();
        DynamicObjectCollection entitys = this.getView().getModel().getEntryEntity("entryentity");
        if ("entryentity".equals(name)) {
            if ("editentry".equals(returnData)) {
                this.skipToEditTrip(eventArgs, entitys);
            } else {
                if (CollectionUtils.isEmpty((Collection)entitys) || entitys.size() == 1) {
                    Label labSumstr = (Label)this.getView().getControl("sumstr");
                    labSumstr.setText("");
                    this.getView().setVisible(Boolean.FALSE, new String[]{"sumflex"});
                }
                if (!CollectionUtils.isEmpty((Collection)entitys) && entitys.size() == 1) {
                    eventArgs.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u5c11\u9700\u8981\u4fdd\u75591\u6761{0}\u3002", (String)"BusiTripBillEdit_5", (String)"wtc-wtam-formplugin", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName()}));
                }
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs env) {
        this.loadFlexDefault();
        this.setSumStr();
        this.setBusiTripSys();
    }

    private void skipToEditTrip(BeforeDeleteRowEventArgs eventArgs, DynamicObjectCollection entitys) {
        eventArgs.setCancel(true);
        this.getView().setReturnData(null);
        if (this.checkIsSetPerson()) {
            return;
        }
        int rowIndex = eventArgs.getRowIndexs()[0];
        DynamicObject dynamicObject = (DynamicObject)entitys.get(rowIndex);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wtam_busitripinfo");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newentry"));
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put("editentry", dynamicObject);
        Boolean ischange = this.getModel().getDataEntity().getBoolean("ischange");
        Long parentId = this.getModel().getDataEntity().getLong("parent");
        map.put("tripresontex", dynamicObject.get("tripresontex"));
        map.put("strapplytime", dynamicObject.getString("strapplytime"));
        map.put("rowindex", rowIndex + 1);
        if (this.getView().getModel() != null && this.getView().getModel().getDataEntity() != null) {
            if (this.getView().getModel().getDataEntity().getDynamicObject("personid") != null) {
                Object personId = this.getView().getModel().getDataEntity().getDynamicObject("personid").getPkValue();
                formShowParameter.setCustomParam("personid", personId);
            }
            if (this.getView().getModel().getDataEntity().getDynamicObject("attfile") != null) {
                Object afftileBo = this.getView().getModel().getDataEntity().getDynamicObject("attfile").getPkValue();
                formShowParameter.setCustomParam("attfile", afftileBo);
            }
        }
        formShowParameter.setCustomParam("isfromchange", (Object)ischange);
        formShowParameter.setCustomParam("parent", (Object)parentId);
        formShowParameter.setCustomParam("editentry", map);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        DynamicObject row = (DynamicObject)closedCallBackEvent.getReturnData();
        int rowIndex = 0;
        if (row != null && "newentry".equals(actionId)) {
            TripBillStyleService.writeTripInfoToPage((DynamicObject)row, (IFormView)this.getView());
            rowIndex = row.getInt("rowindex");
            this.setSumStr();
            this.setBusiTripSys();
            this.setAttachMustInput();
        }
        TpInfoParameterParam tpInfoParameterParam = new TpInfoParameterParam(rowIndex, this.getView(), closedCallBackEvent);
        WTCPluginProxy hrPluginProxy = WTCPluginProxyFactory.create(TpInfoExpService.class, (String)"kd.sdk.wtc.wtam.business.tp.TpInfoExpService");
        hrPluginProxy.invokeReplace(hrPlugin -> {
            LOG.info("\u3010\u4e8c\u5f00\u57cb\u70b9\u3011\u51fa\u5dee\u4fe1\u606f\u6269\u5c55\u65b9\u6cd5\u8c03\u7528\u56de\u8c03\u4e8b\u4ef6\u5f00\u59cb,\u8c03\u7528\u6269\u5c55\u7c7b\uff1a{}", (Object)hrPlugin.getClass().getName());
            hrPlugin.onCallBackTpInfo(tpInfoParameterParam);
        });
    }

    protected void setAttachMustInput() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        Set enclosuremodeSet = entrys.stream().map(et -> et.getString("enclosuremode")).collect(Collectors.toSet());
        if (enclosuremodeSet.contains("1")) {
            Container flexPanel = (Container)this.getView().getControl("attflex");
            flexPanel.setCollapse(false);
            this.getView().setVisible(Boolean.TRUE, new String[]{"attachmentpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"attlackflex"});
        }
    }

    private void setSumStr() {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        HashMap<Long, BusiTypeModel> map = new HashMap<Long, BusiTypeModel>(entrys.size());
        Label labSumstr = (Label)this.getView().getControl("sumstr");
        if (CollectionUtils.isEmpty((Collection)entrys)) {
            labSumstr.setText("");
            this.getView().setVisible(Boolean.FALSE, new String[]{"sumflex"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"sumflex"});
        for (DynamicObject entry : entrys) {
            DynamicObject type = entry.getDynamicObject("busitriptype");
            BusiTypeModel busiTypeModel = (BusiTypeModel)map.get(type.getPkValue());
            BigDecimal tripTime = entry.getBigDecimal("triptime");
            if (busiTypeModel == null) {
                BusiTypeModel busiTypeModelNew = new BusiTypeModel();
                busiTypeModelNew.setName(type.getString("name"));
                busiTypeModelNew.setUnit(entry.getString("unit"));
                busiTypeModelNew.setTime(tripTime);
                map.put((Long)type.getPkValue(), busiTypeModelNew);
                continue;
            }
            BigDecimal time = busiTypeModel.getTime();
            busiTypeModel.setTime(time.add(tripTime));
        }
        StringBuilder stringBuilder = new StringBuilder(ResManager.loadKDString((String)"\u5df2\u63d0  ", (String)"BusiTripBillEdit_1", (String)"wtc-wtam-formplugin", (Object[])new Object[0]));
        AtomicInteger curIndex = new AtomicInteger(1);
        int count = map.size();
        map.forEach((typeKey, typeValue) -> {
            String name = typeValue.getName();
            BigDecimal time = typeValue.getTime();
            String unit = typeValue.getUnit();
            String unitStr = "A".equals(unit) ? ResManager.loadKDString((String)"\u5929", (String)"BusiTripBillEdit_2", (String)"wtc-wtam-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"BusiTripInfoPlugin_2", (String)"wtc-wtam-formplugin", (Object[])new Object[0]);
            stringBuilder.append(String.format(ResManager.loadKDString((String)"%1$s %2$s%3$s", (String)"BusiTripBillEdit_3", (String)"wtc-wtam-formplugin", (Object[])new Object[0]), name, time.setScale(2, RoundingMode.HALF_UP), unitStr));
            if (count > 1 && curIndex.get() < count) {
                stringBuilder.append(WTCSymbolMultiLanguageUtil.getSemicolonSymbol());
            }
            curIndex.getAndIncrement();
        });
        labSumstr.setText(stringBuilder.toString());
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("newentry".equals(itemKey)) {
            this.skipToNewTripPage();
        }
    }

    private void skipToNewTripPage() {
        DynamicObjectCollection pEntitys = this.getView().getModel().getEntryEntity("entryentity");
        int pSize = pEntitys.size();
        if (pSize > 100) {
            this.getView().showTipNotification(BusiTripBillKDStringHelper.maxEntry());
            return;
        }
        if (this.checkIsSetPerson()) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wtam_busitripinfo");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        Boolean ischange = this.getModel().getDataEntity().getBoolean("ischange");
        formShowParameter.setCustomParam("isfromchange", (Object)ischange);
        Long parentId = this.getModel().getDataEntity().getLong("parent");
        formShowParameter.setCustomParam("parent", (Object)parentId);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newentry"));
        if (this.getView().getModel() != null && this.getView().getModel().getDataEntity() != null) {
            if (this.getView().getModel().getDataEntity().getDynamicObject("attfile") != null) {
                Object afftileBo = this.getView().getModel().getDataEntity().getDynamicObject("attfile").getPkValue();
                formShowParameter.setCustomParam("attfile", afftileBo);
            }
            if (this.getView().getModel().getDataEntity().getDynamicObject("personid") != null) {
                Object personId = this.getView().getModel().getDataEntity().getDynamicObject("personid").getPkValue();
                formShowParameter.setCustomParam("personid", personId);
            }
        }
        this.getView().showForm(formShowParameter);
    }

    private boolean checkIsSetPerson() {
        DynamicObject person = this.getView().getModel().getDataEntity().getDynamicObject("personid");
        if (person == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9{0}\u4eba\u5458\u3002", (String)"BusiTripBillEdit_4", (String)"wtc-wtam-formplugin", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName()}));
            return true;
        }
        return false;
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess() && "change".equals(operateKey)) {
            BusiTripCommonService service = new BusiTripCommonService();
            service.openChangeForDetail(this.getView(), (AbstractFormPlugin)this);
        }
    }

    private Long getEntityId(DynamicObject row, String fieldTo) {
        DynamicObject toEnt = row.getDynamicObject(fieldTo);
        if (toEnt != null) {
            return toEnt.getLong("id");
        }
        return null;
    }
}

