/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.formplugin.web.busitripbill;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtam.business.busitrip.BusiTripBillImportService;
import kd.wtc.wtam.business.busitrip.BusiTripBillKDStringHelper;
import kd.wtc.wtam.business.busitripmobile.BusiTripBillUtil;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;

public class BusiTripBillImportEdit
extends HRDataBaseEdit {
    private Map<String, DynamicObject> numberAndTop1 = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> numberAndPersonDy = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> numberAndAttFileBoDy = new HashMap<String, DynamicObject>(16);

    public void initImportData(InitImportDataEventArgs ee) {
        super.initImportData(ee);
        String appId = this.getView().getFormShowParameter().getAppId();
        String entityId = this.getView().getEntityId();
        this.initImportData(ee.getSourceDataList(), appId, entityId);
    }

    public void initImportData(List<Map<String, Object>> sourceDataList, String appId, String entityId) {
        new BillCommonService().initBillImportData(appId, entityId, sourceDataList, this.numberAndTop1, this.numberAndPersonDy, this.numberAndAttFileBoDy);
    }

    public void afterImportData(ImportDataEventArgs ee) {
        super.afterImportData(ee);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject attFileF7 = dataEntity.getDynamicObject("attfilebasef7");
        if (HRObjectUtils.isEmpty((Object)attFileF7)) {
            return;
        }
        this.afterImportData(ee, dataEntity);
    }

    public void afterImportData(ImportDataEventArgs ee, DynamicObject dataEntity) {
        DynamicObject attFileF7 = dataEntity.getDynamicObject("attfilebasef7");
        if (attFileF7 == null) {
            return;
        }
        String number = attFileF7.getString("number");
        DynamicObject curAttFileDy = this.numberAndAttFileBoDy.get(number);
        DynamicObject effAttFileDy = this.numberAndTop1.get(number);
        String attFileError = BillCommonService.getInstance().judgeAttFile(curAttFileDy, BillTypeEnum.EVECTIONBILL.getBillName());
        if (HRStringUtils.isNotEmpty((String)attFileError)) {
            this.dealImport(ee, attFileError);
            return;
        }
        DynamicObject attPersonDy = this.numberAndPersonDy.get(number);
        if (curAttFileDy == null || effAttFileDy == null) {
            this.dealImport(ee, BusiTripBillKDStringHelper.emptyAttFile());
            return;
        }
        dataEntity.set("attfilebasef7", (Object)effAttFileDy);
        dataEntity.set("attfile", (Object)curAttFileDy);
        dataEntity.set("personid", (Object)attPersonDy);
        DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection("entryentity");
        if (entryColl == null || entryColl.isEmpty()) {
            this.dealImport(ee, BusiTripBillKDStringHelper.minEntry());
            return;
        }
        if (entryColl.size() > 100) {
            this.dealImport(ee, BusiTripBillKDStringHelper.maxEntry());
            return;
        }
        String upStr = BusiTripBillKDStringHelper.dayUp();
        String downStr = BusiTripBillKDStringHelper.dayDown();
        int count = entryColl.size();
        BusiTripBillImportService busiTripBillImportService = new BusiTripBillImportService();
        for (int index = 0; index < entryColl.size(); ++index) {
            DynamicObject entry = (DynamicObject)entryColl.get(index);
            entry.set("tripresontex", (Object)entry.getString("tripreason"));
            String error = busiTripBillImportService.checkEntry(entry);
            if (error != null) {
                this.dealImport(ee, this.getMsg(count, index, error));
                break;
            }
            entry.set("startdatestr", (Object)BusiTripBillUtil.getDateMethodStr((DynamicObject)entry, (String)"startmethod", (String)"startdate", (String)upStr, (String)downStr));
            entry.set("enddatestr", (Object)BusiTripBillUtil.getDateMethodStr((DynamicObject)entry, (String)"endmethod", (String)"enddate", (String)upStr, (String)downStr));
            entry.set("enclosuremode", (Object)0);
        }
    }

    private String getMsg(int count, int curIndex, String curMsg) {
        if (count <= 1) {
            return curMsg;
        }
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < count; ++index) {
            sb.append(BusiTripBillKDStringHelper.entity((int)(index + 1)));
            if (index == curIndex) {
                sb.append(curMsg);
                continue;
            }
            sb.append(BusiTripBillKDStringHelper.entity());
        }
        return sb.toString();
    }

    private void dealImport(ImportDataEventArgs eventArgs, String errorMsg) {
        if (eventArgs != null) {
            eventArgs.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), errorMsg);
            eventArgs.setCancel(true);
        }
    }
}

