/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.formplugin.web.busitripbill;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.EnableCustomSumEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtam.business.busitrip.BusiTripBillKDStringHelper;
import kd.wtc.wtam.business.busitrip.TripBillOriginalUpgradeHelper;
import kd.wtc.wtam.formplugin.web.busitripbill.BusTripListProvider;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.common.enums.BillSystemParamConfigEnum;
import kd.wtc.wtbs.common.enums.WTCBillChangeEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.model.bill.BillSystemParamRange;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.formplugin.util.WTCBillViewUtils;

public class BusiTripBillList
extends HRDataBaseList {
    private static final Log LOG = LogFactory.getLog(BusiTripBillList.class);
    private static final String KEY_BTDATE = "btdate";
    private HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtam_busibillchange");
    private final List<Date> dateList = new ArrayList<Date>(2);
    private final Set<CompareTypeEnum> compareTypeEnums = Sets.newHashSet((Object[])new CompareTypeEnum[]{CompareTypeEnum.TODAY, CompareTypeEnum.YESTERDAY, CompareTypeEnum.THISWEEK, CompareTypeEnum.LASTWEEK, CompareTypeEnum.THISMONTH, CompareTypeEnum.LASTMONTH, CompareTypeEnum.LASTONEMONTH, CompareTypeEnum.LASTTHREEMONTH, CompareTypeEnum.THISQUARTER, CompareTypeEnum.LASTQUARTER, CompareTypeEnum.THISYEAR, CompareTypeEnum.LASTYEAR, CompareTypeEnum.TOMORROW, CompareTypeEnum.NEXTWEEK, CompareTypeEnum.NEXTMONTH, CompareTypeEnum.FUTUREONEMONTH, CompareTypeEnum.FUTURETHREEMONTH, CompareTypeEnum.NEXTYEAR, CompareTypeEnum.NEXTQUARTER, CompareTypeEnum.BETWEEN});
    private String exportSelectFields;

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new BusTripListProvider());
    }

    public void setEnableCustomSum(EnableCustomSumEvent args) {
        super.setEnableCustomSum(args);
        args.setEnableCustomSum(false);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillListHyperLinkClickEvent clickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        String fieldName = clickEvent.getFieldName();
        if (fieldName.equals("barcode")) {
            String formId;
            Object primaryKeyValue = clickEvent.getCurrentRow().getPrimaryKeyValue();
            DynamicObject currentRow = this.serviceHelper.queryOne(primaryKeyValue);
            args.setCancel(true);
            Long parentId = currentRow.getLong("parent");
            ArrayList<Long> list = new ArrayList<Long>();
            list.add((Long)currentRow.getPkValue());
            this.getIdList(list, parentId);
            ListShowParameter lsp = new ListShowParameter();
            ListFilterParameter fParameter = new ListFilterParameter();
            QFilter filter = new QFilter("id", "in", list);
            fParameter.setFilter(filter);
            lsp.setListFilterParameter(fParameter);
            lsp.getOpenStyle().setShowType(ShowType.Modal);
            if ("0".equals(currentRow.getString("applytyperadio"))) {
                formId = "wtam_busiselfbillchange";
            } else {
                formId = "wtam_busibillchange";
                ListView listView = (ListView)this.getView();
                if (HRStringUtils.equals((String)"wtam_busitripselfbill", (String)listView.getBillFormId())) {
                    lsp.setCustomParam("wtcbill_hasright", (Object)"1");
                }
            }
            lsp.setBillFormId(formId);
            OpenStyle openStyle = lsp.getOpenStyle();
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth("1050px");
            styleCss.setHeight("400px");
            openStyle.setInlineStyleCss(styleCss);
            lsp.setHasRight(true);
            lsp.setCaption(ResManager.loadKDString((String)"{0}\u53d8\u66f4\u5386\u53f2", (String)"BusiTripBillList_13", (String)"wtc-wtam-formplugin", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName()}));
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    private void getIdList(List<Long> list, Long parentId) {
        DynamicObject parentDynamicObject = this.serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)parentId));
        boolean isChange = parentDynamicObject.getBoolean("ischange");
        list.add(parentId);
        if (isChange) {
            Long id = parentDynamicObject.getLong("parent");
            this.getIdList(list, id);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate;
        String operateKey;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof FormOperate && "printpreview".equals(operateKey = (formOperate = (FormOperate)args.getSource()).getOperateKey())) {
            ListView view = (ListView)this.getView();
            ListSelectedRowCollection selectedRows = view.getSelectedRows();
            String errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"BusiTripBillList_02", (String)"wtc-wtam-formplugin", (Object[])new Object[0]);
            if (selectedRows.size() > 1) {
                errorMsg = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a{0}\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"BusiTripBillList_01", (String)"wtc-wtam-formplugin", (Object[])new Object[0]);
            }
            Map<Object, String> pkIdBillNoMap = selectedRows.stream().collect(Collectors.toMap(ListSelectedRow::getPrimaryKeyValue, ListSelectedRow::getBillNo, (o1, o2) -> o2));
            Set<Object> pkIds = pkIdBillNoMap.keySet();
            HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)view.getEntityTypeId());
            DynamicObject[] billDys = serviceHelper.queryOriginalArray("id", new QFilter("id", "in", pkIds).toArray());
            List dbPkIds = Arrays.stream(billDys).map(item -> item.get("id")).collect(Collectors.toList());
            for (Map.Entry<Object, String> entry : pkIdBillNoMap.entrySet()) {
                if (dbPkIds.contains(entry.getKey())) continue;
                view.showErrorNotification(MessageFormat.format(errorMsg, entry.getValue()));
                args.setCancel(true);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        if (billlistap != null) {
            billlistap.refresh();
            billlistap.clearSelection();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        boolean success = false;
        if (operationResult != null) {
            success = operationResult.isSuccess();
        }
        switch (operateKey) {
            case "save": 
            case "submit": 
            case "submiteffect": 
            case "discard": 
            case "unsubmit": 
            case "wfauditing": 
            case "wfauditnotpass": 
            case "wfrejecttosubmit": {
                if (!success) break;
                this.refreshListPage();
                break;
            }
        }
    }

    private void refreshListPage() {
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        if (billlistap != null) {
            billlistap.refresh();
        }
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        event.addCustomQFilter(new QFilter("isnewbill", "=", (Object)Boolean.TRUE));
        this.setBtDateQFilter(event);
    }

    private void setBtDateQFilter(SetFilterEvent event) {
        List qFilters = event.getQFilters();
        LOG.info("BusiTripBillList.setFilter,qFilters:{}", (Object)qFilters);
        Set filters = event.getQFilters().stream().map(filter -> filter.getNests(true).stream().map(QFilter.QFilterNest::getFilter).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet());
        filters.addAll(qFilters);
        if (this.dateList.isEmpty()) {
            for (QFilter qFilter : filters) {
                if (!StringUtils.equals((CharSequence)KEY_BTDATE, (CharSequence)qFilter.getProperty())) continue;
                Object value = qFilter.getValue();
                String cp = "=";
                if (value instanceof Date) {
                    this.dateList.add((Date)qFilter.getValue());
                } else if (value instanceof QEmptyValue) {
                    this.dateList.add(WTCDateUtils.getMaxEndDate());
                    this.dateList.add(WTCDateUtils.getMaxEndDate());
                    cp = "!=";
                }
                qFilter.__setProperty("1");
                qFilter.__setCP(cp);
                qFilter.__setValue((Object)1);
            }
        }
        if (this.dateList.size() >= 2) {
            Collections.sort(this.dateList);
            Date startDate = this.dateList.get(0);
            Date endDate = this.dateList.get(1);
            QFilter dateFilter = new QFilter("entryentity.startdate", "<", (Object)endDate).and("entryentity.enddate", ">=", (Object)startDate);
            if (event.getCustomQFilters() == null) {
                event.setCustomQFilters(new ArrayList(1));
            }
            event.getCustomQFilters().add(dateFilter);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map currentCommonFilter;
        super.filterContainerSearchClick(args);
        Map filterValues = args.getFilterValues();
        List schemeFilters = (List)filterValues.get("schemefilter");
        if (schemeFilters != null && !schemeFilters.isEmpty()) {
            for (Map schemeFilter : schemeFilters) {
                String compare;
                CompareTypeEnum compareTypeEnum;
                List fieldName = (List)schemeFilter.get("FieldName");
                List compares = (List)schemeFilter.get("Compare");
                if (fieldName == null || fieldName.isEmpty() || compares == null || compares.isEmpty()) {
                    LOG.warn("\u83b7\u53d6\u7684\u65b9\u6848\u67e5\u8be2\u6761\u4ef6\u5f02\u5e38, schemeFilters:{}", (Object)JSON.toJSONString((Object)schemeFilters));
                    continue;
                }
                boolean exitBtDate = false;
                for (Object obj : fieldName) {
                    if (!(obj instanceof String) || !HRStringUtils.equals((String)KEY_BTDATE, (String)((String)obj))) continue;
                    exitBtDate = true;
                }
                if (!exitBtDate || this.compareTypeEnums.contains(compareTypeEnum = CompareTypeEnum.createCompareTypeEnum((String)(compare = (String)compares.get(0))))) continue;
                String errMsg = ResManager.loadKDString((String)"{0}\u65e5\u671f\u5b57\u6bb5\u4ec5\u652f\u6301\u4eca\u5929\u3001\u6628\u5929\u3001\u672c\u5468\u3001\u4e0a\u5468\u3001\u672c\u6708\u3001\u4e0a\u6708\u3001\u8fc7\u53bb\u4e00\u4e2a\u6708\u3001\u8fc7\u53bb\u4e09\u4e2a\u6708\u3001\u672c\u5b63\u5ea6\u3001\u4e0a\u5b63\u5ea6\u3001\u4eca\u5e74\u3001\u53bb\u5e74\u3001\u660e\u5929\u3001\u4e0b\u5468\u3001\u4e0b\u4e2a\u6708\u3001\u672a\u6765\u4e00\u4e2a\u6708\u3001\u672a\u6765\u4e09\u4e2a\u6708\u3001\u4e0b\u5b63\u5ea6\u3001\u660e\u5e74\u3001\u4ece...\u5230...\u7684\u6761\u4ef6\u67e5\u8be2\u3002", (String)"BusiTripBillList_4", (String)"wtc-wtam-formplugin", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName()});
                throw new KDBizException(errMsg);
            }
        }
        if ((currentCommonFilter = args.getCurrentCommonFilter()) != null && currentCommonFilter.get("FieldName") != null) {
            for (List fieldName : (List)currentCommonFilter.get("FieldName")) {
                if (!KEY_BTDATE.equals(fieldName)) continue;
                this.handleBTDateFilter(args, currentCommonFilter);
            }
        }
    }

    private void handleBTDateFilter(FilterContainerSearchClickArgs args, Map<String, List<Object>> currentCommonFilter) {
        BillSystemParamRange range;
        Tuple result;
        List<Object> values;
        Date startDate = null;
        Date endDate = null;
        List qFilters = args.getFilterModel().getFilterObject().getFilterResult().getQFilters();
        for (QFilter qFilter : qFilters) {
            if (!StringUtils.equals((CharSequence)KEY_BTDATE, (CharSequence)qFilter.getProperty())) continue;
            startDate = (Date)qFilter.getValue();
            for (QFilter.QFilterNest nest : qFilter.getNests(true)) {
                endDate = (Date)nest.getFilter().getValue();
            }
        }
        if ((values = currentCommonFilter.get("Value")) != null && values.size() > 1 && !((Boolean)(result = WTCBillViewUtils.dateCheckSuccess((BillSystemParamRange)(range = SystemParamQueryUtil.getBillSystemParamRange((BillSystemParamConfigEnum)BillSystemParamConfigEnum.BUSITRIP)), (Date)startDate, endDate)).getKey()).booleanValue()) {
            this.getView().showTipNotification((String)result.getValue());
            values.clear();
            values.add("63");
        }
    }

    public void beforeQueryOfExport(BeforeQueryOfExportEvent ee) {
        super.beforeQueryOfExport(ee);
        String selectFields = ee.getSelectFields();
        String fields = String.join((CharSequence)",", selectFields, "tripresontex", "originalid", "ischange", "parent", "entryentity.startdate", "entryentity.startmethod", "entryentity.enddate", "entryentity.endmethod", "entryentity.triptime");
        ee.setSelectFields(fields);
        this.exportSelectFields = ee.getSelectFields();
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent ee) {
        super.afterQueryOfExport(ee);
        DynamicObject[] dataArr = ee.getQueryValues();
        if (dataArr != null && dataArr.length > 0) {
            this.checkTripBillUpgrade(dataArr);
            LinkedHashMap<Long, Long> leafBillIdMap = new LinkedHashMap<Long, Long>(dataArr.length);
            Arrays.stream(dataArr).forEach(dy -> leafBillIdMap.put(dy.getLong("id"), dy.getLong("originalid")));
            DynamicObject[] resultDys = HRBaseServiceHelper.create((String)"wtam_busitripbill").query(this.exportSelectFields, new QFilter("originalid", "in", leafBillIdMap.values()).toArray(), "id desc");
            ArrayList result = new ArrayList(resultDys.length);
            Map<Long, List<DynamicObject>> dyMapByOriginalId = Arrays.stream(resultDys).collect(Collectors.groupingBy(dy -> dy.getLong("originalid")));
            leafBillIdMap.forEach((leafId, originalId) -> {
                List dys = (List)dyMapByOriginalId.get(originalId);
                if (WTCCollections.isNotEmpty((Collection)dys)) {
                    if (dys.size() > 1) {
                        dys = BillCommonService.getInstance().leafFilter(leafId, dys, WTCBillChangeEnum.BUSTRIP);
                    }
                    int changeNum = dys.size() - 1;
                    for (DynamicObject dy : dys) {
                        if (!dy.containsProperty("changenum")) continue;
                        String changeNumStr = changeNum > 0 ? ResManager.loadKDString((String)"\u7b2c{0}\u6b21\u53d8\u66f4", (String)"BusiTripBillList_2", (String)"wtc-wtam-formplugin", (Object[])new Object[]{changeNum--}) : ResManager.loadKDString((String)"\u539f\u5355", (String)"BusiTripBillList_3", (String)"wtc-wtam-formplugin", (Object[])new Object[0]);
                        dy.set("changenum", (Object)changeNumStr);
                    }
                    result.addAll(dys);
                }
            });
            ee.setCustomOrder(true);
            ee.setQueryValues(result.toArray(new DynamicObject[result.size()]));
        }
        for (DynamicObject dy2 : ee.getQueryValues()) {
            DynamicObjectCollection coll = dy2.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : coll) {
                if (entry.containsProperty("tripreason")) {
                    entry.set("tripreason", (Object)entry.getString("tripresontex"));
                }
                this.setEntryStartEndDate(entry);
            }
        }
    }

    private void setEntryStartEndDate(DynamicObject entry) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String endMethod = entry.getString("endmethod");
        String startMethod = entry.getString("startmethod");
        if (entry.get("startdate") != null && entry.get("enddate") != null) {
            String startDataStr = " ";
            String endDataStr = " ";
            if ((HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) || HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value)) && (HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) || HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value))) {
                String endMethodStr = HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) ? BusiTripBillKDStringHelper.dayUp() : BusiTripBillKDStringHelper.dayDown();
                String startMethodStr = HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) ? BusiTripBillKDStringHelper.dayUp() : BusiTripBillKDStringHelper.dayDown();
                startDataStr = simpleDateFormat.format(entry.get("startdate")) + startMethodStr;
                endDataStr = simpleDateFormat.format(entry.get("enddate")) + endMethodStr;
            } else if (HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.DAY.value) && HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.DAY.value)) {
                startDataStr = simpleDateFormat.format(entry.get("startdate"));
                endDataStr = simpleDateFormat.format(entry.get("enddate"));
            } else if (HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.CUSTOM.value) && HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.CUSTOM.value)) {
                startDataStr = simpleDateFormat2.format(entry.get("startdate"));
                endDataStr = simpleDateFormat2.format(entry.get("enddate"));
            } else {
                startDataStr = simpleDateFormat.format(entry.get("startdate"));
                endDataStr = simpleDateFormat.format(entry.get("enddate"));
            }
            entry.set("startdatestr", (Object)startDataStr);
            entry.set("enddatestr", (Object)endDataStr);
        }
        if (entry.containsProperty("triptime")) {
            entry.set("triptimestr", (Object)entry.getBigDecimal("triptime").setScale(2, 4).toPlainString());
        }
    }

    private void checkTripBillUpgrade(DynamicObject[] dataArr) {
        List notHaveOriginalBills = Arrays.stream(dataArr).filter(dy -> dy.getLong("originalid") == 0L).collect(Collectors.toList());
        if (notHaveOriginalBills.size() > 0) {
            TripBillOriginalUpgradeHelper.getInstance().upgradeOriginalId(notHaveOriginalBills, this.exportSelectFields);
        }
    }
}

