/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.formplugin.web.busitripbill;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sdk.wtc.wtam.business.tp.TpInfoExpService;
import kd.sdk.wtc.wtam.business.tp.TpInfoParameterParam;
import kd.wtc.wtam.business.busitrip.BusiTripBillService;
import kd.wtc.wtam.business.busitripmobile.BusiTripBillUtil;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.formplugin.util.WTCBillViewUtils;

public class BusiTripChangeBillEdit
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(BusiTripChangeBillEdit.class);
    private HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtam_busibillchange");

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        BillShowParameter billShowParameter = (BillShowParameter)evt.getFormShowParameter();
        Map map = (Map)billShowParameter.getCustomParam("wtam_busitripbill");
        if (map != null) {
            Long parentId = (Long)map.get("parent");
            StringBuilder errMsg = new StringBuilder();
            boolean require = WTCBillViewUtils.requireMutex((String)String.valueOf(parentId), (String)"wtam_busitripbill", (String)"change", (StringBuilder)errMsg);
            if (!require) {
                evt.setCancel(true);
                evt.setCancelMessage(errMsg.toString());
            }
        }
    }

    private void copyAttachment(Long parentId, String applyType) {
        Long pkValue = DB.genGlobalLongId();
        this.getModel().getDataEntity().set("id", (Object)pkValue);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_attachment");
        QFilter filter = new QFilter("finterid", "=", (Object)parentId.toString());
        DynamicObject[] originalAttachments = helper.loadDynamicObjectArray(new QFilter[]{filter});
        if (originalAttachments == null || originalAttachments.length == 0) {
            return;
        }
        DynamicObject[] attachments = new DynamicObject[originalAttachments.length];
        for (int i = 0; i < originalAttachments.length; ++i) {
            DynamicObject attachment = originalAttachments[i];
            DynamicObject newAttachment = helper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)attachment, (DynamicObject)newAttachment);
            newAttachment.set("fbilltype", (Object)this.getView().getFormShowParameter().getFormId());
            newAttachment.set("finterid", (Object)pkValue);
            attachments[i] = newAttachment;
        }
        helper.save(attachments);
    }

    public void afterCreateNewData(EventObject evt) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map map = (Map)formShowParameter.getCustomParam("wtam_busitripbill");
        if (map != null) {
            this.getModel().setValue("attfilebasef7", map.get("attfilebasef7"));
            Long parentId = (Long)map.get("parent");
            String applyType = (String)map.get("applytyperadio");
            this.copyAttachment(parentId, applyType);
        }
        this.setReturnValue();
        BillCommonService billCommonService = new BillCommonService();
        UnifyBillApplyAttr unifyBillApplyAttr = new UnifyBillApplyAttr(billCommonService.getAuthAppIdForFormPlugin(this.getView()), this.getView().getEntityId(), "attfilebasef7");
        billCommonService.showAttFileChangeInfoAndUpdate(this.getView(), this.getView().getModel(), unifyBillApplyAttr);
    }

    public void afterLoadData(EventObject evt) {
        super.afterLoadData(evt);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if ("A".equals(dataEntity.getString("billstatus")) || "G".equals(dataEntity.getString("billstatus")) || "D".equals(dataEntity.getString("billstatus"))) {
            DynamicObject parentDy = BusiTripBillService.getInstance().queryOne((Object)dataEntity.getLong("parent"));
            Map returnMap = BusiTripBillService.getInstance().genOriginDataMap(parentDy);
            this.getView().getFormShowParameter().setCustomParam("wtam_busitripbill", (Object)returnMap);
            this.getView().cacheFormShowParameter();
        }
        this.getModel().setValue("treatmethodgroup", (Object)(dataEntity.getBoolean("isnottrip") ? "1" : "0"));
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject eventObject) {
        this.earlyBusiTrip();
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        OperationResult opResult = evt.getOperationResult();
        String opKey = evt.getOperateKey();
        if (opResult != null && opResult.isSuccess() && StringUtils.equalsAny((CharSequence)opKey, (CharSequence[])new CharSequence[]{"save", "submit", "unsubmit", "submiteffect", "discard"})) {
            this.earlyBusiTrip();
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        if (evt.getChangeSet() == null || evt.getChangeSet().length <= 0) {
            return;
        }
        String name = evt.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"treatmethodgroup")) {
            boolean isNoTrip = HRObjectUtils.equals((Object)"1", (Object)evt.getChangeSet()[0].getNewValue());
            this.getModel().beginInit();
            this.getModel().setValue("isnottrip", (Object)isNoTrip);
            this.getModel().deleteEntryData("entryentity");
            this.setReturnValue();
            if (isNoTrip) {
                DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                entryEntity.forEach(e -> e.set("triptime", (Object)BigDecimal.ZERO));
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    private void earlyBusiTrip() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        Map map = (Map)formShowParameter.getCustomParam("wtam_busitripbill");
        long parrntId = OperationStatus.ADDNEW == status && map != null ? ((Long)map.get("parent")).longValue() : this.getView().getModel().getDataEntity().getLong("parent");
        ListShowParameter lsp = new ListShowParameter();
        ListFilterParameter fParameter = new ListFilterParameter();
        ArrayList<Long> list = new ArrayList<Long>();
        list.add((Long)this.getModel().getDataEntity().getPkValue());
        this.getIdList(list, parrntId);
        QFilter filter = new QFilter("id", "in", list);
        fParameter.setFilter(filter);
        lsp.setListFilterParameter(fParameter);
        lsp.getOpenStyle().setShowType(ShowType.InContainer);
        lsp.setBillFormId(formShowParameter.getFormId());
        lsp.setCustomParam("billno", (Object)this.getModel().getDataEntity().getString("billno"));
        lsp.setCustomParam("wtcbill_hasright", formShowParameter.getCustomParam("wtcbill_hasright"));
        lsp.setHasRight(true);
        lsp.setFormId("wtbs_rimlesslist");
        lsp.getOpenStyle().setTargetKey("trip");
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, null));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void getIdList(List<Long> list, Long parentId) {
        DynamicObject parentDynamicObject = this.serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)parentId));
        boolean isChange = parentDynamicObject.getBoolean("ischange");
        list.add(parentId);
        if (isChange) {
            Long id = parentDynamicObject.getLong("parent");
            this.getIdList(list, id);
        }
    }

    private void setReturnValue() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map map = (Map)formShowParameter.getCustomParam("wtam_busitripbill");
        if (map != null) {
            DynamicObject parentDy;
            long parentId = 0L;
            try {
                parentId = Long.parseLong(String.valueOf(map.get("parent")));
                parentDy = this.serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)parentId));
            }
            catch (Exception e) {
                LOG.warn("BusiTripChangeBillEdit.setReturnValue.getParentPkIdError:{}", (Object)e.getMessage());
                parentDy = null;
            }
            this.getModel().setValue("personid", map.get("personid"));
            this.getModel().setValue("attfile", map.get("attfile"));
            this.getModel().setValue("attfilebasef7", map.get("attfilebasef7"));
            this.getModel().setValue("parent", map.get("parent"));
            boolean selfApply = BillApplyTypeEnum.SELF.getCode().equals(this.getModel().getValue("applytyperadio"));
            if (selfApply) {
                this.getModel().setValue("billstyle", map.get("billstyle"));
            }
            this.getModel().setValue("org", map.get("org"));
            JSONArray entrys = (JSONArray)map.get("entryentity");
            for (int i = 0; i < entrys.size(); ++i) {
                JSONObject jsonObject = entrys.getJSONObject(i);
                this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("busitriptype", (Object)jsonObject.getJSONObject("busitriptype").getLong("id"), i);
                JSONObject to = jsonObject.getJSONObject("to");
                JSONObject from = jsonObject.getJSONObject("from");
                this.getModel().setValue("to", (Object)(to != null ? to.getLong("id") : null), i);
                this.getModel().setValue("from", (Object)(from != null ? from.getLong("id") : null), i);
                this.getModel().setValue("startdate", (Object)jsonObject.getDate("startdate"), i);
                this.getModel().setValue("enddate", (Object)jsonObject.getDate("enddate"), i);
                this.getModel().setValue("owndate", (Object)jsonObject.getDate("owndate"), i);
                this.getModel().setValue("startdatestr", (Object)jsonObject.getString("startdatestr"), i);
                this.getModel().setValue("enddatestr", (Object)jsonObject.getString("enddatestr"), i);
                this.getModel().setValue("startmethod", (Object)jsonObject.getString("startmethod"), i);
                this.getModel().setValue("endmethod", (Object)jsonObject.getString("endmethod"), i);
                this.getModel().setValue("enclosuremode", (Object)jsonObject.getString("enclosuremode"), i);
                this.getModel().setValue("triptime", (Object)jsonObject.getBigDecimal("triptime"), i);
                this.getModel().setValue("efftctime", (Object)jsonObject.getBigDecimal("efftctime"), i);
                this.getModel().setValue("unit", (Object)jsonObject.getString("unit"), i);
                this.getModel().setValue("entryparentid", (Object)jsonObject.getLong("id"), i);
                JSONObject tool = jsonObject.getJSONObject("traveltool");
                long toolId = tool != null ? tool.getLong("masterid") : 0L;
                this.getModel().setValue("traveltool", (Object)toolId, i);
                OrmLocaleValue ormLocaleValue = (OrmLocaleValue)this.getModel().getValue("tripresontex", i);
                JSONObject reasonJson = jsonObject.getJSONObject("tripresontex");
                BusiTripBillUtil.setLangValue((JSONObject)reasonJson, (OrmLocaleValue)ormLocaleValue);
                OrmLocaleValue strApplyTimeValue = (OrmLocaleValue)this.getModel().getValue("strapplytime", i);
                JSONObject strApplyTimeJson = jsonObject.getJSONObject("strapplytime");
                BusiTripBillUtil.setLangValue((JSONObject)strApplyTimeJson, (OrmLocaleValue)strApplyTimeValue);
                if (parentDy != null && parentDy.containsProperty("entryentity") && WTCCollections.isNotEmpty((Collection)parentDy.getDynamicObjectCollection("entryentity")) && parentDy.getDynamicObjectCollection("entryentity").size() > i) {
                    DynamicObjectCollection entryEntity = parentDy.getDynamicObjectCollection("entryentity");
                    DynamicObjectCollection targetEntry = this.getModel().getEntryEntity("entryentity");
                    if (WTCCollections.isNotEmpty((Collection)targetEntry) && targetEntry.size() > i) {
                        BillCommonService.writeInfo2Model((DynamicObject)((DynamicObject)entryEntity.get(i)), (DynamicObject)((DynamicObject)targetEntry.get(i)));
                    }
                }
                TpInfoParameterParam tpInfoParameterParam = new TpInfoParameterParam(this.getView(), jsonObject, i);
                WTCPluginProxy hrPluginProxy = WTCPluginProxyFactory.create(TpInfoExpService.class, (String)"kd.sdk.wtc.wtam.business.tp.TpInfoExpService");
                hrPluginProxy.invokeReplace(hrPlugin -> {
                    LOG.info("\u3010\u4e8c\u5f00\u57cb\u70b9\u3011\u51fa\u5dee\u4fe1\u606f\u6269\u5c55\u65b9\u6cd5\u8c03\u7528\u53d8\u66f4\u5355\u8d4b\u503c\u4e8b\u4ef6\u5f00\u59cb,\u8c03\u7528\u6269\u5c55\u7c7b\uff1a{}", (Object)hrPlugin.getClass().getName());
                    hrPlugin.setChangeTpInfoValue(tpInfoParameterParam);
                });
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (dataEntity != null) {
            IDataEntityProperty fieldIsNotTrip = (IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)"isnottrip");
            dataEntity.getDataEntityState().setBizChanged(fieldIsNotTrip.getOrdinal(), false);
        }
    }

    public void pageRelease(EventObject evt) {
        super.pageRelease(evt);
        Map map = (Map)this.getView().getFormShowParameter().getCustomParam("wtam_busitripbill");
        if (map != null) {
            DataMutex dataMutex = DataMutex.create();
            Long parentId = (Long)map.get("parent");
            dataMutex.release(parentId.toString(), "wtam_busitripbill", "change");
        }
    }
}

