/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.formplugin.web.busitripbill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtam.business.busitrip.BusiTripBillKDStringHelper;
import kd.wtc.wtbs.business.bill.WtcTimeRangeControlService;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.evaluation.EvaluationServiceHelper;
import kd.wtc.wtbs.common.bill.ApplyTimeTypeParam;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeEventEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeTypeEnum;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.shift.RefDateType;
import kd.wtc.wtbs.common.model.wtctimerange.WtcTimeRangeArgsModel;
import kd.wtc.wtbs.common.model.wtctimerange.WtcTimeRangeModel;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class BusiTripInfoCustomPlugin
extends HRDynamicFormBasePlugin {
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
    private static final Log LOG = LogFactory.getLog(BusiTripInfoCustomPlugin.class);

    public void beforeBindData(EventObject e) {
        CustomControl customControl = (CustomControl)this.getView().getControl("wtctimerange");
        WtcTimeRangeModel wtcTimeRangeModel = null;
        JSONObject map = (JSONObject)this.getView().getFormShowParameter().getCustomParam("editentry");
        if (map != null) {
            JSONObject customParam = map.getJSONObject("editentry");
            int startMethod = customParam.getInteger("startmethod");
            int endMethod = customParam.getInteger("endmethod");
            String startDateStr = customParam.getString("startdate");
            String endDateStr = customParam.getString("enddate");
            wtcTimeRangeModel = this.initWtcTimeRangeModel(startDateStr, endDateStr, startMethod, endMethod);
        } else {
            wtcTimeRangeModel = new WtcTimeRangeModel();
            wtcTimeRangeModel.setEvent(WtcTimeRangeEventEnum.INIT.value);
            WtcTimeRangeArgsModel wtcTimeRangeArgsModel = new WtcTimeRangeArgsModel();
            wtcTimeRangeArgsModel.setType(WtcTimeRangeTypeEnum.EDIT.value);
            wtcTimeRangeArgsModel.setStartMethod(WtcTimeRangeBtnTypeEnum.DAY.code);
            wtcTimeRangeArgsModel.setEndMethod(WtcTimeRangeBtnTypeEnum.DAY.code);
            ArrayList<Object> dates = new ArrayList<Object>();
            dates.add(null);
            dates.add(null);
            wtcTimeRangeArgsModel.setDate(dates);
            wtcTimeRangeModel.setArgs(wtcTimeRangeArgsModel);
        }
        if (wtcTimeRangeModel != null) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            long attFileBoId = dataEntity.getLong("attfile");
            Date startTime = dataEntity.getDate("startdate");
            Date endTime = dataEntity.getDate("enddate");
            WtcTimeRangeArgsModel args = wtcTimeRangeModel.getArgs();
            if (args == null) {
                args = new WtcTimeRangeArgsModel();
            }
            long baseDataId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dataEntity, (String)"busitriptype");
            ApplyTimeTypeParam query = new ApplyTimeTypeParam();
            query.setEntity("wtbd_traveltype");
            query.setApplyTimeTypeField("applytimetype");
            query.setJumpStepField("jumpstep");
            query.setTypeId(Long.valueOf(baseDataId));
            query.setAttFileBoId(attFileBoId);
            query.setOriStartTime(startTime);
            query.setOriEndTime(endTime);
            query.setOriStartBtnTypeEnum(WtcTimeRangeBtnTypeEnum.getEnumByCode((int)args.getStartMethod()));
            query.setOriEndBtnTypeEnum(WtcTimeRangeBtnTypeEnum.getEnumByCode((int)args.getEndMethod()));
            WtcTimeRangeControlService rangeControlService = WtcTimeRangeControlService.getInstance();
            query.setDisableTip(rangeControlService.getDisableTip(BillTypeEnum.EVECTIONBILL.getBillName()));
            rangeControlService.setApplyTimeTypeData(query, args);
            customControl.setData((Object)wtcTimeRangeModel);
        }
    }

    private WtcTimeRangeModel initWtcTimeRangeModel(String startDateStr, String endDateStr, int startMethod, int endMethod) {
        WtcTimeRangeModel wtcTimeRangeModel = new WtcTimeRangeModel();
        WtcTimeRangeArgsModel args = new WtcTimeRangeArgsModel();
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
            args.setType(WtcTimeRangeTypeEnum.VIEW.value);
        } else {
            args.setType(WtcTimeRangeTypeEnum.EDIT.value);
        }
        ArrayList<String> dates = new ArrayList<String>();
        args.setStartMethod(startMethod);
        args.setEndMethod(endMethod);
        dates.add(startDateStr);
        dates.add(endDateStr);
        args.setDate(dates);
        wtcTimeRangeModel.setEvent(WtcTimeRangeEventEnum.INIT.value);
        wtcTimeRangeModel.setArgs(args);
        return wtcTimeRangeModel;
    }

    public void customEvent(CustomEventArgs args) {
        String key = args.getEventName();
        String eventArgs = args.getEventArgs();
        if (StringUtils.equals((CharSequence)key, (CharSequence)WtcTimeRangeEventEnum.RANGE_CHANGE.value)) {
            WtcTimeRangeArgsModel timeRangeArgsModel = (WtcTimeRangeArgsModel)JSONObject.parseObject((String)eventArgs, WtcTimeRangeArgsModel.class);
            List dates = timeRangeArgsModel.getDate();
            int startMethod = timeRangeArgsModel.getStartMethod();
            int endMethod = timeRangeArgsModel.getEndMethod();
            String startDateStr = (String)dates.get(0);
            String endDateStr = (String)dates.get(1);
            this.getModel().setValue("startdate", null);
            this.getModel().setValue("enddate", null);
            Date startDate = null;
            Date endDate = null;
            if (HRStringUtils.isNotEmpty((String)startDateStr) && HRStringUtils.isNotEmpty((String)endDateStr)) {
                if (!(startMethod != 0 && startMethod != 1 || endMethod != 0 && endMethod != 1)) {
                    try {
                        startDate = this.simpleDateFormat2.parse(startDateStr);
                        endDate = this.simpleDateFormat2.parse(endDateStr);
                        String starttimeAreaStr = startMethod == 0 ? BusiTripBillKDStringHelper.dayUp() : BusiTripBillKDStringHelper.dayDown();
                        String endtimeAreaStr = endMethod == 0 ? BusiTripBillKDStringHelper.dayUp() : BusiTripBillKDStringHelper.dayDown();
                        startDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startDate);
                        endDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endDate);
                        startDateStr = startDateStr + starttimeAreaStr;
                        endDateStr = endDateStr + endtimeAreaStr;
                    }
                    catch (ParseException e) {
                        LOG.warn("\u81ea\u5b9a\u4e49\u63a7\u4ef6\u4ea4\u4e92\u9519\u8bef\u3002");
                    }
                } else if (startMethod == 2 && endMethod == 2) {
                    try {
                        startDate = this.simpleDateFormat2.parse(startDateStr);
                        endDate = this.simpleDateFormat2.parse(endDateStr);
                        startDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startDate);
                        endDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endDate);
                    }
                    catch (ParseException e) {
                        LOG.warn("\u81ea\u5b9a\u4e49\u63a7\u4ef6\u4ea4\u4e92\u9519\u8bef\u3002");
                    }
                } else if (startMethod == 3 && endMethod == 3) {
                    try {
                        startDate = this.simpleDateFormat.parse(startDateStr);
                        endDate = this.simpleDateFormat.parse(endDateStr);
                        startDateStr = WTCInteDateUtil.formatBySysTzAndUserFmt((Date)startDate);
                        endDateStr = WTCInteDateUtil.formatBySysTzAndUserFmt((Date)endDate);
                    }
                    catch (ParseException e) {
                        LOG.warn("\u81ea\u5b9a\u4e49\u63a7\u4ef6\u4ea4\u4e92\u9519\u8bef\u3002");
                    }
                }
                this.getModel().setValue("startmethod", (Object)String.valueOf(startMethod));
                this.getModel().setValue("endmethod", (Object)String.valueOf(endMethod));
                this.getModel().setValue("startdate", (Object)startDate);
                this.getModel().setValue("enddate", (Object)endDate);
                this.getModel().setValue("startdatestr", (Object)startDateStr);
                this.getModel().setValue("enddatestr", (Object)endDateStr);
            }
        } else if (StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{WtcTimeRangeEventEnum.SET_CHOOSE_TIME.value})) {
            this.customEventOfChooseTime(eventArgs);
        }
    }

    private void customEventOfChooseTime(String eventArgs) {
        Date startDate;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        ArrayList attFileBaseBoIds = Lists.newArrayList((Object[])new Long[]{dataEntity.getLong("attfile")});
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        String rosterDateStr = jsonObject.getString("date");
        if (StringUtils.isNotEmpty((CharSequence)rosterDateStr) && rosterDateStr.trim().length() >= 10) {
            rosterDateStr = rosterDateStr.trim().substring(0, 10);
            try {
                startDate = WTCDateUtils.parseDate((String)rosterDateStr, (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                LOG.warn("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01{}", (Object)rosterDateStr);
                return;
            }
        } else {
            LOG.info("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e.");
            return;
        }
        Date endDate = startDate;
        DutyShiftResponse shiftResponse = EvaluationServiceHelper.getDutyShiftsByAttFileBoId((List)attFileBaseBoIds, (Date)startDate, (Date)endDate);
        Shift shift = shiftResponse.getCurrShiftHis(Long.valueOf(dataEntity.getLong("attfile")), startDate).orElse(null);
        if (shift != null) {
            String endDateStr;
            String startDateStr;
            boolean offNonPlan = shift.getOffNonPlan();
            if (offNonPlan) {
                startDateStr = WTCDateUtils.date2Str((Date)startDate, (String)"yyyy-MM-dd") + " 00:00:00";
                endDateStr = WTCDateUtils.date2Str((Date)startDate, (String)"yyyy-MM-dd") + " 23:59:00";
            } else {
                startDate = WTCDateUtils.getDate((Date)startDate, (Integer)shift.getLastShiftStartDate());
                if (StringUtils.equals((CharSequence)RefDateType.NEXTDAY.code, (CharSequence)shift.getLastRefEndDay())) {
                    endDate = WTCDateUtils.addDays((Date)endDate, (int)1);
                }
                endDate = WTCDateUtils.getDate((Date)endDate, (Integer)shift.getLastShiftEndDate());
                startDateStr = WTCDateUtils.date2Str((Date)startDate, (String)"yyyy-MM-dd HH:mm:ss");
                endDateStr = WTCDateUtils.date2Str((Date)endDate, (String)"yyyy-MM-dd HH:mm:ss");
            }
            HashMap returnMap = Maps.newHashMap();
            returnMap.put("event", WtcTimeRangeEventEnum.CHOOSE_TIME_RESPONSE.value);
            returnMap.put("timestamp", System.currentTimeMillis());
            returnMap.put("type", jsonObject.getString("type"));
            returnMap.put("owndate", rosterDateStr);
            ArrayList argsList = Lists.newArrayList((Object[])new String[]{startDateStr, endDateStr});
            returnMap.put("args", argsList);
            CustomControl customControl = (CustomControl)this.getView().getControl("wtctimerange");
            customControl.setData((Object)returnMap);
        } else {
            LOG.info("\u6839\u636e\u65e5\u671f\u672a\u67e5\u8be2\u5230\u6392\u73ed\uff1astartDate\uff1a{},attFileBaseBoIds:{}", (Object)startDate, (Object)attFileBaseBoIds);
        }
    }
}

