/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.formplugin.web.busitripbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.MainDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.datasource.WorkflowDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.AfterLoadDataEvent;
import kd.bos.print.core.plugin.event.BeforeLoadDataEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class BusiTripPrintPlugin
extends AbstractPrintPlugin {
    private static HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtam_busibillchange");
    private static final Map<String, String> BILLSTATUSNAMEMAP = new HashMap<String, String>(16);
    private static final Map<String, String> UNITNAMEMAP = new HashMap<String, String>(16);
    private static final String POSITION_NAME = "attfile.position.name";
    private static final String JOB_NAME = "attfile.job.name";

    public void beforeLoadData(BeforeLoadDataEvent evt) {
        block8: {
            PrtDataSource dataSource;
            block6: {
                String applyType;
                WorkflowDataSource workflowDataSource;
                block7: {
                    super.beforeLoadData(evt);
                    dataSource = evt.getDataSource();
                    if (!(dataSource instanceof WorkflowDataSource)) break block6;
                    workflowDataSource = (WorkflowDataSource)dataSource;
                    String businessKey = workflowDataSource.getBusinessKey();
                    if (HRStringUtils.isEmpty((String)businessKey) || "0".equals(businessKey)) {
                        return;
                    }
                    long pkId = Long.parseLong(businessKey);
                    DynamicObject dynamicObject = this.loadById(pkId);
                    boolean isChange = dynamicObject.getBoolean("ischange");
                    applyType = dynamicObject.getString("applytyperadio");
                    if (!isChange) break block7;
                    if ("0".equals(applyType)) {
                        workflowDataSource.setFormId("wtam_busiselfbillchange");
                    } else {
                        workflowDataSource.setFormId("wtam_busibillchange");
                    }
                    break block8;
                }
                if (!"0".equals(applyType)) break block8;
                workflowDataSource.setFormId("wtam_busitripselfbill");
                break block8;
            }
            if (dataSource instanceof MainDataSource) {
                MainDataSource mainDataSource = (MainDataSource)dataSource;
                List prtDataSourceList = mainDataSource.getChildrenDs();
                for (PrtDataSource prtDataSource : prtDataSourceList) {
                    String dsName = prtDataSource.getDsName();
                    if (!dsName.contains("entryentity")) continue;
                    List queryField = prtDataSource.getQueryField();
                    if (!queryField.contains("startdatestr")) {
                        prtDataSource.addField("startdatestr");
                    }
                    if (queryField.contains("enddatestr")) continue;
                    prtDataSource.addField("enddatestr");
                }
            }
        }
    }

    public void afterLoadData(AfterLoadDataEvent evt) {
        super.afterLoadData(evt);
        PrtDataSource dataSource = evt.getDataSource();
        if (dataSource instanceof MainDataSource) {
            List dataRowSets = evt.getDataRowSets();
            for (DataRowSet dataRowSet : dataRowSets) {
                this.resetPositionJob(dataRowSet);
            }
        }
    }

    public void loadCustomData(CustomDataLoadEvent evt) {
        DataRowSet mainDataRow;
        boolean isChange;
        super.loadCustomData(evt);
        String dsName = evt.getDataSource().getDsName();
        if ("billchangehis".equals(dsName) && (isChange = Boolean.parseBoolean((String)(mainDataRow = evt.getDataSource().getMainDataRow()).getField("ischange").getValue()))) {
            long pkId = (Long)evt.getDataSource().getPkId();
            List customDataRows = evt.getCustomDataRows();
            this.loadBillChangeList(pkId, customDataRows);
        }
    }

    private void resetPositionJob(DataRowSet mainDataRow) {
        Field positionField = mainDataRow.getField(POSITION_NAME);
        String position = (String)positionField.getValue();
        Field jobField = mainDataRow.getField(JOB_NAME);
        String job = (String)jobField.getValue();
        String format = HRStringUtils.isNotEmpty((String)position) && HRStringUtils.isNotEmpty((String)job) ? position + "/" + job : (HRStringUtils.isNotEmpty((String)position) ? position : job);
        mainDataRow.put(POSITION_NAME, (Field)new TextField(format));
        Field entryentity = mainDataRow.getField("entryentity");
        if (entryentity instanceof NullField) {
            return;
        }
        List dataRowSets = (List)entryentity.getValue();
        if (CollectionUtils.isNotEmpty((Collection)dataRowSets)) {
            for (DataRowSet dataRowSet : dataRowSets) {
                Field endDate;
                Field startDate = dataRowSet.getField("startdatestr");
                if (!(startDate instanceof NullField)) {
                    dataRowSet.put("startdate", startDate);
                }
                if ((endDate = dataRowSet.getField("enddatestr")) instanceof NullField) continue;
                dataRowSet.put("enddate", endDate);
            }
        }
    }

    public void loadBillChangeList(long pkId, List<DataRowSet> customDataRows) {
        ArrayList<DynamicObject> tripChangeList = new ArrayList<DynamicObject>(16);
        this.getTripChangeList(tripChangeList, pkId);
        String changeDesc = ResManager.loadKDString((String)"\u7b2c%s\u6b21\u53d8\u66f4", (String)"BusiTripListChangeProvider_0", (String)"wtc-wtam-formplugin", (Object[])new Object[0]);
        String originalDesc = ResManager.loadKDString((String)"\u539f\u5355\u4fe1\u606f", (String)"BusiTripListChangeProvider_1", (String)"wtc-wtam-formplugin", (Object[])new Object[0]);
        int index = tripChangeList.size() - 1;
        for (DynamicObject tripBill : tripChangeList) {
            String changeInfoDesc = index == 0 ? originalDesc : String.format(Locale.ROOT, changeDesc, index);
            String billStatusName = BILLSTATUSNAMEMAP.get(tripBill.getString("billstatus"));
            String billNo = tripBill.getString("billno");
            for (DynamicObject tripBillDetail : tripBill.getDynamicObjectCollection("entryentity")) {
                DataRowSet dataRowSet = new DataRowSet();
                dataRowSet.put("changeinfo", (Field)new TextField(changeInfoDesc));
                dataRowSet.put("billstatus", (Field)new TextField(billStatusName));
                dataRowSet.put("billno", (Field)new TextField(billNo));
                String startDate = tripBillDetail.getString("startdatestr");
                dataRowSet.put("startdate", (Field)new TextField(startDate));
                String endDate = tripBillDetail.getString("enddatestr");
                dataRowSet.put("enddate", (Field)new TextField(endDate));
                BigDecimal tripTime = tripBillDetail.getBigDecimal("triptime");
                String tripTimeStr = tripTime.setScale(2, RoundingMode.HALF_UP).toPlainString();
                dataRowSet.put("triptime", (Field)new TextField(tripTimeStr));
                String unit = UNITNAMEMAP.get(tripBillDetail.getString("unit"));
                dataRowSet.put("unit", (Field)new TextField(unit));
                customDataRows.add(dataRowSet);
            }
            --index;
        }
    }

    private void getTripChangeList(List<DynamicObject> tripChangeList, long pkId) {
        DynamicObject parentDynamicObject = this.loadById(pkId);
        tripChangeList.add(parentDynamicObject);
        boolean isChange = parentDynamicObject.getBoolean("ischange");
        if (isChange) {
            Long id = parentDynamicObject.getLong("parent");
            this.getTripChangeList(tripChangeList, id);
        }
    }

    private DynamicObject loadById(long pkId) {
        return serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)pkId));
    }

    static {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"wtam_busibillchange");
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        BillStatusProp billStatusProp = (BillStatusProp)properties.get((Object)"billstatus");
        List statusItems = billStatusProp.getStatusItems();
        for (BillStatusProp.StatusItemPro statusItemPro : statusItems) {
            BILLSTATUSNAMEMAP.put(statusItemPro.getStatusKey(), statusItemPro.getStatusName().getLocaleValue());
        }
        EntryProp entryProp = (EntryProp)properties.get((Object)"entryentity");
        DataEntityPropertyCollection entryProperties = entryProp.getItemType().getProperties();
        ComboProp property = (ComboProp)entryProperties.get((Object)"unit");
        List comboItems = property.getComboItems();
        for (ValueMapItem valueMapItem : comboItems) {
            UNITNAMEMAP.put(valueMapItem.getValue(), valueMapItem.getName().getLocaleValue());
        }
    }
}

