/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.formplugin.web.busitripbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtam.business.busitrip.BusiTripBillKDStringHelper;
import kd.wtc.wtam.formplugin.web.busitripbill.BusiTripCommonService;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class BusiTripSelfBillList
extends HRDataBaseList {
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        OperateOption option = operate.getOption();
        option.setVariableValue("list_op", "1");
        String operateKey = operate.getOperateKey();
        if (operateKey.equals("submit") || operateKey.equals("unsubmit")) {
            this.jumpToChangePageStream(args, operateKey, operate);
        } else if ("viewflowchart".equals(operateKey)) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            List selectRowIds = listSelectedData.stream().map(item -> (Long)item.getPrimaryKeyValue()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(selectRowIds) && selectRowIds.size() > 1) {
                return;
            }
            String entityId = operate.getEntityId();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityId);
            DynamicObject dy = serviceHelper.queryOne(selectRowIds.get(0));
            if (dy.getBoolean("ischange")) {
                operate.setEntityId("wtam_busiselfbillchange");
            }
        } else if ("change".equals(operateKey)) {
            new BusiTripCommonService().jumpToChangePage(args, this.getView());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        boolean success = false;
        if (operationResult != null) {
            success = operationResult.isSuccess();
        }
        if (success && "change".equals(operateKey)) {
            new BusiTripCommonService().showChangeView(afterDoOperationEventArgs, this.getView(), (IFormPlugin)this);
        }
    }

    private void jumpToChangePageStream(BeforeDoOperationEventArgs args, String operateKey, FormOperate operate) {
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        List selectRowIds = listSelectedData.stream().map(item -> (Long)item.getPrimaryKeyValue()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", selectRowIds);
        String properties = String.join((CharSequence)",", "ischange", "billno");
        ArrayList bgList = Lists.newArrayListWithExpectedSize((int)selectRowIds.size());
        ArrayList tgList = Lists.newArrayListWithExpectedSize((int)selectRowIds.size());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtam_busitripbill");
        DynamicObject[] dynamicObjects = serviceHelper.query(properties, new QFilter[]{qFilter});
        Arrays.stream(dynamicObjects).forEachOrdered(dyn -> {
            if (dyn.getBoolean("ischange")) {
                bgList.add(dyn);
            } else {
                tgList.add(dyn);
            }
        });
        if (!bgList.isEmpty() && !tgList.isEmpty()) {
            String tipsMessage = this.getTipsMessage(operateKey);
            this.getView().showTipNotification(tipsMessage);
            args.setCancel(true);
            return;
        }
        if (!bgList.isEmpty()) {
            operate.setEntityId("wtam_busiselfbillchange");
        }
    }

    private String getTipsMessage(String operateKey) {
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit")) {
            return BusiTripBillKDStringHelper.submit();
        }
        return BusiTripBillKDStringHelper.unSubmit();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        if (billlistap != null) {
            billlistap.refresh();
            billlistap.clearSelection();
        }
    }
}

