/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.formplugin.web.busitripbill;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.sdk.wtc.wtam.business.tp.TpInfoExpService;
import kd.sdk.wtc.wtam.business.tp.TpInfoParameterParam;
import kd.wtc.wtam.business.busitrip.TripBillStyleService;
import kd.wtc.wtam.business.busitripmobile.BusiTripBillUtil;
import kd.wtc.wtam.common.model.BusiTimeTypeEnum;
import kd.wtc.wtam.formplugin.web.busitripbill.BusiTripBillEdit;
import kd.wtc.wtbs.business.bill.BillStyleService;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.enums.bill.BillOpenStyleEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class BusiTripStylePlugin
extends BusiTripBillEdit {
    public static final String BACK_ID = "back";
    public static final String FORCE_CLOSE = "force_close";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        boolean formChange = this.getModel().getDataEntity().getBoolean("isChange");
        boolean selfApply = BillApplyTypeEnum.SELF.getCode().equals(this.getModel().getValue("applytyperadio"));
        boolean sysSingleStyle = BillStyleService.getInstance().sysSingleStyle(BillTypeEnum.EVECTIONBILL);
        if (!formChange && selfApply && sysSingleStyle) {
            this.getModel().setValue("billstyle", (Object)BillOpenStyleEnum.SINGLE.getCode());
        }
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
            this.getView().getPageCache().put(FORCE_CLOSE, "1");
        } else {
            this.getView().getPageCache().put(FORCE_CLOSE, "0");
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
            this.getView().getPageCache().put(FORCE_CLOSE, "1");
        } else {
            this.getView().getPageCache().put(FORCE_CLOSE, "0");
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.checkSingleTripInfoDateChanged(e);
    }

    @Override
    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        if (TripBillStyleService.singleStyle((DynamicObject)this.getModel().getDataEntity(true))) {
            Boolean isChange = this.getModel().getDataEntity().getBoolean("ischange");
            Object value = this.getModel().getValue("treatmethodgroup");
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if ("1".equals(value) && Boolean.TRUE.equals(isChange)) {
                this.getView().setStatus(OperationStatus.VIEW);
            }
            TripBillStyleService.getInstance().handleSingleStyle(this.getView(), "wtam_singlebusitripinfo");
            this.getView().setStatus(status);
        }
        this.getModel().setDataChanged(false);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        super.propertyChanged(args);
        switch (name = args.getProperty().getName()) {
            case "attfile": {
                if (!TripBillStyleService.singleStyle((DynamicObject)this.getModel().getDataEntity(true))) break;
                DynamicObjectCollection entryColl = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
                entryColl.clear();
                TripBillStyleService.getInstance().handleSingleStyle(this.getView(), "wtam_singlebusitripinfo");
                break;
            }
            case "treatmethodgroup": {
                this.updateTripInfoLock();
                break;
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String operateKey;
        FormOperate operate = (FormOperate)evt.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": 
            case "submit": 
            case "submiteffect": {
                this.getView().getPageCache().put(FORCE_CLOSE, "1");
                if (!TripBillStyleService.singleStyle((DynamicObject)this.getModel().getDataEntity(true)) || this.checkChildPageSave(evt.getSource())) break;
                evt.setCancel(true);
                return;
            }
        }
        super.beforeDoOperation(evt);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        OperationResult opResult = evt.getOperationResult();
        String opKey = evt.getOperateKey();
        if (TripBillStyleService.singleStyle((DynamicObject)this.getModel().getDataEntity(true)) && TripBillStyleService.REFRESH_OP.contains(opKey) && opResult != null && opResult.isSuccess()) {
            TripBillStyleService.getInstance().failureFlushSingleFlex(this.getView(), "wtam_singlebusitripinfo", this.getView().getFormShowParameter().getStatus(), false);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes.equals((Object)result) && BACK_ID.equals(messageBoxClosedEvent.getCallBackId())) {
            this.getView().getPageCache().put(FORCE_CLOSE, "1");
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    private boolean checkChildPageSave(Object eventSource) {
        boolean opResult = true;
        String childPageId = this.getView().getPageCache().get("tripInfoPageId");
        if (WTCStringUtils.isNotEmpty((String)childPageId) && !BusiTripBillUtil.checkBillAllDisuse((DynamicObject)this.getModel().getDataEntity(true))) {
            OperationResult childComfResult;
            IFormView childPage = this.getView().getView(childPageId);
            if (childPage == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b50\u9875\u9762\u5f02\u5e38\u5173\u95ed\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BusiTripStylePlugin_0", (String)"wtc-wtam-formplugin", (Object[])new Object[0]));
            }
            try {
                childComfResult = childPage.invokeOperation("comf");
            }
            catch (Exception e) {
                LOG.warn("invokeSinglePageOperation.fail,error:{}", (Object)e.getMessage());
                throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"BusiTripStylePlugin_4", (String)"wtc-wtam-formplugin", (Object[])new Object[0]));
            }
            if (!childComfResult.isSuccess()) {
                if (WTCCollections.isNotEmpty((Collection)childComfResult.getAllErrorOrValidateInfo())) {
                    this.getView().showTipNotification(((IOperateInfo)childComfResult.getAllErrorOrValidateInfo().get(0)).getMessage());
                }
                opResult = false;
            } else {
                DynamicObject tripInfo = childPage.getModel().getDataEntity();
                int rowIndex = 0;
                if (tripInfo != null) {
                    try {
                        TripBillStyleService.writeTripInfoToPage((DynamicObject)tripInfo, (IFormView)this.getView());
                    }
                    catch (Exception e) {
                        LOG.warn("BusiTripStylePlugin.writeTripInfoToPageFail.error:{}", (Object)e.getMessage());
                        throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u56de\u5199\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BusiTripStylePlugin_1", (String)"wtc-wtam-formplugin", (Object[])new Object[0]));
                    }
                    this.setBusiTripSys();
                    this.setAttachMustInput();
                    ++rowIndex;
                }
                ClosedCallBackEvent fakeCloseCallBackEvent = new ClosedCallBackEvent(eventSource, "newentry", (Object)tripInfo);
                TpInfoParameterParam tpInfoParameterParam = new TpInfoParameterParam(rowIndex, this.getView(), fakeCloseCallBackEvent);
                WTCPluginProxy hrPluginProxy = WTCPluginProxyFactory.create(TpInfoExpService.class, (String)"kd.sdk.wtc.wtam.business.tp.TpInfoExpService");
                hrPluginProxy.invokeReplace(hrPlugin -> {
                    LOG.info("\u3010\u4e8c\u5f00\u57cb\u70b9\u3011\u51fa\u5dee\u4fe1\u606f\u6269\u5c55\u65b9\u6cd5\u8c03\u7528\u56de\u8c03\u4e8b\u4ef6\u5f00\u59cb,\u8c03\u7528\u6269\u5c55\u7c7b\uff1a{}", (Object)hrPlugin.getClass().getName());
                    hrPlugin.onCallBackTpInfo(tpInfoParameterParam);
                });
            }
        }
        return opResult;
    }

    private void updateTripInfoLock() {
        if (this.getView() == null) {
            return;
        }
        Object value = this.getModel().getValue("treatmethodgroup");
        String childPageId = this.getView().getPageCache().get("CACHE_SINGLE_FLEX_PAGE_ID");
        IFormView singleTripInfoPage = this.getView().getView(childPageId);
        if (singleTripInfoPage == null) {
            return;
        }
        if ("1".equals(value)) {
            TripBillStyleService.getInstance().failureFlushSingleFlex(this.getView(), "wtam_singlebusitripinfo", OperationStatus.VIEW, true);
            this.setBusiTripSys();
        } else {
            OperationStatus childStatus = OperationStatus.EDIT;
            DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            if (entryEntity != null && !entryEntity.isEmpty()) {
                String strApplyTime = ((DynamicObject)entryEntity.get(0)).getBigDecimal("triptime").toPlainString();
                singleTripInfoPage.getModel().setValue("triptime", (Object)((DynamicObject)entryEntity.get(0)).getBigDecimal("triptime"));
                String unitCode = ((DynamicObject)entryEntity.get(0)).getString("unit");
                if (BusiTimeTypeEnum.HOUR.getCode().equals(unitCode)) {
                    strApplyTime = strApplyTime + BusiTimeTypeEnum.HOUR.getDescription();
                } else if (BusiTimeTypeEnum.DAY.getCode().equals(unitCode)) {
                    strApplyTime = strApplyTime + BusiTimeTypeEnum.DAY.getDescription();
                }
                singleTripInfoPage.getModel().setValue("strapplytime", (Object)strApplyTime);
            }
            TripBillStyleService.getInstance().changeSingleFlexStatus(singleTripInfoPage, childStatus);
            this.getView().sendFormAction(singleTripInfoPage);
        }
    }

    private void checkSingleTripInfoDateChanged(BeforeClosedEvent evt) {
        if (TripBillStyleService.singleStyle((DynamicObject)this.getModel().getDataEntity()) && !"1".equals(this.getView().getPageCache().get(FORCE_CLOSE))) {
            String singlePageId = this.getPageCache().get("CACHE_SINGLE_FLEX_PAGE_ID");
            IFormView singleView = this.getView().getView(singlePageId);
            if (singleView != null) {
                String changeDesc;
                boolean singleTripInfoDateChanged;
                try {
                    singleTripInfoDateChanged = singleView.getModel().getDataChanged();
                }
                catch (KDException e) {
                    return;
                }
                if (singleTripInfoDateChanged && WTCStringUtils.isNotEmpty((String)(changeDesc = singleView.getModel().getChangeDesc()))) {
                    this.showDateChangeNotifyAndCancelClose(evt, changeDesc);
                }
            }
        }
    }

    private void showDateChangeNotifyAndCancelClose(BeforeClosedEvent evt, String changeDesc) {
        HashMap btnNameMaps = Maps.newHashMapWithExpectedSize((int)2);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"BusiTripStylePlugin_5", (String)"wtc-wtam-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"BusiTripStylePlugin_6", (String)"wtc-wtam-formplugin", (Object[])new Object[0]));
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(BACK_ID, (IFormPlugin)this);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String changeMsg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f", (String)"BusiTripStylePlugin_2", (String)"wtc-wtam-formplugin", (Object[])new Object[0]);
        changeMsg = changeMsg + "\r\n";
        changeMsg = changeMsg + ResManager.loadKDString((String)"\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"BusiTripStylePlugin_3", (String)"wtc-wtam-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(changeMsg, changeDesc, options, ConfirmTypes.Save, confirmCallBackListener, (Map)btnNameMaps);
        evt.setCancel(true);
    }
}

