/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.business.busitrip;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtam.business.busitrip.BusiTripBillKDStringHelper;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;

public class BusiTripBillImportService {
    private SimpleDateFormat longSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private SimpleDateFormat sortSdf = new SimpleDateFormat("yyyy-MM-dd");

    public String checkEntry(DynamicObject entry) {
        DynamicObject typeDy = entry.getDynamicObject("busitriptype");
        if (HRObjectUtils.isEmpty((Object)typeDy)) {
            return "";
        }
        String error = this.checkDateAndMethod(entry);
        if (HRStringUtils.isNotEmpty((String)error)) {
            return error;
        }
        Date startDate = this.TranDate(entry, "startdatestr");
        Date endDate = this.TranDate(entry, "enddatestr");
        if (startDate == null) {
            return BusiTripBillKDStringHelper.startDateTime();
        }
        if (endDate == null) {
            return BusiTripBillKDStringHelper.endDateTime();
        }
        String startMethod = entry.getString("startmethod");
        String endMethod = entry.getString("endmethod");
        if (HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.CUSTOM.value) && HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.CUSTOM.value) && startDate.getTime() == endDate.getTime()) {
            return BusiTripBillKDStringHelper.zeroTime();
        }
        if (startDate.getTime() > endDate.getTime()) {
            return BusiTripBillKDStringHelper.timeCheck();
        }
        entry.set("startdate", (Object)startDate);
        entry.set("enddate", (Object)endDate);
        return null;
    }

    private String checkDateAndMethod(DynamicObject entry) {
        String startMethod = entry.getString("startmethod");
        if (!this.isDate(entry, "startdatestr", startMethod)) {
            return BusiTripBillKDStringHelper.startDateTime();
        }
        String endMethod = entry.getString("endmethod");
        if (!this.isDate(entry, "enddatestr", endMethod)) {
            return BusiTripBillKDStringHelper.endDateTime();
        }
        if (HRStringUtils.isEmpty((String)startMethod)) {
            return BusiTripBillKDStringHelper.startMethodError();
        }
        boolean sortDate = this.isSortDate(entry, "startdatestr");
        if (HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) || HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value) || HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.DAY.value)) {
            if (!sortDate) {
                return BusiTripBillKDStringHelper.startSortDateTime();
            }
        } else if (sortDate) {
            return BusiTripBillKDStringHelper.startLongDateTime();
        }
        if (HRStringUtils.isEmpty((String)endMethod)) {
            return BusiTripBillKDStringHelper.endMethodError();
        }
        sortDate = this.isSortDate(entry, "enddatestr");
        if (HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) || HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value) || HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.DAY.value)) {
            if (!sortDate) {
                return BusiTripBillKDStringHelper.endSortDateTime();
            }
        } else if (sortDate) {
            return BusiTripBillKDStringHelper.endLongDateTime();
        }
        if (HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.DAY.value) && !HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.DAY.value)) {
            return BusiTripBillKDStringHelper.notDayMethod();
        }
        if (HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) && !HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) && !HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value)) {
            return BusiTripBillKDStringHelper.notDayUpMethod();
        }
        if (HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value)) {
            if (this.isAnotherDay(entry)) {
                if (!HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) && !HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value)) {
                    return BusiTripBillKDStringHelper.notDayDownMethod();
                }
            } else if (!HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value)) {
                return BusiTripBillKDStringHelper.notDayDownMethod2();
            }
        }
        if (HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.CUSTOM.value) && !HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.CUSTOM.value)) {
            return BusiTripBillKDStringHelper.notCustomMethod();
        }
        return null;
    }

    private boolean isDate(DynamicObject entry, String key, String method) {
        String dateStr = entry.getString(key);
        if (HRStringUtils.isEmpty((String)dateStr)) {
            return false;
        }
        boolean isCusTom = HRStringUtils.equals((String)method, (String)WtcTimeRangeBtnTypeEnum.CUSTOM.value);
        try {
            if (isCusTom) {
                this.longSdf.parse(dateStr);
            } else {
                this.sortSdf.parse(dateStr);
            }
        }
        catch (ParseException var10) {
            return false;
        }
        return true;
    }

    private boolean isSortDate(DynamicObject entry, String key) {
        String dateStr = entry.getString(key);
        try {
            this.sortSdf.parse(dateStr);
        }
        catch (ParseException var10) {
            return false;
        }
        String datePattern1 = "\\d{4}-\\d{2}-\\d{2}";
        Pattern pattern = Pattern.compile(datePattern1);
        Matcher match = pattern.matcher(dateStr);
        return match.matches();
    }

    private boolean isAnotherDay(DynamicObject entry) {
        try {
            Date start = this.sortSdf.parse(entry.getString("startdatestr"));
            Date end = this.sortSdf.parse(entry.getString("enddatestr"));
            if (start.getTime() < end.getTime()) {
                return true;
            }
        }
        catch (ParseException e) {
            return false;
        }
        return false;
    }

    private Date TranDate(DynamicObject entry, String key) {
        String dateStr = entry.getString(key);
        Date date = null;
        try {
            date = this.longSdf.parse(dateStr);
        }
        catch (ParseException var10) {
            try {
                date = this.sortSdf.parse(dateStr);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }
}

