/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.business.busitrip;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtam.business.busitrip.BusiTripBillKDStringHelper;
import kd.wtc.wtbs.common.enums.ApplyBillCheckMsgEnum;
import kd.wtc.wtbs.common.model.bill.BillSystemParam;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class BusiTripBillService {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("wtam_busitripbill");
    private static final BusiTripBillService INS = new BusiTripBillService();

    public static BusiTripBillService getInstance() {
        return INS;
    }

    public DynamicObject queryOne(Object pkId) {
        return HELPER.queryOne(pkId);
    }

    public Map<String, Object> genOriginDataMap(DynamicObject dynamicObject) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)8);
        DynamicObject person = dynamicObject.getDynamicObject("personid");
        DynamicObject attFileBo = dynamicObject.getDynamicObject("attfile");
        DynamicObject attFilebase = dynamicObject.getDynamicObject("attfilebasef7");
        if (dynamicObject.containsProperty("billstyle") && dynamicObject.get("billstyle") != null) {
            map.put("billstyle", dynamicObject.get("billstyle"));
        }
        long personId = person != null ? (Long)person.getPkValue() : 0L;
        long attFileBoId = attFileBo != null ? (Long)attFileBo.getPkValue() : 0L;
        long attFileId = attFilebase != null ? (Long)attFilebase.getPkValue() : 0L;
        DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("entryentity");
        DynamicObject org = dynamicObject.getDynamicObject("org");
        long orgId = 0L;
        if (org != null) {
            orgId = (Long)org.getPkValue();
        }
        map.put("personid", personId);
        map.put("attfile", attFileBoId);
        map.put("attfilebasef7", attFileId);
        map.put("org", orgId);
        map.put("isnottrip", dynamicObject.getBoolean("isnottrip"));
        map.put("parent", dynamicObject.getPkValue());
        map.put("entryentity", entrys);
        return map;
    }

    public String checkParamStr(String ... strs) {
        for (String str : strs) {
            if (!WTCStringUtils.isEmpty((String)str)) continue;
            return ApplyBillCheckMsgEnum.THERDATAERROR.getMsg();
        }
        return null;
    }

    public List<String> attachmeCheck(boolean attachmeMust, List<Map<String, Object>> attachmentData, BillSystemParam billSystemParam) {
        ArrayList errorList = Lists.newArrayListWithExpectedSize((int)4);
        if (attachmeMust && CollectionUtils.isEmpty(attachmentData)) {
            errorList.add(BusiTripBillKDStringHelper.notAttachme());
        } else if (attachmentData != null && !attachmentData.isEmpty()) {
            String attachmentFormat = billSystemParam.getAttachmentFormat();
            HashSet formatSet = Sets.newHashSetWithExpectedSize((int)20);
            if (HRStringUtils.isNotEmpty((String)attachmentFormat)) {
                String[] formatArr;
                for (String type : formatArr = attachmentFormat.split(",")) {
                    if (!HRStringUtils.isNotEmpty((String)type)) continue;
                    formatSet.add(type.toLowerCase());
                }
            }
            boolean passCapacity = false;
            HashSet typeSet = Sets.newHashSetWithExpectedSize((int)attachmentData.size());
            for (Map<String, Object> stringObjectMap : attachmentData) {
                String[] split;
                Object size = stringObjectMap.get("size");
                BigDecimal fileSize = BigDecimal.valueOf(Long.parseLong(size.toString())).divide(BigDecimal.valueOf(0x100000L), 2, RoundingMode.HALF_UP);
                if (!passCapacity && fileSize.compareTo(BigDecimal.valueOf(billSystemParam.getMaxcapacity().intValue())) > 0) {
                    passCapacity = true;
                }
                String type = (String)stringObjectMap.get("name");
                if (formatSet.isEmpty() || !HRStringUtils.isNotEmpty((String)type) || (split = type.split("\\.")) == null || split.length <= 0 || (type = split[split.length - 1]) == null || formatSet.contains(type = type.toLowerCase())) continue;
                typeSet.add(type);
            }
            if (attachmentData.size() > billSystemParam.getMaxuploadnums()) {
                errorList.add(ApplyBillCheckMsgEnum.OVERFILENUM.getMsg());
            }
            for (String type : typeSet) {
                errorList.add(BusiTripBillKDStringHelper.typeError(type));
            }
            if (passCapacity) {
                errorList.add(ApplyBillCheckMsgEnum.OVERFILESIZE.getMsg());
            }
        }
        return errorList;
    }
}

