/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.business.busitrip;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.applybill.service.BillUnifyQueryService;
import kd.wtc.wtbs.business.web.billservice.dutyDate.BillOptionalDutyDateService;
import kd.wtc.wtbs.business.web.billservice.shift.BillShiftService;
import kd.wtc.wtbs.common.bill.BillQueryEnum;
import kd.wtc.wtbs.common.bill.BillQueryParam;
import kd.wtc.wtbs.common.bill.BusitripBillQueryParam;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.model.billservice.BillDutyDateRealTimeParam;
import kd.wtc.wtbs.common.model.billservice.BillShiftParam;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class BusitripBillUnifyQueryService
extends BillUnifyQueryService {
    private HRBaseServiceHelper service = new HRBaseServiceHelper("wtam_busitripbill");

    public BusitripBillUnifyQueryService(BusitripBillQueryParam param) {
        super(BillQueryEnum.TP, (BillQueryParam)param);
        this.initBuildQFilter(param);
        this.defaultQuery(param);
    }

    protected final void initBuildQFilter(BusitripBillQueryParam param) {
        long travelTool = param.getTravelTool();
        if (travelTool != 0L) {
            QFilter qFilter = new QFilter("entryentity.traveltool", "=", (Object)travelTool);
            if (this.qFilter != null) {
                this.qFilter.and(qFilter);
            } else {
                this.qFilter = qFilter;
            }
        }
    }

    protected final void defaultQuery(BusitripBillQueryParam param) {
        super.defaultQuery((BillQueryParam)param, this.service);
    }

    public List<DynamicObject> getBillOfDefault() {
        return Arrays.stream(this.result).collect(Collectors.toList());
    }

    public List<DynamicObject> filterRealTimeByDutyDate(List<DynamicObject> tpBillDyList, LocalDate startDate, LocalDate endDate) {
        if (startDate == null || endDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u4e0e\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusitripBillUnifyQueryService_0", (String)"wtc-wtam-business", (Object[])new Object[0]));
        }
        if (WTCCollections.isEmpty(tpBillDyList)) {
            return Collections.emptyList();
        }
        BillShiftService billShiftService = new BillShiftService();
        List<BillDutyDateRealTimeParam> realTimeParams = this.convertToDutyInfo(tpBillDyList);
        BillOptionalDutyDateService dutyDateService = new BillOptionalDutyDateService();
        List shiftParams = dutyDateService.convertShiftParam(realTimeParams);
        for (int index = 0; index < shiftParams.size(); ++index) {
            realTimeParams.get(index).setShiftParam((BillShiftParam)shiftParams.get(index));
        }
        shiftParams = shiftParams.stream().filter(sf -> sf.getQueryStartDate() != null && sf.getQueryEndDate() != null).collect(Collectors.toList());
        billShiftService.fillShiftInfo(shiftParams);
        dutyDateService.handleRealTimeForDutyDate(realTimeParams);
        Map<Long, BillDutyDateRealTimeParam> shiftAndAllDayHour = realTimeParams.stream().collect(Collectors.toMap(BillDutyDateRealTimeParam::getBillId, br -> br, (e1, e2) -> e2));
        ArrayList<DynamicObject> afterFilter = new ArrayList<DynamicObject>(10);
        Date startDateBegin = WTCDateUtils.toDate((LocalDate)startDate);
        Date endDateBegin = WTCDateUtils.toDate((LocalDate)endDate);
        block1: for (DynamicObject dynamicObject : tpBillDyList) {
            BillDutyDateRealTimeParam billDutyDateRealTimeParam = shiftAndAllDayHour.get(dynamicObject.getLong("id"));
            if (billDutyDateRealTimeParam == null) continue;
            Set confirmDutyDate = billDutyDateRealTimeParam.getConfirmDutyDate();
            for (Date date : confirmDutyDate) {
                boolean match = date != null && WTCDateUtils.betweenTimeEquals((Date)WTCDateUtils.getDayStart((Date)date), (Date)startDateBegin, (Date)endDateBegin);
                if (!match) continue;
                afterFilter.add(dynamicObject);
                continue block1;
            }
        }
        return afterFilter;
    }

    private List<BillDutyDateRealTimeParam> convertToDutyInfo(List<DynamicObject> tpBillDyList) {
        ArrayList<BillDutyDateRealTimeParam> result = new ArrayList<BillDutyDateRealTimeParam>(10);
        for (DynamicObject tpBillDy : tpBillDyList) {
            BillDutyDateRealTimeParam dateInfoForDy = new BillDutyDateRealTimeParam(tpBillDy.getLong("id"), WTCDynamicObjectUtils.getBaseDataId((DynamicObject)tpBillDy, (String)"attfile"));
            HashSet confirmDate = new HashSet(16);
            ArrayList<Tuples.Tuple2> realTime = new ArrayList<Tuples.Tuple2>(10);
            DynamicObjectCollection entryColl = tpBillDy.getDynamicObjectCollection("entryentity");
            if (WTCCollections.isEmpty((Collection)entryColl)) continue;
            for (DynamicObject entryDy : entryColl) {
                ArrayList dateInEntry = new ArrayList(10);
                Date entryStartDate = entryDy.getDate("startdate");
                Date entryEndDate = entryDy.getDate("enddate");
                if (entryStartDate == null || entryEndDate == null) continue;
                dateInEntry.addAll(WTCDateUtils.getDateRange((Date)entryStartDate, (Date)entryEndDate));
                String method = entryDy.getString("startmethod");
                if (HRStringUtils.equals((String)method, (String)WtcTimeRangeBtnTypeEnum.CUSTOM.value)) {
                    realTime.add(new Tuples.Tuple2((Object)entryDy.getDate("startdate"), (Object)entryDy.getDate("enddate")));
                    continue;
                }
                confirmDate.addAll(dateInEntry);
            }
            dateInfoForDy.setBillId(tpBillDy.getLong("id"));
            dateInfoForDy.setConfirmDutyDate(confirmDate);
            dateInfoForDy.setNeedQueryRealTime(realTime);
            result.add(dateInfoForDy);
        }
        return result;
    }
}

