/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.business.busitrip;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCMaps;

public class TripBillOriginalUpgradeHelper {
    private static final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtam_busitripbill");
    private static final TripBillOriginalUpgradeHelper INS = new TripBillOriginalUpgradeHelper();

    public static TripBillOriginalUpgradeHelper getInstance() {
        return INS;
    }

    private TripBillOriginalUpgradeHelper() {
    }

    public void upgradeOriginalId(Collection<DynamicObject> noOriginalDys, String selectProperties) {
        if ((noOriginalDys = (Collection)noOriginalDys.stream().filter(dy -> dy.getLong("originalid") == 0L).collect(Collectors.toList())).size() <= 0) {
            return;
        }
        ArrayList<DynamicObject> updateDys = new ArrayList<DynamicObject>();
        this.backtrackParent(noOriginalDys, updateDys, selectProperties);
        noOriginalDys = noOriginalDys.stream().filter(dy -> dy.getLong("originalid") == 0L).collect(Collectors.toList());
        this.backtrackChild(noOriginalDys, updateDys, selectProperties);
        serviceHelper.update(updateDys.toArray(new DynamicObject[updateDys.size()]));
    }

    private void backtrackParent(Collection<DynamicObject> noOriginalDys, List<DynamicObject> updateDys, String selectProperties) {
        HashMap dyMapByParentId = new HashMap();
        noOriginalDys.stream().forEach(dy -> {
            if (dy.getBoolean("ischange")) {
                ArrayList<DynamicObject> brotherLeaf = (ArrayList<DynamicObject>)dyMapByParentId.get(dy.getLong("parent"));
                if (WTCCollections.isEmpty((Collection)brotherLeaf)) {
                    brotherLeaf = new ArrayList<DynamicObject>();
                }
                brotherLeaf.add((DynamicObject)dy);
                dyMapByParentId.put(dy.getLong("parent"), brotherLeaf);
            } else if (dy.getLong("originalid") == 0L) {
                dy.set("originalid", (Object)dy.getLong("id"));
                updateDys.add((DynamicObject)dy);
            }
        });
        if (WTCMaps.isNotEmpty(dyMapByParentId)) {
            DynamicObject[] parentDys = serviceHelper.query(selectProperties, new QFilter("id", "in", dyMapByParentId.keySet()).toArray());
            List<DynamicObject> dys = Arrays.asList(parentDys);
            this.backtrackParent(dys, updateDys, selectProperties);
            for (DynamicObject parentDy : dys) {
                List brotherLeafs = (List)dyMapByParentId.get(parentDy.getLong("id"));
                brotherLeafs.stream().filter(dy -> dy != null && dy.getLong("originalid") == 0L).forEach(dy -> {
                    dy.set("originalid", (Object)parentDy.getLong("originalid"));
                    updateDys.add((DynamicObject)dy);
                });
            }
        }
    }

    private void backtrackChild(Collection<DynamicObject> noOriginalDys, List<DynamicObject> updateDys, String selectProperties) {
        if (WTCCollections.isEmpty(noOriginalDys)) {
            return;
        }
        HashMap dyMapByParentId = new HashMap();
        noOriginalDys.stream().forEach(dy -> dyMapByParentId.put(dy.getLong("id"), dy));
        DynamicObject[] child = serviceHelper.query(selectProperties, new QFilter("parent", "in", dyMapByParentId.keySet()).toArray());
        if (child != null && child.length > 0) {
            for (DynamicObject dy2 : child) {
                DynamicObject parent = (DynamicObject)dyMapByParentId.get(dy2.getLong("parent"));
                if (parent == null || dy2.getLong("originalid") != 0L) continue;
                dy2.set("originalid", (Object)parent.getLong("originalid"));
                updateDys.add(dy2);
            }
            this.backtrackChild(Arrays.asList(child), updateDys, selectProperties);
        }
    }
}

