/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.business.busitrip;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillStyleService;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeEventEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeTypeEnum;
import kd.wtc.wtbs.common.model.wtctimerange.WtcTimeRangeArgsModel;
import kd.wtc.wtbs.common.model.wtctimerange.WtcTimeRangeModel;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class TripBillStyleService {
    public static final Set<String> REFRESH_OP = Sets.newHashSet((Object[])new String[]{"unsubmit", "submit", "submiteffect", "discard"});
    private static final String KEY_ISHAND = "ishand";

    private TripBillStyleService() {
    }

    public static TripBillStyleService getInstance() {
        return SingletonInstance.singleton;
    }

    public void handleSingleStyle(IFormView billView, String openPage) {
        if (billView == null) {
            return;
        }
        IDataModel model = billView.getModel();
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        boolean openSingleStyle = TripBillStyleService.singleStyle(model.getDataEntity(true));
        if (openSingleStyle) {
            DynamicObjectCollection collection = this.getEntryColl(billView);
            if (collection != null && collection.size() > 0) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(0);
                HashMap<String, Object> map = new HashMap<String, Object>(10);
                map.put("editentry", dynamicObject);
                map.put("tripresontex", dynamicObject.get("tripresontex"));
                map.put("strapplytime", dynamicObject.getString("strapplytime"));
                map.put("rowindex", 1);
                param.put("editentry", map);
            }
            Boolean isChange = model.getDataEntity().getBoolean("ischange");
            param.put("isfromchange", isChange);
            Long parentId = model.getDataEntity().getLong("parent");
            param.put("parent", parentId);
            if (model != null && model.getDataEntity() != null) {
                if (model.getDataEntity().getDynamicObject("attfile") != null) {
                    Object afftileBo = model.getDataEntity().getDynamicObject("attfile").getPkValue();
                    param.put("attfile", afftileBo);
                }
                if (model.getDataEntity().getDynamicObject("personid") != null) {
                    Object personId = model.getDataEntity().getDynamicObject("personid").getPkValue();
                    param.put("personid", personId);
                }
            }
            param.put("singleStyle", true);
            BillStyleService.getInstance().openSingleFlex(billView, param, model.getDataEntity(), openPage, (Set)Sets.newHashSet((Object[])new String[]{"advcontoolbarap", "entryentity", "sumflex"}));
        }
    }

    public void failureFlushSingleFlex(IFormView billView, String openPage, OperationStatus status, boolean isFail) {
        if (billView == null) {
            return;
        }
        IDataModel model = billView.getModel();
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        boolean openSingleStyle = TripBillStyleService.singleStyle(model.getDataEntity(true));
        if (openSingleStyle) {
            DynamicObjectCollection collection = this.getEntryColl(billView);
            if (collection != null && collection.size() > 0) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(0);
                HashMap<String, Object> map = new HashMap<String, Object>(10);
                if (isFail) {
                    dynamicObject.set("triptime", (Object)BigDecimal.ZERO);
                    dynamicObject.set("strapplytime", (Object)"0");
                }
                map.put("editentry", dynamicObject);
                map.put("tripresontex", dynamicObject.get("tripresontex"));
                map.put("strapplytime", dynamicObject.getString("strapplytime"));
                map.put("rowindex", 1);
                param.put("editentry", map);
            }
            Boolean isChange = model.getDataEntity().getBoolean("ischange");
            param.put("isfromchange", isChange);
            Long parentId = model.getDataEntity().getLong("parent");
            param.put("parent", parentId);
            if (model != null && model.getDataEntity() != null) {
                if (model.getDataEntity().getDynamicObject("attfile") != null) {
                    Object afftileBo = model.getDataEntity().getDynamicObject("attfile").getPkValue();
                    param.put("attfile", afftileBo);
                }
                if (model.getDataEntity().getDynamicObject("personid") != null) {
                    Object personId = model.getDataEntity().getDynamicObject("personid").getPkValue();
                    param.put("personid", personId);
                }
            }
            param.put("singleStyle", true);
            BillStyleService.getInstance().openSingleFlexWithStatus(billView, param, model.getDataEntity(), openPage, (Set)Sets.newHashSet((Object[])new String[]{"advcontoolbarap", "entryentity", "sumflex"}), status);
        }
    }

    public void changeSingleFlexStatus(IFormView singleView, OperationStatus status) {
        if (singleView != null) {
            singleView.setStatus(status);
            WtcTimeRangeModel wtcTimeRangeModel = new WtcTimeRangeModel();
            wtcTimeRangeModel.setEvent(WtcTimeRangeEventEnum.UPDATE_DATA.value);
            WtcTimeRangeArgsModel argsModel = new WtcTimeRangeArgsModel();
            if (OperationStatus.VIEW.equals((Object)status)) {
                argsModel.setType(WtcTimeRangeTypeEnum.VIEW.value);
            } else {
                argsModel.setType(WtcTimeRangeTypeEnum.EDIT.value);
            }
            wtcTimeRangeModel.setArgs(argsModel);
            CustomControl customControl = (CustomControl)singleView.getControl("wtctimerange");
            if (customControl != null) {
                customControl.setData((Object)wtcTimeRangeModel);
            }
        }
    }

    public static boolean singleStyle(DynamicObject dynamicObject) {
        return BillStyleService.getInstance().isOpenSingleStyle(dynamicObject);
    }

    public DynamicObjectCollection getEntryColl(IFormView billView) {
        if (billView == null) {
            return null;
        }
        return billView.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
    }

    public static void writeTripInfoToPage(DynamicObject row, IFormView view) {
        if (view == null) {
            return;
        }
        int rowIndex = 0;
        if (row != null) {
            view.getPageCache().put(KEY_ISHAND, "0");
            IDataModel model = view.getModel();
            Date startDate = row.getDate("startdate");
            Date endDate = row.getDate("enddate");
            long typeId = (Long)row.getDynamicObject("busitriptype").getPkValue();
            Long tripToolId = TripBillStyleService.getEntityId(row, "traveltool");
            BigDecimal tripTime = row.getBigDecimal("triptime");
            BigDecimal efftctime = row.getBigDecimal("efftctime");
            Long to = TripBillStyleService.getEntityId(row, "to");
            Long from = TripBillStyleService.getEntityId(row, "from");
            Object tripresontex = row.get("tripresontex");
            String strApplyTime = row.getString("strapplytime");
            String enclosuremode = row.getString("enclosuremode");
            String unit = row.getString("unit");
            String startDateStr = row.getString("startdatestr");
            String endDateStr = row.getString("enddatestr");
            String startMethod = row.getString("startmethod");
            String endMethod = row.getString("endmethod");
            Date ownDate = row.getDate("owndate");
            Long entryParentId = row.getLong("changecheck");
            long personId = 0L;
            DynamicObject person = model.getDataEntity().getDynamicObject("personid");
            if (person != null) {
                personId = person.getLong("id");
            }
            model.beginInit();
            if (TripBillStyleService.singleStyle(model.getDataEntity(true))) {
                if (WTCCollections.isEmpty((Collection)model.getDataEntity().getDynamicObjectCollection("entryentity"))) {
                    model.createNewEntryRow("entryentity");
                }
            } else {
                rowIndex = row.getInt("rowindex");
                if (rowIndex == 0) {
                    DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
                    rowIndex = entryEntity.size();
                    model.createNewEntryRow("entryentity");
                } else {
                    --rowIndex;
                }
            }
            model.setValue("busitriptype", (Object)typeId, rowIndex);
            model.setValue("startdate", (Object)startDate, rowIndex);
            model.setValue("enddate", (Object)endDate, rowIndex);
            model.setValue("traveltool", (Object)tripToolId, rowIndex);
            model.setValue("triptime", (Object)tripTime, rowIndex);
            model.setValue("efftctime", (Object)efftctime, rowIndex);
            model.setValue("unit", (Object)unit, rowIndex);
            model.setValue("to", (Object)to, rowIndex);
            model.setValue("from", (Object)from, rowIndex);
            model.setValue("personid", (Object)personId, rowIndex);
            model.setValue("tripresontex", tripresontex, rowIndex);
            model.setValue("strapplytime", (Object)strApplyTime, rowIndex);
            model.setValue("enclosuremode", (Object)enclosuremode, rowIndex);
            model.setValue("startdatestr", (Object)startDateStr, rowIndex);
            model.setValue("enddatestr", (Object)endDateStr, rowIndex);
            model.setValue("startmethod", (Object)startMethod, rowIndex);
            model.setValue("endmethod", (Object)endMethod, rowIndex);
            model.setValue("owndate", (Object)ownDate, rowIndex);
            model.setValue("entryparentid", (Object)entryParentId, rowIndex);
            BillCommonService.writeInfo2Model((DynamicObject)row, (DynamicObject)view.getModel().getEntryRowEntity("entryentity", rowIndex));
            model.endInit();
            view.updateView("entryentity");
        }
    }

    private static Long getEntityId(DynamicObject row, String fieldTo) {
        DynamicObject toEnt = row.getDynamicObject(fieldTo);
        if (toEnt != null) {
            return toEnt.getLong("id");
        }
        return null;
    }

    private static class SingletonInstance {
        private static final TripBillStyleService singleton = new TripBillStyleService();

        private SingletonInstance() {
        }
    }
}

