/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.business.busitrip;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.sdk.wtc.wtam.business.tp.TripRuleCalInfo;
import kd.sdk.wtc.wtp.business.tripplan.TripPlanRuleQuery;
import kd.sdk.wtc.wtp.business.tripplan.TripPlanRuleResp;
import kd.wtc.wtbs.business.web.applybill.commonhelper.UnifyBillCommonHelper;
import kd.wtc.wtbs.business.web.billservice.common.BillSetCommonService;
import kd.wtc.wtbs.business.web.billservice.plan.BillPlanService;
import kd.wtc.wtbs.business.web.billservice.rule.BillRuleService;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.bill.PlanSceneEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.model.billservice.BillDutyDatePlanInfo;
import kd.wtc.wtbs.common.model.billservice.BillDutyDateRuleInfo;
import kd.wtc.wtbs.common.model.billservice.BillRuleField;
import kd.wtc.wtbs.common.model.billservice.BillSetSpiltRangeQuery;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class TripSdkHelper {
    private static TripSdkHelper instance = new TripSdkHelper();

    private TripSdkHelper() {
    }

    public static TripSdkHelper getInstance() {
        return instance;
    }

    public List<TripPlanRuleResp> queryTripPlanRule(List<TripPlanRuleQuery> queries) {
        if (CollectionUtils.isEmpty(queries)) {
            return Collections.emptyList();
        }
        BillPlanService planService = new BillPlanService();
        List<BillDutyDatePlanInfo> billDutyDatePlanInfoList = this.convertToBillDutyDatePlanInfo(queries);
        planService.fillPlanByAttFileAndDate(billDutyDatePlanInfoList, AttFileScheduleEnum.TP, "wtp_taplan");
        List<BillDutyDateRuleInfo> billDutyDateRuleInfoList = this.convertToRuleParam(billDutyDatePlanInfoList, queries);
        BillRuleService ruleService = new BillRuleService();
        BillRuleField field = new BillRuleField();
        field.setRuleEntityName("wtp_tarvelrule");
        field.setRuleInPlan("triprule");
        field.setRuleCalEntryKeyName("entryentity");
        field.setLimitJsonKeyName("limitscope");
        field.setTypeKeyName("traveltype");
        field.setBillType(UnifyBillEnum.TP.name());
        ruleService.fillRuleCalByRetrieval(billDutyDateRuleInfoList, PlanSceneEnum.TP, field, true);
        Tuples.Tuple2<Date, Date> minAndMax = this.minAndMax(billDutyDateRuleInfoList);
        HashSet<Long> allBaseSet = new HashSet<Long>(16);
        for (BillDutyDateRuleInfo billDutyDateRuleInfo : billDutyDateRuleInfoList) {
            List ruleCalList = billDutyDateRuleInfo.getRuleCalList();
            if (CollectionUtils.isEmpty((Collection)ruleCalList)) continue;
            for (DynamicObject dynamicObject : ruleCalList) {
                DynamicObject tripBaseSet = dynamicObject.getDynamicObject("travelmeter");
                if (tripBaseSet == null) continue;
                allBaseSet.add(tripBaseSet.getLong("id"));
            }
        }
        ArrayList<DynamicObject> engineQuery = new ArrayList<DynamicObject>(10);
        for (BillDutyDatePlanInfo billDutyDatePlanInfo : billDutyDatePlanInfoList) {
            if (billDutyDatePlanInfo.getPlanDy() == null) continue;
            engineQuery.add(billDutyDatePlanInfo.getPlanDy());
        }
        Map map = BillPlanService.getInstance().usePlanEngine(engineQuery);
        Object[] allSeqHisDys = UnifyBillCommonHelper.getAllSeqHisDys((String)"wtp_travelmeter", (Date)((Date)minAndMax.item1), (Date)((Date)minAndMax.item2), allBaseSet);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)queries.size());
        for (int index = 0; index < queries.size(); ++index) {
            Tuples.Tuple2 ruleRange;
            TripPlanRuleQuery ruleParam = queries.get(index);
            BillDutyDateRuleInfo ruleInfo = billDutyDateRuleInfoList.get(index);
            DynamicObject attFileVersionDy = ruleInfo.getAttFileVersionDy();
            DynamicObject planVersionDy = ruleInfo.getPlanDy();
            boolean usedEngine = false;
            if (planVersionDy != null) {
                usedEngine = (Boolean)map.get(planVersionDy.getLong("id"));
            }
            String engineCondition = usedEngine ? "usedEngine" : "";
            DynamicObject ruleVersionDy = ruleInfo.getRuleDy();
            Optional sideDyOption = BillPlanService.getInstance().getSideDy(billDutyDatePlanInfoList, ruleInfo.getAttFileBoId(), ruleInfo.getQueryDate());
            DynamicObject sideDy = sideDyOption.orElse(null);
            LocalDate baseDate = WTCDateUtils.toLocalDate((Date)ruleInfo.getQueryDate());
            List ruleCalList = ruleInfo.getRuleCalList();
            ArrayList<TripRuleCalInfo> tripRuleCalInfoList = new ArrayList<TripRuleCalInfo>(10);
            for (DynamicObject dynamicObject : ruleCalList) {
                TripRuleCalInfo calInfoParam = new TripRuleCalInfo();
                DynamicObject baseSet = UnifyBillCommonHelper.getSeqHisDyByDate((Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dynamicObject, (String)"travelmeter"), (Date)ruleParam.getQueryDate(), (List)Lists.newArrayList((Object[])allSeqHisDys));
                calInfoParam.setRuleEntryCalDy(dynamicObject);
                calInfoParam.setBaseSetDy(baseSet);
                String limitCondition = dynamicObject.getString("limitscope");
                BillSetSpiltRangeQuery billSetSpiltRangeQuery = new BillSetSpiltRangeQuery();
                billSetSpiltRangeQuery.setAttFileVersionDy(attFileVersionDy);
                billSetSpiltRangeQuery.setSideTableDy(sideDy);
                billSetSpiltRangeQuery.setPlanVersionDy(planVersionDy);
                billSetSpiltRangeQuery.setEngineCondition(engineCondition);
                billSetSpiltRangeQuery.setRuleVersionDy(ruleVersionDy);
                billSetSpiltRangeQuery.setLimitCondition(limitCondition);
                billSetSpiltRangeQuery.setCalSetVersionDy(baseSet);
                billSetSpiltRangeQuery.setBaseDate(baseDate);
                Tuples.Tuple2 rangeTime = BillSetCommonService.getInstance().splitHisBaseSet(billSetSpiltRangeQuery);
                if (rangeTime != null) {
                    if (rangeTime.item1 != null) {
                        calInfoParam.setBaseSetEffectStart(WTCDateUtils.toDate((LocalDate)((LocalDate)rangeTime.item1)));
                    }
                    if (rangeTime.item2 != null) {
                        calInfoParam.setBaseSetEffectEnd(WTCDateUtils.toDate((LocalDate)((LocalDate)rangeTime.item2)));
                    }
                }
                tripRuleCalInfoList.add(calInfoParam);
            }
            TripPlanRuleResp tripPlanRuleResp = new TripPlanRuleResp(queries.get(index), ruleInfo.getPlanDy(), ruleInfo.getRuleDy(), tripRuleCalInfoList);
            Tuples.Tuple2 planRange = BillSetCommonService.getInstance().splitHisPlanRange(attFileVersionDy, sideDy, planVersionDy, baseDate);
            if (planRange != null) {
                if (planRange.item1 != null) {
                    tripPlanRuleResp.setPlanEffectStart(WTCDateUtils.toDate((LocalDate)((LocalDate)planRange.item1)));
                }
                if (planRange.item2 != null) {
                    tripPlanRuleResp.setPlanEffectEnd(WTCDateUtils.toDate((LocalDate)((LocalDate)planRange.item2)));
                }
            }
            if ((ruleRange = BillSetCommonService.getInstance().splitHisRuleRange(attFileVersionDy, sideDy, planVersionDy, engineCondition, ruleVersionDy, baseDate)) != null) {
                if (ruleRange.item1 != null) {
                    tripPlanRuleResp.setRuleEffectStart(WTCDateUtils.toDate((LocalDate)((LocalDate)ruleRange.item1)));
                }
                if (ruleRange.item2 != null) {
                    tripPlanRuleResp.setRuleEffectEnd(WTCDateUtils.toDate((LocalDate)((LocalDate)ruleRange.item2)));
                }
            }
            result.add(tripPlanRuleResp);
        }
        return result;
    }

    private List<BillDutyDatePlanInfo> convertToBillDutyDatePlanInfo(List<TripPlanRuleQuery> tripRuleQueryList) {
        ArrayList<BillDutyDatePlanInfo> result = new ArrayList<BillDutyDatePlanInfo>(10);
        for (TripPlanRuleQuery tripRuleQuery : tripRuleQueryList) {
            BillDutyDatePlanInfo billDutyDatePlanInfo = new BillDutyDatePlanInfo(tripRuleQuery.getAttFileBoId(), WTCDateUtils.getDayStart((Date)tripRuleQuery.getQueryDate()));
            result.add(billDutyDatePlanInfo);
        }
        return result;
    }

    private List<BillDutyDateRuleInfo> convertToRuleParam(List<BillDutyDatePlanInfo> billDutyDatePlanInfos, List<TripPlanRuleQuery> planRuleQueryList) {
        ArrayList<BillDutyDateRuleInfo> result = new ArrayList<BillDutyDateRuleInfo>(10);
        for (int index = 0; index < planRuleQueryList.size(); ++index) {
            TripPlanRuleQuery ruleParam = planRuleQueryList.get(index);
            BillDutyDatePlanInfo billDutyDatePlanInfo = billDutyDatePlanInfos.get(index);
            BillDutyDateRuleInfo ruleInfo = new BillDutyDateRuleInfo(billDutyDatePlanInfo.getAttFileBoId(), billDutyDatePlanInfo.getQueryDate(), billDutyDatePlanInfo.getPlanDy(), ruleParam.getTripType());
            DynamicObject tpBillDy = ruleParam.getTpBillDy();
            if (tpBillDy != null) {
                ruleInfo.setBillDy(tpBillDy);
                ruleInfo.setEntryKey("entryentity");
                ruleInfo.setEntryIndex(ruleParam.getEntryIndex());
            }
            result.add(ruleInfo);
        }
        return result;
    }

    private Tuples.Tuple2<Date, Date> minAndMax(List<BillDutyDateRuleInfo> billDutyDateRuleInfoList) {
        Date min = WTCDateUtils.getDayStart((Date)WTCDateUtils.getMaxEndDate());
        Date max = WTCDateUtils.getDayStart((Date)WTCDateUtils.getMinEndDate());
        for (BillDutyDateRuleInfo ruleInfo : billDutyDateRuleInfoList) {
            Date queryDate = ruleInfo.getQueryDate();
            if (queryDate == null) continue;
            if (queryDate.before(min)) {
                min = queryDate;
            }
            if (!queryDate.after(max)) continue;
            max = queryDate;
        }
        return new Tuples.Tuple2((Object)min, (Object)max);
    }
}

