/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.business.busitripmobile;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtam.business.busitrip.BusiTripBillService;
import kd.wtc.wtam.common.model.BusiTimeTypeEnum;
import kd.wtc.wtbs.business.mobile.BillContainerService;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class BusiTripBillUtil {
    private static final Log logger = LogFactory.getLog(BusiTripBillUtil.class);
    private static final BigDecimal ONE_DAY_HOUR = new BigDecimal("24");

    public static List<String> getTripTotalTime(DynamicObject busiTripBill) {
        DynamicObjectCollection entryEntity = busiTripBill.getDynamicObjectCollection("entryentity");
        HashMap<String, Tuple> tripTotalTimeMap = new HashMap<String, Tuple>(16);
        for (DynamicObject entry : entryEntity) {
            Tuple totalTimePair;
            BigDecimal hourToDayTime;
            if (entry.getDynamicObject("busitriptype") == null || entry.getString("unit") == null) continue;
            String busiTripType = entry.getDynamicObject("busitriptype") != null ? entry.getDynamicObject("busitriptype").getString("name") : null;
            BigDecimal tripTime = entry.getBigDecimal("triptime");
            String unit = entry.getString("unit");
            Tuple timeUnitPair = (Tuple)tripTotalTimeMap.get(busiTripType);
            if (timeUnitPair == null) {
                Tuple totalTimePair2 = new Tuple((Object)tripTime, (Object)unit);
                tripTotalTimeMap.put(busiTripType, totalTimePair2);
                continue;
            }
            String existUnit = (String)timeUnitPair.getValue();
            BigDecimal existTripTime = (BigDecimal)timeUnitPair.getKey();
            if (unit.equals(existUnit)) {
                Tuple totalTimePair3 = new Tuple((Object)existTripTime.add(tripTime), (Object)unit);
                tripTotalTimeMap.put(busiTripType, totalTimePair3);
                continue;
            }
            if (BusiTimeTypeEnum.HOUR.getCode().equals(existUnit)) {
                hourToDayTime = existTripTime.divide(ONE_DAY_HOUR, 2, 4);
                totalTimePair = new Tuple((Object)tripTime.add(hourToDayTime), (Object)unit);
                tripTotalTimeMap.put(busiTripType, totalTimePair);
            }
            if (!BusiTimeTypeEnum.HOUR.getCode().equals(unit)) continue;
            hourToDayTime = tripTime.divide(ONE_DAY_HOUR, 2, 4);
            totalTimePair = new Tuple((Object)existTripTime.add(hourToDayTime), (Object)existUnit);
            tripTotalTimeMap.put(busiTripType, totalTimePair);
        }
        ArrayList<String> tripTotalTime = new ArrayList<String>(tripTotalTimeMap.size());
        if (tripTotalTimeMap.size() == 0) {
            return null;
        }
        Set entrySet = tripTotalTimeMap.entrySet();
        Iterator iterator = entrySet.iterator();
        char empty = ' ';
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            Tuple tripTotalTimePair = (Tuple)next.getValue();
            StringBuilder tripTotalTimeStr = new StringBuilder();
            tripTotalTimeStr.append((String)next.getKey()).append(empty);
            BigDecimal num = (BigDecimal)tripTotalTimePair.getKey();
            if (num != null) {
                BigDecimal newNum = num.setScale(2, RoundingMode.HALF_UP);
                tripTotalTimeStr.append(newNum.toPlainString());
            }
            String unit = (String)tripTotalTimePair.getValue();
            String unitStr = "";
            if (HRStringUtils.equalsIgnoreCase((String)"A", (String)unit)) {
                unitStr = ResManager.loadKDString((String)"\u5929", (String)"BusiTripBillUtil_0", (String)"wtc-wtam-business", (Object[])new Object[0]);
            } else if (HRStringUtils.equalsIgnoreCase((String)"B", (String)unit)) {
                unitStr = ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"BusiTripBillUtil_1", (String)"wtc-wtam-business", (Object[])new Object[0]);
            }
            tripTotalTimeStr.append(unitStr);
            tripTotalTime.add(String.valueOf(tripTotalTimeStr));
        }
        return tripTotalTime;
    }

    public static void setFieldMustInput(List<String> mustInputFieldList, IFormView view) {
        for (String field : mustInputFieldList) {
            if (!"attachmentpanel".equals(field)) continue;
            view.getPageCache().put("ismustattach", "1");
        }
    }

    public static List<String> setMustInpConvert(List<String> mustInputFieldList) {
        ArrayList<String> mustInpList = new ArrayList<String>(16);
        if (mustInputFieldList.contains("isplace")) {
            mustInpList.add("from");
            mustInpList.add("to");
        }
        if (mustInputFieldList.contains("isvehicle")) {
            mustInpList.add("traveltool");
        }
        if (mustInputFieldList.contains("isreasonrequired")) {
            mustInpList.add("tripresontex");
        }
        if (mustInputFieldList.contains("isneedenclosure")) {
            mustInpList.add("attachmentpanel");
        }
        return mustInpList;
    }

    public static void addTag(IFormView view, String flexId, String tagId, String name) {
        Container flexpanelap = (Container)view.getControl(flexId);
        FlexPanelAp completeLabelPanelAp = new FlexPanelAp();
        completeLabelPanelAp.setKey(tagId);
        completeLabelPanelAp.setLazyLoad(false);
        completeLabelPanelAp.setClickable(true);
        completeLabelPanelAp.setGrow(0);
        completeLabelPanelAp.setForeColor("#666666");
        Style style = new Style();
        completeLabelPanelAp.setStyle(style);
        ArrayList<Map> listitem = new ArrayList<Map>();
        LabelAp title = new LabelAp();
        title.setKey(tagId);
        title.setName(new LocaleString(name));
        title.setClickable(true);
        String pageType = tagId.substring(0, 3);
        if ("det".equals(pageType)) {
            title.setFontSize(14);
            title.setForeColor("#212121");
        } else {
            title.setFontSize(16);
            title.setForeColor("#666666");
        }
        completeLabelPanelAp.getItems().add(title);
        listitem.add(completeLabelPanelAp.createControl());
        flexpanelap.addControls(listitem);
    }

    public static void tripTotalTimeLineFeed(DynamicObject busiTripBill, IFormView view, String flexId, String pageFlag) {
        String tripTotalCache = view.getPageCache().get("tripTotalTime");
        if (tripTotalCache != null && "apply".equals(pageFlag)) {
            List cacheNames = (List)SerializationUtils.deSerializeFromBase64((String)tripTotalCache);
            for (String cacheName : cacheNames) {
                BusiTripBillUtil.deleteTag(view, flexId, cacheName);
            }
        }
        ArrayList<String> tripTotalLabNames = new ArrayList<String>(16);
        List<String> tripTotalTime = BusiTripBillUtil.getTripTotalTime(busiTripBill);
        if (WTCCollections.isEmpty(tripTotalTime)) {
            return;
        }
        for (int i = 0; i < tripTotalTime.size(); ++i) {
            BusiTripBillUtil.addTag(view, flexId, pageFlag + "triptotaltime" + i, tripTotalTime.get(i));
            tripTotalLabNames.add(pageFlag + "triptotaltime" + i);
        }
        String cacheString = SerializationUtils.serializeToBase64(tripTotalLabNames);
        if ("apply".equals(pageFlag)) {
            view.getPageCache().put("tripTotalTime", cacheString);
        }
    }

    public static void deleteTag(IFormView view, String flexId, String tagKey) {
        Container flexPanelAp = (Container)view.getControl(flexId);
        flexPanelAp.deleteControls(new String[]{tagKey});
    }

    public static Map<String, Object> getReturnMap(DynamicObject dynamicObject) {
        BusiTripBillService billService = new BusiTripBillService();
        return billService.genOriginDataMap(dynamicObject);
    }

    public static void showBusTripDetail(String formId, IDataModel model, IFormView view) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(2);
        customParams.put("isapplySave", Boolean.TRUE);
        customParams.put("entityId", view.getEntityId());
        BillContainerService.getInstance().openDetailPageOfSave(view, formId, model.getDataEntity().getLong("id"), customParams);
    }

    public static void setLangValue(JSONObject jsonObject, OrmLocaleValue ormLocaleValue) {
        if (jsonObject != null) {
            ormLocaleValue.setLocaleValue_en(jsonObject.getString("en_US"));
            ormLocaleValue.setLocaleValue(jsonObject.getString("GLang"));
            ormLocaleValue.setLocaleValue_zh_CN(jsonObject.getString("zh_CN"));
            ormLocaleValue.setLocaleValue_zh_TW(jsonObject.getString("zh_TW"));
        }
    }

    public static String getDateMethodStr(DynamicObject entry, String methodKey, String key, String upStr, String downStr) {
        String method = entry.getString(methodKey);
        String str = "";
        if (HRStringUtils.equals((String)method, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value)) {
            str = WTCDateUtils.date2Str((Date)entry.getDate(key), (String)"yyyy-MM-dd") + upStr;
        } else if (HRStringUtils.equals((String)method, (String)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value)) {
            str = WTCDateUtils.date2Str((Date)entry.getDate(key), (String)"yyyy-MM-dd") + downStr;
        } else if (HRStringUtils.equals((String)method, (String)WtcTimeRangeBtnTypeEnum.DAY.value)) {
            str = WTCDateUtils.date2Str((Date)entry.getDate(key), (String)"yyyy-MM-dd");
        } else if (HRStringUtils.equals((String)method, (String)WtcTimeRangeBtnTypeEnum.CUSTOM.value)) {
            str = WTCDateUtils.date2Str((Date)entry.getDate(key), (String)"yyyy-MM-dd HH:mm");
        }
        return str;
    }

    public static boolean checkBillAllDisuse(DynamicObject billDy) {
        if (billDy == null) {
            return false;
        }
        boolean isChange = billDy.containsProperty("ischange") && billDy.get("ischange") instanceof Boolean && billDy.getBoolean("ischange");
        boolean isNotTrip = billDy.containsProperty("isnottrip") && billDy.get("isnottrip") instanceof Boolean && billDy.getBoolean("isnottrip");
        return isChange && isNotTrip;
    }
}

