/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.business.busitripmobile;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtam.business.busitrip.BusiTripBillKDStringHelper;
import kd.wtc.wtam.business.busitrip.BusiTripBillService;
import kd.wtc.wtam.business.busitripmobile.BusiTripBillUtil;
import kd.wtc.wtam.common.constants.busitripbill.BusiTripConstants;
import kd.wtc.wtam.common.constants.busitripbill.BusiTripMConstants;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.web.WTCAttFileService;
import kd.wtc.wtbs.business.web.applybill.service.BustripEntityCheckService;
import kd.wtc.wtbs.common.concurrent.WTCMutexHelper;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.attfileauth.AttFileAuthBase;
import kd.wtc.wtbs.common.model.attfileauth.AttFileInfo;
import kd.wtc.wtbs.common.model.bill.BillSystemParam;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.ArrayUtils;
import kd.wtc.wtbs.common.util.third.util.MapUtils;

public class MobBusiTripBusiness
implements BusiTripConstants,
BusiTripMConstants {
    private static final Log logger = LogFactory.getLog(MobBusiTripBusiness.class);

    private MobBusiTripBusiness() {
    }

    public static MobBusiTripBusiness getInstance() {
        return Instance.INSTANCE;
    }

    public void showEntryCardHeader(IFormView iFormView) {
        CardEntry entryGrid = (CardEntry)iFormView.getControl("entryentity");
        Object[] items = entryGrid.getEntryData().getDataEntitys();
        Boolean moreThanOne = Boolean.TRUE;
        if (ArrayUtils.isNotEmpty((Object[])items) && items.length == 1) {
            moreThanOne = Boolean.FALSE;
        }
        entryGrid.setChildVisible(moreThanOne.booleanValue(), 0, new String[]{"cardentryheadflex"});
        if (moreThanOne.booleanValue()) {
            IDataModel model = iFormView.getModel();
            for (int index = 0; index < items.length; ++index) {
                String billEntryName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u884c\u7a0b\u660e\u7ec6%d", (String)"MobBusiTripBusiness_8", (String)"wtc-wtam-business", (Object[])new Object[0]), index + 1);
                model.setValue("billentryname", (Object)billEntryName, index);
            }
        } else if (items.length == 1) {
            IDataModel model = iFormView.getModel();
            model.setValue("billentryname", (Object)"", 0);
        }
    }

    public void deleteEntry(IFormView view) {
        CardEntry entryGrid = (CardEntry)view.getControl("entryentity");
        int focusRow = entryGrid.getEntryState().getFocusRow();
        entryGrid.getEntryState().selectRow(focusRow);
        view.invokeOperation("deleteentry");
    }

    public List<DynamicObject> getEntryEntityDynamicObjects(IFormView view, String entityName) {
        EntryGrid entryGrid = (EntryGrid)view.getControl(entityName);
        EntryData entryData = entryGrid.getEntryData();
        DynamicObject[] dataEntity = entryData.getDataEntitys();
        return Arrays.asList(dataEntity);
    }

    public void cleanAttFileInfo(IDataModel dataModel, boolean needCleanOrg) {
        dataModel.setValue("attfile", null);
        dataModel.setValue("personid", null);
        dataModel.setValue("attfilebasef7", null);
        if (needCleanOrg) {
            dataModel.setValue("org", null);
        }
    }

    public void setAttFileInfo(IFormView iFormView, Map<String, String> returnData, boolean needSetOrg) {
        if (CollectionUtils.isEmpty(returnData)) {
            return;
        }
        String personId = returnData.get("personid");
        String attFile = returnData.get("attfile");
        String attfilebasef7 = returnData.get("id");
        logger.info("MobBusiTripBusiness.setPersonName.personId:{}", (Object)personId);
        logger.info("MobBusiTripBusiness.setPersonName.attFile:{}", (Object)attFile);
        logger.info("MobBusiTripBusiness.setPersonName.attfilebasef7:{}", (Object)attfilebasef7);
        if (personId != null && attFile != null) {
            iFormView.getModel().setValue("attfile", (Object)Long.parseLong(attFile));
            iFormView.getModel().setValue("personid", (Object)Long.parseLong(personId));
            iFormView.getModel().setValue("attfilebasef7", (Object)Long.parseLong(attfilebasef7));
            DynamicObject attfile = iFormView.getModel().getDataEntity(true).getDynamicObject("attfile");
            if (attfile != null && needSetOrg) {
                AttFileInfo attFileAuth;
                List attFileInfos = WTCAttFileService.queryAttFileInfoByIds(Collections.singletonList((Long)attfile.getPkValue()));
                AttFileInfo attFileInfo = attFileAuth = CollectionUtils.isEmpty((Collection)attFileInfos) ? null : (AttFileInfo)attFileInfos.get(0);
                if (attFileAuth != null) {
                    AttFileAuthBase org = attFileAuth.getAttFile().getOrg();
                    iFormView.getModel().setValue("org", (Object)org.getBoid());
                }
            }
        }
    }

    public List<Map<String, String>> queryBusTripType(IFormView view, String entityId) {
        QFilter audit = null;
        DynamicObject entryClickRowData = this.getEntryClickRowData(view);
        DynamicObject busTripType = entryClickRowData.getDynamicObject("busitriptype");
        Long busTripTypeId = busTripType != null ? Long.valueOf(busTripType.getLong("id")) : null;
        HRBaseServiceHelper typeHelper = new HRBaseServiceHelper("wtbd_traveltype");
        Map typeRegulation = new HashMap(0);
        if (BillCommonService.billCheckIsStrict()) {
            Set enumTypeIdSet;
            DynamicObject mainDataEntity = view.getModel().getDataEntity(true);
            long attFileBo = 0L;
            if (mainDataEntity != null && mainDataEntity.getDynamicObject("attfile") != null) {
                attFileBo = mainDataEntity.getDynamicObject("attfile").getLong("id");
            }
            logger.info("MobBusiTripBusiness.queryBusTripType.attFileBo:{}", (Object)attFileBo);
            BustripEntityCheckService service = new BustripEntityCheckService(entityId);
            String appId = BillCommonService.getInstance().getAuthAppIdForFormPlugin(view);
            if ("wtam_busibillchange".equals(entityId) || "wtam_busiselfbillchange".equals(entityId)) {
                Object entryParentId = entryClickRowData.get("entryparentid");
                enumTypeIdSet = service.getChangeEnumTypeIds(attFileBo, Long.parseLong(entryParentId.toString()), ApplyBillCheckEnum.BUSTRIP, appId);
            } else {
                enumTypeIdSet = service.getEnumTypeIdSet(Long.valueOf(attFileBo), UnifyBillEnum.TP, appId);
            }
            logger.info("MobBusiTripBusiness.queryBusTripType.enumTypeIdSet:{}", (Object)enumTypeIdSet);
            typeRegulation = service.getTypeRegulation(Long.valueOf(attFileBo), appId);
            logger.info("MobBusiTripBusiness.queryBusTripType.typeRegulation:{}", typeRegulation);
            ArrayList idList = new ArrayList(enumTypeIdSet);
            audit = new QFilter("id", "in", idList);
        } else {
            audit = new QFilter("id", "!=", (Object)0L);
        }
        audit.and(WTCHisServiceHelper.statusValidQFilter());
        DynamicObject orgDy = (DynamicObject)view.getModel().getValue("org");
        if (orgDy != null) {
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"wtbd_traveltype", (Long)orgDy.getLong("id"));
            if (baseDataFilter != null) {
                audit.and(baseDataFilter);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8003\u52e4\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"MobBusiTripBusiness_11", (String)"wtc-wtam-business", (Object[])new Object[0]));
        }
        DynamicObject[] query = typeHelper.query(new QFilter[]{audit});
        ArrayList result = Lists.newArrayListWithExpectedSize((int)query.length);
        if (query.length == 0) {
            return result;
        }
        for (DynamicObject dynObj : query) {
            HashMap param = Maps.newHashMapWithExpectedSize((int)4);
            long id = dynObj.getLong("id");
            if (busTripTypeId != null && id == busTripTypeId) {
                param.put("select", "1");
            }
            param.put("text", dynObj.getString("name"));
            param.put("id", String.valueOf(id));
            param.put("formid", typeRegulation.get(id) != null ? ((Long)typeRegulation.get(id)).toString() : null);
            result.add(param);
        }
        return result;
    }

    public List<Map<String, String>> queryTravelTool(IFormView view) {
        QFilter baseDataFilter;
        DynamicObject entryClickRowData = this.getEntryClickRowData(view);
        DynamicObject travelTool = entryClickRowData.getDynamicObject("traveltool");
        Long travelToolId = travelTool != null ? Long.valueOf(travelTool.getLong("id")) : null;
        HRBaseServiceHelper typeHelper = new HRBaseServiceHelper("wtbd_traveltool");
        QFilter traFilter = new QFilter("enable", "=", (Object)"1");
        traFilter.and(WTCHisServiceHelper.statusValidQFilter());
        DynamicObject orgDy = (DynamicObject)view.getModel().getValue("org");
        if (orgDy != null && (baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"wtbd_traveltool", (Long)orgDy.getLong("id"))) != null) {
            traFilter.and(baseDataFilter);
        }
        DynamicObject[] query = typeHelper.query(new QFilter[]{traFilter});
        ArrayList result = Lists.newArrayListWithExpectedSize((int)query.length);
        if (query.length == 0) {
            return result;
        }
        for (DynamicObject dynObj : query) {
            HashMap param = Maps.newHashMapWithExpectedSize((int)4);
            long id = dynObj.getLong("id");
            if (travelToolId != null && id == travelToolId) {
                param.put("select", "1");
            }
            param.put("text", dynObj.getString("name"));
            param.put("id", String.valueOf(id));
            param.put("formid", null);
            result.add(param);
        }
        return result;
    }

    public DynamicObject getEntryClickRowData(IFormView view) {
        CardEntry entryGrid = (CardEntry)view.getControl("entryentity");
        int focusRow = entryGrid.getEntryState().getFocusRow();
        view.getPageCache().put("focusRow", String.valueOf(focusRow));
        List<DynamicObject> entryEntityDynamicObjects = MobBusiTripBusiness.getInstance().getEntryEntityDynamicObjects(view, "entryentity");
        DynamicObject dynamicObject = entryEntityDynamicObjects.get(focusRow);
        return dynamicObject;
    }

    public void setType(IFormView view, Map<String, String> returnData) {
        CardEntry entryGrid = (CardEntry)view.getControl("entryentity");
        int focusRow = entryGrid.getEntryState().getFocusRow();
        if (focusRow < 0 || focusRow >= view.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").size()) {
            logger.info("MobBusiTripBusiness.setType.getFocusRow:{}", (Object)focusRow);
            return;
        }
        if (MapUtils.isEmpty(returnData)) {
            return;
        }
        if ("0".equals(returnData.get("id"))) {
            view.getModel().setValue("busitriptype", null, focusRow);
            return;
        }
        long id = Long.parseLong(returnData.get("id"));
        view.getModel().setValue("busitriptype", (Object)id, focusRow);
    }

    public void setTravelTool(IFormView view, Map<String, String> returnData) {
        CardEntry entryGrid = (CardEntry)view.getControl("entryentity");
        int focusRow = entryGrid.getEntryState().getFocusRow();
        if (focusRow < 0 || focusRow >= view.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").size()) {
            logger.info("MobBusiTripBusiness.setTravelTool.getFocusRow:{}", (Object)focusRow);
            return;
        }
        if (MapUtils.isEmpty(returnData)) {
            return;
        }
        long id = Long.parseLong(returnData.get("id"));
        view.getModel().setValue("traveltool", (Object)id, focusRow);
    }

    public void setChangEver(IFormView view, Map<String, String> returnData) {
        String focusRow = view.getPageCache().get("focusRow");
        if (MapUtils.isEmpty(returnData)) {
            return;
        }
        long id = Long.parseLong(returnData.get("id"));
        String name = returnData.get("text");
        view.getModel().setValue("entryparentid", (Object)id, Integer.parseInt(focusRow));
        view.getModel().setValue("changever", (Object)name, Integer.parseInt(focusRow));
    }

    public void setSelectDates(IFormView view, Map<String, String> returnData) {
        String focusRow = view.getPageCache().get("focusRow");
        if (MapUtils.isEmpty(returnData)) {
            view.getModel().setValue("startdate", null, Integer.parseInt(focusRow));
            view.getModel().setValue("enddate", null, Integer.parseInt(focusRow));
            view.getModel().setValue("startmethod", null, Integer.parseInt(focusRow));
            view.getModel().setValue("endmethod", null, Integer.parseInt(focusRow));
            view.getModel().setValue("startdatestr", null, Integer.parseInt(focusRow));
            view.getModel().setValue("enddatestr", null, Integer.parseInt(focusRow));
            view.getModel().setValue("strapplytime", null, Integer.parseInt(focusRow));
        } else {
            view.getPageCache().put("startmethod", returnData.get("startmethod"));
            view.getPageCache().put("endmethod", returnData.get("endmethod"));
            if ("3".equals(returnData.get("startmethod"))) {
                view.getPageCache().put("startdate", String.valueOf(this.transferString2DateTime(returnData.get("startdate")).getTime()));
                view.getPageCache().put("enddate", String.valueOf(this.transferString2DateTime(returnData.get("enddate")).getTime()));
            } else {
                view.getPageCache().put("startdate", String.valueOf(this.transferString2Date(returnData.get("startdate")).getTime()));
                view.getPageCache().put("enddate", String.valueOf(this.transferString2Date(returnData.get("enddate")).getTime()));
            }
            view.getModel().setValue("startmethod", (Object)returnData.get("startmethod"), Integer.parseInt(focusRow));
            view.getModel().setValue("endmethod", (Object)returnData.get("endmethod"), Integer.parseInt(focusRow));
            if ("3".equals(returnData.get("startmethod"))) {
                view.getModel().setValue("startdate", (Object)this.transferString2DateTime(returnData.get("startdate")), Integer.parseInt(focusRow));
                view.getModel().setValue("enddate", (Object)this.transferString2DateTime(returnData.get("enddate")), Integer.parseInt(focusRow));
            } else {
                view.getModel().setValue("startdate", (Object)this.transferString2Date(returnData.get("startdate")), Integer.parseInt(focusRow));
                view.getModel().setValue("enddate", (Object)this.transferString2Date(returnData.get("enddate")), Integer.parseInt(focusRow));
            }
            if (!"3".equals(returnData.get("startmethod"))) {
                view.getModel().setValue("startdatestr", (Object)this.getDateTypeStr(returnData.get("startmethod")), Integer.parseInt(focusRow));
            } else {
                view.getModel().setValue("startdatestr", (Object)returnData.get("startdatestr"), Integer.parseInt(focusRow));
            }
            if (!"3".equals(returnData.get("endmethod"))) {
                view.getModel().setValue("enddatestr", (Object)this.getDateTypeStr(returnData.get("endmethod")), Integer.parseInt(focusRow));
            } else {
                view.getModel().setValue("enddatestr", (Object)returnData.get("enddatestr"), Integer.parseInt(focusRow));
            }
        }
    }

    private String getDateTypeStr(String method) {
        if (HRStringUtils.equals((String)"0", (String)method)) {
            return ResManager.loadKDString((String)"\u4e0a\u534a\u5929", (String)"MobBusiTripBusiness_0", (String)"wtc-wtam-business", (Object[])new Object[0]);
        }
        if (HRStringUtils.equals((String)"1", (String)method)) {
            return ResManager.loadKDString((String)"\u4e0b\u534a\u5929", (String)"MobBusiTripBusiness_1", (String)"wtc-wtam-business", (Object[])new Object[0]);
        }
        if (HRStringUtils.equals((String)"2", (String)method)) {
            return ResManager.loadKDString((String)"\u5168\u5929", (String)"MobBusiTripBusiness_2", (String)"wtc-wtam-business", (Object[])new Object[0]);
        }
        if (HRStringUtils.equals((String)"3", (String)method)) {
            return ResManager.loadKDString((String)"\u65f6\u5206", (String)"MobBusiTripBusiness_3", (String)"wtc-wtam-business", (Object[])new Object[0]);
        }
        return "";
    }

    private String getFlagName(String flagName) {
        if (HRStringUtils.equals((String)"from", (String)flagName)) {
            return ResManager.loadKDString((String)"\u51fa\u53d1\u5730", (String)"MobBusiTripBusiness_4", (String)"wtc-wtam-business", (Object[])new Object[0]);
        }
        if (HRStringUtils.equals((String)"to", (String)flagName)) {
            return ResManager.loadKDString((String)"\u76ee\u7684\u5730", (String)"MobBusiTripBusiness_5", (String)"wtc-wtam-business", (Object[])new Object[0]);
        }
        if (HRStringUtils.equals((String)"traveltool", (String)flagName)) {
            return ResManager.loadKDString((String)"\u4ea4\u901a\u5de5\u5177", (String)"MobBusiTripBusiness_6", (String)"wtc-wtam-business", (Object[])new Object[0]);
        }
        if (HRStringUtils.equals((String)"tripresontex", (String)flagName)) {
            return ResManager.loadKDString((String)"{0}\u539f\u56e0", (String)"MobBusiTripBusiness_7", (String)"wtc-wtam-business", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName()});
        }
        return "";
    }

    public void setSubmit(IFormView view) {
    }

    public void customMustInputVal(BeforeDoOperationEventArgs args, IDataModel model, IFormView view) {
        DynamicObjectCollection dynObjColl = model.getDataEntity(true).getDynamicObjectCollection("entryentity");
        logger.info("MobBusiTripBusiness.customMustInputVal.dynObjColl.size:{}", (Object)(WTCCollections.isNotEmpty((Collection)dynObjColl) ? dynObjColl.size() : 0));
        int index = 0;
        boolean isMustAttach = false;
        for (DynamicObject dynObj : dynObjColl) {
            List mustInput;
            ++index;
            if (dynObj.get("busitriptype") == null) {
                view.showTipNotification(BusiTripBillKDStringHelper.busType(index));
                args.setCancel(true);
                return;
            }
            if (dynObj.get("startdate") == null) {
                view.showTipNotification(BusiTripBillKDStringHelper.startDate(index));
                args.setCancel(true);
                return;
            }
            if (dynObj.get("enddate") == null) {
                view.showTipNotification(BusiTripBillKDStringHelper.endDate(index));
                args.setCancel(true);
                return;
            }
            if (BusiTripBillUtil.checkBillAllDisuse(model.getDataEntity())) continue;
            logger.info("MobBusiTripBusiness.customMustInputVal.starttime:{}", (Object)System.currentTimeMillis());
            BustripEntityCheckService checkTypeHelper = this.getCheckHelper(dynObj, view);
            BillResponse typeResponse = checkTypeHelper.checkBaseSet();
            logger.info("MobBusiTripBusiness.customMustInputVal.endtime:{}", (Object)System.currentTimeMillis());
            if (!typeResponse.isSuccess() || (mustInput = checkTypeHelper.getMustInput()) == null || mustInput.isEmpty()) continue;
            logger.info("MobBusiTripBusiness.customMustInputVal.mustInput:{}", (Object)mustInput);
            List<String> mustInpConvert = BusiTripBillUtil.setMustInpConvert(mustInput);
            logger.info("MobBusiTripBusiness.customMustInputVal.mustInpConvert:{}", mustInpConvert);
            if (mustInpConvert.contains("attachmentpanel")) {
                if (!isMustAttach) {
                    isMustAttach = true;
                }
                mustInpConvert.remove(mustInpConvert.size() - 1);
            }
            for (String flagName : mustInpConvert) {
                if (dynObj.get(flagName) != null && !StringUtils.isEmpty((String)dynObj.get(flagName).toString())) continue;
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u884c\u7a0b\u660e\u7ec6\u201d\u7b2c%1$s\u884c:\u201c%2$s\u201d\u3002", (String)"MobBusiTripBusiness_9", (String)"wtc-wtam-business", (Object[])new Object[0]), index, this.getFlagName(flagName)));
                args.setCancel(true);
                return;
            }
        }
        AttachmentPanel attachmentPanel = (AttachmentPanel)view.getControl("attachmentpanel");
        List attachmentData = attachmentPanel.getAttachmentData();
        BillSystemParam billSystemParam = SystemParamQueryUtil.getBillSystemParam();
        List<String> errorList = BusiTripBillService.getInstance().attachmeCheck(isMustAttach, attachmentData, billSystemParam);
        if (!errorList.isEmpty()) {
            view.showTipNotification(errorList.get(0));
            args.setCancel(true);
            return;
        }
        if (!this.checkParamMust(dynObjColl, args, view)) {
            return;
        }
        if (!args.cancel) {
            this.setStartEndDate(model, view);
        }
    }

    private boolean checkParamMust(DynamicObjectCollection busTripBillEntry, BeforeDoOperationEventArgs args, IFormView view) {
        if (WTCCollections.isEmpty((Collection)busTripBillEntry)) {
            view.showTipNotification(BusiTripBillService.getInstance().checkParamStr(""));
            args.setCancel(true);
            return false;
        }
        for (DynamicObject entry : busTripBillEntry) {
            String checkParamStr = BusiTripBillService.getInstance().checkParamStr(entry.getString("startmethod"), entry.getString("endmethod"), entry.getString("startdate"), entry.getString("enddate"));
            if (StringUtils.isEmpty((String)checkParamStr)) continue;
            view.showTipNotification(checkParamStr);
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private BustripEntityCheckService getCheckHelper(DynamicObject dataEntity, IFormView view) {
        DynamicObject mainDataEntity = view.getModel().getDataEntity(true);
        Long attFileBo = mainDataEntity.getDynamicObject("attfile") != null ? Long.valueOf(mainDataEntity.getDynamicObject("attfile").getLong("id")) : null;
        UnifyBillEnum infoEnum = UnifyBillEnum.TP;
        ApplyBillCheckEnum checkEnum = ApplyBillCheckEnum.BUSTRIP;
        logger.info("MobBusiTripBusiness.getCheckHelper.attFileBo:{}", (Object)attFileBo);
        logger.info("MobBusiTripBusiness.getCheckHelper.busitriptype:{}", dataEntity.get("busitriptype"));
        String appId = BillCommonService.getInstance().getAuthAppIdForFormPlugin(view);
        BustripEntityCheckService billCommonCheckHelper = new BustripEntityCheckService(attFileBo, infoEnum, checkEnum, dataEntity, view.getEntityId(), appId);
        return billCommonCheckHelper;
    }

    private void setStartEndDate(IDataModel model, IFormView view) {
        DynamicObjectCollection busTripBillEntry = view.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        for (int index = 0; index < busTripBillEntry.size(); ++index) {
            DynamicObject entry = (DynamicObject)busTripBillEntry.get(index);
            String startMethod = entry.getString("startmethod");
            String endMethod = entry.getString("endmethod");
            if (entry.get("startdate") == null || entry.get("enddate") == null) continue;
            String startDataStr = " ";
            String endDataStr = " ";
            if ((HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) || HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value)) && (HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) || HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value))) {
                String startDate = simpleDateFormat.format(entry.get("startdate"));
                String endDate = simpleDateFormat.format(entry.get("enddate"));
                String startMethodStr = HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) ? BusiTripBillKDStringHelper.dayUp() : BusiTripBillKDStringHelper.dayDown();
                String endMethodStr = HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) ? BusiTripBillKDStringHelper.dayUp() : BusiTripBillKDStringHelper.dayDown();
                startDataStr = startDate + startMethodStr;
                endDataStr = endDate + endMethodStr;
            } else if (HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.DAY.value) && HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.DAY.value)) {
                startDataStr = simpleDateFormat.format(entry.get("startdate"));
                endDataStr = simpleDateFormat.format(entry.get("enddate"));
            } else if (HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.CUSTOM.value) && HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.CUSTOM.value)) {
                startDataStr = simpleDateFormat2.format(entry.get("startdate"));
                endDataStr = simpleDateFormat2.format(entry.get("enddate"));
            }
            model.setValue("startdatestr", (Object)startDataStr, index);
            model.setValue("enddatestr", (Object)endDataStr, index);
        }
    }

    public void releaseMutexIfIsCurrentUser(Long objectId, String EntityType) {
        if (this.currentUserHasMutex(objectId, EntityType)) {
            this.releaseMutex(objectId, EntityType);
        }
    }

    public boolean currentUserHasMutex(Long objectId, String EntityType) {
        QFilter operateKeyFilter = new QFilter("operationkey", "=", (Object)"modify");
        QFilter entityKeyFilter = new QFilter("entitykey", "=", (Object)EntityType);
        QFilter objectIdFilter = new QFilter("objectid", "=", (Object)String.valueOf(objectId));
        QFilter userFilter = new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId());
        HRBaseServiceHelper dataLockHelper = new HRBaseServiceHelper("bos_datalock");
        DynamicObject[] dynamicObjects = dataLockHelper.query("id", new QFilter[]{objectIdFilter, operateKeyFilter, entityKeyFilter, userFilter});
        return dynamicObjects != null && dynamicObjects.length > 0;
    }

    public void releaseMutex(Long objectId, String EntityType) {
        boolean release = WTCMutexHelper.release((String)EntityType, (String)"modify", (String)String.valueOf(objectId));
        logger.info("mobsupsign releaseMutex entityId:{},pkId:{},operateKey:{},result:{}", new Object[]{EntityType, objectId, "modify", release});
    }

    private Date transferString2Date(String str) {
        Date date = new Date();
        try {
            date = WTCInteDateUtil.getUserSimpleDateFormat().parse(str);
        }
        catch (ParseException e) {
            logger.warn(e.getMessage());
        }
        return date;
    }

    private Date transferString2DateTime(String str) {
        Date date = new Date();
        try {
            SimpleDateFormat userDateTimeFormat = WTCInteDateUtil.getUserDateTimeFormat();
            userDateTimeFormat.setTimeZone(WTCInteDateUtil.getSysTimeZone().getTimeZone());
            date = userDateTimeFormat.parse(str);
        }
        catch (ParseException e) {
            logger.warn(e.getMessage());
        }
        return date;
    }

    private static class Instance {
        private static MobBusiTripBusiness INSTANCE = new MobBusiTripBusiness();

        private Instance() {
        }
    }
}

