/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.business.busitripmobile;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtam.business.busitrip.BusiTripBillKDStringHelper;
import kd.wtc.wtam.business.busitripmobile.BusiTripBillUtil;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class MobBusiTripHelper
extends HRBaseServiceHelper {
    public MobBusiTripHelper(String entityName) {
        super(entityName);
    }

    public static MobBusiTripHelper getInstance() {
        return Instance.MOB_BUSITIRP_INSTANCE;
    }

    public void setHeaderInfo(DynamicObject busiTripBill, IFormView view) {
        Label billTitle = (Label)view.getControl("billtitle");
        boolean isChange = busiTripBill.getBoolean("ischange");
        String name = busiTripBill.getString("personid.name");
        String caption = isChange ? BusiTripBillKDStringHelper.busName(name) : BusiTripBillKDStringHelper.changeName(name);
        billTitle.setText(caption);
        BusiTripBillUtil.tripTotalTimeLineFeed(busiTripBill, view, "triptimeflex", "apply");
    }

    public static void dateStrCut(DynamicObjectCollection busiTripBillEntry, IDataModel model) {
        for (int index = 0; index < busiTripBillEntry.size(); ++index) {
            String startDateStr = ((DynamicObject)busiTripBillEntry.get(index)).getString("startdatestr");
            String endDateStr = ((DynamicObject)busiTripBillEntry.get(index)).getString("enddatestr");
            String startMethod = ((DynamicObject)busiTripBillEntry.get(index)).getString("startmethod");
            String endMethod = ((DynamicObject)busiTripBillEntry.get(index)).getString("endmethod");
            String startDateParse = MobBusiTripHelper.dateTransformation(startDateStr, startMethod);
            String endDateParse = MobBusiTripHelper.dateTransformation(endDateStr, endMethod);
            model.setValue("startdatestr", (Object)startDateParse, index);
            model.setValue("enddatestr", (Object)endDateParse, index);
        }
    }

    public static String dateTransformation(String dateStr, String dateMethod) {
        if (dateStr == null || StringUtils.isEmpty((String)dateStr)) {
            return null;
        }
        if ("0".equals(dateMethod)) {
            return ResManager.loadKDString((String)"\u4e0a\u534a\u5929", (String)"MobBusiTripHelper_1", (String)"wtc-wtam-business", (Object[])new Object[0]);
        }
        if ("1".equals(dateMethod)) {
            return ResManager.loadKDString((String)"\u4e0b\u534a\u5929", (String)"MobBusiTripHelper_2", (String)"wtc-wtam-business", (Object[])new Object[0]);
        }
        if ("2".equals(dateMethod)) {
            return ResManager.loadKDString((String)"\u5168\u5929", (String)"MobBusiTripHelper_3", (String)"wtc-wtam-business", (Object[])new Object[0]);
        }
        Date date = WTCDateUtils.str2Date((String)dateStr, (String)"yyyy-MM-dd HH:mm");
        if (date != null) {
            dateStr = WTCDateUtils.date2Str((Date)date, (String)"yyyy-MM-dd HH:mm");
        }
        return dateStr.length() > 6 ? dateStr.substring(dateStr.length() - 6) : dateStr;
    }

    private static class Instance {
        private static final MobBusiTripHelper MOB_BUSITIRP_INSTANCE = new MobBusiTripHelper("wtam_busitripbill");

        private Instance() {
        }
    }
}

