/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.business.schedule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.util.CollectionUtils;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtp.business.attconfirm.AttConfirmHelper;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmAddOpServiceImpl;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmRuleServiceImpl;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordTypeEnum;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordOpParam;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordOpResult;

public class AttConfirmGenByDayTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(AttConfirmGenByDayTask.class);
    private static final String ATT_CONFIRM_GEN_RULE_NUMBER = "attConfirmGenRuleNumber";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (LOG.isInfoEnabled()) {
            LOG.info("AttConfirmGenByDayTask.execute start");
        }
        if (WTCCollections.isEmpty(map) || null == map.get(ATT_CONFIRM_GEN_RULE_NUMBER)) {
            LOG.info("AttConfirmGenByDayTask.execute param is null");
            return;
        }
        Set ruleCodeList = AttConfirmHelper.getInstance().getRuleNumberSet(map, ATT_CONFIRM_GEN_RULE_NUMBER);
        if (CollectionUtils.isEmpty((Collection)ruleCodeList)) {
            return;
        }
        Map ruleCodeAttConfirmRecordOpParamListMap = AttConfirmRuleServiceImpl.getInstance().attConfirmGenerateRule(new ArrayList(ruleCodeList), AttConRecordTypeEnum.BY_DATE);
        if (MapUtils.isEmpty((Map)ruleCodeAttConfirmRecordOpParamListMap)) {
            return;
        }
        for (Map.Entry entry : ruleCodeAttConfirmRecordOpParamListMap.entrySet()) {
            List attConfirmRecordOpParams = (List)entry.getValue();
            for (AttConfirmRecordOpParam attConfirmRecordOpParam : attConfirmRecordOpParams) {
                if (null == attConfirmRecordOpParam) continue;
                AttConfirmRecordOpResult attConfirmRecordOpResult = AttConfirmAddOpServiceImpl.getInstance().opAttConfirmRecord(attConfirmRecordOpParam);
                if (null != attConfirmRecordOpResult) {
                    String name = attConfirmRecordOpResult.getName();
                    int totalCount = attConfirmRecordOpResult.getTotalCount();
                    int failCount = attConfirmRecordOpResult.getFailCount();
                    int successCount = attConfirmRecordOpResult.getSuccessCount();
                    String ruleCode = (String)entry.getKey();
                    LOG.info("AttConfirmGenByDayTask.execute gen ruleCode:{},name:{},totalCount:{},failCount:{} ", new Object[]{ruleCode, name, totalCount, successCount, failCount});
                    continue;
                }
                LOG.error("AttConfirmGenByDayTask.execute gen error ");
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("AttConfirmGenByDayTask.execute end");
        }
    }
}

