/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.business.schedule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtp.business.attconfirm.AttConfirmHelper;
import kd.wtc.wtp.business.attconfirm.AttConfirmServiceFactory;
import kd.wtc.wtp.business.attconfirm.IAttConfirmOpService;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmRuleServiceImpl;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordTypeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmRecordOpEnum;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordOpParam;

public class AttConfirmPushByDayTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(AttConfirmPushByDayTask.class);
    private static final String ATT_CONFIRM_PUSH_RULE_NUMBER = "attConfirmPushRuleNumber";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (LOG.isInfoEnabled()) {
            LOG.info("AttConfirmPushByDayTask.execute start");
        }
        if (WTCCollections.isEmpty(map) || null == map.get(ATT_CONFIRM_PUSH_RULE_NUMBER)) {
            LOG.info("AttConfirmPushByDayTask.execute param is null");
            return;
        }
        Set collect = AttConfirmHelper.getInstance().getRuleNumberSet(map, ATT_CONFIRM_PUSH_RULE_NUMBER);
        List attConfirmRecordOpParams = AttConfirmRuleServiceImpl.getInstance().attConfirmPushRule(new ArrayList(collect), AttConRecordTypeEnum.BY_DATE);
        if (WTCCollections.isNotEmpty((Collection)attConfirmRecordOpParams)) {
            for (AttConfirmRecordOpParam attConfirmRecordOpParam : attConfirmRecordOpParams) {
                if (attConfirmRecordOpParam == null) continue;
                IAttConfirmOpService attConfirmService = AttConfirmServiceFactory.getInstance().getAttConfirmService(AttConfirmRecordOpEnum.PUSH);
                attConfirmService.opAttConfirmRecord(attConfirmRecordOpParam);
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("AttConfirmPushByDayTask.execute end");
        }
    }
}

